/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.javascript.JSFileReference;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.ResolvedModuleInfo;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.index.ES6ImportIndex;
import com.intellij.lang.typescript.modules.TypeScriptNodeReference;
import com.intellij.lang.typescript.modules.TypeScriptSimpleModuleReference;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptImportPathsResolver {
    @NotNull
    private final Project myProject;
    @NotNull
    private final PsiFileFactory myPsiFileFactory;
    private final TypeScriptNodeReference.TypeScriptNodeModuleDirectorySearchProcessor myNodeProcessor;
    @NotNull
    private PsiManager myPsiManager;

    public static TypeScriptImportPathsResolver getInstance(Project project) {
        return (TypeScriptImportPathsResolver)ServiceManager.getService((Project)project, TypeScriptImportPathsResolver.class);
    }

    public TypeScriptImportPathsResolver(@NotNull Project project, @NotNull PsiFileFactory psiFileFactory, @NotNull PsiManager psiManager) {
        if (project == null) {
            TypeScriptImportPathsResolver.$$$reportNull$$$0(0);
        }
        if (psiFileFactory == null) {
            TypeScriptImportPathsResolver.$$$reportNull$$$0(1);
        }
        if (psiManager == null) {
            TypeScriptImportPathsResolver.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myPsiFileFactory = psiFileFactory;
        this.myPsiManager = psiManager;
        this.myNodeProcessor = new TypeScriptNodeReference.TypeScriptNodeModuleDirectorySearchProcessor(project);
    }

    @Nullable
    public PsiFileSystemItem resolveIncludedFile(@NotNull ES6ImportIndex.ImportInfo info, final @NotNull PsiFile context) {
        if (info == null) {
            TypeScriptImportPathsResolver.$$$reportNull$$$0(3);
        }
        if (context == null) {
            TypeScriptImportPathsResolver.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        final String path = info.getPath();
        final boolean hasExtension = JSFileReference.findExtension(path, TypeScriptUtil.TYPESCRIPT_EXTENSIONS) != null;
        PsiFileImpl psiFile = (PsiFileImpl)this.myPsiFileFactory.createFileFromText("dummy.txt", (FileType)FileTypes.PLAIN_TEXT, (CharSequence)path);
        psiFile.setOriginalFile(context);
        return new FileReferenceSet((PsiElement)psiFile){

            @NotNull
            public Collection<PsiFileSystemItem> computeDefaultContexts() {
                VirtualFile parent;
                VirtualFile nodeModules;
                Collection contexts = super.computeDefaultContexts();
                if (path.startsWith(".")) {
                    Collection collection = contexts;
                    if (collection == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return collection;
                }
                VirtualFile config2 = TypeScriptConfigUtil.getNearestParentConfig(context.getVirtualFile());
                if (config2 != null && (nodeModules = (parent = config2.getParent()).findChild("node_modules")) != null) {
                    ArrayList items = ContainerUtil.newArrayList((Iterable)contexts);
                    TypeScriptImportPathsResolver.this.addFileIfNotNull(nodeModules, items);
                    VirtualFile types = nodeModules.findChild("@types");
                    if (types != null) {
                        TypeScriptImportPathsResolver.this.addFileIfNotNull(types, items);
                    }
                    ArrayList arrayList = items;
                    if (arrayList == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return arrayList;
                }
                Collection collection = contexts;
                if (collection == null) {
                    1.$$$reportNull$$$0(2);
                }
                return collection;
            }

            public FileReference createFileReference(TextRange range, int index, String text) {
                return hasExtension ? super.createFileReference(range, index, text) : new TypeScriptSimpleModuleReference(text, index, range, this);
            }

            protected boolean useIncludingFileAsContext() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/TypeScriptImportPathsResolver$1", "computeDefaultContexts"));
            }
        }.resolve();
    }

    private void addFileIfNotNull(@NotNull VirtualFile virtualFile, @NotNull Collection<PsiFileSystemItem> items) {
        PsiDirectory file;
        if (virtualFile == null) {
            TypeScriptImportPathsResolver.$$$reportNull$$$0(5);
        }
        if (items == null) {
            TypeScriptImportPathsResolver.$$$reportNull$$$0(6);
        }
        if ((file = this.myPsiManager.findDirectory(virtualFile)) != null) {
            items.add((PsiFileSystemItem)file);
        }
    }

    @NotNull
    public Set<VirtualFile> getIncludedFiles(@NotNull VirtualFile file) {
        if (file == null) {
            TypeScriptImportPathsResolver.$$$reportNull$$$0(7);
        }
        List<ES6ImportIndex.ImportInfo> includes = ES6ImportIndex.getIncludes(file, GlobalSearchScope.allScope((Project)this.myProject));
        Set<VirtualFile> set = includes.stream().map(el -> {
            if (file == null) {
                TypeScriptImportPathsResolver.$$$reportNull$$$0(11);
            }
            return this.resolveInfo(file, (ES6ImportIndex.ImportInfo)el);
        }).filter(el -> el != null).map(el -> {
            if (el.isDirectory()) {
                ResolvedModuleInfo info = this.myNodeProcessor.loadDirectory(null, (VirtualFile)el, ModuleType.NODE_MODULES_DIR, true);
                return info == null ? el : info.getModuleMainFile();
            }
            return el;
        }).filter(el -> !el.isDirectory()).collect(Collectors.toSet());
        if (set == null) {
            TypeScriptImportPathsResolver.$$$reportNull$$$0(8);
        }
        return set;
    }

    @Nullable
    private VirtualFile resolveInfo(@NotNull VirtualFile file, @NotNull ES6ImportIndex.ImportInfo info) {
        PsiFile psiFile;
        if (file == null) {
            TypeScriptImportPathsResolver.$$$reportNull$$$0(9);
        }
        if (info == null) {
            TypeScriptImportPathsResolver.$$$reportNull$$$0(10);
        }
        if ((psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file)) == null) {
            return null;
        }
        PsiFileSystemItem item = TypeScriptImportPathsResolver.getInstance(this.myProject).resolveIncludedFile(info, psiFile);
        return item != null ? item.getVirtualFile() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFileFactory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/index/TypeScriptImportPathsResolver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/index/TypeScriptImportPathsResolver";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveIncludedFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addFileIfNotNull";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getIncludedFiles";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveInfo";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getIncludedFiles$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

