/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index.flags;

import com.intellij.lang.javascript.index.flags.FlagsStructureElement;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;

public class EnumSetStructureElement<T extends Enum<T>>
extends FlagsStructureElement<EnumSet<T>> {
    private final Class<T> myEnumClass;

    public EnumSetStructureElement(Class<T> enumClass) {
        super(((Enum[])enumClass.getEnumConstants()).length);
        assert (((Enum[])enumClass.getEnumConstants()).length < 32) : "getObject/getValue are ints";
        this.myEnumClass = enumClass;
    }

    @Override
    @NotNull
    public EnumSet<T> getObject(int value) {
        EnumSet<T> result = EnumSet.noneOf(this.myEnumClass);
        Enum[] constants = (Enum[])this.myEnumClass.getEnumConstants();
        for (int i = 0; i < constants.length; ++i) {
            if ((value & 1 << i) == 0) continue;
            result.add(constants[i]);
        }
        EnumSet<T> enumSet = result;
        if (enumSet == null) {
            EnumSetStructureElement.$$$reportNull$$$0(0);
        }
        return enumSet;
    }

    @Override
    public int getValue(EnumSet<T> object) {
        int result = 0;
        Enum[] constants = (Enum[])this.myEnumClass.getEnumConstants();
        for (int i = 0; i < constants.length; ++i) {
            if (!object.contains(constants[i])) continue;
            result |= 1 << i;
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/flags/EnumSetStructureElement", "getObject"));
    }
}

