/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inject;

import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.impl.source.tree.injected.MultiHostRegistrarImpl;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFormattableInjectionUtil {
    private static final Key<Boolean> FORMATTABLE_INJECTION_KEY = new Key("js.injection.formattable");

    private JSFormattableInjectionUtil() {
    }

    public static void setReformattableInjection(@NotNull MultiHostRegistrar registrar, PsiElement context) {
        if (registrar == null) {
            JSFormattableInjectionUtil.$$$reportNull$$$0(0);
        }
        context.putUserData(FORMATTABLE_INJECTION_KEY, (Object)true);
        PsiFile file = JSFormattableInjectionUtil.getInjectedFile(registrar);
        if (file != null) {
            file.putUserData(FORMATTABLE_INJECTION_KEY, (Object)true);
        }
    }

    public static boolean isReformattableInjectedPsi(PsiFile psi) {
        return psi.getUserData(FORMATTABLE_INJECTION_KEY) == Boolean.TRUE;
    }

    public static boolean isFormattableHost(@NotNull PsiElement host) {
        if (host == null) {
            JSFormattableInjectionUtil.$$$reportNull$$$0(1);
        }
        return host.isPhysical() && host.getNode().getElementType() == JSStubElementTypes.STRING_TEMPLATE_EXPRESSION;
    }

    public static boolean hostContainsFormattableInjection(@NotNull PsiElement host) {
        if (host == null) {
            JSFormattableInjectionUtil.$$$reportNull$$$0(2);
        }
        if (!JSFormattableInjectionUtil.isFormattableHost(host)) {
            return false;
        }
        if (host.getUserData(FORMATTABLE_INJECTION_KEY) != Boolean.TRUE) {
            return false;
        }
        Ref result = Ref.create(null);
        InjectedLanguageUtil.enumerate((PsiElement)host, (injectedPsi, places) -> result.set((Object)(JSFormattableInjectionUtil.isReformattableInjectedPsi(injectedPsi) && places.size() == 1 ? 1 : 0)));
        return Boolean.TRUE == result.get();
    }

    @Nullable
    private static PsiFile getInjectedFile(@NotNull MultiHostRegistrar registrar) {
        List result;
        if (registrar == null) {
            JSFormattableInjectionUtil.$$$reportNull$$$0(3);
        }
        return (result = ((MultiHostRegistrarImpl)registrar).getResult()) == null || result.isEmpty() ? null : (PsiFile)((Pair)result.get((int)(result.size() - 1))).second;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/inject/JSFormattableInjectionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setReformattableInjection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isFormattableHost";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hostContainsFormattableInjection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getInjectedFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

