/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flow.FlowJSSettingsManager;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfigService;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.inspections.JSUnusedLocalSymbolsInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.resolve.JSNamedElementKind;
import com.intellij.lang.typescript.imports.ES6UnusedImportsHelper;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6UnusedImportsInspection
extends JSInspection {
    public static final String SHORT_NAME = ES6UnusedImportsInspection.calcShortNameFromClass(ES6UnusedImportsInspection.class);

    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.unused.es6.import.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            ES6UnusedImportsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitTypeScriptImportStatement(@NotNull TypeScriptImportStatement importStatement) {
                if (importStatement == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (ES6UnusedImportsHelper.isUnusedTypeScriptImport(importStatement)) {
                    LocalQuickFixAndIntentionActionOnPsiElement fix = JSFixFactory.getInstance().removeASTNodeFix("javascript.unused.import.remove", importStatement.getNode());
                    holder.registerProblem((PsiElement)importStatement, JSUnusedLocalSymbolsInspection.unusedMessage(JSNamedElementKind.ES6_IMPORT), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{fix});
                }
            }

            public void visitES6ImportDeclaration(ES6ImportDeclaration importDeclaration) {
                PsiFile file;
                if (importDeclaration.getLanguage() == JavaScriptSupportLoader.FLOW_JS && FlowJSSettingsManager.isResolveEnabled((file = importDeclaration.getContainingFile()).getProject()) && !FlowJSConfigService.getService(file.getProject()).getConfigOfFile(file.getVirtualFile()).isEmpty()) {
                    return;
                }
                ES6UnusedImportsHelper.UnusedInfo info = ES6UnusedImportsHelper.getInfo(importDeclaration);
                if (info.isAllUnused()) {
                    LocalQuickFixAndIntentionActionOnPsiElement fix = JSFixFactory.getInstance().removeASTNodeFix("javascript.unused.import.remove", importDeclaration.getNode());
                    holder.registerProblem((PsiElement)importDeclaration, JSUnusedLocalSymbolsInspection.unusedMessage(JSNamedElementKind.ES6_IMPORT), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{fix});
                } else {
                    for (ES6ImportedBinding binding : info.getUnusedBindings()) {
                        holder.registerProblem((PsiElement)binding, JSUnusedLocalSymbolsInspection.unusedMessage(JSNamedElementKind.ES6_BINDING), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[0]);
                    }
                    for (ES6ImportSpecifier specifier : info.getUnusedSpecifiers()) {
                        holder.registerProblem((PsiElement)specifier, JSUnusedLocalSymbolsInspection.unusedMessage(JSNamedElementKind.ES6_SPECIFIER), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new DeleteSpecifierFix((PsiElement)specifier)});
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importStatement", "com/intellij/lang/javascript/inspections/ES6UnusedImportsInspection$1", "visitTypeScriptImportStatement"));
            }
        };
        if (jSElementVisitor == null) {
            ES6UnusedImportsInspection.$$$reportNull$$$0(1);
        }
        return jSElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/inspections/ES6UnusedImportsInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class DeleteSpecifierFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        protected DeleteSpecifierFix(@Nullable PsiElement element) {
            super(element);
        }

        @NotNull
        public String getText() {
            String string = JSBundle.message((String)"javascript.unused.import.remove.specifier", (Object[])new Object[0]);
            if (string == null) {
                DeleteSpecifierFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                DeleteSpecifierFix.$$$reportNull$$$0(1);
            }
            if (file == null) {
                DeleteSpecifierFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                DeleteSpecifierFix.$$$reportNull$$$0(3);
            }
            if (endElement == null) {
                DeleteSpecifierFix.$$$reportNull$$$0(4);
            }
            if (startElement instanceof ES6ImportExportSpecifier) {
                startElement.delete();
            }
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                DeleteSpecifierFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/ES6UnusedImportsInspection$DeleteSpecifierFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6UnusedImportsInspection$DeleteSpecifierFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

