/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.inspections.NewLineEraser;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSNamedElementKind;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.safeDelete.SafeDeleteHandler;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRemoveElementLocalQuickFix
extends FixAndIntentionAction
implements BatchQuickFix<CommonProblemDescriptor> {
    private static final Logger LOG = Logger.getInstance(JSRemoveElementLocalQuickFix.class);
    private final String myName;
    private final JSNamedElementKind myKind;

    public JSRemoveElementLocalQuickFix(JSNamedElementKind kind, String name) {
        this.myKind = kind;
        this.myName = name;
    }

    @NotNull
    public String getName() {
        String type = StringUtil.decapitalize((String)JSBundle.message((String)this.myKind.humanReadableKey(), (Object[])new Object[0]));
        String string = StringUtil.isEmptyOrSpaces((String)this.myName) ? JSBundle.message((String)"js.unused.symbol.remove.unnamed", (Object[])new Object[]{type}) : JSBundle.message((String)"js.unused.symbol.remove", (Object[])new Object[]{type, this.myName});
        if (string == null) {
            JSRemoveElementLocalQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected void applyFix(Project project, PsiElement psiElement, PsiFile file, Editor editor) {
        Document document;
        PsiElement element = JSRemoveElementLocalQuickFix.walkUpToDeleteTarget(psiElement);
        if (element == null) {
            return;
        }
        PsiElement scope = JSChangeUtil.getScopeElementInFile(element);
        editor = editor == null ? PsiUtilBase.findEditor((PsiElement)psiElement) : editor;
        Document document2 = document = editor != null ? editor.getDocument() : null;
        if (document == null) {
            return;
        }
        MyRemovedReformatter reformatter = new MyRemovedReformatter(element, document);
        NewLineEraser eraser = new NewLineEraser(element);
        PsiElement elementToReplace = JSRemoveElementLocalQuickFix.createElementToReplace(project, element);
        Runnable afterRefactoring = () -> DocumentUtil.writeInRunUndoTransparentAction(() -> {
            if (elementToReplace != null) {
                MyLeftRightContext remainingContext = reformatter.getRemainingContext();
                if (remainingContext != null && remainingContext.myParent != null) {
                    if (remainingContext.myRight != null) {
                        PsiElement added = JSChangeUtil.doDoAddBefore(remainingContext.myParent, elementToReplace, remainingContext.myRight);
                        eraser.process(added);
                        return;
                    }
                    if (remainingContext.myLeft != null) {
                        PsiElement added = JSChangeUtil.doAddAfter(remainingContext.myParent, elementToReplace, remainingContext.myLeft);
                        eraser.process(added);
                        return;
                    }
                }
                scope.add(elementToReplace);
            } else {
                PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
                reformatter.reformat();
            }
        });
        SafeDeleteHandler.invoke((Project)project, (PsiElement[])new PsiElement[]{element}, null, (boolean)false, null, (Runnable)afterRefactoring);
    }

    @Nullable
    private static PsiElement createElementToReplace(Project project, PsiElement element) {
        String name;
        if (!(element instanceof ES6ExportDefaultAssignment)) {
            return null;
        }
        JSNamedElement expression = (JSNamedElement)ObjectUtils.tryCast((Object)((ES6ExportDefaultAssignment)element).getExpression(), JSNamedElement.class);
        if (expression != null && !StringUtil.isEmptyOrSpaces((String)(name = expression.getName()))) {
            if (expression instanceof JSFunction) {
                return JSRefactoringUtil.functionDeclarationFromFunctionExpression(project, (JSFunction)expression, name, false);
            }
            if (expression instanceof JSClass) {
                return JSRefactoringUtil.classDeclarationFromClassExpression(project, (JSClass)expression, name, false);
            }
        }
        return null;
    }

    public void applyFix(@NotNull Project project, @NotNull CommonProblemDescriptor[] descriptors, @NotNull List<PsiElement> psiElementsToIgnore, @Nullable Runnable refreshViews) {
        List toDelete;
        if (project == null) {
            JSRemoveElementLocalQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptors == null) {
            JSRemoveElementLocalQuickFix.$$$reportNull$$$0(2);
        }
        if (psiElementsToIgnore == null) {
            JSRemoveElementLocalQuickFix.$$$reportNull$$$0(3);
        }
        if ((toDelete = Arrays.stream(descriptors).map(descriptor2 -> ((ProblemDescriptor)descriptor2).getPsiElement()).filter(Objects::nonNull).map(JSRemoveElementLocalQuickFix::walkUpToDeleteTarget).filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) {
            return;
        }
        psiElementsToIgnore.addAll(toDelete);
        SafeDeleteHandler.invoke((Project)project, (PsiElement[])PsiUtilCore.toPsiElementArray(toDelete), (boolean)false, (Runnable)refreshViews);
    }

    private static PsiElement walkUpToDeleteTarget(@NotNull PsiElement psiElement) {
        PsiElement element;
        if (psiElement == null) {
            JSRemoveElementLocalQuickFix.$$$reportNull$$$0(4);
        }
        for (element = psiElement; element != null && !(element instanceof JSNamedElement) && !(element instanceof ES6ExportDefaultAssignment); element = element.getParent()) {
        }
        if (element == null) {
            LOG.info("Was not able to remove element: " + psiElement.getText());
        }
        if (element != null && element.getParent() instanceof ES6ExportDefaultAssignment) {
            element = element.getParent();
        }
        return element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSRemoveElementLocalQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElementsToIgnore";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSRemoveElementLocalQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "walkUpToDeleteTarget";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyLeftRightContext {
        @Nullable
        private PsiElement myLeft;
        @Nullable
        private PsiElement myRight;
        @Nullable
        private PsiElement myParent;
        private final boolean myInline;

        public MyLeftRightContext(@NotNull PsiElement element, @NotNull Document document) {
            if (element == null) {
                MyLeftRightContext.$$$reportNull$$$0(0);
            }
            if (document == null) {
                MyLeftRightContext.$$$reportNull$$$0(1);
            }
            this.myLeft = JSPsiImplUtils.getPrevSiblingIgnoreWhitespace(element);
            this.myRight = JSPsiImplUtils.getNextSiblingIgnoreWhitespace(element);
            this.myParent = element.getParent();
            this.myInline = this.myLeft != null && this.myRight != null && document.getLineNumber(this.myLeft.getTextRange().getEndOffset()) == document.getLineNumber(this.myRight.getTextRange().getStartOffset());
        }

        boolean isInline() {
            return this.myInline;
        }

        @Nullable
        PsiElement getParent() {
            return this.myParent;
        }

        @Nullable
        TextRange getTextRangeIfValid() {
            if (this.myParent == null || !this.myParent.isValid()) {
                return null;
            }
            boolean prevValid = this.myLeft != null && this.myLeft.isValid();
            boolean nextValid = this.myRight != null && this.myRight.isValid();
            int startOffset = prevValid ? this.myLeft.getTextRange().getEndOffset() : this.myParent.getTextRange().getStartOffset();
            int endOffset = nextValid ? this.myRight.getTextRange().getStartOffset() : this.myParent.getTextRange().getEndOffset();
            return new TextRange(startOffset, endOffset);
        }

        boolean isWholeFile() {
            return this.myParent instanceof PsiFile && this.myLeft == null && this.myRight == null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "document";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/inspections/JSRemoveElementLocalQuickFix$MyLeftRightContext";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyRemovedReformatter {
        private final List<MyLeftRightContext> myContexts;
        private final PsiFile myContainingFile;
        @NotNull
        private final PsiElement myElement;
        @NotNull
        private final Document myDocument;

        public MyRemovedReformatter(@NotNull PsiElement element, @NotNull Document document) {
            if (element == null) {
                MyRemovedReformatter.$$$reportNull$$$0(0);
            }
            if (document == null) {
                MyRemovedReformatter.$$$reportNull$$$0(1);
            }
            this.myElement = element;
            this.myDocument = document;
            this.myContexts = MyRemovedReformatter.createContextList(element, document);
            this.myContainingFile = element.getContainingFile();
        }

        public void reformat() {
            if (this.myElement.isValid()) {
                return;
            }
            MyLeftRightContext context = this.getRemainingContext();
            if (context == null) {
                return;
            }
            TextRange range = context.getTextRangeIfValid();
            assert (range != null);
            if (context.isInline()) {
                FormatFixer.create(this.myContainingFile, range, FormatFixer.Mode.Reformat).fixFormat();
            } else {
                Project project = this.myContainingFile.getProject();
                if (context.isWholeFile() || range.getStartOffset() == 0) {
                    if (range.getLength() > 0) {
                        this.myDocument.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)"");
                        PsiDocumentManager.getInstance((Project)project).commitDocument(this.myDocument);
                    }
                } else {
                    this.myDocument.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)"\n");
                    PsiDocumentManager.getInstance((Project)project).commitDocument(this.myDocument);
                    CodeStyleManager.getInstance((Project)project).adjustLineIndent(this.myContainingFile, range);
                }
            }
        }

        @Nullable
        public MyLeftRightContext getRemainingContext() {
            return this.myContexts.stream().filter(c -> c.getTextRangeIfValid() != null).findFirst().orElse(null);
        }

        @NotNull
        private static List<MyLeftRightContext> createContextList(@NotNull PsiElement element, @NotNull Document document) {
            MyLeftRightContext context;
            if (element == null) {
                MyRemovedReformatter.$$$reportNull$$$0(2);
            }
            if (document == null) {
                MyRemovedReformatter.$$$reportNull$$$0(3);
            }
            SmartList result = new SmartList();
            PsiElement current = element;
            while (current != null && !(current instanceof PsiFile) && !(current instanceof JSEmbeddedContent) && (context = new MyLeftRightContext(current, document)).getParent() != null) {
                result.add(context);
                current = context.getParent();
            }
            SmartList smartList = result;
            if (smartList == null) {
                MyRemovedReformatter.$$$reportNull$$$0(4);
            }
            return smartList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSRemoveElementLocalQuickFix$MyRemovedReformatter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSRemoveElementLocalQuickFix$MyRemovedReformatter";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createContextList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createContextList";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

