/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.controlflow.JSControlFlowProcessor;
import com.intellij.lang.javascript.psi.controlflow.JSControlFlowUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSFunctionBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSUnusedAssignmentInspection
extends JSInspection {
    @NonNls
    public static final String SHORT_NAME = "JSUnusedAssignment";

    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.unused.assignment.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            JSUnusedAssignmentInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            JSUnusedAssignmentInspection.$$$reportNull$$$0(1);
        }
        return highlightDisplayLevel;
    }

    @Override
    @NotNull
    @NonNls
    public String getShortName() {
        if (SHORT_NAME == null) {
            JSUnusedAssignmentInspection.$$$reportNull$$$0(2);
        }
        return SHORT_NAME;
    }

    @NotNull
    protected JSElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSFunctionExpression(JSFunctionExpression node) {
                this.visitJSFunctionDeclaration((JSFunction)node);
            }

            public void visitJSFunctionDeclaration(JSFunction node) {
                this.processDataFlow((JSExecutionScope)node);
            }

            public void visitJSEmbeddedContent(JSEmbeddedContent embeddedContent) {
                this.processDataFlow((JSExecutionScope)embeddedContent);
            }

            public void visitJSFile(JSFile file) {
                if (file.getContext() == null) {
                    this.processDataFlow((JSExecutionScope)file);
                }
            }

            private void processDataFlow(JSExecutionScope scope) {
                THashMap variablesReadWithoutInitialization = new THashMap(2);
                ArrayList valuesOverwritten = ContainerUtil.newArrayList();
                THashMap variablesWritten = new THashMap();
                THashSet variablesReferencedInInners = new THashSet(2);
                THashSet readAtLeastOnce = new THashSet();
                JSControlFlowUtils.processControlFlowFor(scope, new SimpleControlFlowProcessor((Map<JSVariable, Map<JSExpression, Boolean>>)variablesWritten, (Map<JSExpression, JSVariable>)variablesReadWithoutInitialization, (Set<JSVariable>)readAtLeastOnce, (Set<String>)variablesReferencedInInners, valuesOverwritten));
                for (Map.Entry e : variablesReadWithoutInitialization.entrySet()) {
                    if (!this.isElementFromProperScope((JSVariable)e.getValue(), scope)) continue;
                    JSExpression jSExpression = (JSExpression)e.getKey();
                    holder.registerProblem((PsiElement)jSExpression, JSBundle.message((String)"js.variable.might.not.been.initialized", (Object[])new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[0]);
                }
                HashMap destructuringPatterns = ContainerUtil.newHashMap();
                for (JSVariable jSVariable : variablesWritten.keySet()) {
                    if (scope instanceof JSFile || scope instanceof JSEmbeddedContent || !this.isElementFromProperScope(jSVariable, scope)) continue;
                    Map values = (Map)variablesWritten.get(jSVariable);
                    for (JSExpression e : values.keySet()) {
                        PsiElement eParent;
                        String name;
                        if (values.get(e) != null || variablesReferencedInInners.contains(name = jSVariable.getName()) || e instanceof JSLiteralExpression && !((JSLiteralExpression)e).isQuotedLiteral() && "null".equals(e.getText()) || this.isPlaceWeNotWorkingReliablyIn(e, scope) || ((eParent = e.getParent()) == jSVariable || PsiTreeUtil.findCommonParent((PsiElement)e, (PsiElement)jSVariable) == eParent) && !readAtLeastOnce.contains(jSVariable) || this.postponeDestructuring(destructuringPatterns, e, jSVariable)) continue;
                        this.reportUnusedValueProblem((JSElement)e, true);
                    }
                }
                for (Pair pair : valuesOverwritten) {
                    JSVariable variable = (JSVariable)pair.second;
                    JSExpression expression = (JSExpression)pair.first;
                    if (!this.isElementFromProperScope(variable, scope) && !this.isIIFE(scope) || variablesReferencedInInners.contains(variable.getName()) || this.isPlaceWeNotWorkingReliablyIn(expression, scope) || this.postponeDestructuring(destructuringPatterns, expression, variable)) continue;
                    this.reportUnusedValueProblem((JSElement)expression, false);
                }
                for (Map.Entry entry : destructuringPatterns.entrySet()) {
                    List problems = (List)entry.getValue();
                    JSElement pattern = JSUnusedAssignmentInspection.getDestructuringAssignmentTarget((JSExpression)entry.getKey());
                    if (pattern == null) continue;
                    List variables = JSUnusedAssignmentInspection.collectPatternVariables(pattern);
                    if (problems.isEmpty() || !Comparing.haveEqualElements((Collection)problems, (Collection)variables)) continue;
                    this.reportUnusedValueProblem((JSElement)entry.getKey(), true);
                }
            }

            private boolean isIIFE(JSExecutionScope scope) {
                return scope instanceof JSFunction && JSPsiImplUtils.isIIFE((JSFunction)scope);
            }

            private boolean postponeDestructuring(@NotNull HashMap<JSExpression, List<JSVariable>> destructuringAssignments, @NotNull JSExpression expression, @NotNull JSVariable variable) {
                JSElement pattern;
                if (destructuringAssignments == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (expression == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (variable == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((pattern = JSUnusedAssignmentInspection.getDestructuringAssignmentTarget(expression)) == null) {
                    return false;
                }
                ((List)ContainerUtil.getOrCreate(destructuringAssignments, (Object)expression, ContainerUtil::newArrayList)).add(variable);
                return true;
            }

            private boolean isPlaceWeNotWorkingReliablyIn(JSExpression key, JSExecutionScope scope) {
                JSElement place = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)key, (Class[])new Class[]{JSLoopStatement.class, JSSwitchStatement.class, scope.getClass()});
                return place != null && place != scope;
            }

            private boolean isElementFromProperScope(JSVariable v, JSExecutionScope scope) {
                if (PsiTreeUtil.getParentOfType((PsiElement)v, JSExecutionScope.class) != scope) {
                    return false;
                }
                return !(JSResolveUtil.findParent((PsiElement)v) instanceof JSClass);
            }

            private void reportUnusedValueProblem(@NotNull JSElement assignedExpression, boolean unused) {
                LocalQuickFix[] localQuickFixArray;
                RemoveInitializerQuickFix quickFix;
                String description;
                if (assignedExpression == null) {
                    1.$$$reportNull$$$0(3);
                }
                PsiElement declarationOrAssignmentExpression = assignedExpression.getParent();
                PsiElement toHighlight = JSUnusedAssignmentInspection.getHighlightTarget(assignedExpression);
                if (!unused && declarationOrAssignmentExpression instanceof JSVariable || declarationOrAssignmentExpression instanceof JSDestructuringElement) {
                    description = JSBundle.message((String)"js.variable.initializer.is.redundant", (Object[])new Object[0]);
                    quickFix = declarationOrAssignmentExpression instanceof JSVariable ? new RemoveInitializerQuickFix() : null;
                } else {
                    description = JSBundle.message((String)"js.value.assigned.is.never.used", (Object[])new Object[0]);
                    PsiElement assignmentParent = JSUtils.getParentSkipParentheses(declarationOrAssignmentExpression);
                    JSFixFactory fixFactory = JSFixFactory.getInstance();
                    Object object = quickFix = assignmentParent instanceof JSExpressionStatement ? fixFactory.removeASTNodeFix("js.remove.unused.assignment", true, assignmentParent.getNode(), assignmentParent.getNode()) : null;
                }
                if (quickFix != null) {
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray2;
                    localQuickFixArray2[0] = quickFix;
                } else {
                    localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                }
                holder.registerProblem(toHighlight, description, ProblemHighlightType.LIKE_UNUSED_SYMBOL, localQuickFixArray);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "destructuringAssignments";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "variable";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "assignedExpression";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSUnusedAssignmentInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "postponeDestructuring";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "reportUnusedValueProblem";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (jSElementVisitor == null) {
            JSUnusedAssignmentInspection.$$$reportNull$$$0(3);
        }
        return jSElementVisitor;
    }

    @NotNull
    private static PsiElement getHighlightTarget(@NotNull JSElement e) {
        if (e == null) {
            JSUnusedAssignmentInspection.$$$reportNull$$$0(4);
        }
        PsiElement parent = e.getParent();
        PsiElement messageTarget = null;
        if (parent instanceof JSAssignmentExpression) {
            JSExpression lOperand = ((JSAssignmentExpression)parent).getLOperand();
            if (lOperand instanceof JSDefinitionExpression) {
                lOperand = ((JSDefinitionExpression)lOperand).getExpression();
            }
            messageTarget = lOperand;
        } else if (parent instanceof JSVariable) {
            messageTarget = ((JSVariable)parent).getNameIdentifier();
        } else if (parent instanceof JSDestructuringElement) {
            messageTarget = ((JSDestructuringElement)parent).getTarget();
        }
        if (messageTarget == null) {
            messageTarget = e;
        }
        PsiElement psiElement = messageTarget;
        if (psiElement == null) {
            JSUnusedAssignmentInspection.$$$reportNull$$$0(5);
        }
        return psiElement;
    }

    @NotNull
    private static List<JSVariable> collectPatternVariables(@NotNull JSElement pattern) {
        if (pattern == null) {
            JSUnusedAssignmentInspection.$$$reportNull$$$0(6);
        }
        if (pattern instanceof JSDestructuringContainer) {
            ArrayList vars = ContainerUtil.newArrayList();
            PsiTreeUtil.processElements((PsiElement)pattern, element -> {
                if (element instanceof JSVariable) {
                    vars.add((JSVariable)element);
                }
                return true;
            });
            ArrayList arrayList = vars;
            if (arrayList == null) {
                JSUnusedAssignmentInspection.$$$reportNull$$$0(7);
            }
            return arrayList;
        }
        if (pattern instanceof JSObjectLiteralExpression || pattern instanceof JSArrayLiteralExpression) {
            List list = ContainerUtil.map(JSDestructuringUtil.collectAssignmentTargets((JSExpression)pattern), expression -> {
                PsiElement resolved = expression.resolve();
                return resolved instanceof JSVariable ? (JSVariable)resolved : null;
            });
            if (list == null) {
                JSUnusedAssignmentInspection.$$$reportNull$$$0(8);
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            JSUnusedAssignmentInspection.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Nullable
    private static JSElement getDestructuringAssignmentTarget(@NotNull JSExpression assigned) {
        JSElement assignment;
        if (assigned == null) {
            JSUnusedAssignmentInspection.$$$reportNull$$$0(10);
        }
        if ((assignment = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)assigned, (Class[])new Class[]{JSDestructuringElement.class, JSAssignmentExpression.class})) instanceof JSDestructuringElement) {
            return ((JSDestructuringElement)assignment).getTarget();
        }
        if (assignment instanceof JSAssignmentExpression) {
            JSExpression lOperand;
            JSDefinitionExpression definitionExpression = ((JSAssignmentExpression)assignment).getDefinitionExpression();
            JSExpression jSExpression = lOperand = definitionExpression != null ? definitionExpression.getExpression() : null;
            if (lOperand instanceof JSArrayLiteralExpression || lOperand instanceof JSObjectLiteralExpression) {
                return lOperand;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 6: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 6: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSUnusedAssignmentInspection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assigned";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 4: 
            case 6: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSUnusedAssignmentInspection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightTarget";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPatternVariables";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightTarget";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectPatternVariables";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDestructuringAssignmentTarget";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SimpleControlFlowProcessor
    extends JSControlFlowProcessor {
        private final Map<JSVariable, Map<JSExpression, Boolean>> myVariablesWritten;
        private final Map<JSExpression, JSVariable> myVariablesReadWithoutInitialization;
        private final Set<JSVariable> myReadAtLeastOnce;
        private final Set<String> myVariablesReferencedInInners;
        private final List<Pair<JSExpression, JSVariable>> myValuesOverwritten;
        final List<BasicBlockInfo> basicBlockInfos;
        final List<PsiElement> branches;
        final List<DefinedValuesInfo> livesValues;
        PsiElement currentBranch;
        DefinedValuesInfo liveValuesForBranch;
        Set<JSVariable> conditionalVariablesForCurrentStatement;
        BasicBlockInfo currentBlockInfo;

        SimpleControlFlowProcessor(Map<JSVariable, Map<JSExpression, Boolean>> variablesWritten, Map<JSExpression, JSVariable> variablesReadWithoutInitialization, Set<JSVariable> readAtLeastOnce, Set<String> variablesReferencedInInners, List<Pair<JSExpression, JSVariable>> valuesOverwritten) {
            this.myVariablesWritten = variablesWritten;
            this.myVariablesReadWithoutInitialization = variablesReadWithoutInitialization;
            this.myReadAtLeastOnce = readAtLeastOnce;
            this.myVariablesReferencedInInners = variablesReferencedInInners;
            this.myValuesOverwritten = valuesOverwritten;
            this.basicBlockInfos = new ArrayList<BasicBlockInfo>(2);
            this.branches = new ArrayList<PsiElement>(2);
            this.livesValues = new ArrayList<DefinedValuesInfo>(2);
            this.liveValuesForBranch = new DefinedValuesInfo(this.myVariablesWritten);
            this.livesValues.add(this.liveValuesForBranch);
            this.currentBlockInfo = new BasicBlockInfo();
            this.basicBlockInfos.add(this.currentBlockInfo);
        }

        @Override
        public void valueRead(JSExpression expression) {
            PsiElement resolve;
            if (expression instanceof JSReferenceExpression && ((JSReferenceExpression)expression).getQualifier() == null && (resolve = ((JSReferenceExpression)expression).resolve()) instanceof JSVariable && !(resolve instanceof ImplicitJSVariableImpl)) {
                boolean readSomething;
                JSVariable var = (JSVariable)resolve;
                boolean bl = readSomething = resolve instanceof JSParameter || TypeScriptPsiUtil.isAmbientDeclaration((PsiElement)var);
                for (int i = this.livesValues.size() - 1; i >= 0; --i) {
                    DefinedValuesInfo info = this.livesValues.get(i);
                    Map<JSExpression, Boolean> usedValues = info.variablesWritten.get(var);
                    if (usedValues != null) {
                        for (JSExpression e : usedValues.keySet()) {
                            usedValues.put(e, Boolean.TRUE);
                            readSomething = true;
                        }
                    }
                    if (info.conditionalVariables == null || !info.conditionalVariables.contains(var)) continue;
                    readSomething = true;
                }
                if (!readSomething && SimpleControlFlowProcessor.isReadInConditional(expression)) {
                    if (this.conditionalVariablesForCurrentStatement == null) {
                        this.conditionalVariablesForCurrentStatement = new THashSet(1);
                    }
                    this.conditionalVariablesForCurrentStatement.add(var);
                    readSomething = true;
                }
                if (!readSomething && this.conditionalVariablesForCurrentStatement != null && this.conditionalVariablesForCurrentStatement.contains(var)) {
                    readSomething = true;
                }
                if (!readSomething) {
                    this.myVariablesReadWithoutInitialization.put(expression, var);
                }
                this.myReadAtLeastOnce.add(var);
            }
        }

        @Override
        public void finishStatement(JSElement node) {
            this.conditionalVariablesForCurrentStatement = null;
        }

        @Override
        public void branchStarted(@Nullable JSExpression condition, JSElement node, JSExpression ... arguments) {
            this.liveValuesForBranch = new DefinedValuesInfo();
            if (this.conditionalVariablesForCurrentStatement != null) {
                this.liveValuesForBranch.conditionalVariables = this.conditionalVariablesForCurrentStatement;
                this.conditionalVariablesForCurrentStatement = null;
            }
            this.livesValues.add(this.liveValuesForBranch);
            if (this.currentBranch != null) {
                this.branches.add(this.currentBranch);
            }
            this.currentBranch = node;
        }

        @Override
        public void branchFinished(JSElement branchId) {
            this.currentBranch = this.branches.size() > 0 ? this.branches.remove(this.branches.size() - 1) : null;
            this.currentBlockInfo.branchesToMerge.add(this.liveValuesForBranch);
            this.livesValues.remove(this.livesValues.size() - 1);
            this.liveValuesForBranch = this.livesValues.get(this.livesValues.size() - 1);
            this.conditionalVariablesForCurrentStatement = null;
        }

        @Override
        public void branchingStarted(@Nullable JSElement node) {
            this.basicBlockInfos.add(this.currentBlockInfo);
            this.currentBlockInfo = new BasicBlockInfo();
        }

        @Override
        public void functionEncountered(JSFunction function) {
            ((JSFunctionBaseImpl)function).addReferencedExternalNames(this.myVariablesReferencedInInners);
        }

        @Override
        public void branchingFinished(@Nullable JSElement condition) {
            for (DefinedValuesInfo m : this.currentBlockInfo.branchesToMerge) {
                for (Map.Entry<JSVariable, Map<JSExpression, Boolean>> e : m.variablesWritten.entrySet()) {
                    Map<JSExpression, Boolean> map = this.liveValuesForBranch.variablesWritten.get(e.getKey());
                    if (map == null) {
                        map = e.getValue();
                        this.liveValuesForBranch.variablesWritten.put(e.getKey(), map);
                        continue;
                    }
                    map.putAll(e.getValue());
                }
            }
            this.currentBlockInfo = this.basicBlockInfos.remove(this.basicBlockInfos.size() - 1);
        }

        @Override
        public void valueWritten(JSElement element, JSExpression rOperand) {
            JSVariable var = null;
            if (element instanceof JSReferenceExpression && ((JSReferenceExpression)element).getQualifier() == null) {
                PsiElement resolve = ((JSReferenceExpression)element).resolve();
                if (resolve instanceof JSVariable) {
                    var = (JSVariable)resolve;
                }
            } else if (element instanceof JSVariable) {
                var = (JSVariable)element;
            }
            if (var != null && rOperand != null) {
                THashMap valuesMap = this.liveValuesForBranch.variablesWritten.get(var);
                if (valuesMap == null) {
                    valuesMap = new THashMap(1);
                    this.liveValuesForBranch.variablesWritten.put(var, (Map<JSExpression, Boolean>)valuesMap);
                }
                Iterator<JSExpression> iterator = valuesMap.keySet().iterator();
                while (iterator.hasNext()) {
                    JSExpression e = iterator.next();
                    if (valuesMap.get(e) != null) continue;
                    this.myValuesOverwritten.add((Pair<JSExpression, JSVariable>)Pair.create((Object)e, (Object)var));
                    iterator.remove();
                }
                valuesMap.put(rOperand, null);
            }
        }

        private static boolean isStrictlyReadInConditional(JSExpression key) {
            PsiElement parent;
            if (!SimpleControlFlowProcessor.isReadInConditional(key)) {
                return false;
            }
            JSExpression child = key;
            for (parent = child.getParent(); parent != null && !(parent instanceof JSStatement); parent = parent.getParent()) {
                child = parent;
            }
            return parent != null && child instanceof JSExpression && SimpleControlFlowProcessor.isConditionOfBlock(child, parent);
        }

        private static boolean isReadInConditional(JSExpression key) {
            IElementType sign;
            PsiElement parent = JSPsiImplUtils.getNonParenthesizeParent((PsiElement)key);
            if (parent instanceof JSPrefixExpression && ((sign = ((JSPrefixExpression)parent).getOperationSign()) == JSTokenTypes.EXCL || sign == JSTokenTypes.TYPEOF_KEYWORD)) {
                return true;
            }
            if (SimpleControlFlowProcessor.isConditionOfBlock(key, parent)) {
                return true;
            }
            if (parent instanceof JSBinaryExpression) {
                JSBinaryExpression binaryExpression = (JSBinaryExpression)parent;
                IElementType sign2 = binaryExpression.getOperationSign();
                if (sign2 == JSTokenTypes.ANDAND) {
                    return true;
                }
                if (JSTokenTypes.EQUALITY_OPERATIONS.contains(sign2) && (key == binaryExpression.getROperand() && SimpleControlFlowProcessor.isUndefinedOperand(binaryExpression.getLOperand()) || key == binaryExpression.getLOperand() && SimpleControlFlowProcessor.isUndefinedOperand(binaryExpression.getROperand()))) {
                    return true;
                }
            }
            return false;
        }

        private static boolean isConditionOfBlock(JSExpression key, PsiElement parent) {
            return parent instanceof JSIfStatement && key == ((JSIfStatement)parent).getCondition() || parent instanceof JSLoopStatement && key == ((JSLoopStatement)parent).getCondition() || parent instanceof JSConditionalExpression && key == ((JSConditionalExpression)parent).getCondition();
        }

        private static boolean isUndefinedOperand(JSExpression operand) {
            if (!(operand instanceof JSReferenceExpression)) {
                return false;
            }
            JSReferenceExpression referenceExpression = (JSReferenceExpression)operand;
            if (referenceExpression.getQualifier() != null) {
                return false;
            }
            return "undefined".equals(referenceExpression.getText());
        }

        private static class BasicBlockInfo {
            final List<DefinedValuesInfo> branchesToMerge = new ArrayList<DefinedValuesInfo>(2);

            private BasicBlockInfo() {
            }
        }

        private static class DefinedValuesInfo {
            final Map<JSVariable, Map<JSExpression, Boolean>> variablesWritten;
            Set<JSVariable> conditionalVariables;

            DefinedValuesInfo(Map<JSVariable, Map<JSExpression, Boolean>> written) {
                this.variablesWritten = written;
            }

            DefinedValuesInfo() {
                this((Map<JSVariable, Map<JSExpression, Boolean>>)new THashMap(2));
            }
        }
    }

    private static class RemoveInitializerQuickFix
    implements LocalQuickFix {
        private RemoveInitializerQuickFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JSBundle.message((String)"js.remove.redundant.initializer.fix", (Object[])new Object[0]);
            if (string == null) {
                RemoveInitializerQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            JSType type;
            JSElement parent;
            JSExpression initializer;
            if (project == null) {
                RemoveInitializerQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                RemoveInitializerQuickFix.$$$reportNull$$$0(2);
            }
            JSExpression jSExpression = initializer = (parent = (JSElement)descriptor2.getStartElement().getParent()) instanceof JSInitializerOwner ? ((JSInitializerOwner)parent).getInitializer() : null;
            if (initializer == null) {
                return;
            }
            PsiElement eq = JSPsiImplUtils.getPrevSiblingIgnoreWhitespace((PsiElement)initializer);
            if (eq == null || eq.getNode().getElementType() != JSTokenTypes.EQ) {
                return;
            }
            DialectOptionHolder dialectOptionHolder = DialectDetector.dialectOfElement((PsiElement)initializer);
            if (dialectOptionHolder != null && dialectOptionHolder.isTypeScript && (type = JSResolveUtil.getExpressionJSType(initializer)) != null) {
                String typeText = type.getTypeText(JSType.TypeTextFormat.CODE);
                JSStatement dummyVarStatement = JSChangeUtil.createStatementPsiFromTextWithContext("var dummy: " + typeText, (PsiElement)parent, JSStatement.class);
                if (dummyVarStatement == null) {
                    return;
                }
                PsiElement typeElement = dummyVarStatement.getLastChild().getLastChild();
                PsiElement colon = (PsiElement)ObjectUtils.assertNotNull((Object)JSPsiImplUtils.getPrevSiblingIgnoreWhitespace(typeElement));
                parent.addBefore(colon, eq);
                parent.addBefore(typeElement, eq);
            }
            eq.delete();
            initializer.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSUnusedAssignmentInspection$RemoveInitializerQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSUnusedAssignmentInspection$RemoveInitializerQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

