/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.ErrorUtil;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSVariablesWithInitializerPredicate
implements JSElementPredicate {
    public static final JSElementPredicate PREDICATE = new JSVariablesWithInitializerPredicate();

    @Override
    public boolean satisfiedBy(@NotNull PsiElement element) {
        if (element == null) {
            JSVariablesWithInitializerPredicate.$$$reportNull$$$0(0);
        }
        if (!(element instanceof JSVarStatement)) {
            return false;
        }
        PsiElement elementParent = element.getParent();
        if (!JSVariablesWithInitializerPredicate.isRegularVariableContext(elementParent)) {
            return false;
        }
        JSVarStatement varStatement = (JSVarStatement)element;
        if (ErrorUtil.containsError((PsiElement)varStatement)) {
            return false;
        }
        for (JSVariable variable : varStatement.getVariables()) {
            if (!this.isAcceptableVariable(variable)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRegularVariableContext(@Nullable PsiElement statementParent) {
        return !(statementParent instanceof JSForStatement) && !(statementParent instanceof JSClass) && (!(statementParent instanceof JSFile) || JSResolveUtil.getClassOfContext(statementParent) == null);
    }

    protected boolean isAcceptableVariable(@NotNull JSVariable variable) {
        if (variable == null) {
            JSVariablesWithInitializerPredicate.$$$reportNull$$$0(1);
        }
        return variable.hasInitializer() && !variable.isConst();
    }

    @Nullable
    public static String formatType(@NotNull JSType type, @Nullable PsiElement context) {
        DialectOptionHolder holder;
        if (type == null) {
            JSVariablesWithInitializerPredicate.$$$reportNull$$$0(2);
        }
        if ((holder = DialectDetector.dialectOfElement(context)) == null) {
            return null;
        }
        if (holder.isECMA4) {
            String result = JSTypeUtils.getPresentableType(type, true);
            return (String)ImportUtils.importAndShortenReference((String)result, (PsiElement)context, (boolean)true, (boolean)true).first;
        }
        String result = TypeScriptUtil.getShortestTypeNameInContext(type, context);
        if (result.contains("\".")) {
            return result.replaceAll("\".*?\"\\.", "");
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/inspections/JSVariablesWithInitializerPredicate";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "satisfiedBy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isAcceptableVariable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "formatType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

