/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.ecmascript6.psi.ES6FunctionProperty;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.generation.JSGetterSetterGenerationMode;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionProperty;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFunctionsHelper {
    public static JSFunction createAnonymousFunction(JSFunction function) {
        return JSFunctionsHelper.createFunction(function, "");
    }

    @Nullable
    public static ES6FunctionProperty createFunctionProperty(@NotNull JSFunction sourceFunction, @NotNull String name) {
        JSObjectLiteralExpression result;
        if (sourceFunction == null) {
            JSFunctionsHelper.$$$reportNull$$$0(0);
        }
        if (name == null) {
            JSFunctionsHelper.$$$reportNull$$$0(1);
        }
        if ((result = JSChangeUtil.createExpressionPsiWithContext(String.format("{%s%s %s(){}}", JSFunctionsHelper.getGeneratorMultText(sourceFunction), JSFunctionsHelper.getFunctionAttributesModifiersText(sourceFunction), name), (PsiElement)sourceFunction, JSObjectLiteralExpression.class)) == null || !(result.getFirstProperty() instanceof JSFunctionProperty)) {
            return null;
        }
        ES6FunctionProperty property = (ES6FunctionProperty)result.getFirstProperty();
        JSFunctionsHelper.moveParameters(sourceFunction, (JSFunction)property);
        JSFunctionsHelper.moveFunctionBody(sourceFunction, (JSFunction)property);
        return property;
    }

    public static JSFunction createGetter(@NotNull Project project, @NotNull JSFunction sourceFunction, @NotNull String name, boolean isStatic) {
        if (project == null) {
            JSFunctionsHelper.$$$reportNull$$$0(2);
        }
        if (sourceFunction == null) {
            JSFunctionsHelper.$$$reportNull$$$0(3);
        }
        if (name == null) {
            JSFunctionsHelper.$$$reportNull$$$0(4);
        }
        JSFunction function = JSFunctionsHelper.createAccessorInClassFromText(project, JSGetterSetterGenerationMode.Getter, name, isStatic, null, false);
        JSFunctionsHelper.moveFunctionBody(sourceFunction, function);
        return function;
    }

    @NotNull
    public static JSFunction createAccessorInClassFromText(@NotNull Project project, @NotNull JSGetterSetterGenerationMode generationMode, @NotNull String name, boolean isStatic, @Nullable String innerText, boolean withParameter) {
        if (project == null) {
            JSFunctionsHelper.$$$reportNull$$$0(5);
        }
        if (generationMode == null) {
            JSFunctionsHelper.$$$reportNull$$$0(6);
        }
        if (name == null) {
            JSFunctionsHelper.$$$reportNull$$$0(7);
        }
        assert (JSGetterSetterGenerationMode.Getter.equals((Object)generationMode) || JSGetterSetterGenerationMode.Setter.equals((Object)generationMode));
        String paramText = JSGetterSetterGenerationMode.Setter.equals((Object)generationMode) && withParameter ? "value" : "";
        String functionText = "class d{" + (isStatic ? "static " : "") + (JSGetterSetterGenerationMode.Getter.equals((Object)generationMode) ? "get " : "set ") + name + "(" + paramText + ")" + (innerText == null ? "{}" : innerText) + "}";
        ASTNode ast = JSChangeUtil.createExpressionFromText(project, functionText);
        assert (ast != null);
        ES6Class aClass = (ES6Class)ast.getPsi(ES6Class.class);
        JSFunction function = (JSFunction)PsiTreeUtil.getChildOfType((PsiElement)aClass, JSFunction.class);
        assert (function != null);
        JSFunction jSFunction = function;
        if (jSFunction == null) {
            JSFunctionsHelper.$$$reportNull$$$0(8);
        }
        return jSFunction;
    }

    public static JSFunction createSetter(@NotNull Project project, @NotNull JSFunction sourceFunction, @NotNull String name, boolean isStatic) {
        if (project == null) {
            JSFunctionsHelper.$$$reportNull$$$0(9);
        }
        if (sourceFunction == null) {
            JSFunctionsHelper.$$$reportNull$$$0(10);
        }
        if (name == null) {
            JSFunctionsHelper.$$$reportNull$$$0(11);
        }
        JSFunction function = JSFunctionsHelper.createAccessorInClassFromText(project, JSGetterSetterGenerationMode.Setter, name, isStatic, null, false);
        JSFunctionsHelper.moveParameters(sourceFunction, function);
        JSFunctionsHelper.moveFunctionBody(sourceFunction, function);
        return function;
    }

    public static JSFunction createFunction(@NotNull JSFunction sourceFunction, @NotNull String name) {
        if (sourceFunction == null) {
            JSFunctionsHelper.$$$reportNull$$$0(12);
        }
        if (name == null) {
            JSFunctionsHelper.$$$reportNull$$$0(13);
        }
        String functionText = JSFunctionsHelper.getFunctionAttributesModifiersText(sourceFunction) + " function " + JSFunctionsHelper.getGeneratorMultText(sourceFunction) + name + "(){}";
        JSFunction function = JSChangeUtil.createExpressionPsiWithContext(functionText, (PsiElement)sourceFunction, JSFunction.class);
        assert (function != null);
        JSFunctionsHelper.moveParameters(sourceFunction, function);
        JSFunctionsHelper.moveFunctionBody(sourceFunction, function);
        return function;
    }

    public static String getFunctionAttributesModifiersText(@NotNull JSFunction sourceFunction) {
        JSAttributeList attributes;
        if (sourceFunction == null) {
            JSFunctionsHelper.$$$reportNull$$$0(14);
        }
        if ((attributes = sourceFunction.getAttributeList()) != null && !StringUtil.isEmptyOrSpaces((String)attributes.getText())) {
            return attributes.getText() + " ";
        }
        return "";
    }

    private static String getGeneratorMultText(@NotNull JSFunction function) {
        ASTNode node;
        if (function == null) {
            JSFunctionsHelper.$$$reportNull$$$0(15);
        }
        return (node = function.getNode().findChildByType(JSTokenTypes.MULT)) != null ? "*" : "";
    }

    public static void copyFunctionFilling(@NotNull JSFunction source, @NotNull JSFunction target) {
        if (source == null) {
            JSFunctionsHelper.$$$reportNull$$$0(16);
        }
        if (target == null) {
            JSFunctionsHelper.$$$reportNull$$$0(17);
        }
        JSFunctionsHelper.moveParameters(source, target);
        JSFunctionsHelper.moveFunctionBody(source, target);
    }

    public static void moveParameters(@NotNull JSFunction source, @NotNull JSFunction target) {
        if (source == null) {
            JSFunctionsHelper.$$$reportNull$$$0(18);
        }
        if (target == null) {
            JSFunctionsHelper.$$$reportNull$$$0(19);
        }
        if (source.getParameters().length > 0) {
            JSParameterList sourceParameterList = source.getParameterList();
            assert (sourceParameterList != null);
            assert (target.getParameterList() != null);
            if (JSFunctionsHelper.noBracesAroundSingleParameter(sourceParameterList) && sourceParameterList.getParameters().length == 1) {
                if (JSFunctionsHelper.noBracesAroundSingleParameter(target.getParameterList())) {
                    target.getParameterList().deleteChildRange(target.getParameterList().getFirstChild(), target.getParameterList().getLastChild());
                    target.getParameterList().add(sourceParameterList.getParameters()[0].copy());
                } else {
                    target.getParameterList().addAfter(sourceParameterList.getParameters()[0].copy(), target.getParameterList().getFirstChild());
                }
            } else {
                JSChangeUtil.replaceElement((JSElement)target.getParameterList(), (JSElement)sourceParameterList.copy());
            }
        }
    }

    private static boolean noBracesAroundSingleParameter(JSParameterList sourceParameterList) {
        return sourceParameterList.getParameters().length > 0 && sourceParameterList.getFirstChild() == sourceParameterList.getParameters()[0];
    }

    public static void moveFunctionBody(@NotNull JSFunction source, @NotNull JSFunction target) {
        if (source == null) {
            JSFunctionsHelper.$$$reportNull$$$0(20);
        }
        if (target == null) {
            JSFunctionsHelper.$$$reportNull$$$0(21);
        }
        JSBlockStatement targetBlock = (JSBlockStatement)PsiTreeUtil.getChildOfType((PsiElement)target, JSBlockStatement.class);
        JSFunctionsHelper.moveFunctionBody(source, targetBlock);
    }

    public static JSStatement moveFunctionBody(JSFunction source, JSBlockStatement targetBlock) {
        JSBlockStatement sourceBlock = (JSBlockStatement)PsiTreeUtil.getChildOfType((PsiElement)source, JSBlockStatement.class);
        if (sourceBlock != null) {
            return JSChangeUtil.replaceStatement((JSStatement)targetBlock, (JSStatement)sourceBlock.copy());
        }
        JSElement body = JSChangeUtil.getFunctionBody(source);
        if (body != null) {
            if (!(body instanceof JSStatement)) {
                String returnText = "return 1" + JSCodeStyleSettings.getSemicolon(source.getContainingFile());
                JSReturnStatement statement = JSChangeUtil.createStatementSafe(source.getProject(), returnText, JSReturnStatement.class);
                JSElement element = body;
                element = element instanceof JSParenthesizedExpression && ((JSParenthesizedExpression)element).getInnerExpression() != null ? ((JSParenthesizedExpression)element).getInnerExpression() : element;
                JSChangeUtil.replaceElement((JSElement)statement.getExpression(), element);
                body = statement;
            }
            targetBlock.addAfter((PsiElement)body, targetBlock.getFirstChild());
        }
        return targetBlock;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFunction";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generationMode";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSFunctionsHelper";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSFunctionsHelper";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createAccessorInClassFromText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFunctionProperty";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createGetter";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createAccessorInClassFromText";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createSetter";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createFunction";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionAttributesModifiersText";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getGeneratorMultText";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "copyFunctionFilling";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "moveParameters";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "moveFunctionBody";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class AccessorsGenerator {
        @NotNull
        private final PsiElement myBaseElement;
        @NotNull
        private final String myName;
        private boolean myIsGetter;
        private String myQualifier;
        private String myBeforeText;
        private String myAfterText;
        private JSNamedElement myNamedElement;

        public AccessorsGenerator(@NotNull PsiElement baseElement, @NotNull String name) {
            if (baseElement == null) {
                AccessorsGenerator.$$$reportNull$$$0(0);
            }
            if (name == null) {
                AccessorsGenerator.$$$reportNull$$$0(1);
            }
            this.myIsGetter = true;
            this.myBaseElement = baseElement;
            this.myName = name;
        }

        public String generate() {
            this.myQualifier = this.myQualifier != null ? this.myQualifier + "." : "";
            String semicolon = JSCodeStyleSettings.getSemicolon(this.myBaseElement.getContainingFile());
            StringBuilder sb = new StringBuilder("{\n");
            if (this.myBeforeText != null) {
                sb.append(this.myBeforeText);
            }
            if (this.myIsGetter) {
                sb.append("return ");
                this.qualifiedName(sb).append(semicolon);
            } else {
                this.qualifiedName(sb).append("=").append("value").append(semicolon);
            }
            if (this.myAfterText != null) {
                sb.append(this.myAfterText);
            }
            sb.append("\n}");
            return sb.toString();
        }

        @NotNull
        private StringBuilder qualifiedName(StringBuilder sb) {
            if (this.myNamedElement instanceof JSDefinitionExpression && ((JSDefinitionExpression)this.myNamedElement).getExpression() instanceof JSIndexedPropertyAccessExpression) {
                StringBuilder stringBuilder = sb.append(this.myQualifier.substring(0, this.myQualifier.length() - 1)).append(this.myName);
                if (stringBuilder == null) {
                    AccessorsGenerator.$$$reportNull$$$0(2);
                }
                return stringBuilder;
            }
            if (this.myQualifier.length() > 0) {
                if (this.myName.startsWith("[")) {
                    StringBuilder stringBuilder = sb.append(this.myQualifier.substring(0, this.myQualifier.length() - 1)).append(this.myName);
                    if (stringBuilder == null) {
                        AccessorsGenerator.$$$reportNull$$$0(3);
                    }
                    return stringBuilder;
                }
                if (this.myName.startsWith("\"") || this.myName.startsWith("'")) {
                    StringBuilder stringBuilder = sb.append(this.myQualifier.substring(0, this.myQualifier.length() - 1)).append("[").append(this.myName).append("]");
                    if (stringBuilder == null) {
                        AccessorsGenerator.$$$reportNull$$$0(4);
                    }
                    return stringBuilder;
                }
            }
            StringBuilder stringBuilder = sb.append(this.myQualifier).append(this.myName);
            if (stringBuilder == null) {
                AccessorsGenerator.$$$reportNull$$$0(5);
            }
            return stringBuilder;
        }

        public AccessorsGenerator setter() {
            this.myIsGetter = false;
            return this;
        }

        public AccessorsGenerator getter() {
            this.myIsGetter = true;
            return this;
        }

        public AccessorsGenerator setQualifier(String qualifier) {
            this.myQualifier = qualifier;
            return this;
        }

        public AccessorsGenerator setBeforeText(String beforeText) {
            this.myBeforeText = beforeText;
            return this;
        }

        public AccessorsGenerator setAfterText(String afterText) {
            this.myAfterText = afterText;
            return this;
        }

        public AccessorsGenerator setNamedElement(JSNamedElement namedElement) {
            this.myNamedElement = namedElement;
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/intentions/JSFunctionsHelper$AccessorsGenerator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/intentions/JSFunctionsHelper$AccessorsGenerator";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "qualifiedName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

