/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSplitDeclarationIntention
extends JavaScriptIntention {
    public JSSplitDeclarationIntention() {
        this.setText(JSBundle.message((String)"js.split.into.multiple.declarations", (Object[])new Object[0]));
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            JSSplitDeclarationIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JSSplitDeclarationIntention.$$$reportNull$$$0(1);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        JSVarStatement varStatement = (JSVarStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSVarStatement.class);
        return varStatement != null && !(varStatement.getParent() instanceof TypeScriptEnum) && PsiTreeUtil.getChildOfType((PsiElement)varStatement, JSDestructuringElement.class) == null && varStatement.getVariables().length > 1;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSSplitDeclarationIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            JSSplitDeclarationIntention.$$$reportNull$$$0(3);
        }
        JSVarStatement varStatement = (JSVarStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSVarStatement.class);
        assert (varStatement != null);
        String varModifier = varStatement.getVarKeyword().getText();
        String semicolon = JSCodeStyleSettings.getSemicolon(element.getContainingFile());
        JSVariable[] variables = varStatement.getVariables();
        JSVarStatement elem = varStatement;
        for (JSVariable variable : variables) {
            List<PsiComment> comments = JSSplitDeclarationIntention.collectLeadingComments(variable);
            JSDocComment docComment = JSSplitDeclarationIntention.getDocComment(variable, varStatement);
            if (docComment != null) {
                docComment.delete();
            }
            String docCommentText = docComment != null ? docComment.getText() + "\n" : "";
            for (PsiComment comment : comments) {
                elem = JSSplitDeclarationIntention.addElement(JSSplitDeclarationIntention.psiFromText((PsiElement)elem, comment.getText()), (PsiElement)elem);
            }
            PsiElement psi = JSSplitDeclarationIntention.psiFromText(element, docCommentText + varModifier + " " + variable.getText() + semicolon);
            elem = JSSplitDeclarationIntention.addElement(psi, (PsiElement)elem);
        }
        varStatement.delete();
    }

    @Nullable
    private static PsiElement psiFromText(@NotNull PsiElement context, @NotNull String text) {
        if (context == null) {
            JSSplitDeclarationIntention.$$$reportNull$$$0(4);
        }
        if (text == null) {
            JSSplitDeclarationIntention.$$$reportNull$$$0(5);
        }
        return JSChangeUtil.createJSTreeFromText(context.getProject(), text, JSUtils.getDialect(context.getContainingFile())).getPsi();
    }

    @NotNull
    private static List<PsiComment> collectLeadingComments(@NotNull JSVariable variable) {
        if (variable == null) {
            JSSplitDeclarationIntention.$$$reportNull$$$0(6);
        }
        ArrayList results = ContainerUtil.newArrayList();
        for (PsiElement current = variable.getPrevSibling(); current != null && (current instanceof PsiComment || current instanceof PsiWhiteSpace); current = current.getPrevSibling()) {
            if (!(current instanceof PsiComment)) continue;
            results.add((PsiComment)current);
        }
        List list = ContainerUtil.reverse((List)results);
        if (list == null) {
            JSSplitDeclarationIntention.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    private static PsiElement addElement(@Nullable PsiElement psi, @NotNull PsiElement context) {
        if (context == null) {
            JSSplitDeclarationIntention.$$$reportNull$$$0(8);
        }
        if (psi == null) {
            PsiElement psiElement = context;
            if (psiElement == null) {
                JSSplitDeclarationIntention.$$$reportNull$$$0(9);
            }
            return psiElement;
        }
        PsiElement psiElement = context.getParent().addAfter(psi, context);
        if (psiElement == null) {
            JSSplitDeclarationIntention.$$$reportNull$$$0(10);
        }
        return psiElement;
    }

    @Nullable
    public static JSDocComment getDocComment(@NotNull JSVariable variable, @NotNull JSVarStatement varStatement) {
        JSVariable[] variables;
        if (variable == null) {
            JSSplitDeclarationIntention.$$$reportNull$$$0(11);
        }
        if (varStatement == null) {
            JSSplitDeclarationIntention.$$$reportNull$$$0(12);
        }
        JSVariable target = (variables = varStatement.getVariables()).length > 0 && variables[0] == variable ? varStatement : variable;
        return (JSDocComment)PsiTreeUtil.getChildOfType((PsiElement)target, JSDocComment.class);
    }

    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.split.declarations", (Object[])new Object[0]);
        if (string == null) {
            JSSplitDeclarationIntention.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSSplitDeclarationIntention";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSSplitDeclarationIntention";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectLeadingComments";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "addElement";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "psiFromText";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectLeadingComments";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 13: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addElement";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDocComment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

