/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library;

import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.library.JSPredefinedLibraryFilesConverter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.xml.util.HtmlUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLibraryUtil {
    public static final Logger LOG = Logger.getInstance(JSLibraryUtil.class);
    public static final String[] MIN_SUFFIXES = new String[]{".min.", "-min.", "-yui-compressed"};
    public static final HashMap<String, String> MIN_TO_DEV_VERSION_MAP = new HashMap();
    public static final String NODE_MODULES = "node_modules";
    public static final String BOWER_COMPONENTS = "bower_components";
    public static final String JSPM_PACKAGES = "jspm_packages";
    public static final String[] LIBRARY_DIR_NAMES = new String[]{"node_modules", "bower_components", "jspm_packages"};
    public static final Set<String> LIBRARY_ROOT_DIR_NAME_SET = Collections.unmodifiableSet(ContainerUtil.newHashSet((Object[])LIBRARY_DIR_NAMES));
    private static final String JS_EXT = ".js";
    private static final String[] HTTP_PREFIXES;

    private JSLibraryUtil() {
    }

    public static boolean containsLibURL(String location) {
        return HtmlUtil.hasHtmlPrefix((String)location) && location.endsWith(JS_EXT);
    }

    public static String getDevVersionLocation(@NotNull String location) {
        if (location == null) {
            JSLibraryUtil.$$$reportNull$$$0(0);
        }
        if (!location.endsWith(JS_EXT)) {
            return location;
        }
        String oldFileName = JSLibraryUtil.extractFileName(location);
        String fileName = oldFileName;
        if (MIN_TO_DEV_VERSION_MAP.containsKey((Object)fileName)) {
            return location.replace(oldFileName, (CharSequence)MIN_TO_DEV_VERSION_MAP.get((Object)fileName));
        }
        for (String minSuffix : MIN_SUFFIXES) {
            if (!fileName.contains(minSuffix)) continue;
            fileName = oldFileName.replace(minSuffix, ".");
            return location.replace(oldFileName, fileName);
        }
        return location;
    }

    public static String makeUniqueFileName(String filePath, boolean adjustFileName) {
        String path = filePath;
        for (String prefix : HTTP_PREFIXES) {
            if (!filePath.contains(prefix)) continue;
            path = filePath.replace(prefix, "http_");
            break;
        }
        if (adjustFileName) {
            String fileName = JSLibraryUtil.extractFileName(filePath);
            if (MIN_TO_DEV_VERSION_MAP.containsKey((Object)fileName)) {
                path = path.replace(fileName, (CharSequence)MIN_TO_DEV_VERSION_MAP.get((Object)fileName));
            } else {
                for (String minSuffix : MIN_SUFFIXES) {
                    if (!filePath.contains(minSuffix)) continue;
                    path = path.replace(minSuffix, ".");
                    break;
                }
            }
        }
        return path.replace('/', '_').replace('\\', '_');
    }

    public static String extractFileName(String filePath) {
        int fileSepIndex = filePath.lastIndexOf(47);
        if (fileSepIndex < 0) {
            fileSepIndex = filePath.lastIndexOf(File.separatorChar);
        }
        return fileSepIndex >= 0 ? filePath.substring(fileSepIndex + 1, filePath.length()) : filePath;
    }

    @Nullable
    public static String getCanonicalUrl(String path) {
        File file = new File(path);
        try {
            return VfsUtilCore.pathToUrl((String)file.getCanonicalPath());
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getLibName(String location) {
        int dotIndex;
        String libName = JSLibraryUtil.extractFileName(location);
        if (!MIN_TO_DEV_VERSION_MAP.containsKey((Object)libName)) {
            for (String minSuffix : MIN_SUFFIXES) {
                if (!libName.contains(minSuffix)) continue;
                libName = libName.replace(minSuffix, ".");
                break;
            }
        }
        if ((dotIndex = libName.lastIndexOf(46)) >= 0) {
            libName = libName.substring(0, dotIndex);
        }
        return libName;
    }

    public static boolean isProbableLibraryFile(@NotNull VirtualFile file, @Nullable Project project) {
        if (file == null) {
            JSLibraryUtil.$$$reportNull$$$0(1);
        }
        return JSLibraryUtil.isProbableLibraryFile(file, project == null ? null : project.getBaseDir());
    }

    public static boolean isProbableLibraryFile(@NotNull VirtualFile file) {
        if (file == null) {
            JSLibraryUtil.$$$reportNull$$$0(2);
        }
        return JSLibraryUtil.isPredefinedLibraryFile(file) || JSLibraryUtil.hasDirectoryInPath(file, LIBRARY_DIR_NAMES, null);
    }

    public static boolean isProbableLibraryFile(@NotNull VirtualFile file, @Nullable VirtualFile fileToStop) {
        if (file == null) {
            JSLibraryUtil.$$$reportNull$$$0(3);
        }
        return JSLibraryUtil.isPredefinedLibraryFile(file) || JSLibraryUtil.hasDirectoryInPath(file, LIBRARY_DIR_NAMES, fileToStop);
    }

    private static boolean isPredefinedLibraryFile(@NotNull VirtualFile file) {
        if (file == null) {
            JSLibraryUtil.$$$reportNull$$$0(4);
        }
        return JSCorePredefinedLibrariesProvider.getAllJSPredefinedLibraryFiles().contains(file);
    }

    public static VirtualFile getTopLibraryFolder(@NotNull VirtualFile file, @NotNull String libraryFolder, @Nullable VirtualFile stopFolder) {
        if (file == null) {
            JSLibraryUtil.$$$reportNull$$$0(5);
        }
        if (libraryFolder == null) {
            JSLibraryUtil.$$$reportNull$$$0(6);
        }
        VirtualFile currentTarget = file;
        VirtualFile current = file;
        VirtualFile candidate;
        while ((candidate = JSLibraryUtil.getLibraryFolder(currentTarget, libraryFolder)) != null && (stopFolder == null || VfsUtilCore.isAncestor((VirtualFile)stopFolder, (VirtualFile)candidate, (boolean)true))) {
            current = candidate;
            if (current.getParent() == null || current.getParent().getParent() == null) {
                return current;
            }
            currentTarget = current.getParent().getParent();
        }
        return current;
    }

    public static VirtualFile getLibraryFolder(@NotNull VirtualFile file) {
        if (file == null) {
            JSLibraryUtil.$$$reportNull$$$0(7);
        }
        return JSLibraryUtil.getLibraryFolder(file, LIBRARY_ROOT_DIR_NAME_SET);
    }

    public static VirtualFile getLibraryFolder(@NotNull VirtualFile file, @NotNull String libraryFolder) {
        if (file == null) {
            JSLibraryUtil.$$$reportNull$$$0(8);
        }
        if (libraryFolder == null) {
            JSLibraryUtil.$$$reportNull$$$0(9);
        }
        return JSLibraryUtil.getLibraryFolder(file, Collections.singleton(libraryFolder));
    }

    public static VirtualFile getLibraryFolder(@NotNull VirtualFile file, @NotNull Set<String> libraryFolders) {
        if (file == null) {
            JSLibraryUtil.$$$reportNull$$$0(10);
        }
        if (libraryFolders == null) {
            JSLibraryUtil.$$$reportNull$$$0(11);
        }
        VirtualFile current = file;
        while (current != null) {
            CharSequence parentName;
            VirtualFile parent = current.getParent();
            CharSequence charSequence = parentName = parent == null ? null : parent.getNameSequence();
            if (parentName != null && libraryFolders.contains(parentName.toString())) {
                return current;
            }
            current = parent;
        }
        return null;
    }

    public static boolean hasDirectoryInPath(@NotNull VirtualFile file, @NotNull String[] dirNames, @Nullable VirtualFile fileToStop) {
        if (file == null) {
            JSLibraryUtil.$$$reportNull$$$0(12);
        }
        if (dirNames == null) {
            JSLibraryUtil.$$$reportNull$$$0(13);
        }
        for (VirtualFile parent = file.getParent(); !(parent == null || fileToStop != null && parent.equals(fileToStop)); parent = parent.getParent()) {
            CharSequence name = parent.getNameSequence();
            for (String dirName : dirNames) {
                if (!StringUtil.equals((CharSequence)dirName, (CharSequence)name)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasDirectoryInPath(@NotNull VirtualFile file, @NotNull String directoryName, @Nullable VirtualFile fileToStop) {
        if (file == null) {
            JSLibraryUtil.$$$reportNull$$$0(14);
        }
        if (directoryName == null) {
            JSLibraryUtil.$$$reportNull$$$0(15);
        }
        for (VirtualFile parent = file.getParent(); !(parent == null || fileToStop != null && parent.equals(fileToStop)); parent = parent.getParent()) {
            if (!StringUtil.equals((CharSequence)directoryName, (CharSequence)parent.getNameSequence())) continue;
            return true;
        }
        return false;
    }

    public static boolean isProbableLibraryPath(@NotNull String file) {
        if (file == null) {
            JSLibraryUtil.$$$reportNull$$$0(16);
        }
        String name = FileUtil.toSystemDependentName((String)file);
        for (String s : FileUtil.splitPath((String)name)) {
            if (!ArrayUtil.contains((String)s, (String[])LIBRARY_DIR_NAMES)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static VirtualFile findFileByIoFile(@NotNull LocalFileSystem localFileSystem, @NotNull File ioFile) {
        if (localFileSystem == null) {
            JSLibraryUtil.$$$reportNull$$$0(17);
        }
        if (ioFile == null) {
            JSLibraryUtil.$$$reportNull$$$0(18);
        }
        if (!ioFile.isFile()) {
            LOG.warn("Cannot find " + ioFile.getAbsolutePath() + ", the installation is possibly broken.");
            return null;
        }
        VirtualFile file = localFileSystem.findFileByIoFile(ioFile);
        if (file != null) {
            return file;
        }
        LOG.warn("Cannot find virtual file for " + ioFile.getAbsolutePath());
        return null;
    }

    @Nullable
    public static VirtualFile convertFile(@Nullable VirtualFile file) {
        if (file != null) {
            for (JSPredefinedLibraryFilesConverter converter : (JSPredefinedLibraryFilesConverter[])JSPredefinedLibraryFilesConverter.EP_NAME.getExtensions()) {
                file = converter.convert(file);
            }
        }
        return file;
    }

    @Nullable
    public static VirtualFile findUpClosestNodeModulesResolveRoot(@NotNull VirtualFile file) {
        if (file == null) {
            JSLibraryUtil.$$$reportNull$$$0(19);
        }
        for (VirtualFile parent = file.getParent(); parent != null; parent = parent.getParent()) {
            VirtualFile nodeModulesDir = parent.findChild(NODE_MODULES);
            if (nodeModulesDir == null || !nodeModulesDir.isDirectory()) continue;
            return nodeModulesDir;
        }
        return null;
    }

    @Contract(value="_, null, _-> null")
    @Nullable
    public static VirtualFile cacheFile(@NotNull String libFileName, @Nullable VirtualFile file, @NotNull Map<String, Ref<VirtualFile>> cache) {
        if (libFileName == null) {
            JSLibraryUtil.$$$reportNull$$$0(20);
        }
        if (cache == null) {
            JSLibraryUtil.$$$reportNull$$$0(21);
        }
        VirtualFile convertFile = JSLibraryUtil.convertFile(file);
        cache.put(libFileName, (Ref<VirtualFile>)Ref.create((Object)convertFile));
        return convertFile;
    }

    @Contract(value="_, null -> null")
    public static VirtualFile getContentRootForFile(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            JSLibraryUtil.$$$reportNull$$$0(22);
        }
        return JSLibraryUtil.getContentRootForFile(ProjectFileIndex.getInstance((Project)project), file);
    }

    @Contract(value="_, null -> null")
    public static VirtualFile getContentRootForFile(@NotNull ProjectFileIndex fileIndex, @Nullable VirtualFile file) {
        if (fileIndex == null) {
            JSLibraryUtil.$$$reportNull$$$0(23);
        }
        if (file == null) {
            return null;
        }
        VirtualFile contentRoot = fileIndex.getContentRootForFile(file, false);
        if (contentRoot == null && (file = file.getParent()) != null) {
            contentRoot = fileIndex.getContentRootForFile(file, false);
        }
        return contentRoot;
    }

    static {
        MIN_TO_DEV_VERSION_MAP.put((Object)"dojo.xd.js", (Object)"dojo.xd.js.uncompressed.js");
        MIN_TO_DEV_VERSION_MAP.put((Object)"dojo.js", (Object)"dojo.js.uncompressed.js");
        MIN_TO_DEV_VERSION_MAP.put((Object)"ext-core.js", (Object)"ext-core-debug.js");
        MIN_TO_DEV_VERSION_MAP.put((Object)"swfobject.js", (Object)"swfobject_src.js");
        MIN_TO_DEV_VERSION_MAP.put((Object)"webfont.js", (Object)"webfont_debug.js");
        HTTP_PREFIXES = new String[]{"http://", "https://"};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryFolder";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryFolders";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirNames";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFileSystem";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ioFile";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libFileName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIndex";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/library/JSLibraryUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getDevVersionLocation";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isProbableLibraryFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isPredefinedLibraryFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getTopLibraryFolder";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getLibraryFolder";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "hasDirectoryInPath";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "isProbableLibraryPath";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "findFileByIoFile";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "findUpClosestNodeModulesResolveRoot";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "cacheFile";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "getContentRootForFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

