/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.json.JsonUtil;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.linter.JSLinterConfigLangSubstitutor;
import com.intellij.lang.javascript.linter.JSLinterGuesser;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;

public class EslintUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.linter.eslint.EslintUtil");
    public static final String DEFAULT_IGNORE_FILENAME = ".eslintignore";
    public static final String CONFIG_SECTION_NAME = "eslintConfig";
    public static final String PACKAGE_NAME = "eslint";
    public static final String DEFAULT_CONFIG_PREFIX = ".eslintrc";
    private static final String[] CONFIG_EXTENSIONS = new String[]{"", ".js", ".yaml", ".yml", ".json"};
    private static final String[] CONFIG_FILENAMES = new String[CONFIG_EXTENSIONS.length];
    private static final String[] CONFIG_FILENAMES_WITH_PACKAGE_JSON = new String[CONFIG_EXTENSIONS.length + 1];
    private static final String PLUGINS = "plugins";
    private static final String EXTENDS = "extends";
    private static final String HTML = "html";
    private static final String TYPESCRIPT = "typescript";
    public static final String VUE = "vue";

    private EslintUtil() {
    }

    public static boolean isEslintConfigFile(@NotNull PsiElement element) {
        PsiFile file;
        if (element == null) {
            EslintUtil.$$$reportNull$$$0(0);
        }
        if ((file = element.getContainingFile()) != null) {
            file = file.getOriginalFile();
        }
        return file != null && EslintUtil.isEslintConfigFile(file);
    }

    public static boolean isEslintConfigFile(@NotNull PsiFile file) {
        if (file == null) {
            EslintUtil.$$$reportNull$$$0(1);
        }
        return EslintUtil.isEslintConfigFile(file.getViewProvider().getVirtualFile());
    }

    public static boolean isEslintConfigFile(@NotNull VirtualFile file) {
        if (file == null) {
            EslintUtil.$$$reportNull$$$0(2);
        }
        if (!file.isValid() || file.isDirectory()) {
            return false;
        }
        CharSequence name = file.getNameSequence();
        if (StringUtil.startsWith((CharSequence)name, (CharSequence)DEFAULT_CONFIG_PREFIX)) {
            for (String ext : CONFIG_EXTENSIONS) {
                if (name.length() != DEFAULT_CONFIG_PREFIX.length() + ext.length() || !StringUtil.endsWith((CharSequence)name, (CharSequence)ext)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static List<VirtualFile> findAllConfigsWithPackageJsonUpFileSystem(@NotNull VirtualFile fileToLint) {
        if (fileToLint == null) {
            EslintUtil.$$$reportNull$$$0(3);
        }
        List configs = ContainerUtil.newSmartList();
        for (VirtualFile dir = fileToLint.getParent(); dir != null; dir = dir.getParent()) {
            EslintUtil.addAllConfigsWithPackageJsonFromDir(dir, configs);
        }
        List list = configs;
        if (list == null) {
            EslintUtil.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static void addAllConfigsWithPackageJsonFromDir(@NotNull VirtualFile dir, @NotNull List<VirtualFile> configs) {
        if (dir == null) {
            EslintUtil.$$$reportNull$$$0(5);
        }
        if (configs == null) {
            EslintUtil.$$$reportNull$$$0(6);
        }
        for (String name : CONFIG_FILENAMES_WITH_PACKAGE_JSON) {
            VirtualFile file = dir.findChild(name);
            if (file == null || !file.isValid() || file.isDirectory()) continue;
            configs.add(file);
        }
    }

    @NotNull
    public static List<VirtualFile> findAllConfigsInScope(@NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            EslintUtil.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            EslintUtil.$$$reportNull$$$0(8);
        }
        ArrayList result = ContainerUtil.newArrayList();
        EslintUtil.configFilesSearch(project, scope, (Processor<VirtualFile>)((Processor)file -> {
            result.add(file);
            return true;
        }));
        ArrayList arrayList = result;
        if (arrayList == null) {
            EslintUtil.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    public static boolean hasConfigFiles(@NotNull Project project) {
        if (project == null) {
            EslintUtil.$$$reportNull$$$0(10);
        }
        Ref ref = new Ref((Object)false);
        EslintUtil.configFilesSearch(project, GlobalSearchScope.projectScope((Project)project), (Processor<VirtualFile>)((Processor)file -> {
            if (JSLinterGuesser.LOG.isDebugEnabled()) {
                JSLinterGuesser.LOG.debug("Found ESLint config: " + file.getPath());
            }
            ref.set((Object)true);
            return false;
        }));
        return Boolean.TRUE.equals(ref.get());
    }

    private static void configFilesSearch(@NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull Processor<VirtualFile> processor) {
        if (project == null) {
            EslintUtil.$$$reportNull$$$0(11);
        }
        if (scope == null) {
            EslintUtil.$$$reportNull$$$0(12);
        }
        if (processor == null) {
            EslintUtil.$$$reportNull$$$0(13);
        }
        for (String name : CONFIG_FILENAMES) {
            FilenameIndex.processFilesByName((String)name, (boolean)false, file -> {
                if (project == null) {
                    EslintUtil.$$$reportNull$$$0(34);
                }
                if (processor == null) {
                    EslintUtil.$$$reportNull$$$0(35);
                }
                return file.isValid() && !file.isDirectory() && !JSLibraryUtil.isProbableLibraryFile(file.getVirtualFile(), project) && processor.process((Object)file.getVirtualFile());
            }, (GlobalSearchScope)scope, (Project)project, null);
        }
    }

    public static boolean lintThisFileType(@NotNull Project project, @NotNull PsiFile file, @NotNull List<VirtualFile> configs, @NotNull EslintState state) {
        if (project == null) {
            EslintUtil.$$$reportNull$$$0(14);
        }
        if (file == null) {
            EslintUtil.$$$reportNull$$$0(15);
        }
        if (configs == null) {
            EslintUtil.$$$reportNull$$$0(16);
        }
        if (state == null) {
            EslintUtil.$$$reportNull$$$0(17);
        }
        if (file instanceof JSFile && DialectDetector.isJavaScript((PsiElement)file)) {
            return true;
        }
        SmartList pluginNames = new SmartList();
        if (JSLinterUtil.isPureHtmlFile(file)) {
            pluginNames.add(HTML);
        }
        if (JSLinterUtil.isVueFile(file)) {
            pluginNames.add(VUE);
            pluginNames.add(HTML);
        }
        if (TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(file.getFileType())) {
            pluginNames.add(TYPESCRIPT);
        }
        if (pluginNames.isEmpty()) {
            return false;
        }
        if (pluginNames.stream().anyMatch(state::hasPluginInExtraOptions)) {
            return true;
        }
        return ContainerUtil.or(configs, arg_0 -> EslintUtil.lambda$lintThisFileType$4(project, (List)pluginNames, arg_0));
    }

    @Nullable
    public static EslintConfigData parseConfigFile(@NotNull Project project, @NotNull VirtualFile configFile) {
        if (project == null) {
            EslintUtil.$$$reportNull$$$0(18);
        }
        if (configFile == null) {
            EslintUtil.$$$reportNull$$$0(19);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        return (EslintConfigData)ReadAction.compute(() -> {
            PsiFile psiFile;
            if (configFile == null) {
                EslintUtil.$$$reportNull$$$0(31);
            }
            if ((psiFile = psiManager.findFile(configFile)) == null) {
                return null;
            }
            CachedValueProvider provider = () -> {
                if (configFile == null) {
                    EslintUtil.$$$reportNull$$$0(32);
                }
                if (configFile.getLength() >= (long)FileUtilRt.LARGE_FOR_CONTENT_LOADING) {
                    return null;
                }
                EslintConfigData configData = EslintUtil.parseInternal(psiFile, psiFile.getLanguage());
                return CachedValueProvider.Result.create((Object)configData, (Object[])new Object[]{psiFile.getViewProvider().getVirtualFile()});
            };
            return (EslintConfigData)CachedValuesManager.getCachedValue((PsiElement)psiFile, (CachedValueProvider)provider);
        });
    }

    @Nullable
    private static EslintConfigData parseInternal(@NotNull PsiFile configFile, @NotNull Language language) {
        if (configFile == null) {
            EslintUtil.$$$reportNull$$$0(20);
        }
        if (language == null) {
            EslintUtil.$$$reportNull$$$0(21);
        }
        if (JSLinterConfigLangSubstitutor.YamlLanguageHolder.INSTANCE.equals(language)) {
            return EslintUtil.parseYamlConfig(configFile);
        }
        if (configFile instanceof JsonFile) {
            return EslintUtil.parseJsonConfig(configFile);
        }
        if (configFile instanceof JSFile) {
            return EslintUtil.parseJavaScriptConfig(configFile);
        }
        return null;
    }

    @Nullable
    private static EslintConfigData parseYamlConfig(@NotNull PsiFile configFile) {
        Map map;
        String content;
        if (configFile == null) {
            EslintUtil.$$$reportNull$$$0(22);
        }
        if ((content = EslintUtil.loadContentOrNull(configFile.getViewProvider().getVirtualFile())) == null) {
            return null;
        }
        try {
            map = (Map)new Yaml().load(content);
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            return null;
        }
        return new EslintConfigData(EslintUtil.getStringList(map.get(PLUGINS)), EslintUtil.getListOrSingleStringValue(map.get(EXTENDS)));
    }

    @Nullable
    private static EslintConfigData parseJsonConfig(@NotNull PsiFile configFile) {
        JsonObject eslintRootObject;
        if (configFile == null) {
            EslintUtil.$$$reportNull$$$0(23);
        }
        if ((eslintRootObject = EslintUtil.getConfigRootObject(configFile)) == null) {
            return null;
        }
        List plugins = ContainerUtil.notNullize((List)JsonUtil.getChildAsStringList((JsonObject)eslintRootObject, (String)PLUGINS));
        List extendsList = ContainerUtil.notNullize((List)JsonUtil.getChildAsSingleStringOrList((JsonObject)eslintRootObject, (String)EXTENDS));
        return new EslintConfigData(plugins, extendsList);
    }

    @Nullable
    public static JsonObject getConfigRootObject(@NotNull PsiFile configFile) {
        JsonFile jsonFile;
        if (configFile == null) {
            EslintUtil.$$$reportNull$$$0(24);
        }
        if ((jsonFile = (JsonFile)ObjectUtils.tryCast((Object)configFile, JsonFile.class)) == null) {
            return null;
        }
        JsonObject eslintRootObject = (JsonObject)ObjectUtils.tryCast((Object)jsonFile.getTopLevelValue(), JsonObject.class);
        if (eslintRootObject == null) {
            return null;
        }
        if ("package.json".equals(configFile.getName()) && (eslintRootObject = (JsonObject)JsonUtil.getPropertyValueOfType((JsonObject)eslintRootObject, (String)CONFIG_SECTION_NAME, JsonObject.class)) == null) {
            return null;
        }
        return eslintRootObject;
    }

    @Nullable
    private static EslintConfigData parseJavaScriptConfig(@NotNull PsiFile configFile) {
        Collection expressions;
        if (configFile == null) {
            EslintUtil.$$$reportNull$$$0(25);
        }
        if ((expressions = PsiTreeUtil.findChildrenOfType((PsiElement)configFile, JSReferenceExpression.class)).isEmpty()) {
            return null;
        }
        Ref ref = new Ref();
        ContainerUtil.or((Iterable)expressions, expression -> {
            if ((JSSymbolUtil.isAccurateReferenceExpressionName(expression, "module", "exports") || JSSymbolUtil.isAccurateReferenceExpressionName(expression, "exports")) && expression.getParent() instanceof JSDefinitionExpression && expression.equals(((JSDefinitionExpression)expression.getParent()).getExpression()) && ((JSDefinitionExpression)expression.getParent()).getInitializer() instanceof JSObjectLiteralExpression) {
                JSObjectLiteralExpression object = (JSObjectLiteralExpression)((JSDefinitionExpression)expression.getParent()).getInitializer();
                assert (object != null);
                ref.set((Object)new EslintConfigData(ContainerUtil.notNullize(EslintUtil.getJSStringArrayOrSimplePropertyValues(object, PLUGINS)), ContainerUtil.notNullize(EslintUtil.getJSStringArrayOrSimplePropertyValues(object, EXTENDS))));
                return true;
            }
            return false;
        });
        return (EslintConfigData)ref.get();
    }

    private static List<String> getJSStringArrayOrSimplePropertyValues(@NotNull JSObjectLiteralExpression object, @NotNull String name) {
        JSProperty property;
        if (object == null) {
            EslintUtil.$$$reportNull$$$0(26);
        }
        if (name == null) {
            EslintUtil.$$$reportNull$$$0(27);
        }
        if ((property = object.findProperty(name)) != null) {
            if (property.getValue() instanceof JSArrayLiteralExpression) {
                JSExpression[] arrayExpressions = ((JSArrayLiteralExpression)property.getValue()).getExpressions();
                return Arrays.stream(arrayExpressions).filter(expr -> expr instanceof JSLiteralExpression && ((JSLiteralExpression)expr).isQuotedLiteral()).map(expr -> StringUtil.unquoteString((String)expr.getText())).collect(Collectors.toList());
            }
            if (property.getValue() instanceof JSLiteralExpression && ((JSLiteralExpression)property.getValue()).isQuotedLiteral()) {
                return Collections.singletonList(StringUtil.unquoteString((String)property.getValue().getText()));
            }
        }
        return null;
    }

    @Nullable
    private static String loadContentOrNull(VirtualFile configFile) {
        try {
            return VfsUtilCore.loadText((VirtualFile)configFile);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    @NotNull
    private static List<String> getStringList(@Nullable Object value) {
        List list = value instanceof List ? (List)value : ContainerUtil.emptyList();
        List list2 = ContainerUtil.map((Collection)list, o -> o.toString());
        if (list2 == null) {
            EslintUtil.$$$reportNull$$$0(28);
        }
        return list2;
    }

    @NotNull
    private static List<String> getListOrSingleStringValue(@Nullable Object value) {
        List<String> list = EslintUtil.getStringList(value);
        if (!list.isEmpty()) {
            List<String> list2 = list;
            if (list2 == null) {
                EslintUtil.$$$reportNull$$$0(29);
            }
            return list2;
        }
        String stringValue = value instanceof String ? (String)value : null;
        List list3 = !StringUtil.isEmpty((String)stringValue) ? ContainerUtil.list((Object[])new String[]{stringValue}) : ContainerUtil.emptyList();
        if (list3 == null) {
            EslintUtil.$$$reportNull$$$0(30);
        }
        return list3;
    }

    private static /* synthetic */ boolean lambda$lintThisFileType$4(@NotNull Project project, List pluginNames, VirtualFile configFile) {
        EslintConfigData configData;
        if (project == null) {
            EslintUtil.$$$reportNull$$$0(33);
        }
        return (configData = EslintUtil.parseConfigFile(project, configFile)) != null && configData.getPlugins().stream().anyMatch(p -> pluginNames.contains(p));
    }

    static {
        for (int i = 0; i < CONFIG_EXTENSIONS.length; ++i) {
            EslintUtil.CONFIG_FILENAMES[i] = DEFAULT_CONFIG_PREFIX + CONFIG_EXTENSIONS[i];
            EslintUtil.CONFIG_FILENAMES_WITH_PACKAGE_JSON[i] = CONFIG_FILENAMES[i];
        }
        EslintUtil.CONFIG_FILENAMES_WITH_PACKAGE_JSON[EslintUtil.CONFIG_FILENAMES_WITH_PACKAGE_JSON.length - 1] = "package.json";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 9: 
            case 28: 
            case 29: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 9: 
            case 28: 
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToLint";
                break;
            }
            case 4: 
            case 9: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/EslintUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 6: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configs";
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 18: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 13: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EslintUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllConfigsWithPackageJsonUpFileSystem";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllConfigsInScope";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringList";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getListOrSingleStringValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isEslintConfigFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findAllConfigsWithPackageJsonUpFileSystem";
                break;
            }
            case 4: 
            case 9: 
            case 28: 
            case 29: 
            case 30: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addAllConfigsWithPackageJsonFromDir";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findAllConfigsInScope";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasConfigFiles";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "configFilesSearch";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lintThisFileType";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "parseConfigFile";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "parseInternal";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "parseYamlConfig";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "parseJsonConfig";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getConfigRootObject";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "parseJavaScriptConfig";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getJSStringArrayOrSimplePropertyValues";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$parseConfigFile$6";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$5";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$lintThisFileType$4";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$configFilesSearch$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 9: 
            case 28: 
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class EslintConfigData {
        private List<String> myExtends;
        private List<String> myPlugins;

        public EslintConfigData(@NotNull List<String> plugins, @NotNull List<String> extended) {
            if (plugins == null) {
                EslintConfigData.$$$reportNull$$$0(0);
            }
            if (extended == null) {
                EslintConfigData.$$$reportNull$$$0(1);
            }
            this.myExtends = extended;
            this.myPlugins = plugins;
        }

        @NotNull
        public List<String> getPlugins() {
            List<String> list = this.myPlugins;
            if (list == null) {
                EslintConfigData.$$$reportNull$$$0(2);
            }
            return list;
        }

        @NotNull
        public List<String> getExtends() {
            List<String> list = this.myExtends;
            if (list == null) {
                EslintConfigData.$$$reportNull$$$0(3);
            }
            return list;
        }

        public String toString() {
            return "EslintConfigData{myExtends=" + StringUtil.join(this.myExtends, (String)",") + ", myPlugins=" + StringUtil.join(this.myPlugins, (String)",") + '}';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = EslintUtil.PLUGINS;
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extended";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/EslintUtil$EslintConfigData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EslintUtil$EslintConfigData";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPlugins";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExtends";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

