/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint.importer;

import com.intellij.json.psi.JsonObject;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.LinterCodeStyleImportSourceTracker;
import com.intellij.lang.javascript.linter.eslint.EslintUtil;
import com.intellij.lang.javascript.linter.eslint.importer.EslintRulesImporter;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Processor;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EslintImportCodeStyleEditorNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"Eslint.Import.Code.Style.Notification");
    private static final Key<ParameterizedCachedValue<EslintRulesImporter, PsiFile>> CACHE_KEY = Key.create((String)"Eslint.Import.Code.Style.cache.key");
    private final LinterCodeStyleImportSourceTracker mySourceTracker;

    public EslintImportCodeStyleEditorNotificationProvider(@NotNull Project project) {
        if (project == null) {
            EslintImportCodeStyleEditorNotificationProvider.$$$reportNull$$$0(0);
        }
        this.mySourceTracker = new LinterCodeStyleImportSourceTracker(project, "eslint", (Processor<VirtualFile>)((Processor)file -> EslintUtil.isEslintConfigFile(file) || "package.json".equals(file.getName())));
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            EslintImportCodeStyleEditorNotificationProvider.$$$reportNull$$$0(1);
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        if (file == null) {
            EslintImportCodeStyleEditorNotificationProvider.$$$reportNull$$$0(2);
        }
        if (fileEditor == null) {
            EslintImportCodeStyleEditorNotificationProvider.$$$reportNull$$$0(3);
        }
        if (!(fileEditor instanceof TextEditor)) {
            return null;
        }
        Project project = ((TextEditor)fileEditor).getEditor().getProject();
        if (project == null) {
            return null;
        }
        if (this.mySourceTracker.shouldDismiss(file)) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null) {
            return null;
        }
        EslintRulesImporter rulesImporter = EslintImportCodeStyleEditorNotificationProvider.getRulesImporter(project, psiFile);
        if (rulesImporter != null && rulesImporter.hasDataToImport(project)) {
            EditorNotificationPanel panel = new EditorNotificationPanel(EditorColors.GUTTER_BACKGROUND);
            panel.setText(JSBundle.message((String)"eslint.code.style.apply.message", (Object[])new Object[0]));
            panel.createActionLabel(JSBundle.message((String)"eslint.code.style.apply.text", (Object[])new Object[0]), () -> {
                if (file == null) {
                    EslintImportCodeStyleEditorNotificationProvider.$$$reportNull$$$0(7);
                }
                Set<String> importedRules = rulesImporter.doImport(project);
                EditorNotifications.getInstance((Project)project).updateNotifications(file);
                JSLinterUtil.reportCodeStyleSettingsImported(project, JSBundle.message((String)"settings.javascript.linters.eslint.configurable.name", (Object[])new Object[0]), file, importedRules);
            });
            panel.createActionLabel(JSBundle.message((String)"eslint.code.style.dismiss.text", (Object[])new Object[0]), this.mySourceTracker.getDismissAction());
            return panel;
        }
        return null;
    }

    @Nullable
    public static EslintRulesImporter getRulesImporter(@NotNull Project project, @NotNull PsiFile psiFile) {
        if (project == null) {
            EslintImportCodeStyleEditorNotificationProvider.$$$reportNull$$$0(4);
        }
        if (psiFile == null) {
            EslintImportCodeStyleEditorNotificationProvider.$$$reportNull$$$0(5);
        }
        return (EslintRulesImporter)CachedValuesManager.getManager((Project)project).getParameterizedCachedValue((UserDataHolder)psiFile, CACHE_KEY, param -> {
            if (psiFile == null) {
                EslintImportCodeStyleEditorNotificationProvider.$$$reportNull$$$0(6);
            }
            EslintRulesImporter importer = null;
            JsonObject rootObject = EslintUtil.getConfigRootObject(psiFile);
            if (rootObject != null) {
                importer = new EslintRulesImporter(rootObject);
            }
            return CachedValueProvider.Result.create((Object)importer, (Object[])new Object[]{psiFile});
        }, false, (Object)psiFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/importer/EslintImportCodeStyleEditorNotificationProvider";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintImportCodeStyleEditorNotificationProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRulesImporter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getRulesImporter$2";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createNotificationPanel$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

