/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jscs;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.lang.javascript.linter.JSLinterError;
import com.intellij.lang.javascript.linter.JSLinterErrorBase;
import com.intellij.lang.javascript.linter.jscs.JscsObsoleteRulesWarning;
import com.intellij.lang.javascript.linter.jscs.config.JscsOption;
import com.intellij.lang.javascript.linter.jscs.config.JscsTypeError;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xml.NanoXmlUtil;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import net.n3.nanoxml.IXMLBuilder;
import net.n3.nanoxml.IXMLElement;
import net.n3.nanoxml.StdXMLBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JscsCheckStyleOutputFormatParser
extends ProcessAdapter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.linter.jscs.Jscs");
    private static final String UNSUPPORTED_RULE = "Unsupported rule:";
    private static final String RULE_IS_NO_LONGER_SUPPORTED = "rule is no longer supported";
    private static final String PLEASE_USE_OTHER = "Please use the following rules instead";
    private static final String NO_FILE_FOUND = "No configuration found. Add a .jscsrc file to your project root or use the -c option.";
    private static final String NO_FILE_FOUND_CORRECTED = "JSCS: No configuration found.";
    private final List<JSLinterError> myErrors;
    private List<String> myObsoleteRulesUsed;
    private List<String> myUnsupportedRulesUsed;
    private final StringBuilder myGlobalError;
    private JSLinterErrorBase myParsedGlobalError;
    private final StringBuilder myText;
    private final String myTmpFile;
    private static final String TYPE_ERROR = "TypeError:";
    private static final String ASSERTION_ERROR = "AssertionError:";
    private static final String OPTION_REQUIRES = "option requires";
    private static final String UNSUPPORTED_RULES = "Error: Unsupported rules:";

    public JscsCheckStyleOutputFormatParser(String actualCodeFile) {
        this.myTmpFile = actualCodeFile;
        this.myErrors = new ArrayList<JSLinterError>();
        this.myGlobalError = new StringBuilder();
        this.myText = new StringBuilder();
    }

    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
        if (event == null) {
            JscsCheckStyleOutputFormatParser.$$$reportNull$$$0(0);
        }
        if (outputType == null) {
            JscsCheckStyleOutputFormatParser.$$$reportNull$$$0(1);
        }
        String text = event.getText().trim();
        if (outputType == ProcessOutputTypes.STDERR) {
            String textToAdd = NO_FILE_FOUND.equals(text) ? NO_FILE_FOUND_CORRECTED : text;
            this.myGlobalError.append(textToAdd).append("\n");
        } else if (outputType == ProcessOutputTypes.STDOUT) {
            this.myText.append(text).append("\n");
        }
    }

    public void process() {
        String text = this.myText.toString();
        if (!StringUtil.isEmptyOrSpaces((String)text)) {
            this.parseStdOut(text);
        }
        if (this.myGlobalError.length() > 0) {
            String message = JscsCheckStyleOutputFormatParser.tryParseExceptionMessage(this.myGlobalError.toString());
            this.myParsedGlobalError = message != null ? JscsCheckStyleOutputFormatParser.parseGlobalError(message) : new JSLinterError(0, 0, this.myGlobalError.toString(), null);
        }
    }

    private static JSLinterErrorBase parseGlobalError(@NotNull String message) {
        if (message == null) {
            JscsCheckStyleOutputFormatParser.$$$reportNull$$$0(2);
        }
        message = message.trim();
        String optionName = null;
        if (message.startsWith(ASSERTION_ERROR)) {
            JscsOption option;
            int endPhraseIdx = message.indexOf(OPTION_REQUIRES);
            if (endPhraseIdx > 0 && (option = JscsOption.safeValueOf(optionName = message.substring(ASSERTION_ERROR.length(), endPhraseIdx).trim())) != null) {
                return new JSLinterErrorBase(message, option.name());
            }
        } else {
            if (message.startsWith(UNSUPPORTED_RULES)) {
                return new JSLinterErrorBase(message, message.substring(UNSUPPORTED_RULES.length()).trim());
            }
            if (message.startsWith(TYPE_ERROR)) {
                return new JscsTypeError(message);
            }
        }
        return new JSLinterErrorBase(message);
    }

    private void parseStdOut(String text) {
        StdXMLBuilder builder = new StdXMLBuilder();
        NanoXmlUtil.parse((Reader)new StringReader(text), (IXMLBuilder)builder);
        IXMLElement root = (IXMLElement)builder.getResult();
        if (root == null) {
            LOG.debug("JSCS: Failed to parse jscs output: " + text);
            return;
        }
        try {
            JscsCheckStyleOutputFormatParser.expect(root, "checkstyle");
            if (root.getChildrenCount() != 1) {
                LOG.debug("JSCS: not one file returned when asked for " + this.myTmpFile + " returned " + root.getChildrenCount());
                return;
            }
            IXMLElement file = root.getChildAtIndex(0);
            JscsCheckStyleOutputFormatParser.expect(file, "file");
            int numErrors = file.getChildrenCount();
            for (int i = 0; i < numErrors; ++i) {
                IXMLElement error = file.getChildAtIndex(i);
                JscsCheckStyleOutputFormatParser.expect(error, "error");
                this.parseError(error);
            }
        }
        catch (MyHomeException e) {
            LOG.debug("JSCS: expected " + e.getMessage() + " but found " + e.getElement().getName() + " Text:\n" + this.myText);
        }
    }

    public List<JSLinterError> getErrors() {
        return this.myErrors;
    }

    @Nullable
    public JscsObsoleteRulesWarning getObsoleteRulesWarning() {
        if (this.myObsoleteRulesUsed == null && this.myUnsupportedRulesUsed == null) {
            return null;
        }
        ArrayList<String> rules = new ArrayList<String>();
        if (this.myObsoleteRulesUsed != null) {
            rules.addAll(this.myObsoleteRulesUsed);
        }
        if (this.myUnsupportedRulesUsed != null) {
            rules.addAll(this.myUnsupportedRulesUsed);
        }
        return new JscsObsoleteRulesWarning("Unsupported rules: " + StringUtil.join(rules, (String)", "), rules);
    }

    public JSLinterErrorBase getGlobalError() {
        return this.myParsedGlobalError;
    }

    private void parseError(IXMLElement error) {
        String code;
        String message = error.getAttribute("message", "");
        if (StringUtil.isEmptyOrSpaces((String)message)) {
            return;
        }
        int colonIdx = message.indexOf(":");
        String string = code = colonIdx <= 0 ? "" : message.substring(0, colonIdx).trim();
        if (message.contains(RULE_IS_NO_LONGER_SUPPORTED) && message.contains(PLEASE_USE_OTHER)) {
            if (!code.isEmpty()) {
                if (this.myObsoleteRulesUsed == null) {
                    this.myObsoleteRulesUsed = new ArrayList<String>();
                }
                this.myObsoleteRulesUsed.add(code);
            }
            return;
        }
        if (message.contains(UNSUPPORTED_RULE)) {
            String string2 = code = colonIdx <= 0 ? "" : message.substring(colonIdx + 1).trim();
            if (!code.isEmpty()) {
                if (this.myUnsupportedRulesUsed == null) {
                    this.myUnsupportedRulesUsed = new ArrayList<String>();
                }
                this.myUnsupportedRulesUsed.add(code);
            }
            return;
        }
        message = colonIdx > 0 ? message.substring(colonIdx + 1) : message;
        Integer line = this.readLineOrCol(error, "line");
        Integer col = this.readLineOrCol(error, "column");
        if (line != null && col != null) {
            this.myErrors.add(new JSLinterError(line, col, message.trim(), code));
        }
    }

    private static String tryParseExceptionMessage(@NotNull String message) {
        String[] lines;
        if (message == null) {
            JscsCheckStyleOutputFormatParser.$$$reportNull$$$0(3);
        }
        if ((lines = message.split("\n")).length == 1) {
            return null;
        }
        boolean atFound = false;
        for (int i = lines.length - 1; i >= 0; --i) {
            String line = lines[i].trim();
            if (line.isEmpty()) continue;
            if (JscsCheckStyleOutputFormatParser.isExceptionLine(line)) {
                atFound = true;
                continue;
            }
            if (atFound) {
                LOG.debug("JSCS: " + message);
                return line;
            }
            return null;
        }
        return null;
    }

    private static boolean isExceptionLine(@NotNull String s) {
        int at;
        if (s == null) {
            JscsCheckStyleOutputFormatParser.$$$reportNull$$$0(4);
        }
        if ((at = s.indexOf("at ")) < 0) {
            return false;
        }
        if (s.indexOf("native", at) > 0) {
            return true;
        }
        int from = at;
        while (from < s.length()) {
            int dotIdx = s.indexOf(":", from);
            if (dotIdx < 0 || dotIdx == s.length() - 1) {
                return false;
            }
            if (Character.isDigit(s.charAt(dotIdx + 1))) {
                return true;
            }
            from = dotIdx + 1;
        }
        return false;
    }

    private Integer readLineOrCol(@NotNull IXMLElement element, @NotNull String name) {
        String line;
        if (element == null) {
            JscsCheckStyleOutputFormatParser.$$$reportNull$$$0(5);
        }
        if (name == null) {
            JscsCheckStyleOutputFormatParser.$$$reportNull$$$0(6);
        }
        if (StringUtil.isEmptyOrSpaces((String)(line = element.getAttribute(name, "")))) {
            LOG.debug("JSCS: when checking file " + this.myTmpFile + " message without " + name + ": " + element.getAttribute("message", ""));
            return null;
        }
        try {
            return Integer.parseInt(line);
        }
        catch (NumberFormatException e) {
            LOG.debug("JSCS: when checking file " + this.myTmpFile + " " + name + " is not a number for message " + element.getAttribute("message", ""));
            return null;
        }
    }

    private static void expect(@NotNull IXMLElement element, @NotNull String name) throws MyHomeException {
        if (element == null) {
            JscsCheckStyleOutputFormatParser.$$$reportNull$$$0(7);
        }
        if (name == null) {
            JscsCheckStyleOutputFormatParser.$$$reportNull$$$0(8);
        }
        if (!name.equals(element.getName())) {
            throw new MyHomeException(name, element);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/linter/jscs/JscsCheckStyleOutputFormatParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onTextAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "parseGlobalError";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "tryParseExceptionMessage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isExceptionLine";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "readLineOrCol";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "expect";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyHomeException
    extends Exception {
        private final IXMLElement myElement;

        public MyHomeException(String message, IXMLElement element) {
            super(message);
            this.myElement = element;
        }

        public IXMLElement getElement() {
            return this.myElement;
        }
    }
}

