/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.inspections.FileHeaderKeeper;
import com.intellij.lang.javascript.modules.ImportJSModuleBaseFix;
import com.intellij.lang.javascript.modules.JSModuleFixDescriptor;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.e4x.impl.JSXmlLiteralExpressionImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ImportCommonJSModuleFix
extends LocalQuickFixOnPsiElement
implements ImportJSModuleBaseFix,
LocalQuickFix,
HintAction,
HighPriorityAction {
    @NotNull
    protected final JSModuleFixDescriptor myFixDescriptor;
    @NotNull
    protected final String myQuotes;
    private volatile boolean myNeedHint;

    protected ImportCommonJSModuleFix(@NotNull PsiElement node, @NotNull JSModuleFixDescriptor descriptor2, @NotNull String quoteString) {
        if (node == null) {
            ImportCommonJSModuleFix.$$$reportNull$$$0(0);
        }
        if (descriptor2 == null) {
            ImportCommonJSModuleFix.$$$reportNull$$$0(1);
        }
        if (quoteString == null) {
            ImportCommonJSModuleFix.$$$reportNull$$$0(2);
        }
        this(node, descriptor2, quoteString, false);
    }

    protected ImportCommonJSModuleFix(@NotNull PsiElement node, @NotNull JSModuleFixDescriptor descriptor2, @NotNull String quoteString, boolean needHint) {
        if (node == null) {
            ImportCommonJSModuleFix.$$$reportNull$$$0(3);
        }
        if (descriptor2 == null) {
            ImportCommonJSModuleFix.$$$reportNull$$$0(4);
        }
        if (quoteString == null) {
            ImportCommonJSModuleFix.$$$reportNull$$$0(5);
        }
        super(node);
        this.myQuotes = quoteString;
        this.myFixDescriptor = descriptor2;
        this.myNeedHint = needHint;
    }

    protected boolean isAcceptableReference(@Nullable PsiElement element) {
        return element instanceof JSReferenceExpression || element instanceof JSXmlLiteralExpressionImpl;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            ImportCommonJSModuleFix.$$$reportNull$$$0(6);
        }
        return this.isAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            ImportCommonJSModuleFix.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        PsiElement element = this.getStartElement();
        if (element != null) {
            FileHeaderKeeper headerKeeper = new FileHeaderKeeper(ES6CreateImportUtil.getExternalModuleScope(element));
            headerKeeper.saveStateAndCutHeader();
            try {
                this.invokeAction(element, editor);
            }
            finally {
                headerKeeper.restoreHeaderForSavedState();
            }
        }
    }

    public void invokeAction(@NotNull PsiElement element, @Nullable Editor editor) {
        JSEmbeddedContent scope;
        if (element == null) {
            ImportCommonJSModuleFix.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        JSEmbeddedContent embeddedContent = (JSEmbeddedContent)PsiTreeUtil.getParentOfType((PsiElement)element, JSEmbeddedContent.class, (boolean)false);
        boolean useEmbeddedContent = embeddedContent != null && (!DialectDetector.isJSX((PsiElement)embeddedContent) || !DialectDetector.isJSX((PsiElement)element.getContainingFile()));
        Object object = scope = useEmbeddedContent ? embeddedContent : element.getContainingFile();
        if (!this.isAcceptableReference(element)) {
            return;
        }
        if (!this.modifyExistingImports((PsiElement)scope, editor, element)) {
            this.createNewImport(element, (PsiElement)scope, editor);
        }
        DaemonCodeAnalyzer.getInstance((Project)scope.getProject()).restart(element.getContainingFile());
    }

    private void createNewImport(@NotNull PsiElement element, @NotNull PsiElement scope, @Nullable Editor editor) {
        if (element == null) {
            ImportCommonJSModuleFix.$$$reportNull$$$0(9);
        }
        if (scope == null) {
            ImportCommonJSModuleFix.$$$reportNull$$$0(10);
        }
        PsiElement created = this.createRequire(scope.getContainingFile());
        this.insertCreatedElement(scope, editor, created);
        this.replaceReferences(element, editor);
    }

    protected abstract void insertCreatedElement(@NotNull PsiElement var1, @Nullable Editor var2, @NotNull PsiElement var3);

    protected abstract boolean modifyExistingImports(@NotNull PsiElement var1, Editor var2, @NotNull PsiElement var3);

    protected void replaceReferences(PsiElement element, @Nullable Editor editor) {
        String[] tail = this.myFixDescriptor.getTail();
        if (tail == null || tail.length == 0) {
            return;
        }
        this.replaceWithNewReference(element, editor, tail[tail.length - 1]);
    }

    protected void replaceWithNewReference(@NotNull PsiElement elementTarget, @Nullable Editor editor, @NotNull String newReferenceName) {
        if (elementTarget == null) {
            ImportCommonJSModuleFix.$$$reportNull$$$0(11);
        }
        if (newReferenceName == null) {
            ImportCommonJSModuleFix.$$$reportNull$$$0(12);
        }
        if (elementTarget instanceof JSReferenceExpression) {
            JSReferenceExpression replaceTarget = (JSReferenceExpression)elementTarget;
            if (replaceTarget.getQualifier() == null && newReferenceName.equals(replaceTarget.getReferenceName())) {
                return;
            }
            PsiFile dummy = ImportCommonJSModuleFix.createDummyFile(replaceTarget.getProject(), newReferenceName);
            JSExpression replace = replaceTarget.replace((JSExpression)PsiTreeUtil.findChildOfType((PsiElement)dummy, JSReferenceExpression.class));
            if (editor != null) {
                editor.getCaretModel().moveToOffset(replace.getTextRange().getEndOffset());
            }
        }
    }

    protected abstract PsiElement createRequire(@NotNull PsiFile var1);

    protected static PsiFile createDummyFile(Project project, String text) {
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)project);
        return psiFileFactory.createFileFromText("dummy.js", (FileType)JavaScriptFileType.INSTANCE, (CharSequence)text);
    }

    public boolean showHint(@NotNull Editor editor) {
        if (editor == null) {
            ImportCommonJSModuleFix.$$$reportNull$$$0(13);
        }
        if (!this.myNeedHint) {
            return false;
        }
        PsiElement element = this.getStartElement();
        if (element == null || !element.isValid()) {
            return false;
        }
        Project project = editor.getProject();
        if (project == null) {
            return false;
        }
        PsiReference reference = element.getReference();
        if (reference == null) {
            return false;
        }
        PsiElement referenceElement = reference.getElement();
        if (referenceElement == null) {
            return false;
        }
        TextRange rangeInElement = reference.getRangeInElement();
        int elOffset = referenceElement.getTextOffset();
        TextRange range = new TextRange(elOffset + rangeInElement.getStartOffset(), elOffset + rangeInElement.getEndOffset());
        String message = ShowAutoImportPass.getMessage((boolean)false, (String)this.getVarName());
        HintManager.getInstance().showQuestionHint(editor, message, range.getStartOffset(), range.getEndOffset(), () -> {
            if (editor == null) {
                ImportCommonJSModuleFix.$$$reportNull$$$0(18);
            }
            if (project.isDisposed() || !element.isValid()) {
                return false;
            }
            TransactionGuard.submitTransaction((Disposable)project, () -> {
                if (editor == null) {
                    ImportCommonJSModuleFix.$$$reportNull$$$0(19);
                }
                Runnable runnable = () -> {
                    if (editor == null) {
                        ImportCommonJSModuleFix.$$$reportNull$$$0(20);
                    }
                    WriteAction.run(() -> {
                        if (editor == null) {
                            ImportCommonJSModuleFix.$$$reportNull$$$0(21);
                        }
                        this.invoke(project, editor, element.getContainingFile());
                    });
                };
                CommandProcessor.getInstance().executeCommand(project, runnable, this.getClass().getName(), (Object)this);
                this.myNeedHint = false;
            });
            return true;
        });
        return true;
    }

    public String getPath() {
        return this.myFixDescriptor.getFromPath();
    }

    @Override
    public String getVarName() {
        if (this.myFixDescriptor.getTail() != null) {
            String[] tail = this.myFixDescriptor.getTail();
            return tail[tail.length - 1];
        }
        return this.myFixDescriptor.getFirstWordInFile();
    }

    public boolean startInWriteAction() {
        return true;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            ImportCommonJSModuleFix.$$$reportNull$$$0(14);
        }
        if (file == null) {
            ImportCommonJSModuleFix.$$$reportNull$$$0(15);
        }
        if (startElement == null) {
            ImportCommonJSModuleFix.$$$reportNull$$$0(16);
        }
        if (endElement == null) {
            ImportCommonJSModuleFix.$$$reportNull$$$0(17);
        }
        if (this.isAcceptableReference(startElement)) {
            this.invokeAction(startElement, null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quoteString";
                break;
            }
            case 6: 
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementTarget";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newReferenceName";
                break;
            }
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/modules/ImportCommonJSModuleFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 7: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeAction";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "createNewImport";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceWithNewReference";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "showHint";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$showHint$3";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$2";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$1";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

