/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.packageJson.PackageJsonDependenciesExternalUpdateManager;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.modules.InstallNodeLocalDependenciesAction;
import com.intellij.lang.javascript.modules.JSModulesQuickFix;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.modules.NpmPackageInstallerLight;
import com.intellij.lang.javascript.modules.NpmUsedModulesInstalledInspection;
import com.intellij.lang.javascript.modules.RecordModuleIntoPackageJsonQuickFix;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.packaging.PackageManagementService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstallNodeModuleQuickFix
implements LocalQuickFix,
HighPriorityAction,
HintAction,
JSModulesQuickFix {
    private final ModuleElement<? extends JSElement> myModuleElement;
    private final boolean myRecordIntoPackageJson;
    private final boolean myInstallAll;
    private final boolean myAsDevDependency;
    private final List<VirtualFile> myPackageJsonFiles;

    public InstallNodeModuleQuickFix(@NotNull ModuleElement<? extends JSElement> module, @NotNull Collection<VirtualFile> virtualFiles) {
        if (module == null) {
            InstallNodeModuleQuickFix.$$$reportNull$$$0(0);
        }
        if (virtualFiles == null) {
            InstallNodeModuleQuickFix.$$$reportNull$$$0(1);
        }
        this(module, false, false, false, virtualFiles);
    }

    protected InstallNodeModuleQuickFix(@NotNull ModuleElement<? extends JSElement> module, boolean recordIntoPackageJson, boolean installAll, boolean asDevDependency, @NotNull Collection<VirtualFile> virtualFiles) {
        if (module == null) {
            InstallNodeModuleQuickFix.$$$reportNull$$$0(2);
        }
        if (virtualFiles == null) {
            InstallNodeModuleQuickFix.$$$reportNull$$$0(3);
        }
        this.myModuleElement = module;
        this.myRecordIntoPackageJson = recordIntoPackageJson;
        this.myInstallAll = installAll;
        this.myAsDevDependency = asDevDependency;
        this.myPackageJsonFiles = new ArrayList<VirtualFile>(virtualFiles);
    }

    @Nls
    @NotNull
    public String getText() {
        String moduleName = this.myModuleElement.getModuleName();
        if (this.myRecordIntoPackageJson) {
            if (this.myAsDevDependency) {
                String string = JSBundle.message((String)"node.js.quickfix.install.node.module.with.dev.dependencies.text", (Object[])new Object[]{moduleName});
                if (string == null) {
                    InstallNodeModuleQuickFix.$$$reportNull$$$0(4);
                }
                return string;
            }
            String string = JSBundle.message((String)"node.js.quickfix.install.node.module.with.dependencies.text", (Object[])new Object[]{moduleName});
            if (string == null) {
                InstallNodeModuleQuickFix.$$$reportNull$$$0(5);
            }
            return string;
        }
        if (this.myInstallAll) {
            String option = this.myPackageJsonFiles.size() == 1 ? InstallNodeLocalDependenciesAction.guessNpmCommand(this.myPackageJsonFiles.get(0)).getCliOption() : "install";
            String string = JSBundle.message((String)"node.js.quickfix.run.npm.update.text", (Object[])new Object[]{option});
            if (string == null) {
                InstallNodeModuleQuickFix.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = JSBundle.message((String)"node.js.quickfix.install.node.module.text", (Object[])new Object[]{moduleName});
        if (string == null) {
            InstallNodeModuleQuickFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            InstallNodeModuleQuickFix.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"node.js.quickfix.install.node.module.family.name", (Object[])new Object[0]);
        if (string == null) {
            InstallNodeModuleQuickFix.$$$reportNull$$$0(9);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            InstallNodeModuleQuickFix.$$$reportNull$$$0(10);
        }
        return !StringUtil.isEmptyOrSpaces((String)this.myModuleElement.getModuleName());
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            InstallNodeModuleQuickFix.$$$reportNull$$$0(11);
        }
        this.applyFixImpl(project, file);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            InstallNodeModuleQuickFix.$$$reportNull$$$0(12);
        }
        if (descriptor2 == null) {
            InstallNodeModuleQuickFix.$$$reportNull$$$0(13);
        }
        this.applyFixImpl(project, descriptor2.getPsiElement().getContainingFile());
    }

    private void applyFixImpl(@NotNull Project project, @NotNull PsiFile psiFile) {
        if (project == null) {
            InstallNodeModuleQuickFix.$$$reportNull$$$0(14);
        }
        if (psiFile == null) {
            InstallNodeModuleQuickFix.$$$reportNull$$$0(15);
        }
        InstallNodeModuleQuickFix.selectPackageJson(project, this.myPackageJsonFiles, (Consumer<VirtualFile>)((Consumer)packageJson -> {
            if (project == null) {
                InstallNodeModuleQuickFix.$$$reportNull$$$0(23);
            }
            if (psiFile == null) {
                InstallNodeModuleQuickFix.$$$reportNull$$$0(24);
            }
            this.invokeAction(project, psiFile, (VirtualFile)packageJson);
        }));
    }

    private void invokeAction(final @NotNull Project project, @NotNull PsiFile psiFile, @Nullable VirtualFile packageJson) {
        String extra;
        if (project == null) {
            InstallNodeModuleQuickFix.$$$reportNull$$$0(16);
        }
        if (psiFile == null) {
            InstallNodeModuleQuickFix.$$$reportNull$$$0(17);
        }
        if (this.myInstallAll && packageJson != null) {
            InstallNodeLocalDependenciesAction.runAndShowConsole(project, packageJson);
            return;
        }
        NodeJsInterpreter interpreter = NodeJsInterpreterManager.getInstance(project).getDefault();
        NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.tryCast(interpreter);
        if (localInterpreter == null) {
            Messages.showErrorDialog((Project)project, (String)JSBundle.message((String)"node.js.quickfix.install.node.module.error.no.interpreter.text", (Object[])new Object[0]), (String)JSBundle.message((String)"node.js.quickfix.install.node.module.error.no.interpreter.title", (Object[])new Object[0]));
            return;
        }
        if (this.myRecordIntoPackageJson) {
            if ((packageJson = InstallNodeModuleQuickFix.savePackageJson(project, packageJson)) == null) {
                return;
            }
            extra = this.myAsDevDependency ? "--save-dev" : "--save";
        } else {
            extra = null;
        }
        String moduleName = this.myModuleElement.getModuleName();
        if (moduleName == null) {
            return;
        }
        final Runnable done = PackageJsonDependenciesExternalUpdateManager.getInstance(project).externalUpdateStarted(packageJson, moduleName);
        DaemonCodeAnalyzer.getInstance((Project)project).restart(psiFile);
        PackageManagementService.Listener listener = new PackageManagementService.Listener(){

            public void operationStarted(String packageName) {
            }

            public void operationFinished(String packageName, @Nullable PackageManagementService.ErrorDescription errorDescription) {
                done.run();
                if (errorDescription != null) {
                    Messages.showErrorDialog((Project)project, (String)JSBundle.message((String)"node.js.quickfix.install.node.module.error.prefix.text", (Object[])new Object[]{errorDescription.getMessage()}), (String)JSBundle.message((String)"node.js.quickfix.install.node.module.error.no.interpreter.title", (Object[])new Object[0]));
                }
            }
        };
        if (project.getBasePath() == null) {
            return;
        }
        NpmPackageInstallerLight installerLight = (NpmPackageInstallerLight)ServiceManager.getService(NpmPackageInstallerLight.class);
        UsageTrigger.trigger((String)"Npm.Packages.Install.Package.From.Package.Json");
        File workingDir = new File(packageJson == null ? project.getBasePath() : packageJson.getParent().getPath());
        installerLight.installPackage(project, localInterpreter, moduleName, null, workingDir, listener, extra);
    }

    public boolean showHint(@NotNull Editor editor) {
        if (editor == null) {
            InstallNodeModuleQuickFix.$$$reportNull$$$0(18);
        }
        return false;
    }

    private static VirtualFile savePackageJson(Project project, VirtualFile packageJson) {
        FileDocumentManager documentManager;
        Document document;
        PsiFile psiFile = RecordModuleIntoPackageJsonQuickFix.ensurePackageJsonExist(project, packageJson, null);
        VirtualFile virtualFile = packageJson = psiFile != null ? psiFile.getVirtualFile() : packageJson;
        if (packageJson != null && (document = (documentManager = FileDocumentManager.getInstance()).getDocument(packageJson)) != null) {
            documentManager.saveDocument(document);
        }
        return packageJson;
    }

    static void selectPackageJson(@NotNull Project project, @NotNull List<VirtualFile> packageJsonFiles, @NotNull Consumer<VirtualFile> consumer) {
        if (project == null) {
            InstallNodeModuleQuickFix.$$$reportNull$$$0(19);
        }
        if (packageJsonFiles == null) {
            InstallNodeModuleQuickFix.$$$reportNull$$$0(20);
        }
        if (consumer == null) {
            InstallNodeModuleQuickFix.$$$reportNull$$$0(21);
        }
        if ((packageJsonFiles = ContainerUtil.filter(packageJsonFiles, file -> file.isValid())).isEmpty()) {
            consumer.consume(null);
            return;
        }
        if (packageJsonFiles.size() == 1 || ApplicationManager.getApplication().isUnitTestMode()) {
            consumer.consume(packageJsonFiles.get(0));
            return;
        }
        Collections.sort(packageJsonFiles, NodeModuleUtil.VIRTUAL_FILE_COMPARATOR);
        JBList list = new JBList();
        ArrayList<String> data = new ArrayList<String>();
        for (VirtualFile file2 : packageJsonFiles) {
            data.add(file2.getPath());
        }
        list.setListData(ArrayUtil.toObjectArray(data));
        List finalPackageJsonFiles = packageJsonFiles;
        JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle("Select package.json File").setItemChoosenCallback(() -> {
            int index;
            if (consumer == null) {
                InstallNodeModuleQuickFix.$$$reportNull$$$0(22);
            }
            if ((index = list.getSelectedIndex()) >= 0) {
                consumer.consume(finalPackageJsonFiles.get(index));
            }
        }).createPopup();
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (editor != null) {
            popup.showInBestPositionFor(editor);
        } else {
            popup.showCenteredInCurrentWindow(project);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFiles";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 15: 
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonFiles";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "applyFixImpl";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "invokeAction";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "showHint";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "selectPackageJson";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$selectPackageJson$2";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$applyFixImpl$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static abstract class ModuleElement<T extends JSElement> {
        protected final SmartPsiElementPointer<T> myPointer;

        public ModuleElement(@NotNull T element) {
            if (element == null) {
                ModuleElement.$$$reportNull$$$0(0);
            }
            this.myPointer = SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element);
        }

        @Nullable
        public String getModuleName() {
            JSElement element = (JSElement)this.myPointer.getElement();
            if (element == null || !element.isValid()) {
                return null;
            }
            return this.getModuleNameImpl(element);
        }

        protected abstract String getModuleNameImpl(@NotNull T var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix$ModuleElement", "<init>"));
        }
    }

    static class RequireModuleElement
    extends ModuleElement<JSLiteralExpression> {
        public RequireModuleElement(@NotNull JSLiteralExpression element) {
            if (element == null) {
                RequireModuleElement.$$$reportNull$$$0(0);
            }
            super(element);
        }

        @Override
        protected String getModuleNameImpl(@NotNull JSLiteralExpression element) {
            if (element == null) {
                RequireModuleElement.$$$reportNull$$$0(1);
            }
            return NpmUsedModulesInstalledInspection.getModuleName(StringUtil.notNullize((String)element.getText()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "element";
            objectArray2[1] = "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix$RequireModuleElement";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getModuleNameImpl";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ES6FromClauseModuleElement
    extends ModuleElement<ES6FromClause> {
        public ES6FromClauseModuleElement(@NotNull ES6FromClause element) {
            if (element == null) {
                ES6FromClauseModuleElement.$$$reportNull$$$0(0);
            }
            super(element);
        }

        @Override
        protected String getModuleNameImpl(@NotNull ES6FromClause element) {
            if (element == null) {
                ES6FromClauseModuleElement.$$$reportNull$$$0(1);
            }
            return StringUtil.unquoteString((String)StringUtil.notNullize((String)element.getReferenceText()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "element";
            objectArray2[1] = "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix$ES6FromClauseModuleElement";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getModuleNameImpl";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

