/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.modules.JsDefinedInObject;
import com.intellij.lang.javascript.modules.ModuleReferenceInfo;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSModuleReferenceExpressionInfo
implements ModuleReferenceInfo {
    @Nullable
    private final String myContextName;
    @Nullable
    private final String myParentName;
    @Nullable
    private final JSReferenceExpression myParent;
    @NotNull
    private final List<JSReferenceExpression> myTailRefs;

    public JSModuleReferenceExpressionInfo(@NotNull JSReferenceExpression node) {
        String referenceName;
        String name;
        if (node == null) {
            JSModuleReferenceExpressionInfo.$$$reportNull$$$0(0);
        }
        this.myContextName = node.getReferenceName();
        PsiElement parent = JSModuleReferenceExpressionInfo.getParentElement(node);
        String string = name = parent == null ? null : ((JSReferenceExpression)parent).getReferenceName();
        if (name == null || JsDefinedInObject.isPredefined(name, DialectDetector.dialectOfFile(node.getContainingFile()))) {
            this.myParent = null;
            this.myParentName = null;
            this.myTailRefs = ContainerUtil.emptyList();
            return;
        }
        this.myParentName = name;
        this.myParent = (JSReferenceExpression)parent;
        ArrayList<JSReferenceExpression> result = new ArrayList<JSReferenceExpression>();
        while (parent instanceof JSReferenceExpression && (referenceName = ((JSReferenceExpression)parent).getReferenceName()) != null) {
            result.add((JSReferenceExpression)parent);
            parent = parent.getParent();
        }
        this.myTailRefs = result;
    }

    @Nullable
    private static PsiElement getParentElement(@NotNull JSReferenceExpression node) {
        if (node == null) {
            JSModuleReferenceExpressionInfo.$$$reportNull$$$0(1);
        }
        if (node.getParent() instanceof JSNewExpression) {
            PsiElement parentOverNewExpression = node.getParent().getParent();
            if (parentOverNewExpression instanceof JSReferenceExpression) {
                return parentOverNewExpression;
            }
        } else if (node.getParent() instanceof JSReferenceExpression) {
            return node.getParent();
        }
        return null;
    }

    @Override
    @NotNull
    public List<JSReferenceExpression> getTailRefs() {
        List<JSReferenceExpression> list = this.myTailRefs;
        if (list == null) {
            JSModuleReferenceExpressionInfo.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    public boolean processFromIndex() {
        return false;
    }

    @Override
    @NotNull
    public Collection<PsiElement> getResolvedParent() {
        JSReferenceExpression ref = this.myParent;
        Collection<Object> collection = ref == null ? ContainerUtil.emptyList() : JSResolveResult.toElements(ref.multiResolve(false));
        if (collection == null) {
            JSModuleReferenceExpressionInfo.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @Override
    public boolean isAcceptable(@NotNull PsiElement elementToImport) {
        if (elementToImport == null) {
            JSModuleReferenceExpressionInfo.$$$reportNull$$$0(4);
        }
        return true;
    }

    @Override
    @Nullable
    public String getContextName() {
        return this.myContextName;
    }

    @Override
    public boolean needHint() {
        return false;
    }

    @Override
    @Nullable
    public PsiElement getParentRef() {
        return this.myParent;
    }

    @Override
    @Nullable
    public String getParentName() {
        return this.myParentName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/JSModuleReferenceExpressionInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToImport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/JSModuleReferenceExpressionInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTailRefs";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedParent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getParentElement";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

