/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.lang.javascript.index.JSNamespaceEvaluationResult;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSNamepath;
import com.intellij.lang.javascript.psi.JSNamepathImpl;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGlobalTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ComparatorUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSNamespaceImpl
extends UserDataHolderBase
implements JSNamespace {
    public static final JSNamespace UNDEFINED = new JSNamespaceImpl(null, JSContext.UNKNOWN, false);
    @Nullable
    protected final JSQualifiedName myName;
    @NotNull
    protected final JSContext myContext;
    protected final boolean myIsExplicitlyDeclared;
    private final boolean myIsLocal;

    public JSNamespaceImpl(@Nullable JSQualifiedName qualifiedName, @NotNull JSContext jsContext, boolean isExplicitlyDeclared) {
        if (jsContext == null) {
            JSNamespaceImpl.$$$reportNull$$$0(0);
        }
        this(qualifiedName, jsContext, isExplicitlyDeclared, false);
    }

    public JSNamespaceImpl(@Nullable JSQualifiedName qualifiedName, @NotNull JSContext jsContext, boolean isExplicitlyDeclared, boolean isLocal) {
        if (jsContext == null) {
            JSNamespaceImpl.$$$reportNull$$$0(1);
        }
        this.myName = qualifiedName;
        this.myContext = jsContext;
        this.myIsExplicitlyDeclared = isExplicitlyDeclared;
        this.myIsLocal = isLocal;
    }

    @Nullable
    public JSQualifiedName getQualifiedName() {
        return this.myName;
    }

    @NotNull
    public JSContext getJSContext() {
        JSContext jSContext = this.myContext;
        if (jSContext == null) {
            JSNamespaceImpl.$$$reportNull$$$0(2);
        }
        return jSContext;
    }

    public boolean isExplicitlyDeclared() {
        return this.myIsExplicitlyDeclared;
    }

    public boolean isLocal() {
        return this.myIsLocal;
    }

    public String toString() {
        JSQualifiedName name = this.getQualifiedName();
        return name != null ? name.getQualifiedName() : "<null>";
    }

    @NotNull
    public JSType toType(@Nullable PsiElement source) {
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(source, this.isExplicitlyDeclared());
        JSQualifiedName name = this.getQualifiedName();
        JSGlobalTypeImpl jSGlobalTypeImpl = name == null ? new JSGlobalTypeImpl(typeSource) : JSNamedType.createType(name.getQualifiedName(), typeSource, this.getJSContext());
        if (jSGlobalTypeImpl == null) {
            JSNamespaceImpl.$$$reportNull$$$0(3);
        }
        return jSGlobalTypeImpl;
    }

    @NotNull
    public static JSNamespace fromNamepath(@NotNull String namepath, boolean isExplicitlyDeclared) {
        if (namepath == null) {
            JSNamespaceImpl.$$$reportNull$$$0(4);
        }
        JSContext jsContext = JSContext.STATIC;
        if (namepath.endsWith(".prototype")) {
            namepath = namepath.substring(0, namepath.length() - "prototype".length() - 1);
            jsContext = JSContext.INSTANCE;
        } else if (namepath.endsWith("#")) {
            namepath = namepath.substring(0, namepath.length() - 1);
            jsContext = JSContext.INSTANCE;
        }
        JSNamespaceImpl jSNamespaceImpl = new JSNamespaceImpl(JSQualifiedNameImpl.fromNamepath(namepath), jsContext, isExplicitlyDeclared);
        if (jSNamespaceImpl == null) {
            JSNamespaceImpl.$$$reportNull$$$0(5);
        }
        return jSNamespaceImpl;
    }

    @Nullable
    public static JSNamespace buildProvidedNamespace(@NotNull JSElementBase element, boolean isExplicitlyDeclared) {
        if (element == null) {
            JSNamespaceImpl.$$$reportNull$$$0(6);
        }
        return JSNamespaceEvaluationResult.buildProvidedNamespace(element, isExplicitlyDeclared, null);
    }

    public boolean isEquivalentTo(@NotNull JSNamespace other) {
        if (other == null) {
            JSNamespaceImpl.$$$reportNull$$$0(7);
        }
        return ComparatorUtil.equalsNullable((Object)this.getQualifiedName(), (Object)other.getQualifiedName()) && this.getJSContext() == other.getJSContext() && this.isExplicitlyDeclared() == other.isExplicitlyDeclared();
    }

    @NotNull
    public static JSNamespace withContext(@NotNull JSNamespace ns, @NotNull JSContext context) {
        if (ns == null) {
            JSNamespaceImpl.$$$reportNull$$$0(8);
        }
        if (context == null) {
            JSNamespaceImpl.$$$reportNull$$$0(9);
        }
        if (context == ns.getJSContext()) {
            JSNamespace jSNamespace = ns;
            if (jSNamespace == null) {
                JSNamespaceImpl.$$$reportNull$$$0(10);
            }
            return jSNamespace;
        }
        JSNamespaceImpl jSNamespaceImpl = new JSNamespaceImpl(ns.getQualifiedName(), context, ns.isExplicitlyDeclared());
        if (jSNamespaceImpl == null) {
            JSNamespaceImpl.$$$reportNull$$$0(11);
        }
        return jSNamespaceImpl;
    }

    @Nullable
    public JSNamepath toNamepath() {
        ArrayList<String> components = new ArrayList<String>();
        for (JSQualifiedName name = this.myName; name != null; name = name.getParent()) {
            components.add(name.getName());
        }
        JSNamepathImpl result = null;
        for (int i = components.size() - 1; i >= 0; --i) {
            String component = (String)components.get(i);
            char contextChar = i == 0 && this.myContext == JSContext.INSTANCE ? (char)'#' : '\u0000';
            result = new JSNamepathImpl(component, result, contextChar);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsContext";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/JSNamespaceImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namepath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ns";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/JSNamespaceImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "fromNamepath";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "withContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 10: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fromNamepath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildProvidedNamespace";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentTo";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "withContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

