/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSDestructuringPropertyBase;
import com.intellij.lang.javascript.psi.resolve.JSReferenceExpressionResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.WalkUpResolveProcessor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSDestructuringPropertyReference
extends PsiPolyVariantReferenceBase<JSDestructuringProperty> {
    public JSDestructuringPropertyReference(@NotNull JSDestructuringProperty property) {
        if (property == null) {
            JSDestructuringPropertyReference.$$$reportNull$$$0(0);
        }
        super((PsiElement)property, true);
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = JSResolveUtil.resolve(((JSDestructuringProperty)this.getElement()).getContainingFile(), this, (reference, incompleteCode1) -> {
            JSDestructuringProperty destructuringProperty = (JSDestructuringProperty)this.getElement();
            JSInitializerOwner element = destructuringProperty.getDestructuringElement();
            if (!(element instanceof JSVariable)) {
                return ResolveResult.EMPTY_ARRAY;
            }
            JSVariable jsVariable = (JSVariable)element;
            JSTypeEvaluationResult type = JSTypeEvaluator.getElementType((PsiElement)jsVariable);
            if (type != null) {
                ArrayList results = ContainerUtil.newArrayList();
                List<JSTypeEvaluationResult.JSTypeEvaluationResultElement> typeResults = type.getResults();
                for (JSTypeEvaluationResult.JSTypeEvaluationResultElement resultElement : typeResults) {
                    PsiElement source = resultElement.getSource();
                    if (source == null || jsVariable == source || destructuringProperty == source || jsVariable.getInitializer() == source || source == PsiUtilCore.NULL_PSI_ELEMENT || !resultElement.getEvaluationContext().isJSElementsToApplyEmpty()) continue;
                    results.add(new JSResolveResult(source));
                }
                if (!results.isEmpty()) {
                    return results.toArray(ResolveResult.EMPTY_ARRAY);
                }
            }
            WalkUpResolveProcessor processor = new WalkUpResolveProcessor(this.getCanonicalText(), destructuringProperty.getContainingFile(), (PsiElement)destructuringProperty);
            processor.setAddOnlyCompleteMatches(true);
            JSReferenceExpressionResolver.processAllSymbols(processor);
            return processor.getResults();
        }, incompleteCode);
        if (resolveResultArray == null) {
            JSDestructuringPropertyReference.$$$reportNull$$$0(1);
        }
        return resolveResultArray;
    }

    protected TextRange calculateDefaultRangeInElement() {
        JSDestructuringProperty element = (JSDestructuringProperty)this.getElement();
        if (element instanceof JSDestructuringPropertyBase) {
            PsiElement identifier = ((JSDestructuringPropertyBase)element).getNameIdentifierForPropertyOrNestedElement();
            if (identifier == null) {
                return ((JSDestructuringProperty)this.getElement()).getTextRange();
            }
            int startOffsetInParent = identifier.getStartOffsetInParent();
            return new TextRange(startOffsetInParent, startOffsetInParent + identifier.getTextLength());
        }
        return new TextRange(0, element.getTextLength());
    }

    @NotNull
    public String getCanonicalText() {
        String string = StringUtil.notNullize((String)((JSDestructuringProperty)this.myElement).getName());
        if (string == null) {
            JSDestructuringPropertyReference.$$$reportNull$$$0(2);
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        JSDestructuringProperty element = (JSDestructuringProperty)this.getElement();
        element.setName(newElementName);
        return element;
    }

    public boolean isReferenceTo(PsiElement element) {
        return super.isReferenceTo(element);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSDestructuringPropertyReference.$$$reportNull$$$0(3);
        }
        return null;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            JSDestructuringPropertyReference.$$$reportNull$$$0(4);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSDestructuringPropertyReference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSDestructuringPropertyReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

