/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.JSNamespaceEvaluationResult;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPropertyImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSObjectLiteralExpressionStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSStubIndexingUtils;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSObjectLiteralExpressionImpl
extends JSStubElementImpl<JSObjectLiteralExpressionStub>
implements JSObjectLiteralExpression,
StubBasedPsiElement<JSObjectLiteralExpressionStub> {
    private static final TokenSet PROPERTIES_AND_SPREADS = TokenSet.orSet((TokenSet[])new TokenSet[]{JSExtendedLanguagesTokenSetProvider.PROPERTIES, TokenSet.create((IElementType[])new IElementType[]{ES6ElementTypes.SPREAD_PROPERTY})});

    public JSObjectLiteralExpressionImpl(ASTNode node) {
        super(node);
    }

    public JSObjectLiteralExpressionImpl(JSObjectLiteralExpressionStub stub) {
        super(stub, (IStubElementType)JSStubElementTypes.OBJECT_LITERAL_EXPRESSION);
    }

    @NotNull
    public JSProperty[] getProperties() {
        JSProperty[] jSPropertyArray = (JSProperty[])this.getStubOrPsiChildren(JSExtendedLanguagesTokenSetProvider.PROPERTIES, JSProperty.ARRAY_FACTORY);
        if (jSPropertyArray == null) {
            JSObjectLiteralExpressionImpl.$$$reportNull$$$0(0);
        }
        return jSPropertyArray;
    }

    @Nullable
    public JSProperty getFirstProperty() {
        return (JSProperty)JSStubBasedPsiTreeUtil.getStubOrPsiChild(this, JSExtendedLanguagesTokenSetProvider.PROPERTIES);
    }

    public JSProperty findProperty(String name) {
        if (name == null) {
            return null;
        }
        Collection<JSElement> namedElements = JSResolveUtil.findNamedElementsInScope(name, this);
        for (JSElement element : namedElements) {
            if (!(element instanceof JSProperty)) continue;
            return (JSProperty)element;
        }
        return null;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSObjectLiteralExpressionImpl.$$$reportNull$$$0(1);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSObjectLiteralExpression((JSObjectLiteralExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public Icon getIcon(int flags) {
        return PlatformIcons.CLASS_ICON;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            JSObjectLiteralExpressionImpl.$$$reportNull$$$0(2);
        }
        if (state == null) {
            JSObjectLiteralExpressionImpl.$$$reportNull$$$0(3);
        }
        if (place == null) {
            JSObjectLiteralExpressionImpl.$$$reportNull$$$0(4);
        }
        if (!(lastParent != null && place instanceof JSProperty || JSPropertyImpl.placeToProcessProperties(place))) {
            return true;
        }
        return JSResolveUtil.processDeclarationsInScope(this, processor, state, lastParent, place);
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        PsiElement elt;
        if (element == null) {
            JSObjectLiteralExpressionImpl.$$$reportNull$$$0(5);
        }
        if ((elt = super.addBefore(element, anchor)) instanceof JSProperty) {
            super.addAfter(JSChangeUtil.createJSTreeFromText(this.getProject(), ",").getTreeNext().getPsi(), elt);
        }
        return elt;
    }

    public JSExpression replace(JSExpression other) {
        return JSChangeUtil.replaceExpression((JSExpression)this, other);
    }

    @NotNull
    public Set<String> getExtendedTypes() {
        String s;
        JSReferenceExpression baseType;
        String lends;
        JSDocComment docComment;
        JSObjectLiteralExpressionStub stub = (JSObjectLiteralExpressionStub)this.getGreenStub();
        if (stub != null) {
            Set set = stub.getExtendedTypes();
            if (set == null) {
                JSObjectLiteralExpressionImpl.$$$reportNull$$$0(6);
            }
            return set;
        }
        PsiElement parent = this.getParent();
        if (parent instanceof JSArgumentList) {
            JSNamespaceEvaluationResult localType;
            JSExpression qualifyingExpression;
            Pair<JSExpression, JSContext> ns = JSSymbolUtil.findNamespaceFromArgument((JSExpression)this, (JSArgumentList)parent);
            JSExpression jSExpression = qualifyingExpression = ns != null ? (JSExpression)ns.first : null;
            if (qualifyingExpression instanceof JSReferenceExpression && (localType = JSSymbolUtil.evaluateNamespaceLocally((JSReferenceExpression)qualifyingExpression)) != null) {
                qualifyingExpression = null;
            }
            if (qualifyingExpression != null) {
                THashSet baseTypes = new THashSet();
                if (qualifyingExpression.getParent() instanceof JSArrayLiteralExpression) {
                    for (JSExpression expr : ((JSArrayLiteralExpression)qualifyingExpression.getParent()).getExpressions()) {
                        String baseType2;
                        if (expr == null || expr.getClass() != qualifyingExpression.getClass() || (baseType2 = JSContextResolver.getQualifierOfExprAsString((JSElement)expr)) == null) continue;
                        baseTypes.add((Object)baseType2);
                    }
                } else {
                    String baseType3 = JSContextResolver.getQualifierOfExprAsString((JSElement)qualifyingExpression);
                    if (baseType3 != null) {
                        baseTypes.add((Object)baseType3);
                    }
                }
                THashSet tHashSet = baseTypes;
                if (tHashSet == null) {
                    JSObjectLiteralExpressionImpl.$$$reportNull$$$0(7);
                }
                return tHashSet;
            }
        }
        if ((docComment = JSDocumentationUtils.findOwnDocComment((PsiElement)this)) != null && (lends = docComment.getLendsTagValue()) != null) {
            Set<String> set = Collections.singleton(StringUtil.replace((String)lends, (String)".prototype", (String)"#"));
            if (set == null) {
                JSObjectLiteralExpressionImpl.$$$reportNull$$$0(8);
            }
            return set;
        }
        JSNamespaceEvaluationResult declarationNamespace = JSSymbolUtil.findNamespace((JSExpression)this);
        JSQualifiedName namespace = declarationNamespace != null ? declarationNamespace.getQualifiedName() : null;
        PsiElement scope = JSPsiImplUtils.getExecutionScope((PsiElement)this);
        if (namespace != null && namespace.getParent() == null && scope instanceof JSExecutionScope && (baseType = (JSReferenceExpression)((JSExecutionScope)scope).getExtensionSymbols().get(namespace.getName())) != null && (s = JSStubIndexingUtils.evaluateTypeString(baseType)) != null) {
            Set<String> set = Collections.singleton(s);
            if (set == null) {
                JSObjectLiteralExpressionImpl.$$$reportNull$$$0(9);
            }
            return set;
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            JSObjectLiteralExpressionImpl.$$$reportNull$$$0(10);
        }
        return set;
    }

    @NotNull
    public JSElement[] getPropertiesIncludingSpreads() {
        JSElement[] jSElementArray = (JSElement[])this.getStubOrPsiChildren(PROPERTIES_AND_SPREADS, JSElement.ARRAY_FACTORY);
        if (jSElementArray == null) {
            JSObjectLiteralExpressionImpl.$$$reportNull$$$0(11);
        }
        return jSElementArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSObjectLiteralExpressionImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSObjectLiteralExpressionImpl";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtendedTypes";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertiesIncludingSpreads";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addBefore";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

