/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.impl.JSStatementImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class JSSwitchStatementImpl
extends JSStatementImpl
implements JSSwitchStatement {
    private volatile JSStatement[] myStatements;

    public JSSwitchStatementImpl(IElementType elementType) {
        super(elementType);
    }

    public JSExpression getSwitchExpression() {
        ASTNode node = this.getNode().findChildByType(JSExtendedLanguagesTokenSetProvider.EXPRESSIONS);
        return node != null ? (JSExpression)node.getPsi() : null;
    }

    public JSCaseClause[] getCaseClauses() {
        ASTNode[] nodes = this.getNode().getChildren(JSExtendedLanguagesTokenSetProvider.CASE_CLAUSES);
        JSCaseClause[] clauses = new JSCaseClause[nodes.length];
        for (int i = 0; i < clauses.length; ++i) {
            clauses[i] = (JSCaseClause)nodes[i].getPsi();
        }
        return clauses;
    }

    public void clearCaches() {
        super.clearCaches();
        this.myStatements = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSStatement[] getStatements() {
        JSStatement[] result = this.myStatements;
        if (result == null) {
            JSSwitchStatementImpl jSSwitchStatementImpl = this;
            synchronized (jSSwitchStatementImpl) {
                result = this.myStatements;
                if (result == null) {
                    ArrayList switchStatements = new ArrayList();
                    for (JSCaseClause clause : this.getCaseClauses()) {
                        ContainerUtil.addAll(switchStatements, (Object[])clause.getStatements());
                    }
                    int switchStatementsCount = switchStatements.size();
                    this.myStatements = result = switchStatementsCount != 0 ? switchStatements.toArray(new JSStatement[switchStatementsCount]) : EMPTY;
                }
            }
        }
        return result;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSSwitchStatementImpl.$$$reportNull$$$0(0);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSSwitchStatement((JSSwitchStatement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/impl/JSSwitchStatementImpl", "accept"));
    }
}

