/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.jsdoc.impl;

import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.openapi.util.Pair;
import com.intellij.util.SmartList;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JSDocCommentCachedData {
    private List<Pair<String, String>> myTypedefs;
    private String myType;
    private String myExplicitName;
    private JSQualifiedName myNamespace;
    private boolean myNamespaceExplicitlyDeclared;
    @NotNull
    private JSContext myContext = JSContext.UNKNOWN;
    private boolean mySeemsToBeFunction;
    private JSQualifiedName myClassName;
    private Map<JSQualifiedName, String> myProperties;
    private Set<JSQualifiedName> myOptionals;
    private List<String> myGenericParameters;
    private JSAttributeList.AccessType myAccessType;
    private Collection<String> myBaseTypes;
    private String myEnumType;
    private boolean myIsInterface;
    private boolean myIsClassExplicitly;
    private boolean myHasDeprecatedTag;
    private boolean myHasConstructsTag;
    private String myReturnType;
    private boolean myHasNamespaceTag;
    private boolean myHasLendsTag;
    private JSDocComment.BrowserFamily myBrowser = JSDocComment.BrowserFamily.ANY;
    private List<Pair<JSQualifiedName, String>> myParameters;
    private Map<JSQualifiedName, String> myDefaultValues;
    private String myThisType;
    private String myAlias;
    private boolean myHasAbstractTag;
    private boolean myHasConstTag;

    JSDocCommentCachedData() {
    }

    public void addTypedef(@Nullable String name, @NotNull String type) {
        if (type == null) {
            JSDocCommentCachedData.$$$reportNull$$$0(0);
        }
        if (this.myTypedefs == null) {
            this.myTypedefs = new SmartList();
        }
        this.myTypedefs.add((Pair<String, String>)Pair.create((Object)name, (Object)type));
    }

    @NotNull
    public List<Pair<String, String>> getTypedefs() {
        List<Object> list = this.myTypedefs != null ? this.myTypedefs : Collections.emptyList();
        if (list == null) {
            JSDocCommentCachedData.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    public String getType() {
        return this.myType;
    }

    public void setType(String type) {
        this.myType = type;
    }

    @Nullable
    public String getExplicitName() {
        return this.myExplicitName;
    }

    public void setExplicitName(String explicitName) {
        this.myExplicitName = explicitName;
    }

    @NotNull
    public JSContext getContext() {
        JSContext jSContext = this.myContext;
        if (jSContext == null) {
            JSDocCommentCachedData.$$$reportNull$$$0(2);
        }
        return jSContext;
    }

    public void setContext(@NotNull JSContext context) {
        if (context == null) {
            JSDocCommentCachedData.$$$reportNull$$$0(3);
        }
        this.myContext = context;
    }

    public boolean seemsToBeFunction() {
        return this.mySeemsToBeFunction;
    }

    public void setSeemsToBeFunction() {
        this.mySeemsToBeFunction = true;
    }

    @Nullable
    public JSQualifiedName getClassName() {
        return this.myClassName;
    }

    public void setClassName(JSQualifiedName className) {
        this.myClassName = className;
        JSQualifiedName ns = className.getParent();
        this.setNamespace(ns, false);
    }

    @Nullable
    public JSQualifiedName getNamespace() {
        return this.myNamespace;
    }

    public boolean isNamespaceExplicitlyDeclared() {
        return this.myNamespaceExplicitlyDeclared;
    }

    public void setNamespace(@Nullable JSQualifiedName namespace, boolean isExplicit) {
        this.myNamespace = namespace;
        if (namespace != null || isExplicit) {
            this.myNamespaceExplicitlyDeclared = true;
        }
    }

    public void addProperty(@NotNull JSQualifiedName name, @Nullable String type) {
        if (name == null) {
            JSDocCommentCachedData.$$$reportNull$$$0(4);
        }
        if (this.myProperties == null) {
            this.myProperties = new THashMap();
        }
        this.myProperties.put(name, type);
    }

    @Nullable
    public Map<JSQualifiedName, String> getProperties() {
        return this.myProperties;
    }

    public void clearProperties() {
        this.myProperties = null;
    }

    public void setOptional(@NotNull JSQualifiedName name) {
        if (name == null) {
            JSDocCommentCachedData.$$$reportNull$$$0(5);
        }
        if (this.myOptionals == null) {
            this.myOptionals = new THashSet();
        }
        this.myOptionals.add(name);
    }

    @NotNull
    public Set<JSQualifiedName> getOptionals() {
        Set<Object> set = this.myOptionals != null ? this.myOptionals : Collections.emptySet();
        if (set == null) {
            JSDocCommentCachedData.$$$reportNull$$$0(6);
        }
        return set;
    }

    public void addGenericParameter(@NotNull String genericParameter) {
        if (genericParameter == null) {
            JSDocCommentCachedData.$$$reportNull$$$0(7);
        }
        if (this.myGenericParameters == null) {
            this.myGenericParameters = new SmartList();
        }
        this.myGenericParameters.add(genericParameter);
    }

    @NotNull
    public List<String> getGenericParameters() {
        List<Object> list = this.myGenericParameters == null ? Collections.emptyList() : this.myGenericParameters;
        if (list == null) {
            JSDocCommentCachedData.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Nullable
    public JSAttributeList.AccessType getAccessType() {
        return this.myAccessType;
    }

    public void setAccessType(JSAttributeList.AccessType accessType) {
        this.myAccessType = accessType;
    }

    @Nullable
    public Collection<String> getBaseTypes() {
        return this.myBaseTypes;
    }

    public void addBaseType(String baseType) {
        if (this.myBaseTypes == null) {
            this.myBaseTypes = new SmartList();
        }
        this.myBaseTypes.add(baseType);
    }

    @Nullable
    public String getEnumType() {
        return this.myEnumType;
    }

    public void setEnumType(String enumType) {
        this.myEnumType = enumType;
    }

    public void setIsInterface() {
        this.myIsInterface = true;
        this.setIsClassExplicitly();
    }

    public boolean isInterface() {
        return this.myIsInterface;
    }

    public boolean isClassExplicitly() {
        return this.myIsClassExplicitly;
    }

    public void setIsClassExplicitly() {
        this.myIsClassExplicitly = true;
    }

    public boolean hasDeprecatedTag() {
        return this.myHasDeprecatedTag;
    }

    public void setHasDeprecatedTag() {
        this.myHasDeprecatedTag = true;
    }

    public boolean hasConstructsTag() {
        return this.myHasConstructsTag;
    }

    public void setHasConstructsTag() {
        this.myHasConstructsTag = true;
    }

    @Nullable
    public String getReturnType() {
        return this.myReturnType;
    }

    public void setReturnType(String returnType) {
        this.myReturnType = returnType;
    }

    public boolean hasNamespaceTag() {
        return this.myHasNamespaceTag;
    }

    public void setHasNamespaceTag() {
        this.myHasNamespaceTag = true;
    }

    public boolean hasLendsTag() {
        return this.myHasLendsTag;
    }

    public void setHasLendsTag() {
        this.myHasLendsTag = true;
    }

    @Nullable
    public String getLendsTagValue() {
        if (!this.hasLendsTag()) {
            return null;
        }
        String value = this.getExplicitName();
        if (value == null) {
            return null;
        }
        if (this.getNamespace() != null) {
            value = this.getNamespace().getQualifiedName() + "." + value;
        }
        if (this.getContext() == JSContext.INSTANCE) {
            value = value + "#";
        }
        return value;
    }

    public void setBrowserFamily(@NotNull JSDocComment.BrowserFamily browserFamily) {
        if (browserFamily == null) {
            JSDocCommentCachedData.$$$reportNull$$$0(9);
        }
        this.myBrowser = browserFamily;
    }

    @NotNull
    public JSDocComment.BrowserFamily getBrowserFamily() {
        JSDocComment.BrowserFamily browserFamily = this.myBrowser;
        if (browserFamily == null) {
            JSDocCommentCachedData.$$$reportNull$$$0(10);
        }
        return browserFamily;
    }

    public void addParameter(@NotNull JSQualifiedName name, @Nullable String type) {
        if (name == null) {
            JSDocCommentCachedData.$$$reportNull$$$0(11);
        }
        if (this.myParameters == null) {
            this.myParameters = new SmartList();
        }
        this.myParameters.add((Pair<JSQualifiedName, String>)Pair.create((Object)name, (Object)type));
    }

    @Nullable
    public List<Pair<JSQualifiedName, String>> getParameters() {
        return this.myParameters;
    }

    public void addDefaultValue(@NotNull JSQualifiedName name, String remainingLineContent) {
        if (name == null) {
            JSDocCommentCachedData.$$$reportNull$$$0(12);
        }
        if (this.myDefaultValues == null) {
            this.myDefaultValues = new THashMap();
        }
        this.myDefaultValues.put(name, remainingLineContent);
    }

    @Nullable
    public String getDefaultValue(@NotNull JSQualifiedName name) {
        if (name == null) {
            JSDocCommentCachedData.$$$reportNull$$$0(13);
        }
        return this.myDefaultValues != null ? this.myDefaultValues.get(name) : null;
    }

    @Nullable
    public String getThisType() {
        return this.myThisType;
    }

    public void setThisType(String thisType) {
        this.myThisType = thisType;
    }

    @Nullable
    public String getAlias() {
        return this.myAlias;
    }

    public void setAlias(String alias) {
        this.myAlias = alias;
    }

    public boolean hasAbstractTag() {
        return this.myHasAbstractTag;
    }

    public void setHasAbstractTag() {
        this.myHasAbstractTag = true;
    }

    public boolean hasConstTag() {
        return this.myHasConstTag;
    }

    public void setHasConstTag() {
        this.myHasConstTag = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentCachedData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericParameter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browserFamily";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentCachedData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypedefs";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionals";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericParameters";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrowserFamily";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addTypedef";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setContext";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addProperty";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setOptional";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addGenericParameter";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setBrowserFamily";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addParameter";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addDefaultValue";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

