/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.accessibility.JSAccessibilityChecker;
import com.intellij.lang.javascript.psi.resolve.accessibility.TypeScriptConfigAccessibilityChecker;
import com.intellij.lang.javascript.psi.resolve.accessibility.TypeScriptModuleAccessibilityChecker;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AccessibilityProcessingHandler {
    public static final String AS3_NAMESPACE_VALUE = "http://adobe.com/AS3/2006/builtin";
    private static final String ourNestedClassPrefix = "_$_$NeStEd$_$_";
    protected boolean acceptPrivateMembers = true;
    protected boolean acceptProtectedMembers = true;
    private boolean acceptProtectedMembersSet;
    protected boolean processStatics;
    protected boolean allowUnqualifiedStaticsFromInstance;
    protected String myTypeName;
    protected Set<String> myClassScopeTypeNames;
    protected boolean myClassDeclarationStarted;
    @Nullable
    protected final PsiElement place;
    protected boolean myProcessingInheritedClasses;
    private boolean myClassScopeExplicitlySet;
    private Collection<JSAccessibilityChecker> myCheckers;
    private static Collection<JSAccessibilityChecker> CHECKERS = ContainerUtil.newArrayList((Object[])new JSAccessibilityChecker[]{TypeScriptConfigAccessibilityChecker.INSTANCE, TypeScriptModuleAccessibilityChecker.INSTANCE});

    public AccessibilityProcessingHandler(@Nullable PsiElement _place) {
        this.place = _place;
        this.allowUnqualifiedStaticsFromInstance = this.place instanceof JSReferenceExpression && ((JSReferenceExpression)this.place).getQualifier() == null;
    }

    public boolean accepts(@NotNull PsiElement element, @NotNull SinkResolveProcessor resolveProcessor) {
        String errorFromCheckers;
        if (element == null) {
            AccessibilityProcessingHandler.$$$reportNull$$$0(0);
        }
        if (resolveProcessor == null) {
            AccessibilityProcessingHandler.$$$reportNull$$$0(1);
        }
        if (!StringUtil.isEmpty((String)(errorFromCheckers = this.processCheckers(element, resolveProcessor)))) {
            resolveProcessor.addPossibleCandidateResult(element, errorFromCheckers);
            return false;
        }
        if (element instanceof JSVariable || element instanceof JSFunction || element instanceof JSNamespaceDeclaration) {
            return this.acceptsForMembersVisibility((JSPsiElementBase)element, resolveProcessor);
        }
        return !this.processStatics || !this.myClassDeclarationStarted || !(element instanceof JSImplicitElement) || ((JSImplicitElement)element).getType() != JSImplicitElement.Type.Tag;
    }

    protected boolean acceptsForMembersVisibility(@NotNull JSPsiElementBase element, @NotNull SinkResolveProcessor resolveProcessor) {
        if (element == null) {
            AccessibilityProcessingHandler.$$$reportNull$$$0(2);
        }
        if (resolveProcessor == null) {
            AccessibilityProcessingHandler.$$$reportNull$$$0(3);
        }
        if (DialectDetector.isES6((PsiElement)element) && !(JSPsiImplUtils.getExecutionScope((PsiElement)element) instanceof JSClass)) {
            return true;
        }
        JSAttributeList.AccessType accessType = element.getAccessType();
        PsiElement parentOfElement = JSResolveUtil.findParent((PsiElement)element);
        if (this.needCheckAccessFromPlace(element, parentOfElement)) {
            if (!this.acceptPrivateMembers && accessType == JSAttributeList.AccessType.PRIVATE) {
                resolveProcessor.addPossibleCandidateResult((PsiElement)element, "javascript.private.member.is.not.accessible.message");
                return false;
            }
            if (!this.acceptProtectedMembers && accessType == JSAttributeList.AccessType.PROTECTED && (this.myClassScopeTypeNames != null || AccessibilityProcessingHandler.isParentClassContext((PsiElement)element))) {
                resolveProcessor.addPossibleCandidateResult((PsiElement)element, "javascript.protected.member.is.not.accessible.message");
                return false;
            }
        }
        if (parentOfElement instanceof TypeScriptObjectType) {
            return this.isProcessStatics();
        }
        if (this.processStatics) {
            if (element.getJSContext() != JSContext.STATIC) {
                return false;
            }
            if (!DialectDetector.isTypeScript((PsiElement)element) && this.myTypeName != null && parentOfElement instanceof JSClass && !this.myTypeName.equals(((JSClass)parentOfElement).getQualifiedName())) {
                resolveProcessor.addPossibleCandidateResult((PsiElement)element, "javascript.static.member.is.not.accessible.message");
                return false;
            }
        } else {
            if (DialectDetector.isES6((PsiElement)element) && element.getJSContext() == JSContext.STATIC) {
                return false;
            }
            if (this.myClassDeclarationStarted && !this.allowUnqualifiedStaticsFromInstance && element.getJSContext() == JSContext.STATIC) {
                resolveProcessor.addPossibleCandidateResult((PsiElement)element, "javascript.static.member.is.not.accessible.message");
                return false;
            }
        }
        return true;
    }

    private boolean needCheckAccessFromPlace(@NotNull JSPsiElementBase element, PsiElement parentOfElement) {
        if (element == null) {
            AccessibilityProcessingHandler.$$$reportNull$$$0(4);
        }
        if (this.place != null && parentOfElement instanceof TypeScriptModule) {
            PsiElement parent = JSResolveUtil.findParent(this.place);
            return parent != null && !PsiTreeUtil.isAncestor((PsiElement)parentOfElement, (PsiElement)parent, (boolean)false);
        }
        return JSResolveUtil.getClassOfContext(this.place) != JSUtils.getMemberContainingClass((PsiElement)element);
    }

    @Nullable
    protected String processCheckers(@NotNull PsiElement element, @NotNull SinkResolveProcessor resolveProcessor) {
        if (element == null) {
            AccessibilityProcessingHandler.$$$reportNull$$$0(5);
        }
        if (resolveProcessor == null) {
            AccessibilityProcessingHandler.$$$reportNull$$$0(6);
        }
        Iterable<JSAccessibilityChecker> allCheckers = CHECKERS;
        if (this.myCheckers != null) {
            allCheckers = ContainerUtil.concat((Iterable[])new Iterable[]{allCheckers, this.myCheckers});
        }
        for (JSAccessibilityChecker checker : allCheckers) {
            String check;
            if (!checker.isAvailable(this, resolveProcessor) || StringUtil.isEmpty((String)(check = checker.check(this.place, element)))) continue;
            return check;
        }
        return null;
    }

    protected static boolean isParentClassContext(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            AccessibilityProcessingHandler.$$$reportNull$$$0(7);
        }
        return (parent = JSResolveUtil.findParent(element)) instanceof JSClass || parent instanceof TypeScriptFunction && ((TypeScriptFunction)parent).isConstructor();
    }

    public void setTypeName(String qualifiedName) {
        this.myTypeName = qualifiedName;
    }

    public void configureClassScope(JSClass jsClass) {
        this.myClassScopeExplicitlySet = true;
        this.configureCurrentClassScope(jsClass);
    }

    private static String getClassScopeName(JSClass jsClass) {
        String qName = jsClass.getQualifiedName();
        if (qName != null && PsiTreeUtil.getParentOfType((PsiElement)jsClass, JSFunction.class) == null) {
            return qName;
        }
        int offset = jsClass.getTextOffset();
        return ourNestedClassPrefix + offset;
    }

    @Nullable
    private static JSClass getParentClass(@NotNull PsiElement element) {
        if (element == null) {
            AccessibilityProcessingHandler.$$$reportNull$$$0(8);
        }
        return (JSClass)PsiTreeUtil.getParentOfType((PsiElement)element, JSClass.class);
    }

    private void configureCurrentClassScope(@Nullable JSClass jsClass) {
        if (jsClass != null) {
            this.myClassScopeTypeNames = new HashSet<String>();
            this.myClassScopeTypeNames.add(AccessibilityProcessingHandler.getClassScopeName(jsClass));
            JSClass parentClass = AccessibilityProcessingHandler.getParentClass((PsiElement)jsClass);
            while (parentClass != null) {
                this.myClassScopeTypeNames.add(AccessibilityProcessingHandler.getClassScopeName(parentClass));
                parentClass = AccessibilityProcessingHandler.getParentClass((PsiElement)parentClass);
            }
            this.acceptProtectedMembersSet = false;
        } else {
            this.acceptProtectedMembers = false;
            this.acceptProtectedMembersSet = true;
        }
    }

    public void startingParent(PsiElement parent) {
        this.myClassDeclarationStarted = parent instanceof JSClass;
        if (parent instanceof JSClass) {
            JSClass jsClass = (JSClass)parent;
            final String qName = AccessibilityProcessingHandler.getClassScopeName(jsClass);
            if (!this.myProcessingInheritedClasses && !this.myClassScopeExplicitlySet) {
                this.configureCurrentClassScope(JSResolveUtil.getClassOfContext(this.place));
            }
            if (this.acceptPrivateMembers) {
                boolean bl = this.acceptPrivateMembers = qName != null && this.myClassScopeTypeNames != null && this.myClassScopeTypeNames.contains(qName);
            }
            if (!this.acceptProtectedMembersSet) {
                this.acceptProtectedMembersSet = true;
                if (this.myClassScopeTypeNames != null) {
                    List<PsiElement> elements;
                    this.acceptProtectedMembers = this.myClassScopeTypeNames.contains(qName);
                    if (this.place != null && (elements = this.getClassScopeTypes(parent)) != null) {
                        for (PsiElement element : elements) {
                            if (this.acceptProtectedMembers || !(element instanceof JSClass)) continue;
                            boolean b = element.processDeclarations((PsiScopeProcessor)new ResolveProcessor(null){
                                {
                                    super(name);
                                    this.setTypeContext(true);
                                    this.setToProcessMembers(false);
                                    this.setToProcessHierarchy(true);
                                    this.setLocalResolve(true);
                                }

                                public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                                    if (element == null) {
                                        1.$$$reportNull$$$0(0);
                                    }
                                    if (state == null) {
                                        1.$$$reportNull$$$0(1);
                                    }
                                    if (!(element instanceof JSClass)) {
                                        return true;
                                    }
                                    String classQName = AccessibilityProcessingHandler.getClassScopeName((JSClass)element);
                                    return classQName != null && !classQName.equals(qName);
                                }

                                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                    Object[] objectArray;
                                    Object[] objectArray2 = new Object[3];
                                    switch (n) {
                                        default: {
                                            objectArray = objectArray2;
                                            objectArray2[0] = "element";
                                            break;
                                        }
                                        case 1: {
                                            objectArray = objectArray2;
                                            objectArray2[0] = "state";
                                            break;
                                        }
                                    }
                                    objectArray[1] = "com/intellij/lang/javascript/psi/resolve/AccessibilityProcessingHandler$1";
                                    objectArray[2] = "execute";
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                                }
                            }, ResolveState.initial(), element, element);
                            boolean bl = this.acceptProtectedMembers = !b;
                            if (!(this.place instanceof JSReferenceExpression) || ((JSReferenceExpression)this.place).getQualifier() instanceof JSSuperExpression) continue;
                            this.acceptProtectedMembers = this.acceptProtectedMembers && this.processStatics;
                        }
                    }
                }
            }
        } else if (parent instanceof TypeScriptModule) {
            if (this.acceptPrivateMembers) {
                String qName = ((TypeScriptModule)parent).getQualifiedName();
                this.acceptPrivateMembers = qName != null && this.myClassScopeTypeNames != null && this.myClassScopeTypeNames.contains(qName);
            }
        } else if (parent instanceof JSAttributeListOwner) {
            JSAttributeList attributeList = ((JSAttributeListOwner)parent).getAttributeList();
            if (attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.STATIC) && !DialectDetector.isES6(parent)) {
                this.processStatics = true;
            }
        } else if (parent instanceof JSFile || parent instanceof JSPackageStatement || parent instanceof XmlTag) {
            this.processStatics = false;
        }
    }

    private List<PsiElement> getClassScopeTypes(PsiElement parent) {
        if (this.myClassScopeTypeNames == null) {
            return null;
        }
        ArrayList<PsiElement> allScopes = new ArrayList<PsiElement>();
        PsiFile file = this.place.getContainingFile();
        for (String myClassScopeTypeName : this.myClassScopeTypeNames) {
            if (myClassScopeTypeName.startsWith(ourNestedClassPrefix)) {
                if (file == null) continue;
                int offset = Integer.parseInt(myClassScopeTypeName.substring(ourNestedClassPrefix.length()));
                PsiElement clazz = file.findElementAt(offset);
                assert (clazz != null);
                clazz = PsiTreeUtil.getParentOfType((PsiElement)clazz, JSClass.class);
                assert (clazz != null);
                allScopes.add(clazz);
                continue;
            }
            if (DialectDetector.isTypeScript(parent)) {
                allScopes.add(JSClassResolver.getInstance().findClassByQName(myClassScopeTypeName, JSResolveUtil.getResolveScope(parent)));
                continue;
            }
            allScopes.add(JSClassResolver.findClassFromNamespace(myClassScopeTypeName, this.place));
        }
        return allScopes;
    }

    public void setProcessStatics(boolean processStatics) {
        this.processStatics = processStatics;
    }

    public void setAllowUnqualifiedStaticsFromInstance(boolean allowUnqualifiedStaticsFromInstance) {
        this.allowUnqualifiedStaticsFromInstance = allowUnqualifiedStaticsFromInstance;
    }

    public boolean isProcessStatics() {
        return this.processStatics;
    }

    public void addChecker(JSAccessibilityChecker checker) {
        if (this.myCheckers == null) {
            this.myCheckers = new SmartList();
        }
        this.myCheckers.add(checker);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveProcessor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/AccessibilityProcessingHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "accepts";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "acceptsForMembersVisibility";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "needCheckAccessFromPlace";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processCheckers";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isParentClassContext";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getParentClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

