/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackage;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagValue;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeContextFilter;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSCompletionPlaceFilter {
    public static final JSCompletionPlaceFilter ANY = new JSCompletionPlaceFilter(){};
    private static final JSCompletionPlaceFilter JS_TYPE_CONTEXT = new JSTypeContextFilter(){};
    private static final JSCompletionPlaceFilter AS_TYPE_CONTEXT = new JSCompletionPlaceFilter(){

        @Override
        public boolean isAcceptable(@NotNull JSPsiElementBase element) {
            if (element == null) {
                3.$$$reportNull$$$0(0);
            }
            if (AS_STRICT_TYPE_CONTEXT.isAcceptable(element)) {
                return true;
            }
            return !(element.getContext() instanceof JSClass) && (element instanceof JSFunction || element instanceof JSVariable);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSCompletionPlaceFilter$3", "isAcceptable"));
        }
    };
    private static final JSCompletionPlaceFilter AS_STRICT_TYPE_CONTEXT = new JSCompletionPlaceFilter(){

        @Override
        public boolean isAcceptable(@NotNull JSPsiElementBase element) {
            if (element == null) {
                4.$$$reportNull$$$0(0);
            }
            return (element instanceof JSClass || element instanceof JSPackage) && !"Arguments".equals(element.getName());
        }

        @Override
        public boolean isPartialResult(@NotNull JSPsiElementBase element) {
            if (element == null) {
                4.$$$reportNull$$$0(1);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "element";
            objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSCompletionPlaceFilter$4";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAcceptable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isPartialResult";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private static final JSCompletionPlaceFilter CLASS_FILTER = new JSCompletionPlaceFilter(){

        @Override
        boolean isAcceptable(@NotNull JSPsiElementBase element) {
            if (element == null) {
                5.$$$reportNull$$$0(0);
            }
            if (element instanceof JSClass) {
                JSClass clazz = (JSClass)element;
                if (clazz.isInterface()) {
                    return false;
                }
                JSAttributeList attributeList = clazz.getAttributeList();
                if (attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.FINAL)) {
                    return false;
                }
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSCompletionPlaceFilter$5", "isAcceptable"));
        }
    };
    private static final JSCompletionPlaceFilter INTERFACE_FILTER = new JSCompletionPlaceFilter(){

        @Override
        boolean isAcceptable(@NotNull JSPsiElementBase element) {
            if (element == null) {
                6.$$$reportNull$$$0(0);
            }
            return !(element instanceof JSClass) || ((JSClass)element).isInterface();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSCompletionPlaceFilter$6", "isAcceptable"));
        }
    };
    private static final JSCompletionPlaceFilter TS_INDEXER_TYPE_FILTER = new JSCompletionPlaceFilter(){

        @Override
        boolean isAcceptable(@NotNull JSPsiElementBase element) {
            if (element == null) {
                7.$$$reportNull$$$0(0);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSCompletionPlaceFilter$7", "isAcceptable"));
        }
    };
    private static final JSCompletionPlaceFilter AS_NEW_EXPRESSION_FILTER = new JSCompletionPlaceFilter(){

        @Override
        boolean isAcceptable(@NotNull JSPsiElementBase element) {
            if (element == null) {
                8.$$$reportNull$$$0(0);
            }
            if (element instanceof JSClass && ((JSClass)element).isInterface() || element instanceof JSFunction && element.getParent() instanceof JSClass && !((JSFunction)element).isConstructor() && (!((JSFunction)element).isGetProperty() || !this.typeCanBePresentInNew(((JSFunction)element).getReturnType()))) {
                return false;
            }
            return !(element instanceof JSVariable) || this.typeCanBePresentInNew(((JSVariable)element).getType());
        }

        private boolean typeCanBePresentInNew(@Nullable JSType type) {
            if (type == null || type instanceof JSAnyType) {
                return false;
            }
            return type.getTypeText().equals("Class");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSCompletionPlaceFilter$8", "isAcceptable"));
        }
    };
    private static final JSCompletionPlaceFilter JS_NEW_EXPRESSION_FILTER = new JSCompletionPlaceFilter(){

        @Override
        boolean isAcceptable(@NotNull JSPsiElementBase element) {
            if (element == null) {
                9.$$$reportNull$$$0(0);
            }
            return JS_TYPE_CONTEXT.isAcceptable(element);
        }

        @Override
        boolean isPartialResult(@NotNull JSPsiElementBase element) {
            if (element == null) {
                9.$$$reportNull$$$0(1);
            }
            return JS_TYPE_CONTEXT.isPartialResult(element);
        }

        @Override
        boolean isLoweredPriority(@NotNull JSPsiElementBase element) {
            if (element == null) {
                9.$$$reportNull$$$0(2);
            }
            if (element instanceof JSClass) {
                return false;
            }
            JSFunctionItem item = JSPsiImplUtils.getPossibleFunctionItem((PsiElement)element);
            return item == null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "element";
            objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSCompletionPlaceFilter$9";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAcceptable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isPartialResult";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isLoweredPriority";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    boolean isAcceptable(@NotNull JSPsiElementBase element) {
        if (element == null) {
            JSCompletionPlaceFilter.$$$reportNull$$$0(0);
        }
        return true;
    }

    boolean isPartialResult(@NotNull JSPsiElementBase element) {
        if (element == null) {
            JSCompletionPlaceFilter.$$$reportNull$$$0(1);
        }
        return false;
    }

    boolean isLoweredPriority(@NotNull JSPsiElementBase element) {
        if (element == null) {
            JSCompletionPlaceFilter.$$$reportNull$$$0(2);
        }
        return false;
    }

    private static boolean isTypeOnlyUsage(@NotNull JSPsiElementBase element) {
        if (element == null) {
            JSCompletionPlaceFilter.$$$reportNull$$$0(3);
        }
        return element instanceof TypeScriptInterface || element instanceof TypeScriptTypeAlias;
    }

    private static boolean isStrictlyNonTypeUsage(@NotNull JSPsiElementBase element) {
        if (element == null) {
            JSCompletionPlaceFilter.$$$reportNull$$$0(4);
        }
        if (element instanceof JSVariable) {
            return !(element instanceof TypeScriptEnumField);
        }
        if (element instanceof JSFunction) {
            return true;
        }
        return element instanceof JSField;
    }

    public static JSCompletionPlaceFilter forPlace(@NotNull PsiElement place) {
        if (place == null) {
            JSCompletionPlaceFilter.$$$reportNull$$$0(5);
        }
        boolean isActionScript = DialectDetector.isActionScript(place);
        if (place instanceof JSReferenceExpression && place.getParent() instanceof JSReferenceListMember) {
            PsiElement parent = place.getParent().getParent();
            if (JSElementTypes.EXTENDS_LISTS.contains(parent.getNode().getElementType())) {
                PsiElement element = parent.getParent();
                if (element instanceof JSClass) {
                    return ((JSClass)element).isInterface() ? INTERFACE_FILTER : CLASS_FILTER;
                }
            } else {
                return INTERFACE_FILTER;
            }
            return ANY;
        }
        if (place instanceof JSReferenceExpression && ((JSReferenceExpression)place).getQualifier() == null) {
            if (ResolveProcessor.completeConstructorName(place)) {
                return isActionScript ? AS_NEW_EXPRESSION_FILTER : JS_NEW_EXPRESSION_FILTER;
            }
            if (TypeScriptPsiUtil.isTsIndexerType(place)) {
                return TS_INDEXER_TYPE_FILTER;
            }
            final boolean strictTypeContext = JSResolveUtil.isExprInTypeContext((JSReferenceExpression)place);
            if (isActionScript) {
                if (strictTypeContext) {
                    return AS_STRICT_TYPE_CONTEXT;
                }
                if (JSResolveUtil.isInPlaceWhereTypeCanBeDuringCompletion(place)) {
                    return AS_TYPE_CONTEXT;
                }
                return ANY;
            }
            JSVariable variable = JSCompletionPlaceFilter.getOwnLetOrConstVariableDeclaration(place);
            final String varName = variable == null ? null : variable.getName();
            final ContextKind contextKind = JSCompletionPlaceFilter.getContextKind(place);
            return new JSTypeContextFilter(){

                @Override
                boolean isAcceptable(@NotNull JSPsiElementBase element) {
                    if (element == null) {
                        10.$$$reportNull$$$0(0);
                    }
                    if (contextKind == ContextKind.TypeDeclaration && JSCompletionPlaceFilter.isStrictlyNonTypeUsage(element)) {
                        return false;
                    }
                    if (contextKind == ContextKind.Expression && JSCompletionPlaceFilter.isTypeOnlyUsage(element)) {
                        return false;
                    }
                    if (!(element instanceof JSVariable)) {
                        return true;
                    }
                    if (varName == null) {
                        return true;
                    }
                    JSVariable var = (JSVariable)element;
                    return !varName.equals(var.getName());
                }

                @Override
                public boolean isPartialResult(@NotNull JSPsiElementBase element) {
                    if (element == null) {
                        10.$$$reportNull$$$0(1);
                    }
                    return strictTypeContext && super.isPartialResult(element);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "element";
                    objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSCompletionPlaceFilter$10";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isAcceptable";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isPartialResult";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }
        if (place instanceof JSReferenceExpression && ((JSReferenceExpression)place).getQualifier() != null) {
            final ContextKind contextKind = JSCompletionPlaceFilter.getContextKind(place);
            return new JSCompletionPlaceFilter(){

                @Override
                boolean isAcceptable(@NotNull JSPsiElementBase element) {
                    if (element == null) {
                        11.$$$reportNull$$$0(0);
                    }
                    if (contextKind == ContextKind.TypeDeclaration && JSCompletionPlaceFilter.isStrictlyNonTypeUsage(element)) {
                        return false;
                    }
                    return contextKind != ContextKind.Expression || !JSCompletionPlaceFilter.isTypeOnlyUsage(element);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSCompletionPlaceFilter$11", "isAcceptable"));
                }
            };
        }
        if (place instanceof JSDocTagValue) {
            return isActionScript ? AS_TYPE_CONTEXT : JS_TYPE_CONTEXT;
        }
        return ANY;
    }

    private static ContextKind getContextKind(@NotNull PsiElement place) {
        if (place == null) {
            JSCompletionPlaceFilter.$$$reportNull$$$0(6);
        }
        if (place.getParent() instanceof JSTypeDeclaration) {
            return ContextKind.TypeDeclaration;
        }
        PsiElement prevSibling = place.getPrevSibling();
        if (prevSibling != null && prevSibling.getNode().getElementType() == JSTokenTypes.LT) {
            return ContextKind.TypeDeclarationOrExpression;
        }
        return ContextKind.Expression;
    }

    @Nullable
    private static JSVariable getOwnLetOrConstVariableDeclaration(@NotNull PsiElement place) {
        PsiElement parent;
        if (place == null) {
            JSCompletionPlaceFilter.$$$reportNull$$$0(7);
        }
        PsiElement psiElement = parent = place instanceof JSVariable ? place : PsiTreeUtil.getParentOfType((PsiElement)place, JSVariable.class);
        if (parent == null) {
            return null;
        }
        JSVarStatement varStatement = ((JSVariable)parent).getStatement();
        if (varStatement == null) {
            return null;
        }
        JSVarStatement.VarKeyword varKeyword = varStatement.getVarKeyword();
        return varKeyword == JSVarStatement.VarKeyword.LET || varKeyword == JSVarStatement.VarKeyword.CONST ? (JSVariable)parent : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSCompletionPlaceFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAcceptable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isPartialResult";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isLoweredPriority";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isTypeOnlyUsage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isStrictlyNonTypeUsage";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "forPlace";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getContextKind";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getOwnLetOrConstVariableDeclaration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum ContextKind {
        TypeDeclaration,
        Expression,
        TypeDeclarationOrExpression;

    }
}

