/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.LanguageExtension;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveScopeProvider;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public abstract class JSElementResolveScopeProvider
extends ResolveScopeProvider {
    public static final LanguageExtension<JSElementResolveScopeProvider> EP_NAME = new LanguageExtension("JavaScript.elementScopeProvider");
    private static final Key<Map<Class, GlobalSearchScope>> PROJECT_SCOPE_WITH_LANGUAGE_SPECIFIC_PREDEFINED_KEY = Key.create((String)"js.project.scope.with.predefined.language.specific");

    @NotNull
    public GlobalSearchScope getElementResolveScope(@NotNull PsiElement element) {
        VirtualFile virtualFile;
        if (element == null) {
            JSElementResolveScopeProvider.$$$reportNull$$$0(0);
        }
        Project project = element.getProject();
        PsiFile psiFile = element.getContainingFile();
        if (psiFile != null && (virtualFile = psiFile.getOriginalFile().getVirtualFile()) != null) {
            GlobalSearchScope globalSearchScope = ResolveScopeManager.getInstance((Project)project).getDefaultResolveScope(virtualFile);
            if (globalSearchScope == null) {
                JSElementResolveScopeProvider.$$$reportNull$$$0(1);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = this.getProjectScopeIncludingPredefines(project);
        if (globalSearchScope == null) {
            JSElementResolveScopeProvider.$$$reportNull$$$0(2);
        }
        return globalSearchScope;
    }

    protected final GlobalSearchScope getProjectScopeIncludingPredefines(@NotNull Project project) {
        Class<?> aClass;
        GlobalSearchScope scope;
        HashMap scopes;
        if (project == null) {
            JSElementResolveScopeProvider.$$$reportNull$$$0(3);
        }
        if ((scopes = (HashMap)project.getUserData(PROJECT_SCOPE_WITH_LANGUAGE_SPECIFIC_PREDEFINED_KEY)) == null) {
            scopes = new HashMap();
            project.putUserData(PROJECT_SCOPE_WITH_LANGUAGE_SPECIFIC_PREDEFINED_KEY, scopes);
        }
        if ((scope = (GlobalSearchScope)scopes.get(aClass = ((Object)((Object)this)).getClass())) == null) {
            List predefinedFiles = JSResolveUtil.JS_INDEXED_ROOT_PROVIDER.getLibraryFiles(project).stream().filter(this::isApplicable).collect(Collectors.toList());
            scope = GlobalSearchScope.filesScope((Project)project, predefinedFiles).uniteWith(GlobalSearchScope.allScope((Project)project));
            scopes.put(aClass, scope);
        }
        return scope;
    }

    protected abstract boolean isApplicable(@NotNull VirtualFile var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSElementResolveScopeProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSElementResolveScopeProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementResolveScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getElementResolveScope";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getProjectScopeIncludingPredefines";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

