/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve.accessibility;

import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.resolve.AccessibilityProcessingHandler;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.accessibility.JSAccessibilityChecker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ImportAccessibilityChecker
extends JSAccessibilityChecker {
    public static final ES6ImportAccessibilityChecker INSTANCE = new ES6ImportAccessibilityChecker();
    private static final Collection<Class<? extends JSElement>> myClasses = ContainerUtil.newArrayList((Object[])new Class[]{JSVariable.class, JSFunction.class, ES6ImportSpecifier.class, ES6ImportSpecifierAlias.class, ES6Class.class, TypeScriptClass.class, TypeScriptModule.class, TypeScriptImportStatement.class, TypeScriptInterface.class, TypeScriptEnum.class, TypeScriptTypeAlias.class});

    @Override
    @NotNull
    protected Collection<Class<? extends JSElement>> getSuitableClasses() {
        Collection<Class<? extends JSElement>> collection = myClasses;
        if (collection == null) {
            ES6ImportAccessibilityChecker.$$$reportNull$$$0(0);
        }
        return collection;
    }

    @Override
    @Nullable
    protected String checkImpl(@Nullable PsiElement place, @NotNull PsiElement element) {
        if (element == null) {
            ES6ImportAccessibilityChecker.$$$reportNull$$$0(1);
        }
        if (place != null) {
            if (!ES6PsiUtil.isElementCanBeExported(element)) {
                return null;
            }
            PsiFile elementFile = element.getContainingFile();
            if (!elementFile.isEquivalentTo((PsiElement)place.getContainingFile()) && element instanceof JSElement && !ES6ImportHandler.isExported(element)) {
                return "javascript.element.need.to.be.exported";
            }
        }
        return null;
    }

    @Override
    public boolean isAvailable(AccessibilityProcessingHandler handler, SinkResolveProcessor resolveProcessor) {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/accessibility/ES6ImportAccessibilityChecker";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuitableClasses";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/accessibility/ES6ImportAccessibilityChecker";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

