/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.EnumConstantValue;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSCompositeTypeImpl
extends JSCompositeTypeBaseImpl
implements JSUnionOrIntersectionType {
    private boolean myIsOptimized;
    public static final int TYPES_NUMBER_LIMIT = 5;
    public static final Comparator<JSType> GENERIC_PARAMETER_LAST = (o1, o2) -> {
        if (o1 instanceof JSGenericParameterImpl) {
            return 1;
        }
        if (o2 instanceof JSGenericParameterImpl) {
            return -1;
        }
        return 0;
    };

    @Contract(value="!null -> !null")
    public static JSType optimizeTypeIfComposite(@Nullable JSType currentType) {
        return JSCompositeTypeImpl.optimizeTypeIfComposite(currentType, true);
    }

    @Contract(value="!null,_ -> !null")
    public static JSType optimizeTypeIfComposite(@Nullable JSType currentType, boolean allowResolve) {
        if (!(currentType instanceof JSCompositeTypeImpl)) {
            return currentType;
        }
        JSCompositeTypeImpl compositeType = (JSCompositeTypeImpl)currentType;
        if (compositeType.isOptimized()) {
            return compositeType;
        }
        List<JSType> originalNestedTypes = compositeType.getTypes();
        if (originalNestedTypes.isEmpty()) {
            return compositeType;
        }
        List preFilteredTypes = originalNestedTypes.stream().filter(el -> !JSCompositeTypeImpl.isEmptyType(el)).collect(Collectors.toList());
        if (preFilteredTypes.size() == 0) {
            return (JSType)ContainerUtil.getFirstItem(originalNestedTypes);
        }
        if (preFilteredTypes.size() == 1) {
            return (JSType)ContainerUtil.getFirstItem(preFilteredTypes);
        }
        List<JSType> types = JSCompositeTypeImpl.flattenTypes(preFilteredTypes.stream().map(el -> JSCompositeTypeImpl.getTypeOfType(el, allowResolve)).filter(el -> !JSCompositeTypeImpl.isEmptyType(el)), JSCompositeTypeImpl.class);
        if (types.size() == 1) {
            return (JSType)ContainerUtil.getFirstItem(types);
        }
        ArrayList filteredEqualsTypes = ContainerUtil.newArrayList(types);
        HashSet removedTypes = ContainerUtil.newHashSet();
        ProcessingContext context = new ProcessingContext();
        for (JSType fromCompare : types) {
            if (removedTypes.contains(fromCompare)) continue;
            Iterator iterator = filteredEqualsTypes.iterator();
            while (iterator.hasNext()) {
                JSType toCompare = (JSType)iterator.next();
                if (fromCompare == toCompare || !fromCompare.isEquivalentTo(toCompare, context, allowResolve)) continue;
                iterator.remove();
                removedTypes.add(toCompare);
            }
        }
        int filteredSize = filteredEqualsTypes.size();
        if (filteredSize == 1) {
            return (JSType)filteredEqualsTypes.get(0);
        }
        if (filteredSize == originalNestedTypes.size() && !allowResolve) {
            return currentType;
        }
        return new JSCompositeTypeImpl(compositeType.getSource(), allowResolve, filteredEqualsTypes);
    }

    @NotNull
    public static JSType getCommonType(@NotNull JSType type1, @NotNull JSType type2, @Nullable JSTypeSource source, boolean allowResolve) {
        if (type1 == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(0);
        }
        if (type2 == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(1);
        }
        if (type1 == type2) {
            JSType jSType = type1;
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(2);
            }
            return jSType;
        }
        if (type1 instanceof JSAnyType) {
            JSType jSType = type1;
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(3);
            }
            return jSType;
        }
        if (type2 instanceof JSAnyType) {
            JSType jSType = type2;
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(4);
            }
            return jSType;
        }
        if (JSCompositeTypeImpl.isEmptyType(type1)) {
            JSType jSType = type2;
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(5);
            }
            return jSType;
        }
        if (JSCompositeTypeImpl.isEmptyType(type2)) {
            JSType jSType = type1;
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(6);
            }
            return jSType;
        }
        if (!allowResolve && type1 instanceof JSNamedType && type2 instanceof JSNamedType && type1.getTypeText().equals(type2.getTypeText())) {
            JSType jSType = type1;
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(7);
            }
            return jSType;
        }
        List<JSType> allCommonTypes = JSCompositeTypeImpl.flattenTypes(Stream.of(type1, type2), JSCompositeTypeImpl.class);
        if (source == null) {
            source = type1 instanceof JSCompositeTypeImpl || !(type2 instanceof JSCompositeTypeImpl) ? type1.getSource() : type2.getSource();
        }
        JSType jSType = JSCompositeTypeImpl.getCommonType(allCommonTypes, source, allowResolve);
        if (jSType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(8);
        }
        return jSType;
    }

    public static JSType getCommonType(@NotNull List<JSType> allCommonTypes, @NotNull JSTypeSource source, boolean allowResolve) {
        if (allCommonTypes == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(9);
        }
        if (source == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(10);
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (JSType currentType : allCommonTypes) {
            if (currentType instanceof JSAnyType) {
                return currentType;
            }
            if (JSCompositeTypeImpl.isEmptyType(currentType)) continue;
            boolean add = true;
            for (JSType resultedType : result) {
                if (!currentType.isEquivalentTo(resultedType, null, allowResolve)) continue;
                add = false;
                break;
            }
            if (!add) continue;
            result.add(currentType);
        }
        if (result.size() == 1) {
            return (JSType)ContainerUtil.getFirstItem((Collection)result, null);
        }
        return new JSCompositeTypeImpl(source, result);
    }

    @NotNull
    private static JSType getTypeOfType(JSType type, boolean allowResolve) {
        if (!allowResolve) {
            JSType jSType = type;
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(11);
            }
            return jSType;
        }
        JSType jSType = type instanceof JSEvaluableType ? type.substitute() : type;
        if (jSType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(12);
        }
        return jSType;
    }

    private JSCompositeTypeImpl(JSTypeSource source, boolean isOptimized, List<JSType> _types) {
        super(source, _types);
        this.myIsOptimized = false;
        this.myIsOptimized = isOptimized;
    }

    public JSCompositeTypeImpl(JSTypeSource source, JSType ... _types) {
        super(source, _types);
        this.myIsOptimized = false;
    }

    public JSCompositeTypeImpl(@NotNull JSTypeSource source, List<JSType> _types) {
        if (source == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(13);
        }
        super(source, _types);
        this.myIsOptimized = false;
    }

    @Override
    @NotNull
    protected String getTypeSeparator() {
        if ("|" == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(14);
        }
        return "|";
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(15);
        }
        if (this.isEquivalentTo(elementType, processingContext)) {
            return true;
        }
        if (elementType instanceof JSCompositeTypeImpl && this.isTypeScript()) {
            return JSTypeCastUtil.checkAssignableComposite(this, (JSCompositeTypeImpl)elementType, processingContext, true);
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    @NotNull
    protected JSTypeCastUtil.AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        JSTypeCastUtil.AssignableResult common;
        if (elementType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(16);
        }
        if ((common = super.isDirectlyAssignableTypeCommon(elementType, processingContext)).isStrict()) {
            JSTypeCastUtil.AssignableResult assignableResult = common;
            if (assignableResult == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(17);
            }
            return assignableResult;
        }
        JSTypeCastUtil.AssignableResult result = this.checkEnumWithLiteralMembers(elementType);
        if (result.isStrict()) {
            JSTypeCastUtil.AssignableResult assignableResult = result;
            if (assignableResult == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(18);
            }
            return assignableResult;
        }
        for (JSType t : this.getTypes()) {
            if (!t.isDirectlyAssignableType(elementType, processingContext)) continue;
            JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(true);
            if (assignableResult == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(19);
            }
            return assignableResult;
        }
        JSTypeCastUtil.AssignableResult assignableResult = common;
        if (assignableResult == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(20);
        }
        return assignableResult;
    }

    @NotNull
    private JSTypeCastUtil.AssignableResult checkEnumWithLiteralMembers(@NotNull JSType elementType) {
        if (elementType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(21);
        }
        if (elementType instanceof JSTypeImpl && ((JSTypeImpl)elementType).isEnum()) {
            HashSet stringKeys = ContainerUtil.newHashSet();
            HashSet numberKeys = ContainerUtil.newHashSet();
            Ref allLiterals = new Ref();
            Ref hasIncompatibleEnumMembers = new Ref();
            allLiterals.set((Object)true);
            hasIncompatibleEnumMembers.set((Object)false);
            JSTypeUtils.processExpandedType((Processor<JSType>)((Processor)t -> {
                if (elementType == null) {
                    JSCompositeTypeImpl.$$$reportNull$$$0(32);
                }
                boolean isEnumLiteral = TypeScriptUtil.isEnumLiteralType(t);
                if (!(t instanceof JSLiteralType) && !isEnumLiteral) {
                    allLiterals.set((Object)false);
                    return false;
                }
                if (t instanceof JSStringLiteralTypeImpl) {
                    stringKeys.add(((JSStringLiteralTypeImpl)t).getLiteral());
                }
                if (t instanceof JSNumberLiteralTypeImpl) {
                    numberKeys.add(((JSNumberLiteralTypeImpl)t).getLiteral());
                }
                if (isEnumLiteral) {
                    Double doubleValue;
                    Pair<TypeScriptEnum, TypeScriptEnumField> parentAndField = TypeScriptUtil.getEnumLiteralParentAndField((JSTypeImpl)((Object)t));
                    if (parentAndField == null || !Objects.equals(parentAndField.first, TypeScriptUtil.getEnumDeclaration((JSTypeImpl)elementType))) {
                        hasIncompatibleEnumMembers.set((Object)true);
                        return true;
                    }
                    EnumConstantValue constantValue = ((TypeScriptEnumField)parentAndField.second).getConstantValue();
                    String stringValue = constantValue.getStringValue();
                    if (stringValue != null) {
                        stringKeys.add(stringValue);
                    }
                    if ((doubleValue = constantValue.getNumericValue()) != null) {
                        numberKeys.add(doubleValue);
                    }
                }
                return true;
            }), this);
            if (((Boolean)allLiterals.get()).booleanValue()) {
                TypeScriptEnum enumElement = TypeScriptUtil.getEnumDeclaration((JSTypeImpl)elementType);
                boolean allAssignable = true;
                if (enumElement != null) {
                    for (JSField field : enumElement.getFields()) {
                        TypeScriptEnumField tsField = (TypeScriptEnumField)field;
                        EnumConstantValue constantValue = tsField.getConstantValue();
                        String stringValue = constantValue.getStringValue();
                        if (stringValue != null && !stringKeys.contains(stringValue)) {
                            allAssignable = false;
                            break;
                        }
                        Double doubleValue = constantValue.getNumericValue();
                        if (doubleValue == null || numberKeys.contains(doubleValue)) continue;
                        allAssignable = false;
                        break;
                    }
                }
                if (allAssignable) {
                    JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.AssignableResult.ASSIGNABLE;
                    if (assignableResult == null) {
                        JSCompositeTypeImpl.$$$reportNull$$$0(22);
                    }
                    return assignableResult;
                }
                if (((Boolean)hasIncompatibleEnumMembers.get()).booleanValue()) {
                    JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.AssignableResult.NOT_ASSIGNABLE;
                    if (assignableResult == null) {
                        JSCompositeTypeImpl.$$$reportNull$$$0(23);
                    }
                    return assignableResult;
                }
            }
        }
        JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.AssignableResult.NOT_SURE;
        if (assignableResult == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(24);
        }
        return assignableResult;
    }

    private boolean isOptimized() {
        return this.myIsOptimized;
    }

    @Override
    @NotNull
    protected JSCompositeTypeImpl createType(@NotNull List<JSType> transformedTypes, @NotNull JSTypeSource newSource) {
        if (transformedTypes == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(25);
        }
        if (newSource == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(26);
        }
        JSCompositeTypeImpl jSCompositeTypeImpl = new JSCompositeTypeImpl(newSource, transformedTypes);
        if (jSCompositeTypeImpl == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(27);
        }
        return jSCompositeTypeImpl;
    }

    @Override
    @NotNull
    public JSType substitute() {
        JSType result = this.getSimpleCompositeTypeResult();
        if (result != null) {
            JSType jSType = result;
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(28);
            }
            return jSType;
        }
        JSType rawTypeToProcess = JSCompositeTypeImpl.optimizeTypeIfComposite(this);
        if (!(rawTypeToProcess instanceof JSCompositeTypeImpl)) {
            JSType jSType = rawTypeToProcess;
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(29);
            }
            return jSType;
        }
        JSCompositeTypeImpl typeToProcess = (JSCompositeTypeImpl)rawTypeToProcess;
        Collection<JSRecordType> resolvedTypes = typeToProcess.getNestedTypesAsRecordType();
        if (resolvedTypes.isEmpty()) {
            JSAnyType jSAnyType = JSAnyType.get(this.getSource().getSourceElement(), this.isExplicitlyDeclared());
            if (jSAnyType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(30);
            }
            return jSAnyType;
        }
        JSRecordType item = (JSRecordType)ContainerUtil.getFirstItem(resolvedTypes);
        resolvedTypes.remove(item);
        assert (item != null);
        PsiElement sourceElement = this.getSource().getSourceElement();
        ArrayList resultMembers = ContainerUtil.newArrayList();
        block0: for (JSRecordType.TypeMember member : item.getTypeMembers()) {
            JSType commonType = null;
            JSRecordType.PropertySignature memberProperty = null;
            for (JSRecordType resolvedType : resolvedTypes) {
                boolean hasCurrent = false;
                for (JSRecordType.TypeMember typeMember : resolvedType.getTypeMembers()) {
                    if (member.isEquivalentTo(typeMember, true)) {
                        hasCurrent = true;
                        continue;
                    }
                    if (!(member instanceof JSRecordType.PropertySignature) || !(typeMember instanceof JSRecordType.PropertySignature)) continue;
                    memberProperty = (JSRecordType.PropertySignature)member;
                    JSRecordType.PropertySignature typeMemberProperty = (JSRecordType.PropertySignature)typeMember;
                    if (sourceElement == null || !StringUtil.equals((CharSequence)memberProperty.getMemberName(), (CharSequence)typeMemberProperty.getMemberName())) continue;
                    JSType type1 = memberProperty.getType();
                    JSType type2 = typeMemberProperty.getType();
                    if (type1 == null || type2 == null) continue;
                    commonType = JSTypeUtils.getCommonType(commonType == null ? type1 : commonType, type2, DialectDetector.dialectOfElement(sourceElement), true);
                    hasCurrent = true;
                }
                if (hasCurrent) continue;
                continue block0;
            }
            if (commonType != null) {
                resultMembers.add(new JSRecordTypeImpl.PropertySignatureImpl(memberProperty.getMemberName(), commonType, memberProperty.isOptional()));
                continue;
            }
            resultMembers.add(member);
        }
        JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(this.getSource(), resultMembers);
        if (jSRecordTypeImpl == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(31);
        }
        return jSRecordTypeImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type1";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type2";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allCommonTypes";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 15: 
            case 16: 
            case 21: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformedTypes";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeOfType";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSeparator";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "checkEnumWithLiteralMembers";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createType";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "substitute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCommonType";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "checkEnumWithLiteralMembers";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkEnumWithLiteralMembers$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

