/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSDecoratedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIterableComponentTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRequireCallExpressionType;
import com.intellij.lang.javascript.psi.types.JSSimpleTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptIndexedAccessJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptMappedJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeOperatorJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.TypeScriptTypePredicateTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverType;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ProcessingContext;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeCastUtil {
    private static final Key<Map<Object, Set<Object>>> OUR_ALREADY_COMPARED_TYPES_KEY = Key.create((String)"already.compared.types");

    public static boolean startRecursiveTypesComparison(@NotNull JSType type1, @NotNull JSType type2, @NotNull ProcessingContext processingContext) {
        if (type1 == null) {
            JSTypeCastUtil.$$$reportNull$$$0(0);
        }
        if (type2 == null) {
            JSTypeCastUtil.$$$reportNull$$$0(1);
        }
        if (processingContext == null) {
            JSTypeCastUtil.$$$reportNull$$$0(2);
        }
        String lId = JSTypeCastUtil.getTypeIdForComparison(type1);
        String rId = JSTypeCastUtil.getTypeIdForComparison(type2);
        return JSTypeCastUtil.startRecursiveTypesComparison(lId, rId, processingContext);
    }

    @NotNull
    public static String getTypeIdForComparison(@NotNull JSType type) {
        if (type == null) {
            JSTypeCastUtil.$$$reportNull$$$0(3);
        }
        if (type instanceof JSNamedType) {
            String string = JSTypeCastUtil.getTypeStringForComparison((JSNamedType)type);
            if (string == null) {
                JSTypeCastUtil.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (type instanceof JSRecordType) {
            String string = "#record#" + type.hashCode();
            if (string == null) {
                JSTypeCastUtil.$$$reportNull$$$0(5);
            }
            return string;
        }
        if (type instanceof JSCompositeTypeImpl) {
            List<JSType> types = ((JSCompositeTypeImpl)type).getTypes();
            String separator = ((JSCompositeTypeImpl)type).getTypeSeparator();
            String string = "#composite#" + StringUtil.join(types, el -> JSTypeCastUtil.getTypeIdForComparison(el), (String)separator);
            if (string == null) {
                JSTypeCastUtil.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = "#type#" + type.getClass() + "#" + type.hashCode();
        if (string == null) {
            JSTypeCastUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    public static void endRecursiveTypesComparison(@NotNull JSType type1, @NotNull JSType type2, @NotNull ProcessingContext processingContext) {
        if (type1 == null) {
            JSTypeCastUtil.$$$reportNull$$$0(8);
        }
        if (type2 == null) {
            JSTypeCastUtil.$$$reportNull$$$0(9);
        }
        if (processingContext == null) {
            JSTypeCastUtil.$$$reportNull$$$0(10);
        }
        String type1Id = JSTypeCastUtil.getTypeIdForComparison(type1);
        String type2Id = JSTypeCastUtil.getTypeIdForComparison(type2);
        JSTypeCastUtil.endRecursiveTypesComparison(type1Id, type2Id, processingContext);
    }

    @NotNull
    private static String getTypeStringForComparison(JSNamedType type1) {
        String string = (JSTypeContext.STATIC == type1.getTypeContext() ? "static#" : "") + type1.getResolvedTypeText();
        if (string == null) {
            JSTypeCastUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    public static boolean startRecursiveTypesComparison(@Nullable Object thisTypeId, @Nullable Object elementTypeId, @NotNull ProcessingContext processingContext) {
        Set typesComparedToThis;
        if (processingContext == null) {
            JSTypeCastUtil.$$$reportNull$$$0(12);
        }
        ProgressIndicatorProvider.checkCanceled();
        Map alreadyComparedTypes = (Map)processingContext.get(OUR_ALREADY_COMPARED_TYPES_KEY);
        if (alreadyComparedTypes == null) {
            alreadyComparedTypes = new THashMap();
            processingContext.put(OUR_ALREADY_COMPARED_TYPES_KEY, (Object)alreadyComparedTypes);
        }
        if ((typesComparedToThis = (Set)alreadyComparedTypes.get(thisTypeId)) == null) {
            THashSet set = new THashSet();
            set.add(elementTypeId);
            alreadyComparedTypes.put(thisTypeId, set);
            return true;
        }
        return typesComparedToThis.add(elementTypeId);
    }

    public static void endRecursiveTypesComparison(Object thisTypeId, Object elementTypeId, @NotNull ProcessingContext processingContext) {
        Set elementQNames;
        Map alreadyComparedTypes;
        if (processingContext == null) {
            JSTypeCastUtil.$$$reportNull$$$0(13);
        }
        if ((alreadyComparedTypes = (Map)processingContext.get(OUR_ALREADY_COMPARED_TYPES_KEY)) != null && (elementQNames = (Set)alreadyComparedTypes.get(thisTypeId)) != null) {
            elementQNames.remove(elementTypeId);
            if (elementQNames.isEmpty()) {
                alreadyComparedTypes.remove(thisTypeId);
            }
        }
    }

    @NotNull
    public static AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType thisOperand, @NotNull JSType rOperand, @Nullable ProcessingContext processingContext) {
        JSType substitutedType;
        JSType type;
        if (thisOperand == null) {
            JSTypeCastUtil.$$$reportNull$$$0(14);
        }
        if (rOperand == null) {
            JSTypeCastUtil.$$$reportNull$$$0(15);
        }
        if (rOperand instanceof JSUndefinedType) {
            AssignableResult assignableResult = AssignableResult.ASSIGNABLE;
            if (assignableResult == null) {
                JSTypeCastUtil.$$$reportNull$$$0(16);
            }
            return assignableResult;
        }
        if (rOperand instanceof JSGenericParameterImpl) {
            JSType type2 = ((JSGenericParameterImpl)rOperand).getConstraintType();
            if (type2 != null) {
                AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand.isDirectlyAssignableType(type2, processingContext));
                if (assignableResult == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(17);
                }
                return assignableResult;
            }
            AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(rOperand.isDirectlyAssignableType(thisOperand, processingContext));
            if (assignableResult == null) {
                JSTypeCastUtil.$$$reportNull$$$0(18);
            }
            return assignableResult;
        }
        if (rOperand instanceof JSDecoratedTypeImpl && !((JSDecoratedTypeImpl)rOperand).getDecorations().isEmpty()) {
            AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand.isDirectlyAssignableType(((JSDecoratedTypeImpl)rOperand).getType(), processingContext));
            if (assignableResult == null) {
                JSTypeCastUtil.$$$reportNull$$$0(19);
            }
            return assignableResult;
        }
        if (rOperand instanceof JSUnionOrIntersectionType) {
            JSUnionOrIntersectionType compositeType = (JSUnionOrIntersectionType)rOperand;
            boolean isIntersection = compositeType instanceof JSIntersectionTypeImpl;
            boolean isStrictContext = JSTypeCastUtil.isStrictTypeScriptType(compositeType);
            boolean result = JSTypeCastUtil.checkAssignableComposite(thisOperand, compositeType, processingContext, !isIntersection && isStrictContext);
            if (result || !isStrictContext) {
                AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(result);
                if (assignableResult == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(20);
                }
                return assignableResult;
            }
        } else if (rOperand instanceof JSTypeImpl) {
            JSType typedefValue;
            JSTypeImpl jsType = (JSTypeImpl)rOperand;
            if (processingContext == null) {
                processingContext = new ProcessingContext();
            }
            if ((typedefValue = jsType.getTypedef(null, processingContext)) != null) {
                if (!JSTypeCastUtil.startRecursiveTypesComparison(thisOperand, jsType, processingContext)) {
                    AssignableResult assignableResult = AssignableResult.ASSIGNABLE;
                    if (assignableResult == null) {
                        JSTypeCastUtil.$$$reportNull$$$0(21);
                    }
                    return assignableResult;
                }
                AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand.isDirectlyAssignableType(typedefValue, processingContext));
                if (assignableResult == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(22);
                }
                return assignableResult;
            }
        } else if (rOperand instanceof JSGenericTypeImpl && (type = ((JSGenericTypeImpl)rOperand).getType()) instanceof JSTypeImpl && ((JSTypeImpl)type).getTypedef(null, processingContext) != null && (substitutedType = rOperand.substitute()) != rOperand) {
            AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand.isDirectlyAssignableType(substitutedType, processingContext));
            if (assignableResult == null) {
                JSTypeCastUtil.$$$reportNull$$$0(23);
            }
            return assignableResult;
        }
        if ((rOperand instanceof JSIterableComponentTypeImpl || rOperand instanceof TypeScriptGenericThisTypeImpl || rOperand instanceof TypeScriptTypePredicateTypeImpl || rOperand instanceof JSEvaluableType || rOperand instanceof TypeScriptTypeOperatorJSTypeImpl || rOperand instanceof TypeScriptIndexedAccessJSTypeImpl || rOperand instanceof TypeScriptMappedJSTypeImpl || rOperand instanceof JSCompositeTypeBaseImpl) && (type = rOperand.substitute()) != rOperand) {
            if (processingContext == null) {
                processingContext = new ProcessingContext();
            }
            if (!JSTypeCastUtil.startRecursiveTypesComparison(thisOperand, rOperand, processingContext)) {
                AssignableResult assignableResult = AssignableResult.ASSIGNABLE;
                if (assignableResult == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(24);
                }
                return assignableResult;
            }
            AssignableResult result = JSTypeCastUtil.toStrictAssignable(thisOperand.isDirectlyAssignableType(type, processingContext));
            JSTypeCastUtil.endRecursiveTypesComparison(thisOperand, rOperand, processingContext);
            AssignableResult assignableResult = result;
            if (assignableResult == null) {
                JSTypeCastUtil.$$$reportNull$$$0(25);
            }
            return assignableResult;
        }
        AssignableResult assignableResult = thisOperand.isEquivalentTo(rOperand, processingContext) ? AssignableResult.ASSIGNABLE : AssignableResult.NOT_SURE;
        if (assignableResult == null) {
            JSTypeCastUtil.$$$reportNull$$$0(26);
        }
        return assignableResult;
    }

    public static boolean isAlwaysAssignableType(@NotNull JSType type) {
        if (type == null) {
            JSTypeCastUtil.$$$reportNull$$$0(27);
        }
        if (type instanceof JSAnyType || type instanceof TypeScriptNeverType || type instanceof JSRequireCallExpressionType) {
            return true;
        }
        return (type instanceof JSNullType || type instanceof JSUndefinedType) && !((JSSimpleTypeBaseImpl)type).isJavaScript();
    }

    public static boolean isStrictTypeScriptType(@NotNull JSUnionOrIntersectionType rOperand) {
        if (rOperand == null) {
            JSTypeCastUtil.$$$reportNull$$$0(28);
        }
        assert (rOperand instanceof JSTypeBaseImpl);
        JSTypeBaseImpl baseType = (JSTypeBaseImpl)((Object)rOperand);
        return baseType.isTypeScript() && baseType.isExplicitlyDeclared();
    }

    public static AssignableResult toStrictAssignable(boolean value) {
        return value ? AssignableResult.ASSIGNABLE : AssignableResult.NOT_ASSIGNABLE;
    }

    @Nullable
    public static JSRecordType buildWithAppliedGenericArguments(@NotNull JSClass jsClass, @NotNull JSGenericTypeImpl type) {
        TypeScriptTypeParameterListOwner owner;
        if (jsClass == null) {
            JSTypeCastUtil.$$$reportNull$$$0(29);
        }
        if (type == null) {
            JSTypeCastUtil.$$$reportNull$$$0(30);
        }
        if (jsClass instanceof TypeScriptTypeParameterListOwner && ((owner = (TypeScriptTypeParameterListOwner)jsClass).getTypeParameterList() != null || type.getOuterArguments() != null)) {
            JSTypeSubstitutor genericArgumentsMap = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(owner, type);
            JSType baseType = type.getType();
            boolean isStatic = baseType instanceof JSNamedType && ((JSNamedType)baseType).isStaticOrInstance() == JSContext.STATIC;
            JSRecordType recordType = TypeScriptTypeParser.buildTypeFromClass(jsClass, isStatic);
            return (JSRecordType)JSTypeUtils.applyGenericArguments((JSType)recordType, (Map<String, JSType>)genericArgumentsMap);
        }
        return null;
    }

    public static boolean checkAssignableComposite(@NotNull JSType thisOperand, @NotNull JSUnionOrIntersectionType rOperand, @Nullable ProcessingContext processingContext, boolean needCheckAllTypes) {
        if (thisOperand == null) {
            JSTypeCastUtil.$$$reportNull$$$0(31);
        }
        if (rOperand == null) {
            JSTypeCastUtil.$$$reportNull$$$0(32);
        }
        for (JSType jsType : rOperand.getTypes()) {
            boolean result = thisOperand.isDirectlyAssignableType(jsType, processingContext);
            if (needCheckAllTypes) {
                if (result) continue;
                return false;
            }
            if (!result) continue;
            return true;
        }
        return needCheckAllTypes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type1";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type2";
                break;
            }
            case 2: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 3: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeCastUtil";
                break;
            }
            case 14: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisOperand";
                break;
            }
            case 15: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rOperand";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeCastUtil";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeIdForComparison";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeStringForComparison";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "isDirectlyAssignableTypeCommon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "startRecursiveTypesComparison";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTypeIdForComparison";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "endRecursiveTypesComparison";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isAlwaysAssignableType";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isStrictTypeScriptType";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "buildWithAppliedGenericArguments";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "checkAssignableComposite";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum AssignableResult {
        ASSIGNABLE(true, true),
        NOT_ASSIGNABLE(true, false),
        NOT_SURE(false, false),
        NO_CACHE(false, false);

        private final boolean myStrict;
        private final boolean myAssignable;

        private AssignableResult(boolean strict, boolean assignable) {
            this.myStrict = strict;
            this.myAssignable = assignable;
        }

        public boolean isAssignable() {
            return this.myAssignable;
        }

        public boolean isStrict() {
            return this.myStrict;
        }
    }
}

