/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.JSNumberParser;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSApplyCallType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSDecoratedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSDestructuringTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIterableComponentTypeImpl;
import com.intellij.lang.javascript.psi.types.JSMixinTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRequireCallExpressionType;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTupleTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.JSUnknownType;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptIndexedAccessJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptMappedJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeOfJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeOperatorJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypePredicateTypeImpl;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeParser {
    public static final char GENERIC_PARAMETER_DELIMITER = '%';
    public static final String TYPEOF_IDENTIFIER = "#typeof";
    public static final String TS_TYPEOF_IDENTIFIER = "#tstypeof";
    public static final String DESTRUCTURING_IDENTIFIER = "#destr";
    public static final String THIS_TYPE_IDENTIFIER = "#this";
    public static final String COMPONENT_OF_ITERABLE_IDENTIFIER = "#compof";
    public static final String APPLY_CALL_PREFIX = "#call(";
    public static final String REQUIRE_CALL_EXPRESSION_PREFIX = "#req";
    public static final String TYPE_PREDICATE_PREFIX = "#guard";
    public static final String TYPE_KEY_OF_PREFIX = "#keyof";
    public static final String TYPE_MAPPED_PREFIX = "#mapped";
    public static final String TYPE_INDEXED_PREFIX = "#indt";
    public static final String INDEX_SIGNATURE_PREFIX = "#idx(";
    public static final char SINGLE_TYPE_SPECIAL_CHAR = '^';
    public static final String SOME_INVALID_TYPE_PART = "^^";
    public static final String MIXIN_DELIMITER = "+";
    public static final String MODULE_PREFIX = "module:";
    public static final String EVENT_PREFIX = "event:";
    public static final String TUPLE_PREFIX = "#tuple";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    @NotNull
    private final String myTypeString;
    private final JSTypeVisitor myVisitor;
    private final boolean myIsFromJSDoc;
    private int myCurrentOffset;
    @NotNull
    private final JSTypeSource mySource;
    private boolean myParsingFunction;

    public JSTypeParser(@NotNull String typeString, @NotNull JSTypeSource source) {
        if (typeString == null) {
            JSTypeParser.$$$reportNull$$$0(0);
        }
        if (source == null) {
            JSTypeParser.$$$reportNull$$$0(1);
        }
        this(typeString, source, false);
    }

    public JSTypeParser(@NotNull String typeString, @NotNull JSTypeSource source, boolean isFromJSDoc) {
        if (typeString == null) {
            JSTypeParser.$$$reportNull$$$0(2);
        }
        if (source == null) {
            JSTypeParser.$$$reportNull$$$0(3);
        }
        this(typeString, source, null, isFromJSDoc);
    }

    public JSTypeParser(@NotNull String typeString, JSTypeVisitor visitor) {
        if (typeString == null) {
            JSTypeParser.$$$reportNull$$$0(4);
        }
        this(typeString, JSTypeSource.EMPTY, visitor, false);
    }

    private JSTypeParser(@NotNull String typeString, @NotNull JSTypeSource typeSource, @Nullable JSTypeVisitor visitor, boolean isFromJSDoc) {
        if (typeString == null) {
            JSTypeParser.$$$reportNull$$$0(5);
        }
        if (typeSource == null) {
            JSTypeParser.$$$reportNull$$$0(6);
        }
        this.myTypeString = typeString;
        this.myIsFromJSDoc = isFromJSDoc;
        this.mySource = typeSource;
        this.myVisitor = visitor;
        this.myCurrentOffset = 0;
    }

    @Nullable
    public JSType parse() {
        return this.parse(false);
    }

    @Nullable
    public JSType parse(boolean allowCommentAfterType) {
        return this.handleParseResult(this.parseComposite(true), allowCommentAfterType);
    }

    @Nullable
    public JSParameterTypeDecorator parseParameterType() {
        return this.parseParameterType(false);
    }

    @Nullable
    public JSParameterTypeDecorator parseParameterType(boolean allowCommentAfterType) {
        return this.handleParseResult(this.parseInnerParameterType(true), allowCommentAfterType);
    }

    @Nullable
    public JSType parseNamepath() {
        return this.handleParseResult(this.parseSingleType(true), false);
    }

    private <T> T handleParseResult(T result, boolean allowCommentAfterType) {
        if (!allowCommentAfterType && this.myCurrentOffset != this.myTypeString.length()) {
            return null;
        }
        return result;
    }

    public int getTypeStringLength() {
        return this.myCurrentOffset;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private JSParameterTypeDecorator parseInnerParameterType(boolean allowComma) {
        JSType type;
        this.advanceSpaces();
        boolean rest = false;
        if (this.myTypeString.startsWith("...", this.myCurrentOffset)) {
            char afterDotsChar;
            rest = true;
            this.myCurrentOffset += 3;
            this.advanceSpaces();
            if (this.myCurrentOffset >= this.myTypeString.length() || (afterDotsChar = this.myTypeString.charAt(this.myCurrentOffset)) == ',' || afterDotsChar == ')' || afterDotsChar == '}') {
                type = JSAnyType.get((PsiElement)this.mySource.getScope(), this.mySource.isExplicitlyDeclared());
            } else {
                boolean parseBrackets;
                boolean bl = parseBrackets = this.myParsingFunction && this.myTypeString.startsWith("[", this.myCurrentOffset);
                if (parseBrackets) {
                    ++this.myCurrentOffset;
                }
                type = this.parseComposite(false);
                if (parseBrackets) {
                    if (!this.myTypeString.startsWith("]", this.myCurrentOffset)) return null;
                    ++this.myCurrentOffset;
                }
            }
        } else {
            type = this.parseComposite(allowComma);
        }
        this.advanceSpaces();
        boolean optional = false;
        if (this.myTypeString.startsWith("?", this.myCurrentOffset) || this.myTypeString.startsWith("=", this.myCurrentOffset)) {
            optional = true;
            ++this.myCurrentOffset;
            this.advanceSpaces();
            while (this.myCurrentOffset < this.myTypeString.length() && (this.myTypeString.charAt(this.myCurrentOffset) == '\"' || StringUtil.isJavaIdentifierPart((char)this.myTypeString.charAt(this.myCurrentOffset)))) {
                ++this.myCurrentOffset;
            }
        } else if (this.myTypeString.startsWith(",", this.myCurrentOffset)) {
            int beforeCommaOffset = this.myCurrentOffset++;
            this.advanceSpaces();
            if (this.myTypeString.startsWith("optional", this.myCurrentOffset)) {
                this.myCurrentOffset += 8;
                optional = true;
            } else {
                this.myCurrentOffset = beforeCommaOffset;
            }
        }
        this.advanceSpaces();
        if (type == null && !optional) {
            if (!rest) return null;
        }
        JSParameterTypeDecoratorImpl jSParameterTypeDecoratorImpl = new JSParameterTypeDecoratorImpl(type, optional, rest, this.mySource.isExplicitlyDeclared());
        return jSParameterTypeDecoratorImpl;
    }

    private JSType parseComposite(boolean allowComma) {
        return this.parseComposite(allowComma, "|/", true);
    }

    @Nullable
    private JSType parseComposite(boolean allowComma, @NotNull String delimiters, boolean isUnion) {
        if (delimiters == null) {
            JSTypeParser.$$$reportNull$$$0(7);
        }
        this.advanceSpaces();
        if (this.myCurrentOffset >= this.myTypeString.length()) {
            return null;
        }
        JSType type = this.parseTypeFromComposite(isUnion);
        this.advanceSpaces();
        ArrayList<JSType> addedUnionOptions = null;
        while (this.myCurrentOffset < this.myTypeString.length() && (delimiters.indexOf(this.myTypeString.charAt(this.myCurrentOffset)) != -1 || allowComma && ',' == this.myTypeString.charAt(this.myCurrentOffset))) {
            JSType unionOption;
            int commaOffset = ',' != this.myTypeString.charAt(this.myCurrentOffset) ? -1 : this.myCurrentOffset;
            ++this.myCurrentOffset;
            if (addedUnionOptions == null) {
                addedUnionOptions = new ArrayList<JSType>();
            }
            if ((unionOption = this.parseTypeFromComposite(isUnion)) == null) continue;
            this.advanceSpaces();
            if (commaOffset >= 0 && unionOption instanceof JSTypeImpl && "optional".equals(unionOption.getTypeText(JSType.TypeTextFormat.SIMPLE))) {
                this.myCurrentOffset = commaOffset;
                break;
            }
            addedUnionOptions.add(unionOption);
        }
        if (addedUnionOptions != null && !addedUnionOptions.isEmpty()) {
            if (type != null) {
                addedUnionOptions.add(0, type);
            }
            type = isUnion ? new JSCompositeTypeImpl(this.mySource, (List<JSType>)addedUnionOptions) : new JSIntersectionTypeImpl(this.mySource, (Collection<JSType>)addedUnionOptions);
        }
        return type;
    }

    private JSType parseTypeFromComposite(boolean isUnion) {
        if (isUnion) {
            return this.parseComposite(false, "&", false);
        }
        return this.parseType();
    }

    private boolean isBooleanLiteralAhead() {
        if (this.myTypeString.startsWith(TRUE, this.myCurrentOffset)) {
            int offset = this.myCurrentOffset + TRUE.length();
            return this.myTypeString.length() == offset || !Character.isJavaIdentifierPart(this.myTypeString.charAt(offset));
        }
        if (this.myTypeString.startsWith(FALSE, this.myCurrentOffset)) {
            int offset = this.myCurrentOffset + FALSE.length();
            return this.myTypeString.length() == offset || !Character.isJavaIdentifierPart(this.myTypeString.charAt(offset));
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private JSType parseType() {
        void var1_26;
        boolean decorationsAdded;
        this.advanceSpaces();
        if (this.myCurrentOffset >= this.myTypeString.length()) {
            return null;
        }
        char c = this.myTypeString.charAt(this.myCurrentOffset);
        if (c == '{') {
            JSRecordType jSRecordType = this.parseRecordType();
            if (jSRecordType == null) {
                return null;
            }
        } else if (c == '(') {
            ++this.myCurrentOffset;
            JSType jSType = this.parseComposite(true);
            this.advanceSpaces();
            if (!this.myTypeString.startsWith(")", this.myCurrentOffset)) return null;
            ++this.myCurrentOffset;
        } else if (c == '[') {
            ++this.myCurrentOffset;
            JSType jSType = this.parseComposite(true);
            this.advanceSpaces();
            if (!this.myTypeString.startsWith("]", this.myCurrentOffset)) return null;
            ++this.myCurrentOffset;
            JSArrayTypeImpl jSArrayTypeImpl = new JSArrayTypeImpl(jSType, this.mySource);
        } else if (c == 'f' && this.myTypeString.startsWith("function", this.myCurrentOffset)) {
            int funcStartOffset = this.myCurrentOffset;
            this.myCurrentOffset += 8;
            this.advanceSpaces();
            if (this.myTypeString.startsWith(":", this.myCurrentOffset) || this.myTypeString.startsWith("(", this.myCurrentOffset)) {
                JSFunctionTypeImpl jSFunctionTypeImpl = this.parseFunctionAfterKeyword();
            } else {
                this.myCurrentOffset = funcStartOffset;
                JSType jSType = this.parseSingleType(false);
            }
        } else if (c == '\"' || c == '\'') {
            JSStringLiteralTypeImpl jSStringLiteralTypeImpl = this.parseStringLiteralType();
        } else if (!this.myIsFromJSDoc && JSStringUtil.isNumericValueStart(this.myTypeString, false)) {
            JSNumberLiteralTypeImpl jSNumberLiteralTypeImpl = this.parseNumericLiteralType();
        } else if (!this.myIsFromJSDoc && this.isBooleanLiteralAhead()) {
            JSBooleanLiteralTypeImpl jSBooleanLiteralTypeImpl = this.parseBooleanLiteralType();
        } else if (!this.myIsFromJSDoc && this.myTypeString.startsWith(TYPEOF_IDENTIFIER, this.myCurrentOffset)) {
            JSTypeofTypeImpl jSTypeofTypeImpl = this.parseTypeofType();
        } else if (!this.myIsFromJSDoc && this.myTypeString.startsWith(TS_TYPEOF_IDENTIFIER, this.myCurrentOffset)) {
            TypeScriptTypeOfJSTypeImpl typeScriptTypeOfJSTypeImpl = this.parseTypeScriptTypeOf();
        } else if (!this.myIsFromJSDoc && this.myTypeString.startsWith(DESTRUCTURING_IDENTIFIER, this.myCurrentOffset)) {
            JSType jSType = this.parseDestructuring();
        } else if (!this.myIsFromJSDoc && this.myTypeString.startsWith(TUPLE_PREFIX, this.myCurrentOffset)) {
            JSType jSType = this.parseTupleType();
        } else if (!this.myIsFromJSDoc && this.myTypeString.startsWith(COMPONENT_OF_ITERABLE_IDENTIFIER, this.myCurrentOffset)) {
            JSIterableComponentTypeImpl jSIterableComponentTypeImpl = this.parseIterableComponentType();
        } else if (!this.myIsFromJSDoc && this.myTypeString.startsWith(REQUIRE_CALL_EXPRESSION_PREFIX, this.myCurrentOffset)) {
            JSType jSType = this.parseRequireCallExpressionType();
        } else if (!this.myIsFromJSDoc && this.myTypeString.startsWith(APPLY_CALL_PREFIX, this.myCurrentOffset)) {
            JSApplyCallType jSApplyCallType = this.parseApplyCallType();
        } else if (!this.myIsFromJSDoc && this.myTypeString.startsWith(THIS_TYPE_IDENTIFIER, this.myCurrentOffset)) {
            JSType jSType = this.parseThisExpressionType();
        } else if (!this.myIsFromJSDoc && this.myTypeString.startsWith(TYPE_PREDICATE_PREFIX, this.myCurrentOffset)) {
            JSType jSType = this.parseTypePredicate();
        } else if (!this.myIsFromJSDoc && this.myTypeString.startsWith(TYPE_KEY_OF_PREFIX, this.myCurrentOffset)) {
            JSType jSType = this.parseKeyOf();
        } else if (!this.myIsFromJSDoc && this.myTypeString.startsWith(TYPE_INDEXED_PREFIX, this.myCurrentOffset)) {
            JSType jSType = this.parseIndexedType();
        } else if (!this.myIsFromJSDoc && this.myTypeString.startsWith(TYPE_MAPPED_PREFIX, this.myCurrentOffset)) {
            JSType jSType = this.parseMappedType();
        } else if (c == '%') {
            int genericParamStartOffset = ++this.myCurrentOffset;
            while (this.myCurrentOffset < this.myTypeString.length() && (c = this.myTypeString.charAt(this.myCurrentOffset)) != '\u0000' && (StringUtil.isJavaIdentifierPart((char)c) || c == '.' || c == '#')) {
                ++this.myCurrentOffset;
            }
            JSGenericParameterImpl jSGenericParameterImpl = new JSGenericParameterImpl(this.myTypeString.substring(genericParamStartOffset, this.myCurrentOffset), this.mySource);
            if (!this.myTypeString.startsWith(String.valueOf('%'), this.myCurrentOffset)) {
                return null;
            }
            ++this.myCurrentOffset;
        } else {
            JSType jSType = this.parseSingleType(false);
        }
        do {
            this.advanceSpaces();
            decorationsAdded = true;
            if (this.myTypeString.startsWith("[]", this.myCurrentOffset)) {
                JSArrayTypeImpl jSArrayTypeImpl = new JSArrayTypeImpl((JSType)var1_26, this.mySource);
                this.myCurrentOffset += 2;
                continue;
            }
            if (this.myTypeString.startsWith("!", this.myCurrentOffset)) {
                JSType jSType = this.addTypeDecoration((JSType)var1_26, JSDecoratedTypeImpl.TypeDecoration.NOTNULL);
                ++this.myCurrentOffset;
                continue;
            }
            if (this.myTypeString.startsWith("<", this.myCurrentOffset)) {
                ++this.myCurrentOffset;
                while (this.myCurrentOffset < this.myTypeString.length() && this.myTypeString.charAt(this.myCurrentOffset) != '>') {
                    int typeStart = this.myCurrentOffset;
                    JSType jSType = this.addGenericArgument((JSType)var1_26, this.parseComposite(false));
                    this.advanceSpaces();
                    if (this.myCurrentOffset < this.myTypeString.length() && this.myTypeString.charAt(this.myCurrentOffset) == ',') {
                        ++this.myCurrentOffset;
                        this.advanceSpaces();
                    }
                    if (typeStart != this.myCurrentOffset) continue;
                    return null;
                }
                if (this.myCurrentOffset >= this.myTypeString.length() || this.myTypeString.charAt(this.myCurrentOffset) != '>') {
                    return null;
                }
                ++this.myCurrentOffset;
                continue;
            }
            if (this.myTypeString.startsWith(".", this.myCurrentOffset)) {
                ++this.myCurrentOffset;
                continue;
            }
            if (this.myTypeString.startsWith(MIXIN_DELIMITER, this.myCurrentOffset)) {
                ++this.myCurrentOffset;
                JSType mixed = this.parseType();
                if (var1_26 == null || mixed == null) continue;
                JSMixinTypeImpl jSMixinTypeImpl = new JSMixinTypeImpl((JSType)var1_26, mixed, this.mySource);
                continue;
            }
            decorationsAdded = false;
        } while (decorationsAdded);
        return var1_26;
    }

    private JSType parseTupleType() {
        assert (this.myTypeString.startsWith(TUPLE_PREFIX, this.myCurrentOffset));
        this.myCurrentOffset += TUPLE_PREFIX.length();
        boolean strict = this.parseStrictModeFlag();
        ++this.myCurrentOffset;
        if (!this.hasSymbol()) {
            return null;
        }
        ArrayList types = ContainerUtil.newArrayList();
        if (this.getSymbol() != ']') {
            do {
                if (this.getSymbol() == ',') {
                    // empty if block
                }
                int startOffset = ++this.myCurrentOffset;
                JSType type = this.parseComposite(false);
                if (type != null) {
                    types.add(type);
                }
                if (startOffset != this.myCurrentOffset) continue;
                ++this.myCurrentOffset;
            } while (this.hasSymbol() && this.getSymbol() == ',');
            if (!this.hasSymbol()) {
                return null;
            }
        }
        ++this.myCurrentOffset;
        return new JSTupleTypeImpl(this.mySource, types, strict);
    }

    @Nullable
    private JSType parseDestructuring() {
        TextRange range = this.parseSegmentBasedType(DESTRUCTURING_IDENTIFIER);
        if (range == null) {
            return null;
        }
        return new JSDestructuringTypeImpl((Segment)range, this.mySource);
    }

    private JSType parseThisExpressionType() {
        assert (this.myTypeString.startsWith(THIS_TYPE_IDENTIFIER, this.myCurrentOffset));
        this.myCurrentOffset += THIS_TYPE_IDENTIFIER.length();
        ++this.myCurrentOffset;
        JSType classQualifiedType = null;
        if (this.hasSymbol()) {
            classQualifiedType = this.parseComposite(false);
        }
        if (this.hasSymbol() && this.getSymbol() == ')') {
            ++this.myCurrentOffset;
        }
        return new TypeScriptGenericThisTypeImpl(this.mySource, classQualifiedType);
    }

    private JSTypeofTypeImpl parseTypeofType() {
        TextRange range = this.parseSegmentBasedType(TYPEOF_IDENTIFIER);
        if (range == null) {
            return null;
        }
        PsiFile file = this.mySource.getScope();
        return file != null ? new JSTypeofTypeImpl(range, file, this.mySource) : null;
    }

    private TextRange parseSegmentBasedType(String identifier) {
        char c;
        char c2;
        assert (this.myTypeString.startsWith(identifier, this.myCurrentOffset));
        this.myCurrentOffset += identifier.length();
        ++this.myCurrentOffset;
        int startOffset = 0;
        while (this.myCurrentOffset < this.myTypeString.length() && Character.isDigit(c2 = this.myTypeString.charAt(this.myCurrentOffset))) {
            startOffset = startOffset * 10 + c2 - 48;
            ++this.myCurrentOffset;
        }
        ++this.myCurrentOffset;
        int endOffset = 0;
        while (this.myCurrentOffset < this.myTypeString.length() && Character.isDigit(c = this.myTypeString.charAt(this.myCurrentOffset))) {
            endOffset = endOffset * 10 + c - 48;
            ++this.myCurrentOffset;
        }
        if (this.myCurrentOffset >= this.myTypeString.length()) {
            return null;
        }
        ++this.myCurrentOffset;
        return new TextRange(startOffset, endOffset);
    }

    private JSIterableComponentTypeImpl parseIterableComponentType() {
        assert (this.myTypeString.startsWith(COMPONENT_OF_ITERABLE_IDENTIFIER, this.myCurrentOffset));
        this.myCurrentOffset += COMPONENT_OF_ITERABLE_IDENTIFIER.length();
        ++this.myCurrentOffset;
        JSType type = this.parseComposite(false);
        if (this.hasSymbol() && this.getSymbol() == ')') {
            ++this.myCurrentOffset;
        }
        if (type == null) {
            type = this.createAnyType();
        }
        return new JSIterableComponentTypeImpl(type, this.mySource);
    }

    private TypeScriptTypeOfJSTypeImpl parseTypeScriptTypeOf() {
        assert (this.myTypeString.startsWith(TS_TYPEOF_IDENTIFIER, this.myCurrentOffset));
        this.myCurrentOffset += TS_TYPEOF_IDENTIFIER.length();
        ++this.myCurrentOffset;
        int start = this.myCurrentOffset;
        while (this.hasSymbol() && this.getSymbol() != ')') {
            ++this.myCurrentOffset;
        }
        int end = this.myCurrentOffset++;
        if (!this.hasSymbol() || this.getSymbol() != ')') {
            return null;
        }
        String identifier = this.myTypeString.substring(start, end);
        return new TypeScriptTypeOfJSTypeImpl(identifier, this.mySource);
    }

    private JSType parseRequireCallExpressionType() {
        assert (this.myTypeString.startsWith(REQUIRE_CALL_EXPRESSION_PREFIX, this.myCurrentOffset));
        this.myCurrentOffset += REQUIRE_CALL_EXPRESSION_PREFIX.length();
        int start = this.myCurrentOffset;
        while (this.myCurrentOffset < this.myTypeString.length()) {
            char c = this.myTypeString.charAt(this.myCurrentOffset);
            ++this.myCurrentOffset;
            if (c != '^') continue;
            break;
        }
        if (this.myCurrentOffset - 1 < start) {
            return null;
        }
        return new JSRequireCallExpressionType(this.myTypeString.substring(start, this.myCurrentOffset - 1), this.mySource);
    }

    private JSApplyCallType parseApplyCallType() {
        assert (this.myTypeString.startsWith(APPLY_CALL_PREFIX, this.myCurrentOffset));
        this.myCurrentOffset += APPLY_CALL_PREFIX.length();
        JSType type = this.parseComposite(false);
        if (this.hasSymbol() && this.getSymbol() == ')') {
            this.inc();
        }
        return new JSApplyCallType((JSType)(type != null ? type : this.createAnyType()), this.mySource);
    }

    @NotNull
    private String readIdentifier() {
        assert (this.hasSymbol());
        int start = this.myCurrentOffset;
        while (this.hasSymbol() && Character.isJavaIdentifierPart(this.myTypeString.charAt(this.myCurrentOffset))) {
            ++this.myCurrentOffset;
        }
        String string = this.myTypeString.substring(start, this.myCurrentOffset);
        if (string == null) {
            JSTypeParser.$$$reportNull$$$0(8);
        }
        return string;
    }

    private int readPositiveNumber() {
        int start = this.myCurrentOffset;
        while (this.hasSymbol() && Character.isDigit(this.myTypeString.charAt(this.myCurrentOffset))) {
            ++this.myCurrentOffset;
        }
        try {
            if (this.myCurrentOffset > start) {
                return Integer.parseInt(this.myTypeString.substring(start, this.myCurrentOffset));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    @NotNull
    private JSType parseTypePredicate() {
        assert (this.myTypeString.startsWith(TYPE_PREDICATE_PREFIX, this.myCurrentOffset));
        this.myCurrentOffset += TYPE_PREDICATE_PREFIX.length();
        this.advanceSpaces();
        String parameterName = null;
        if (this.myTypeString.charAt(this.myCurrentOffset) != '?') {
            parameterName = this.readIdentifier();
        } else {
            ++this.myCurrentOffset;
        }
        this.advanceSpaces();
        boolean isNegative = false;
        if (this.hasSymbol() && this.getSymbol() == '-') {
            isNegative = true;
            ++this.myCurrentOffset;
        }
        int parameterIndex = this.readPositiveNumber();
        JSType type = this.parseType();
        TypeScriptTypePredicateTypeImpl typeScriptTypePredicateTypeImpl = new TypeScriptTypePredicateTypeImpl(type, this.mySource, parameterName, isNegative ? -1 : parameterIndex);
        if (typeScriptTypePredicateTypeImpl == null) {
            JSTypeParser.$$$reportNull$$$0(9);
        }
        return typeScriptTypePredicateTypeImpl;
    }

    @NotNull
    private JSType parseKeyOf() {
        assert (this.myTypeString.startsWith(TYPE_KEY_OF_PREFIX, this.myCurrentOffset));
        this.myCurrentOffset += TYPE_KEY_OF_PREFIX.length();
        if (this.hasSymbol()) {
            this.inc();
        }
        JSType type = null;
        if (this.hasSymbol() && this.getSymbol() != ')') {
            type = this.parseComposite(false);
        }
        if (this.hasSymbol() && this.getSymbol() == ')') {
            ++this.myCurrentOffset;
        }
        if (type == null) {
            type = this.createAnyType();
        }
        TypeScriptTypeOperatorJSTypeImpl typeScriptTypeOperatorJSTypeImpl = new TypeScriptTypeOperatorJSTypeImpl(type, this.mySource);
        if (typeScriptTypeOperatorJSTypeImpl == null) {
            JSTypeParser.$$$reportNull$$$0(10);
        }
        return typeScriptTypeOperatorJSTypeImpl;
    }

    private JSType parseIndexedType() {
        assert (this.myTypeString.startsWith(TYPE_INDEXED_PREFIX, this.myCurrentOffset));
        this.myCurrentOffset += TYPE_INDEXED_PREFIX.length();
        if (!this.hasSymbol() || this.getSymbol() != '(') {
            return this.createAnyType();
        }
        this.inc();
        JSType ownerType = this.parseType();
        if (ownerType == null || !this.hasSymbol() || this.getSymbol() != ',') {
            return this.createAnyType();
        }
        this.inc();
        JSType parameterType = this.parseComposite(false);
        if (parameterType == null || !this.hasSymbol() || this.getSymbol() != ')') {
            return this.createAnyType();
        }
        this.inc();
        return new TypeScriptIndexedAccessJSTypeImpl(ownerType, parameterType, this.mySource);
    }

    private JSType parseMappedType() {
        assert (this.myTypeString.startsWith(TYPE_MAPPED_PREFIX, this.myCurrentOffset));
        this.myCurrentOffset += TYPE_MAPPED_PREFIX.length();
        if (this.hasSymbol()) {
            this.inc();
        }
        if (!this.hasSymbol()) {
            return this.createAnyType();
        }
        char candidate = this.getSymbol();
        boolean isReadonly = false;
        if (candidate == 'r') {
            isReadonly = true;
            this.inc();
            if (this.hasSymbol()) {
                candidate = this.getSymbol();
            } else {
                return this.createAnyType();
            }
        }
        if (candidate == '[') {
            this.inc();
        }
        String parameterName = this.readIdentifier();
        if (!this.hasSymbol()) {
            return this.createAnyType();
        }
        char separator = this.getSymbol();
        if (separator != '+') {
            return this.createAnyType();
        }
        this.inc();
        if (!this.hasSymbol()) {
            return this.createAnyType();
        }
        JSType type = this.parseType();
        if (type == null || !this.hasSymbol() || this.getSymbol() != ']') {
            return this.createAnyType();
        }
        this.inc();
        if (!this.hasSymbol()) {
            return this.createAnyType();
        }
        boolean isOptional = false;
        candidate = this.getSymbol();
        if (candidate == '?') {
            isOptional = true;
            this.inc();
            if (!this.hasSymbol()) {
                return this.createAnyType();
            }
            candidate = this.getSymbol();
        }
        if (candidate != ':') {
            return this.createAnyType();
        }
        this.inc();
        if (!this.hasSymbol()) {
            return this.createAnyType();
        }
        JSType resultType = this.parseType();
        if (resultType == null || !this.hasSymbol() || this.getSymbol() != '}') {
            return this.createAnyType();
        }
        this.inc();
        return new TypeScriptMappedJSTypeImpl(this.mySource, isReadonly, isOptional, parameterName, type, resultType);
    }

    @NotNull
    private JSAnyType createAnyType() {
        JSAnyType jSAnyType = JSAnyType.get(this.mySource.getSourceElement(), true);
        if (jSAnyType == null) {
            JSTypeParser.$$$reportNull$$$0(11);
        }
        return jSAnyType;
    }

    private JSRecordType parseRecordType() {
        ArrayList<JSRecordType.TypeMember> typeMembers = new ArrayList<JSRecordType.TypeMember>();
        ++this.myCurrentOffset;
        this.advanceSpaces();
        while (this.myCurrentOffset < this.myTypeString.length() && this.getSymbol() != '}') {
            int labelStart = this.myCurrentOffset;
            if (this.myTypeString.startsWith("(", this.myCurrentOffset)) {
                JSFunctionTypeImpl callSignature = this.parseFunctionAfterKeyword();
                if (callSignature != null) {
                    typeMembers.add((JSRecordType.TypeMember)new JSRecordTypeImpl.CallSignatureImpl(false, callSignature));
                }
            } else if (this.myTypeString.startsWith(INDEX_SIGNATURE_PREFIX, this.myCurrentOffset)) {
                JSRecordType.IndexSignature signature = this.parseIndexSignature();
                if (signature != null) {
                    typeMembers.add((JSRecordType.TypeMember)signature);
                }
            } else {
                boolean optional = false;
                boolean isSymbol = this.myTypeString.startsWith("[Symbol.", this.myCurrentOffset);
                if (this.myTypeString.startsWith("[", this.myCurrentOffset) && !isSymbol) {
                    optional = true;
                    ++this.myCurrentOffset;
                    this.advanceSpaces();
                }
                labelStart = this.myCurrentOffset++;
                if (isSymbol) {
                    // empty if block
                }
                while (this.myCurrentOffset < this.myTypeString.length() && (StringUtil.isJavaIdentifierPart((char)this.getSymbol()) || '.' == this.getSymbol())) {
                    ++this.myCurrentOffset;
                }
                if (isSymbol && this.myTypeString.startsWith("]", this.myCurrentOffset)) {
                    ++this.myCurrentOffset;
                }
                String recordLabel = this.myTypeString.substring(labelStart, this.myCurrentOffset);
                this.advanceSpaces();
                if (optional && this.myTypeString.startsWith("]", this.myCurrentOffset)) {
                    ++this.myCurrentOffset;
                    this.advanceSpaces();
                }
                if (!optional && "new".equals(recordLabel) && this.myTypeString.startsWith("(", this.myCurrentOffset)) {
                    JSFunctionTypeImpl callSignature = this.parseFunctionAfterKeyword();
                    if (callSignature != null) {
                        typeMembers.add((JSRecordType.TypeMember)new JSRecordTypeImpl.CallSignatureImpl(true, callSignature));
                    }
                } else {
                    JSParameterTypeDecorator recordPropertyType = null;
                    if (this.myTypeString.startsWith("?", this.myCurrentOffset)) {
                        optional = true;
                        ++this.myCurrentOffset;
                        this.advanceSpaces();
                    }
                    if (this.myCurrentOffset < this.myTypeString.length() && this.myTypeString.charAt(this.myCurrentOffset) == ':') {
                        ++this.myCurrentOffset;
                        this.advanceSpaces();
                        recordPropertyType = this.parseInnerParameterType(false);
                        this.advanceSpaces();
                    }
                    JSType type = recordPropertyType != null ? recordPropertyType.getType() : null;
                    typeMembers.add((JSRecordType.TypeMember)new JSRecordTypeImpl.PropertySignatureImpl(recordLabel, type, optional |= recordPropertyType != null && recordPropertyType.isOptional()));
                    if (this.myVisitor != null) {
                        this.myVisitor.visitRecordProperty(labelStart, recordLabel, type != null ? type.getTypeText() : null);
                    }
                }
            }
            if (this.hasSymbol() && this.getSymbol() == ',') {
                ++this.myCurrentOffset;
                this.advanceSpaces();
            }
            if (labelStart != this.myCurrentOffset) continue;
            break;
        }
        if (!this.hasSymbol() || this.getSymbol() != '}') {
            return null;
        }
        ++this.myCurrentOffset;
        return new JSRecordTypeImpl(this.mySource, typeMembers);
    }

    @NotNull
    private JSBooleanLiteralTypeImpl parseBooleanLiteralType() {
        if (this.myTypeString.startsWith(TRUE)) {
            this.myCurrentOffset += TRUE.length();
            JSBooleanLiteralTypeImpl jSBooleanLiteralTypeImpl = new JSBooleanLiteralTypeImpl(true, this.parseStrictModeFlag(), this.mySource);
            if (jSBooleanLiteralTypeImpl == null) {
                JSTypeParser.$$$reportNull$$$0(12);
            }
            return jSBooleanLiteralTypeImpl;
        }
        this.myCurrentOffset += FALSE.length();
        JSBooleanLiteralTypeImpl jSBooleanLiteralTypeImpl = new JSBooleanLiteralTypeImpl(false, this.parseStrictModeFlag(), this.mySource);
        if (jSBooleanLiteralTypeImpl == null) {
            JSTypeParser.$$$reportNull$$$0(13);
        }
        return jSBooleanLiteralTypeImpl;
    }

    @Nullable
    private JSNumberLiteralTypeImpl parseNumericLiteralType() {
        JSStringUtil.NumberParseResult result = JSNumberParser.tryParseNumericValue(this.myTypeString, this.myCurrentOffset);
        if (result == null) {
            return null;
        }
        this.myCurrentOffset = result.getNewOffset();
        return new JSNumberLiteralTypeImpl(result.getValue(), this.parseStrictModeFlag(), this.mySource, result.getStringValue());
    }

    @Nullable
    private JSStringLiteralTypeImpl parseStringLiteralType() {
        char quote = this.myTypeString.charAt(this.myCurrentOffset);
        ++this.myCurrentOffset;
        int literalStart = this.myCurrentOffset;
        boolean screened = false;
        while (this.myCurrentOffset < this.myTypeString.length()) {
            char c = this.myTypeString.charAt(this.myCurrentOffset);
            if (c == '\\') {
                screened = !screened;
            } else if (!screened && c == quote) {
                ++this.myCurrentOffset;
                String literalValue = this.myTypeString.substring(literalStart, this.myCurrentOffset - 1);
                return new JSStringLiteralTypeImpl(literalValue, this.parseStrictModeFlag(), this.mySource);
            }
            ++this.myCurrentOffset;
        }
        return null;
    }

    private boolean parseStrictModeFlag() {
        boolean isStrict = false;
        if (this.hasSymbol() && this.getSymbol() == '!') {
            ++this.myCurrentOffset;
            isStrict = true;
        }
        return isStrict;
    }

    private JSRecordType.IndexSignature parseIndexSignature() {
        assert (this.myTypeString.startsWith(INDEX_SIGNATURE_PREFIX, this.myCurrentOffset));
        this.myCurrentOffset += INDEX_SIGNATURE_PREFIX.length();
        if (!this.checkCurrentSymbol('[')) {
            return null;
        }
        this.inc();
        JSType typeParameter = this.parseComposite(false);
        this.advanceSpaces();
        if (!this.checkCurrentSymbol(']')) {
            return null;
        }
        this.inc();
        if (!this.checkCurrentSymbol(':')) {
            return null;
        }
        this.inc();
        this.advanceSpaces();
        JSType typeReturn = this.parseComposite(false);
        this.advanceSpaces();
        if (!this.checkCurrentSymbol(')')) {
            return null;
        }
        this.inc();
        return new JSRecordTypeImpl.IndexSignatureImpl(typeParameter, typeReturn, null);
    }

    @Nullable
    private JSType addTypeDecoration(@Nullable JSType type, JSDecoratedTypeImpl.TypeDecoration decoration) {
        JSDecoratedTypeImpl decoratedType;
        if (type == null) {
            return null;
        }
        if (type instanceof JSDecoratedTypeImpl) {
            EnumSet<JSDecoratedTypeImpl.TypeDecoration> decorations = EnumSet.copyOf(((JSDecoratedTypeImpl)type).getDecorations());
            decorations.add(decoration);
            decoratedType = new JSDecoratedTypeImpl(this.mySource, ((JSDecoratedTypeImpl)type).getType(), decorations);
        } else {
            decoratedType = new JSDecoratedTypeImpl(this.mySource, type, EnumSet.of(decoration));
        }
        return decoratedType;
    }

    @Nullable
    private JSType addGenericArgument(JSType type, JSType genericArgument) {
        if (type == null || genericArgument == null) {
            return null;
        }
        if (type instanceof JSGenericTypeImpl) {
            ((JSGenericTypeImpl)type).addGenericArgument(genericArgument);
            return type;
        }
        return new JSGenericTypeImpl(this.mySource, type, genericArgument);
    }

    @Nullable
    private JSFunctionTypeImpl parseFunctionAfterKeyword() {
        SmartList decorators = new SmartList();
        JSType newType = null;
        JSType thisType = null;
        this.myParsingFunction = true;
        if (this.myCurrentOffset < this.myTypeString.length() && this.myTypeString.charAt(this.myCurrentOffset) == '(') {
            ++this.myCurrentOffset;
            this.advanceSpaces();
            while (this.myCurrentOffset < this.myTypeString.length() && this.myTypeString.charAt(this.myCurrentOffset) != ')') {
                JSType paramType;
                int paramStart = this.myCurrentOffset;
                while (this.myCurrentOffset < this.myTypeString.length() && StringUtil.isJavaIdentifierPart((char)this.myTypeString.charAt(this.myCurrentOffset))) {
                    ++this.myCurrentOffset;
                }
                int identifierEnd = this.myCurrentOffset;
                this.advanceSpaces();
                String recordLabel = null;
                if (this.myCurrentOffset < this.myTypeString.length() && this.myTypeString.charAt(this.myCurrentOffset) == ':') {
                    ++this.myCurrentOffset;
                    recordLabel = this.myTypeString.substring(paramStart, identifierEnd);
                } else {
                    this.myCurrentOffset = paramStart;
                }
                JSParameterTypeDecorator paramTypeDecorator = this.parseInnerParameterType(false);
                JSType jSType = paramType = paramTypeDecorator != null ? paramTypeDecorator.getType() : null;
                if ("this".equals(recordLabel)) {
                    thisType = paramType;
                } else if ("new".equals(recordLabel)) {
                    newType = paramType;
                } else {
                    boolean optional = paramTypeDecorator != null && paramTypeDecorator.isOptional();
                    boolean rest = paramTypeDecorator != null && paramTypeDecorator.isRest();
                    JSParameterTypeDecoratorImpl decorator = new JSParameterTypeDecoratorImpl(paramType, optional, rest, true);
                    decorators.add(decorator);
                }
                this.advanceSpaces();
                if (this.myCurrentOffset < this.myTypeString.length() && this.myTypeString.charAt(this.myCurrentOffset) == ',') {
                    ++this.myCurrentOffset;
                    this.advanceSpaces();
                }
                if (this.myCurrentOffset != paramStart) continue;
                return null;
            }
            if (this.myCurrentOffset >= this.myTypeString.length() || this.myTypeString.charAt(this.myCurrentOffset) != ')') {
                return null;
            }
            ++this.myCurrentOffset;
        }
        this.advanceSpaces();
        JSType returnType = null;
        if (this.myCurrentOffset < this.myTypeString.length() && this.myTypeString.charAt(this.myCurrentOffset) == ':') {
            ++this.myCurrentOffset;
            returnType = this.parseType();
        }
        return new JSFunctionTypeImpl(this.mySource, (List<JSParameterTypeDecorator>)decorators, returnType, thisType, newType);
    }

    @Nullable
    private JSType parseSingleType(boolean isModule) {
        JSType type;
        char c;
        this.advanceSpaces();
        char c2 = c = this.myCurrentOffset < this.myTypeString.length() ? this.myTypeString.charAt(this.myCurrentOffset) : (char)'\u0000';
        if (c == '?') {
            ++this.myCurrentOffset;
            this.advanceSpaces();
            int afterQuestOffset = this.myCurrentOffset;
            type = this.parseType();
            type = type == null && afterQuestOffset == this.myCurrentOffset ? JSUnknownType.INSTANCE : this.addTypeDecoration(type, JSDecoratedTypeImpl.TypeDecoration.NULLABLE);
        } else if (c == '!') {
            ++this.myCurrentOffset;
            type = this.parseType();
            type = this.addTypeDecoration(type, JSDecoratedTypeImpl.TypeDecoration.NOTNULL);
        } else if (c == '*') {
            ++this.myCurrentOffset;
            type = JSAnyType.get((PsiElement)this.mySource.getScope(), this.mySource.isExplicitlyDeclared());
        } else {
            int identifierStartOffset = this.myCurrentOffset;
            JSContext jsContext = JSContext.INSTANCE;
            if (c == 't' && this.myTypeString.startsWith("typeof ", this.myCurrentOffset)) {
                this.myCurrentOffset += "typeof".length();
                this.advanceSpaces();
                if (this.myCurrentOffset < this.myTypeString.length() && StringUtil.isJavaIdentifierPart((char)this.myTypeString.charAt(this.myCurrentOffset))) {
                    jsContext = JSContext.STATIC;
                    identifierStartOffset = this.myCurrentOffset;
                } else {
                    this.myCurrentOffset = identifierStartOffset;
                }
            }
            int identifierEndOffset = identifierStartOffset;
            while (this.myCurrentOffset < this.myTypeString.length() && (c = this.myTypeString.charAt(this.myCurrentOffset)) != '\u0000' && (StringUtil.isJavaIdentifierPart((char)c) || c == '.' || c == '#' || c == '~' || isModule && c == '/' || c == '^')) {
                if (c == 'm' && this.myTypeString.startsWith(MODULE_PREFIX, this.myCurrentOffset)) {
                    this.myCurrentOffset += MODULE_PREFIX.length();
                    isModule = true;
                    continue;
                }
                if (c == 'e' && this.myTypeString.startsWith(EVENT_PREFIX, this.myCurrentOffset)) {
                    this.myCurrentOffset += EVENT_PREFIX.length();
                    continue;
                }
                if (c == 'e' && this.myTypeString.startsWith("external:", this.myCurrentOffset)) {
                    this.myCurrentOffset += "external:".length();
                    continue;
                }
                ++this.myCurrentOffset;
                if (c != '.' && c != '#' && c != '~') {
                    identifierEndOffset = this.myCurrentOffset;
                }
                if (c != '^' || this.myCurrentOffset >= this.myTypeString.length() || this.myTypeString.charAt(this.myCurrentOffset) != 'q') continue;
                ++this.myCurrentOffset;
                while (true) {
                    if (this.myCurrentOffset + 1 >= this.myTypeString.length()) {
                        return null;
                    }
                    if (this.myTypeString.charAt(this.myCurrentOffset) == '^' && this.myTypeString.charAt(this.myCurrentOffset + 1) == 'q') break;
                    ++this.myCurrentOffset;
                }
                this.myCurrentOffset += 2;
            }
            if (identifierEndOffset > identifierStartOffset) {
                String name = this.myTypeString.substring(identifierStartOffset, identifierEndOffset);
                if (c == '.') {
                    jsContext = JSContext.STATIC;
                }
                JSType jSType = type = this.mySource.getLanguage() == JSTypeSource.SourceLanguage.TS && "any".equals(name) ? JSAnyType.get((PsiElement)this.mySource.getScope(), this.mySource.isExplicitlyDeclared()) : JSNamedType.createType(name, this.mySource, JSTypeContext.fromJSContext(jsContext), false, this.myIsFromJSDoc);
                if (this.myVisitor != null) {
                    this.myVisitor.visitSingleType(identifierStartOffset, name);
                }
            } else {
                return null;
            }
        }
        return type;
    }

    private char getSymbol() {
        return this.myTypeString.charAt(this.myCurrentOffset);
    }

    private boolean checkCurrentSymbol(char ch) {
        return this.hasSymbol() && this.getSymbol() == ch;
    }

    private void inc() {
        ++this.myCurrentOffset;
    }

    private boolean hasSymbol() {
        return this.myCurrentOffset < this.myTypeString.length();
    }

    private void advanceSpaces() {
        while (this.myCurrentOffset < this.myTypeString.length() && StringUtil.isWhiteSpace((char)this.myTypeString.charAt(this.myCurrentOffset))) {
            ++this.myCurrentOffset;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeString";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delimiters";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeParser";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "readIdentifier";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTypePredicate";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "parseKeyOf";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnyType";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "parseBooleanLiteralType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseComposite";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

