/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeSourceFactory {
    @NotNull
    public static JSTypeSource createTypeSource(@NotNull PsiElement scope) {
        if (scope == null) {
            JSTypeSourceFactory.$$$reportNull$$$0(0);
        }
        JSTypeSource jSTypeSource = JSTypeSourceFactory.createTypeSource(scope, false);
        if (jSTypeSource == null) {
            JSTypeSourceFactory.$$$reportNull$$$0(1);
        }
        return jSTypeSource;
    }

    @NotNull
    public static JSTypeSource createTypeSource(@Nullable PsiElement scope, boolean isExplicitlyDeclared) {
        PsiFile file = scope != null ? scope.getContainingFile() : null;
        JSTypeSource jSTypeSource = new JSTypeSource(file, scope, JSTypeSourceFactory.sourceFileLanguage(file), isExplicitlyDeclared);
        if (jSTypeSource == null) {
            JSTypeSourceFactory.$$$reportNull$$$0(2);
        }
        return jSTypeSource;
    }

    public static JSTypeSource copyTypeSource(JSTypeSource source, boolean isExplicitlyDeclared) {
        return new JSTypeSource(source.getScope(), source.getSourceElement(), source.getLanguage(), isExplicitlyDeclared);
    }

    @NotNull
    public static JSTypeSource.SourceLanguage sourceFileLanguage(PsiFile file) {
        DialectOptionHolder dialect = DialectDetector.dialectOfFile(file);
        JSTypeSource.SourceLanguage sourceLanguage = dialect != null ? JSTypeSourceFactory.ofDialectOptionsHolder(dialect) : JSTypeSource.SourceLanguage.JS;
        if (sourceLanguage == null) {
            JSTypeSourceFactory.$$$reportNull$$$0(3);
        }
        return sourceLanguage;
    }

    @NotNull
    private static JSTypeSource.SourceLanguage ofDialectOptionsHolder(@NotNull DialectOptionHolder dialect) {
        if (dialect == null) {
            JSTypeSourceFactory.$$$reportNull$$$0(4);
        }
        switch (dialect) {
            case ECMA_4: {
                JSTypeSource.SourceLanguage sourceLanguage = JSTypeSource.SourceLanguage.AS;
                if (sourceLanguage == null) {
                    JSTypeSourceFactory.$$$reportNull$$$0(5);
                }
                return sourceLanguage;
            }
            case TS: 
            case TSX: {
                JSTypeSource.SourceLanguage sourceLanguage = JSTypeSource.SourceLanguage.TS;
                if (sourceLanguage == null) {
                    JSTypeSourceFactory.$$$reportNull$$$0(6);
                }
                return sourceLanguage;
            }
        }
        JSTypeSource.SourceLanguage sourceLanguage = JSTypeSource.SourceLanguage.JS;
        if (sourceLanguage == null) {
            JSTypeSourceFactory.$$$reportNull$$$0(7);
        }
        return sourceLanguage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeSourceFactory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeSourceFactory";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeSource";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "sourceFileLanguage";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "ofDialectOptionsHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTypeSource";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "ofDialectOptionsHolder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

