/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.guard;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSIntersectionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeComparingCacheService;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.TypeScriptTypePredicateTypeImpl;
import com.intellij.lang.javascript.psi.types.guard.JSTypeFacts;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveArrayType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveFunctionType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverType;
import com.intellij.lang.javascript.psi.util.JSTreeUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeGuardChecker {
    public static final String[] TYPE_NAMES = new String[]{"string", "number", "boolean", "symbol", "null", "undefined", "function"};
    @NotNull
    private final String myTopReferenceName;
    @NotNull
    private final JSReferenceExpression myReference;
    @NotNull
    private final JSTypeSource mySource;
    @Nullable
    private final JSType myDeclaredType;
    private final boolean myIsTypeScript;
    @NotNull
    private final ProcessingContext myProcessingContext;

    public static boolean isAvailable(@NotNull PsiElement place, @Nullable JSType type) {
        DialectOptionHolder holder;
        if (place == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(0);
        }
        if ((holder = DialectDetector.dialectOfElement(place)) == null || holder.isECMA4) {
            return false;
        }
        if (!(place instanceof JSReferenceExpression)) {
            return false;
        }
        JSExpression qualifier = ((JSReferenceExpression)place).getQualifier();
        if (qualifier != null) {
            if (!(qualifier instanceof JSReferenceExpression)) {
                return false;
            }
            if (!holder.isTypeScript || !JSSymbolUtil.isAccurateReferenceExpression((JSReferenceExpression)qualifier)) {
                return false;
            }
        }
        if (holder.isTypeScript && type == null) {
            return false;
        }
        return !(type instanceof JSArrayTypeImpl) && !(type instanceof JSPrimitiveType) && !(type instanceof JSPrimitiveArrayType) && !(type instanceof JSUndefinedType);
    }

    public JSTypeGuardChecker(@NotNull JSReferenceExpression reference, @Nullable JSType startType, @NotNull String topReferenceName) {
        if (reference == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(1);
        }
        if (topReferenceName == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(2);
        }
        PsiElement expression = JSResolveUtil.getTopReferenceExpression((PsiElement)reference);
        this.myTopReferenceName = expression instanceof JSReferenceExpression ? StringUtil.notNullize((String)((JSReferenceExpression)expression).getReferenceName()) : topReferenceName;
        this.myProcessingContext = JSTypeComparingCacheService.getProcessingContextWithCache((PsiElement)reference);
        this.myReference = reference;
        this.myDeclaredType = startType;
        this.mySource = this.myDeclaredType == null ? JSTypeSource.EMPTY : this.myDeclaredType.getSource();
        this.myIsTypeScript = DialectDetector.isTypeScript((PsiElement)reference);
    }

    @Nullable
    public JSType getNarrowedType() {
        JSType type = this.myDeclaredType;
        boolean typeWasNarrowed = false;
        type = JSTypeGuardChecker.getExactType(type);
        JSReferenceExpression node = this.myReference;
        while (node.getParent() != null) {
            JSType distinct;
            JSBinaryExpression binaryExpression;
            JSReferenceExpression child = node;
            node = node.getParent();
            JSType narrowedType = type;
            if (JSTypeGuardChecker.isScopeElement((PsiElement)node)) break;
            if (node instanceof JSCaseClause && ((JSCaseClause)node).getCaseExpression() != child) {
                narrowedType = this.narrowTypeForCase(type, (PsiElement)node);
            }
            if (node instanceof JSIfStatement) {
                JSIfStatement ifStatement = (JSIfStatement)node;
                if (ifStatement.getCondition() != child) {
                    narrowedType = this.narrowType(type, ifStatement.getCondition(), child == ifStatement.getThen());
                }
            } else if (node instanceof JSConditionalExpression) {
                JSConditionalExpression conditionalExpression = (JSConditionalExpression)node;
                if (conditionalExpression.getCondition() != child) {
                    narrowedType = this.narrowType(type, conditionalExpression.getCondition(), conditionalExpression.getThen() == child);
                }
            } else if (node instanceof JSBinaryExpression && child == (binaryExpression = (JSBinaryExpression)node).getROperand()) {
                if (binaryExpression.getOperationSign() == JSTokenTypes.ANDAND) {
                    narrowedType = this.narrowType(type, binaryExpression.getLOperand(), true);
                } else if (binaryExpression.getOperationSign() == JSTokenTypes.OROR) {
                    narrowedType = this.narrowType(type, binaryExpression.getLOperand(), false);
                }
            }
            if (narrowedType != type) {
                if (this.isVariableAssignedWithin((PsiElement)node)) break;
                type = narrowedType;
                typeWasNarrowed = true;
            }
            if ((distinct = this.getDistinctTypeFromUnionType(type)) == null) continue;
            return distinct;
        }
        if (!typeWasNarrowed) {
            return this.myDeclaredType;
        }
        JSType distinct = this.getDistinctTypeFromUnionType(type);
        if (distinct != null) {
            return distinct;
        }
        return type;
    }

    @Nullable
    public JSType narrowTypeForCase(@Nullable JSType type, @NotNull PsiElement node) {
        JSCaseClause clause;
        int i;
        JSSwitchStatement statement;
        if (node == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(3);
        }
        if ((statement = ((JSCaseClause)node).getSwitchStatement()) == null) {
            return type;
        }
        JSCaseClause[] clauses = statement.getCaseClauses();
        JSCaseClause prev = null;
        for (i = 0; i < clauses.length && node != (clause = clauses[i]); ++i) {
            prev = clause;
        }
        if (prev == null) {
            return this.processTypeForCase(type, statement, i);
        }
        JSStatement element = (JSStatement)ArrayUtil.getLastElement((Object[])prev.getStatements());
        if (element == null) {
            return type;
        }
        return element instanceof JSReturnStatement || element instanceof JSBreakStatement ? this.processTypeForCase(type, statement, i) : type;
    }

    public JSType processTypeForCase(@Nullable JSType type, JSSwitchStatement statement, int i) {
        JSType resultType = this.getTypeAtSwitchClause(type, statement, i, i + 1);
        if (resultType != null && !(resultType instanceof TypeScriptNeverType)) {
            return resultType;
        }
        return type;
    }

    private static boolean isScopeElement(@Nullable PsiElement node) {
        return node instanceof JSExecutionScope && !(node instanceof JSFunctionExpression) || node instanceof TypeScriptModule;
    }

    @Nullable
    protected JSType getDistinctTypeFromUnionType(@Nullable JSType type) {
        List<JSType> types;
        if (type instanceof JSCompositeTypeImpl && (types = ((JSCompositeTypeImpl)type).getTypes()).size() == 1) {
            return (JSType)ContainerUtil.getFirstItem(types, null);
        }
        return null;
    }

    private boolean isVariableAssignedWithin(PsiElement element) {
        ASTNode astNode = element.getNode();
        if (astNode instanceof CompositeElement) {
            return JSTreeUtil.definedOrAssignedInCodeBlock(this.myTopReferenceName, true, (CompositeElement)astNode);
        }
        return false;
    }

    @Nullable
    private static JSPrefixExpression getTypeOfPrefixExpression(@Nullable JSExpression candidate) {
        if (candidate instanceof JSPrefixExpression && ((JSPrefixExpression)candidate).getOperationSign() == JSTokenTypes.TYPEOF_KEYWORD) {
            return (JSPrefixExpression)candidate;
        }
        return null;
    }

    private JSType narrowTypeByEquality(@Nullable JSType type, @NotNull IElementType sign, @NotNull JSExpression expression, boolean assumeTrue) {
        JSType valueType;
        if (sign == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(4);
        }
        if (expression == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(5);
        }
        if (type == null || type instanceof JSAnyType) {
            return type;
        }
        if (JSTypeGuardChecker.isNegativeSign(sign)) {
            assumeTrue = false;
        }
        if ((valueType = JSTypeGuardChecker.getExactType(JSResolveUtil.getExpressionJSType(expression))) == null) {
            return type;
        }
        if (!(type instanceof JSCompositeTypeImpl) && !JSTypeGuardChecker.isUnitType(type)) {
            return type;
        }
        if (assumeTrue) {
            JSType regularType = JSTypeGuardChecker.getRegularTypeOfLiteralType(valueType);
            JSType narrowType = JSTypeFacts.filterType(type, (Predicate<JSType>)((Predicate)el -> TypeScriptTypeRelations.areTypesComparable(el, regularType, this.myProcessingContext)), (PsiElement)this.myReference);
            return narrowType instanceof TypeScriptNeverType ? type : this.replacePrimitivesWithLiterals(narrowType, valueType);
        }
        if (JSTypeGuardChecker.isUnitType(valueType)) {
            JSType regularType = JSTypeGuardChecker.getRegularTypeOfLiteralType(valueType);
            JSType resultType = JSTypeFacts.filterType(type, (Predicate<JSType>)((Predicate)el -> {
                JSType literalType = JSTypeGuardChecker.getRegularTypeOfLiteralType(el);
                return literalType != null && !literalType.isEquivalentTo(regularType, null, true);
            }), (PsiElement)this.myReference);
            return JSTypeGuardChecker.processNeverType(type, resultType);
        }
        return type;
    }

    @Nullable
    private static JSType processNeverType(@Nullable JSType type, @Nullable JSType resultOrNeverType) {
        return resultOrNeverType instanceof TypeScriptNeverType ? type : resultOrNeverType;
    }

    @Nullable
    private static JSType getRegularTypeOfLiteralType(@Nullable JSType valueType) {
        if (valueType instanceof JSLiteralType && !((JSLiteralType)valueType).isStrict()) {
            if (valueType instanceof JSStringLiteralTypeImpl) {
                return new JSStringLiteralTypeImpl(((JSStringLiteralTypeImpl)valueType).getLiteral(), true, valueType.getSource());
            }
            if (valueType instanceof JSNumberLiteralTypeImpl) {
                JSNumberLiteralTypeImpl type = (JSNumberLiteralTypeImpl)valueType;
                return new JSNumberLiteralTypeImpl(type.getLiteral(), true, valueType.getSource(), type.getValueAsString());
            }
        }
        return valueType;
    }

    private static boolean isDiscriminantProperty(@Nullable JSType type, @NotNull String propertyName) {
        JSRecordType recordType;
        JSRecordType.PropertySignature signature;
        if (propertyName == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(6);
        }
        if (type instanceof JSCompositeTypeImpl && (signature = (recordType = type.asRecordType()).findPropertySignature(propertyName)) != null && signature.getSource() == null) {
            return JSTypeGuardChecker.isLiteralType(signature.getType());
        }
        return false;
    }

    private static boolean isNegativeSign(@NotNull IElementType sign) {
        if (sign == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(7);
        }
        return sign == JSTokenTypes.NE || sign == JSTokenTypes.NEQEQ;
    }

    @Nullable
    private JSType narrowTypeByAnd(@Nullable JSType rawType, JSBinaryExpression expr, boolean assumeTrue) {
        if (assumeTrue) {
            return this.narrowType(this.narrowType(rawType, expr.getLOperand(), true), expr.getROperand(), true);
        }
        JSType type1 = this.narrowType(rawType, expr.getLOperand(), false);
        JSType type2 = this.narrowType(this.narrowType(rawType, expr.getLOperand(), true), expr.getROperand(), false);
        if (type1 == rawType) {
            return type2;
        }
        if (type2 == rawType) {
            return type1;
        }
        return this.getUnionType(type1, type2);
    }

    @Nullable
    private JSType narrowTypeByOr(@Nullable JSType rawType, JSBinaryExpression expr, boolean assumeTrue) {
        if (assumeTrue) {
            return this.getUnionType(this.narrowType(rawType, expr.getLOperand(), true), this.narrowType(this.narrowType(rawType, expr.getLOperand(), false), expr.getROperand(), true));
        }
        return this.narrowType(this.narrowType(rawType, expr.getLOperand(), false), expr.getROperand(), false);
    }

    @Contract(value="null,_ -> false")
    private boolean isMatchingReferenceDiscriminant(@Nullable JSType type, @Nullable PsiElement expression) {
        if (type == null) {
            return false;
        }
        if (expression instanceof JSReferenceExpression) {
            JSReferenceExpression referenceExpression = (JSReferenceExpression)expression;
            String name = referenceExpression.getReferenceName();
            if (name == null) {
                return false;
            }
            JSExpression qualifier = referenceExpression.getQualifier();
            if (qualifier == null) {
                return false;
            }
            if ((type = JSTypeGuardChecker.getExactType(type)) instanceof JSCompositeTypeImpl) {
                return JSTypeGuardChecker.isMatchingReference((PsiElement)this.myReference, (PsiElement)qualifier) && JSTypeGuardChecker.isDiscriminantProperty(type, name);
            }
        }
        return false;
    }

    private static boolean isLiteralType(@Nullable JSType rawType) {
        if (rawType == null) {
            return false;
        }
        if (rawType instanceof JSTypeImpl && ((JSTypeImpl)rawType).isStrictEnumLiteral()) {
            return true;
        }
        if (rawType instanceof JSCompositeTypeImpl) {
            return ((JSCompositeTypeImpl)rawType).getTypes().stream().allMatch(JSTypeGuardChecker::isUnitType);
        }
        return false;
    }

    private static boolean isUnitType(@Nullable JSType rawType) {
        return rawType instanceof JSLiteralType || rawType instanceof JSUndefinedType || rawType instanceof JSNullType;
    }

    @Nullable
    private JSType narrowTypeByInstanceof(@Nullable JSType type, JSBinaryExpression expr, boolean assumeTrue) {
        JSExpression left = JSTypeGuardChecker.getReferenceCandidate(expr.getLOperand());
        if (left == null) {
            return type;
        }
        if (!JSTypeGuardChecker.isMatchingReference((PsiElement)this.myReference, (PsiElement)left)) {
            if (JSTypeGuardChecker.containsMatchingReference((PsiElement)this.myReference, (PsiElement)left)) {
                return this.myDeclaredType;
            }
            return type;
        }
        JSExpression rOperand = expr.getROperand();
        if (rOperand == null) {
            return type;
        }
        JSType rightType = JSResolveUtil.getExpressionJSType(rOperand);
        if (rightType == null) {
            return type;
        }
        rightType = JSTypeGuardChecker.getExactType(rightType);
        type = JSTypeGuardChecker.getExactType(type);
        JSType targetType = JSTypeGuardChecker.getTargetTypeForInstanceof(rightType, (PsiElement)rOperand);
        if (targetType == null) {
            return type;
        }
        if (JSTypeGuardChecker.isSourceTypeAnyAndTargetTypeFunctionOrObject(type, targetType)) {
            return type;
        }
        if (type == null || type instanceof JSAnyType) {
            return targetType;
        }
        JSType narrowedType = this.getNarrowedType(type, targetType, assumeTrue, TypeScriptTypeRelations::isTypeInstanceOf);
        return JSTypeGuardChecker.processNeverType(type, narrowedType);
    }

    private static JSType getTargetTypeForInstanceof(@Nullable JSType rightType, PsiElement rOperand) {
        if (!(rOperand instanceof JSReferenceExpression)) {
            return null;
        }
        JSReferenceExpression operand = (JSReferenceExpression)rOperand;
        return JSSymbolUtil.createTypeFromReferenceExpression(operand, JSTypeContext.INSTANCE);
    }

    @Nullable
    private JSType getNarrowedType(@Nullable JSType type, @NotNull JSType candidate, boolean assumeTrue, TypeRelation relation) {
        JSType assignableType;
        if (candidate == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(8);
        }
        if (!assumeTrue) {
            return JSTypeFacts.filterType(type, (Predicate<JSType>)((Predicate)t -> {
                if (candidate == null) {
                    JSTypeGuardChecker.$$$reportNull$$$0(26);
                }
                return !relation.isRelated((JSType)t, candidate, this.myProcessingContext);
            }), (PsiElement)this.myReference);
        }
        if ((type = JSTypeGuardChecker.getExactType(type)) instanceof JSCompositeTypeImpl && !((assignableType = JSTypeFacts.filterType(type, (Predicate<JSType>)((Predicate)t -> {
            if (candidate == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(25);
            }
            return relation.isRelated((JSType)t, candidate, this.myProcessingContext);
        }), (PsiElement)this.myReference)) instanceof TypeScriptNeverType)) {
            return assignableType;
        }
        if (TypeScriptTypeRelations.isTypeSubtypeOf(candidate, type, this.myProcessingContext)) {
            return candidate;
        }
        if (TypeScriptTypeRelations.isTypeAssignableTo(type, candidate, this.myProcessingContext)) {
            return type;
        }
        if (TypeScriptTypeRelations.isTypeAssignableTo(candidate, type, this.myProcessingContext)) {
            return candidate;
        }
        return JSIntersectionTypeImpl.getIntersectionType(ContainerUtil.newArrayList((Object[])new JSType[]{type, candidate}), candidate.getSource());
    }

    @Nullable
    private JSType getTypeAtSwitchClause(@Nullable JSType type, @NotNull JSSwitchStatement statement, int start, int end) {
        JSExpression expression;
        if (statement == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(9);
        }
        if (JSTypeGuardChecker.isMatchingReference((PsiElement)this.myReference, (PsiElement)(expression = statement.getSwitchExpression()))) {
            return this.narrowTypeBySwitchOnDiscriminant(type, statement, start, end);
        }
        if (expression instanceof JSReferenceExpression && this.isMatchingReferenceDiscriminant(this.myDeclaredType, (PsiElement)expression)) {
            return this.narrowTypeByDiscriminant(type, (JSReferenceExpression)expression, (Function<JSType, JSType>)((Function)t -> {
                if (statement == null) {
                    JSTypeGuardChecker.$$$reportNull$$$0(24);
                }
                return this.narrowTypeBySwitchOnDiscriminant((JSType)t, statement, start, end);
            }));
        }
        return null;
    }

    private JSType narrowTypeBySwitchOnDiscriminant(@Nullable JSType type, @NotNull JSSwitchStatement statement, int clauseStart, int clauseEnd) {
        JSType caseType;
        if (statement == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(10);
        }
        assert (clauseStart <= clauseEnd);
        ArrayList clauses = ContainerUtil.newArrayList((Object[])statement.getCaseClauses());
        if (clauses.size() == 0 || clauses.size() < clauseEnd) {
            return type;
        }
        List subList = clauses.subList(clauseStart, clauseEnd);
        boolean hasDefaultClause = clauseStart == clauseEnd || subList.stream().anyMatch(el -> el.isDefault());
        List<JSType> clauseTypes = subList.stream().map(el -> el.isDefault() ? new TypeScriptNeverType(this.mySource) : JSResolveUtil.getExpressionJSType(el.getCaseExpression())).filter(el -> el != null).collect(Collectors.toList());
        JSType discriminantType = JSCompositeTypeImpl.getCommonType(clauseTypes, this.mySource, true);
        JSType jSType = caseType = discriminantType instanceof TypeScriptNeverType ? discriminantType : this.replacePrimitivesWithLiterals(JSTypeFacts.filterType(type, (Predicate<JSType>)((Predicate)t -> TypeScriptTypeRelations.isTypeComparableTo(discriminantType, t, this.myProcessingContext)), (PsiElement)this.myReference), discriminantType);
        if (!hasDefaultClause) {
            return caseType;
        }
        JSType defaultType = JSTypeFacts.filterType(type, (Predicate<JSType>)((Predicate)t -> !JSTypeGuardChecker.isUnitType(t) || !this.containsType(clauseTypes, JSTypeGuardChecker.getRegularTypeOfLiteralType(t))), (PsiElement)this.myReference);
        return caseType instanceof TypeScriptNeverType ? defaultType : this.getUnionType(caseType, defaultType);
    }

    private boolean containsType(@NotNull List<JSType> types, @Nullable JSType type) {
        if (types == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(11);
        }
        for (JSType clauseType : types) {
            if (!clauseType.isEquivalentTo(type, this.myProcessingContext)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private JSType replacePrimitivesWithLiterals(@Nullable JSType typeWithPrimitives, @Nullable JSType typeWithLiterals) {
        if (typeWithPrimitives == null || typeWithLiterals == null) {
            return typeWithPrimitives;
        }
        if (!JSTypeUtils.hasTypes(typeWithLiterals, JSNumberLiteralTypeImpl.class, JSStringLiteralTypeImpl.class)) {
            return typeWithPrimitives;
        }
        typeWithLiterals = JSTypeGuardChecker.getExactType(typeWithLiterals);
        typeWithPrimitives = JSTypeGuardChecker.getExactType(typeWithPrimitives);
        JSType numberLiterals = JSTypeFacts.filterType(typeWithLiterals, (Predicate<JSType>)((Predicate)t -> t instanceof JSNumberType), (PsiElement)this.myReference);
        JSType stringLiterals = JSTypeFacts.filterType(typeWithLiterals, (Predicate<JSType>)((Predicate)t -> t instanceof JSStringType), (PsiElement)this.myReference);
        return typeWithPrimitives.transformTypeHierarchy(toProcess -> {
            if ((toProcess instanceof JSStringType || toProcess instanceof JSNumberType) && !(toProcess instanceof JSLiteralType)) {
                return toProcess instanceof JSNumberType ? numberLiterals : stringLiterals;
            }
            return toProcess;
        });
    }

    private JSType narrowTypeByTypePredicate(@Nullable JSType rawType, JSExpression expr, boolean assumeTrue) {
        if (!this.myIsTypeScript) {
            return rawType;
        }
        JSType expressionTypeRaw = JSResolveUtil.getExpressionJSType(expr);
        JSType expressionJSType = JSTypeGuardChecker.getExactType(expressionTypeRaw);
        if (!(expressionJSType instanceof TypeScriptTypePredicateTypeImpl)) {
            return rawType;
        }
        TypeScriptTypePredicateTypeImpl typePredicate = (TypeScriptTypePredicateTypeImpl)expressionJSType;
        JSType guardType = typePredicate.getGuardType();
        if (guardType == null) {
            return rawType;
        }
        guardType = JSTypeGuardChecker.getExactType(guardType);
        JSType type = JSTypeGuardChecker.getExactType(rawType);
        if (JSTypeGuardChecker.isSourceTypeAnyAndTargetTypeFunctionOrObject(type, guardType)) {
            return type;
        }
        JSExpression argument = JSTypeGuardChecker.getExpressionUnderGuard(typePredicate, expr);
        if (!(argument instanceof JSReferenceExpression)) {
            return rawType;
        }
        if (!JSTypeGuardChecker.isMatchingReference((PsiElement)this.myReference, (PsiElement)argument)) {
            return rawType;
        }
        if (type instanceof JSAnyType) {
            return rawType;
        }
        JSType narrowedType = this.getNarrowedType(type, guardType, assumeTrue, TypeScriptTypeRelations::isTypeSubtypeOf);
        return JSTypeGuardChecker.processNeverType(type, narrowedType);
    }

    private static boolean isSourceTypeAnyAndTargetTypeFunctionOrObject(@Nullable JSType type, @Nullable JSType guardType) {
        return type instanceof JSAnyType && (guardType instanceof JSPrimitiveFunctionType || guardType instanceof JSObjectType);
    }

    private static JSExpression getExpressionUnderGuard(@NotNull TypeScriptTypePredicateTypeImpl typePredicate, JSExpression expr) {
        if (typePredicate == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(12);
        }
        if (typePredicate.isThisParameter()) {
            JSExpression qualifier;
            JSExpression jSExpression = qualifier = expr instanceof JSCallExpression ? ((JSCallExpression)expr).getMethodExpression() : expr;
            if (qualifier instanceof JSReferenceExpression) {
                return ((JSReferenceExpression)qualifier).getQualifier();
            }
            return null;
        }
        if (!(expr instanceof JSCallExpression)) {
            return null;
        }
        JSCallExpression callExpression = (JSCallExpression)expr;
        int index = typePredicate.getParameterIndex();
        if (index < 0) {
            return null;
        }
        JSExpression[] arguments = callExpression.getArguments();
        if (arguments.length <= index) {
            return null;
        }
        return arguments[index];
    }

    @Nullable
    private JSType narrowType(@Nullable JSType type, @Nullable JSExpression expression, boolean assumeTrue) {
        if ((expression instanceof JSSuperExpression || expression instanceof JSThisExpression || expression instanceof JSReferenceExpression) && this.myIsTypeScript) {
            return this.narrowTypeByTruthiness(type, expression, assumeTrue);
        }
        if (expression instanceof JSCallExpression) {
            return this.narrowTypeByTypePredicate(type, expression, assumeTrue);
        }
        if (expression instanceof JSParenthesizedExpression) {
            return this.narrowType(type, ((JSParenthesizedExpression)expression).getInnerExpression(), assumeTrue);
        }
        if (expression instanceof JSBinaryExpression) {
            return this.narrowTypeByBinaryExpression(type, (JSBinaryExpression)expression, assumeTrue);
        }
        if (expression instanceof JSPrefixExpression && ((JSPrefixExpression)expression).getOperationSign() == JSTokenTypes.EXCL) {
            return this.narrowType(type, ((JSPrefixExpression)expression).getExpression(), !assumeTrue);
        }
        return type;
    }

    @Nullable
    private JSType narrowTypeByTruthiness(@Nullable JSType type, @Nullable JSExpression expression, boolean assumeTrue) {
        if (JSTypeGuardChecker.isMatchingReference((PsiElement)this.myReference, (PsiElement)expression)) {
            return JSTypeGuardChecker.processNeverType(type, JSTypeFacts.TYPE_FACTS.getTypeWithFact(type, assumeTrue ? JSTypeFacts.SimpleFact.Truthy : JSTypeFacts.SimpleFact.Falsy, (PsiElement)this.myReference));
        }
        if (this.isMatchingReferenceDiscriminant(this.myDeclaredType, (PsiElement)expression) && expression instanceof JSReferenceExpression) {
            return this.narrowTypeByDiscriminant(type, (JSReferenceExpression)expression, (Function<JSType, JSType>)((Function)el -> JSTypeFacts.TYPE_FACTS.getTypeWithFact((JSType)el, assumeTrue ? JSTypeFacts.SimpleFact.Truthy : JSTypeFacts.SimpleFact.Falsy, (PsiElement)this.myReference)));
        }
        if (JSTypeGuardChecker.containsMatchingReferenceDiscriminant((PsiElement)this.myReference, (PsiElement)expression)) {
            return this.myDeclaredType;
        }
        return type;
    }

    private static boolean containsMatchingReferenceDiscriminant(@Nullable PsiElement source, @Nullable PsiElement target) {
        if (source == null || target == null) {
            return false;
        }
        if (!(target instanceof JSReferenceExpression)) {
            return false;
        }
        JSReferenceExpression targetRefExpression = (JSReferenceExpression)target;
        String name = targetRefExpression.getReferenceName();
        if (StringUtil.isEmpty((String)name)) {
            return false;
        }
        JSExpression targetQualifier = targetRefExpression.getQualifier();
        if (!JSTypeGuardChecker.containsMatchingReference(source, (PsiElement)targetQualifier)) {
            return false;
        }
        JSType type = JSResolveUtil.getExpressionJSType(targetQualifier);
        return JSTypeGuardChecker.isDiscriminantProperty(type, name);
    }

    @Contract(value="_,null -> false")
    private static boolean containsMatchingReference(@Nullable PsiElement source, @Nullable PsiElement target) {
        while (JSTypeGuardChecker.isPropertyAccessExpression(source)) {
            if (!JSTypeGuardChecker.isMatchingReference(source = ((JSReferenceExpression)source).getQualifier(), target)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private JSType narrowTypeByDiscriminant(@Nullable JSType type, @NotNull JSReferenceExpression expression, @NotNull Function<JSType, JSType> convertType) {
        JSType narrowedPropType;
        String name;
        if (expression == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(13);
        }
        if (convertType == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(14);
        }
        if ((name = expression.getReferenceName()) == null) {
            return type;
        }
        JSType propType = JSTypeGuardChecker.getTypeOfPropertyOfType(type, name);
        JSType jSType = narrowedPropType = propType == null ? null : (JSType)convertType.fun((Object)propType);
        if (narrowedPropType == null) {
            return type;
        }
        JSType result = propType == narrowedPropType ? type : JSTypeFacts.filterType(type, (Predicate<JSType>)((Predicate)el -> TypeScriptTypeRelations.isTypeComparableTo(JSTypeGuardChecker.getTypeOfPropertyOfType(el, name), narrowedPropType, this.myProcessingContext)), (PsiElement)this.myReference);
        return JSTypeGuardChecker.processNeverType(type, result);
    }

    @Nullable
    private static JSType getTypeOfPropertyOfType(@Nullable JSType type, @NotNull String propertyName) {
        if (propertyName == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(15);
        }
        if (type == null) {
            return null;
        }
        JSRecordType recordType = type.asRecordType();
        JSRecordType.PropertySignature signature = recordType.findPropertySignature(propertyName);
        return signature == null ? null : signature.getType();
    }

    private static boolean isMatchingReference(@Nullable PsiElement source, @Nullable PsiElement target) {
        if (target == null || source == null) {
            return false;
        }
        if (source instanceof JSReferenceExpression && target instanceof JSReferenceExpression) {
            String sourceName;
            String targetName = ((JSReferenceExpression)target).getReferenceName();
            if (!StringUtil.equals((CharSequence)targetName, (CharSequence)(sourceName = ((JSReferenceExpression)source).getReferenceName()))) {
                return false;
            }
            JSExpression targetQualifier = ((JSReferenceExpression)target).getQualifier();
            JSExpression sourceQualifier = ((JSReferenceExpression)source).getQualifier();
            if (targetQualifier == null) {
                return sourceQualifier == null;
            }
            return JSTypeGuardChecker.isMatchingReference((PsiElement)targetQualifier, (PsiElement)sourceQualifier);
        }
        if (source instanceof JSThisExpression && target instanceof JSThisExpression) {
            return true;
        }
        return source instanceof JSSuperExpression && target instanceof JSSuperExpression;
    }

    private static boolean isPropertyAccessExpression(@Nullable PsiElement element) {
        return element instanceof JSReferenceExpression && ((JSReferenceExpression)element).getQualifier() != null;
    }

    @Nullable
    private JSType narrowTypeByBinaryExpression(@Nullable JSType type, JSBinaryExpression expression, boolean assumeTrue) {
        IElementType sign = expression.getOperationSign();
        if (sign == null) {
            return type;
        }
        if (sign == JSTokenTypes.ANDAND) {
            return this.narrowTypeByAnd(type, expression, assumeTrue);
        }
        if (sign == JSTokenTypes.OROR) {
            return this.narrowTypeByOr(type, expression, assumeTrue);
        }
        if (sign == JSTokenTypes.EQ) {
            return this.narrowTypeByTruthiness(type, expression.getLOperand(), assumeTrue);
        }
        if (sign == JSTokenTypes.INSTANCEOF_KEYWORD) {
            return this.narrowTypeByInstanceof(type, expression, assumeTrue);
        }
        if (sign == JSTokenTypes.COMMA) {
            return this.narrowType(type, expression.getROperand(), assumeTrue);
        }
        if (sign == JSTokenTypes.EQEQ || sign == JSTokenTypes.NE || sign == JSTokenTypes.NEQEQ || sign == JSTokenTypes.EQEQEQ) {
            JSExpression left = JSTypeGuardChecker.getReferenceCandidate(expression.getLOperand());
            JSExpression right = JSTypeGuardChecker.getReferenceCandidate(expression.getROperand());
            if (left == null || right == null) {
                return type;
            }
            JSPrefixExpression leftTypeOf = JSTypeGuardChecker.getTypeOfPrefixExpression(left);
            if (leftTypeOf != null && JSTypeGuardChecker.isStringLiteralExpression(right)) {
                return this.narrowTypeByTypeof(type, leftTypeOf, sign, (JSLiteralExpression)right, assumeTrue);
            }
            JSPrefixExpression rightTypeOf = JSTypeGuardChecker.getTypeOfPrefixExpression(right);
            if (rightTypeOf != null && JSTypeGuardChecker.isStringLiteralExpression(left)) {
                return this.narrowTypeByTypeof(type, rightTypeOf, sign, (JSLiteralExpression)left, assumeTrue);
            }
            if (JSTypeGuardChecker.isMatchingReference((PsiElement)this.myReference, (PsiElement)left)) {
                return this.narrowTypeByEquality(type, sign, right, assumeTrue);
            }
            if (JSTypeGuardChecker.isMatchingReference((PsiElement)this.myReference, (PsiElement)right)) {
                return this.narrowTypeByEquality(type, sign, left, assumeTrue);
            }
            if (left instanceof JSReferenceExpression && this.isMatchingReferenceDiscriminant(this.myDeclaredType, (PsiElement)left)) {
                return this.narrowTypeByDiscriminant(type, (JSReferenceExpression)left, (Function<JSType, JSType>)((Function)el -> this.narrowTypeByEquality((JSType)el, sign, right, assumeTrue)));
            }
            if (right instanceof JSReferenceExpression && this.isMatchingReferenceDiscriminant(this.myDeclaredType, (PsiElement)right)) {
                return this.narrowTypeByDiscriminant(type, (JSReferenceExpression)right, (Function<JSType, JSType>)((Function)el -> this.narrowTypeByEquality((JSType)el, sign, left, assumeTrue)));
            }
        }
        return type;
    }

    private JSType narrowTypeByTypeof(@Nullable JSType type, @NotNull JSPrefixExpression typeOfExpr, @NotNull IElementType sign, @NotNull JSLiteralExpression literal, boolean assumeTrue) {
        JSType primitiveType;
        JSExpression target;
        if (typeOfExpr == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(16);
        }
        if (sign == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(17);
        }
        if (literal == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(18);
        }
        if (!JSTypeGuardChecker.isMatchingReference((PsiElement)this.myReference, (PsiElement)(target = JSTypeGuardChecker.getReferenceCandidate(typeOfExpr.getExpression())))) {
            return type;
        }
        if (JSTypeGuardChecker.isNegativeSign(sign)) {
            assumeTrue = false;
        }
        if ((type = JSTypeGuardChecker.getExactType(type)) == null) {
            return null;
        }
        String value = (String)literal.getValue();
        if (StringUtil.isEmpty((String)value)) {
            return type;
        }
        if (assumeTrue && !(type instanceof JSCompositeTypeImpl) && JSTypeGuardChecker.isPrimitiveType(value) && TypeScriptTypeRelations.isTypeSubtypeOf(primitiveType = this.buildPrimitiveType(value), type, this.myProcessingContext)) {
            return primitiveType;
        }
        JSTypeFacts.SimpleFact fact = JSTypeGuardChecker.getFactsForPrimitiveType(value, assumeTrue);
        return JSTypeFacts.TYPE_FACTS.getTypeWithFact(type, fact, (PsiElement)this.myReference);
    }

    @NotNull
    private static JSTypeFacts.SimpleFact getFactsForPrimitiveType(@NotNull String value, boolean assumeTrue) {
        JSTypeFacts.SimpleFact fact;
        if (value == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(19);
        }
        if (assumeTrue) {
            fact = JSTypeFacts.typeofEQFacts.get(value);
            if (fact == null) {
                JSTypeFacts.SimpleFact simpleFact = JSTypeFacts.SimpleFact.TypeofEQHostObject;
                if (simpleFact == null) {
                    JSTypeGuardChecker.$$$reportNull$$$0(20);
                }
                return simpleFact;
            }
        } else {
            fact = JSTypeFacts.typeofNEFacts.get(value);
            if (fact == null) {
                JSTypeFacts.SimpleFact simpleFact = JSTypeFacts.SimpleFact.TypeofNEHostObject;
                if (simpleFact == null) {
                    JSTypeGuardChecker.$$$reportNull$$$0(21);
                }
                return simpleFact;
            }
        }
        JSTypeFacts.SimpleFact simpleFact = fact;
        if (simpleFact == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(22);
        }
        return simpleFact;
    }

    private static boolean isStringLiteralExpression(@Nullable JSExpression right) {
        return right instanceof JSLiteralExpression && ((JSLiteralExpression)right).isQuotedLiteral();
    }

    @Nullable
    private static JSExpression getReferenceCandidate(@Nullable JSExpression expression) {
        if (expression instanceof JSParenthesizedExpression) {
            return JSTypeGuardChecker.getReferenceCandidate(((JSParenthesizedExpression)expression).getInnerExpression());
        }
        if (expression instanceof JSBinaryExpression) {
            IElementType sign = ((JSBinaryExpression)expression).getOperationSign();
            if (sign == JSTokenTypes.EQ) {
                return JSTypeGuardChecker.getReferenceCandidate(((JSBinaryExpression)expression).getLOperand());
            }
            if (sign == JSTokenTypes.COMMA) {
                return JSTypeGuardChecker.getReferenceCandidate(((JSBinaryExpression)expression).getROperand());
            }
        }
        return expression;
    }

    @Nullable
    private JSType getUnionType(@Nullable JSType type1, @Nullable JSType type2) {
        if (type1 == null) {
            return type2;
        }
        if (type2 == null) {
            return type1;
        }
        return JSCompositeTypeImpl.getCommonType(type1, type2, this.mySource, false);
    }

    private static boolean isPrimitiveType(String name) {
        return ArrayUtil.contains((String)name, (String[])TYPE_NAMES);
    }

    @NotNull
    private JSType buildPrimitiveType(String name) {
        JSType jSType = JSNamedType.createType(name, this.mySource, JSContext.INSTANCE);
        if (jSType == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(23);
        }
        return jSType;
    }

    @Contract(value="!null -> !null")
    private static JSType getExactType(@Nullable JSType type) {
        JSType defType;
        if (null == type) {
            return null;
        }
        JSType valuableType = JSTypeUtils.getValuableType(type);
        if (valuableType instanceof JSTypeImpl && ((JSTypeImpl)valuableType).isTypeScript() && (defType = ((JSTypeImpl)valuableType).getTypedef(null, new ProcessingContext())) != null) {
            valuableType = defType;
        }
        return valuableType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topReferenceName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: 
            case 7: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sign";
                break;
            }
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 8: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 9: 
            case 10: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typePredicate";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertType";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeOfExpr";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/guard/JSTypeGuardChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/JSTypeGuardChecker";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactsForPrimitiveType";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPrimitiveType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "narrowTypeForCase";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "narrowTypeByEquality";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isDiscriminantProperty";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isNegativeSign";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNarrowedType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAtSwitchClause";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "narrowTypeBySwitchOnDiscriminant";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "containsType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionUnderGuard";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "narrowTypeByDiscriminant";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTypeOfPropertyOfType";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "narrowTypeByTypeof";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getFactsForPrimitiveType";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getTypeAtSwitchClause$4";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getNarrowedType$3";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getNarrowedType$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface TypeRelation {
        public boolean isRelated(@Nullable JSType var1, @Nullable JSType var2, @Nullable ProcessingContext var3);
    }
}

