/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.intellij.util.ui.UIUtil;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSGetterSetterRenameUtil {
    private JSGetterSetterRenameUtil() {
    }

    public static boolean isFieldWithAccessors(PsiElement element) {
        if (!(element instanceof JSVariable)) {
            return false;
        }
        String name = ((JSVariable)element).getName();
        PsiElement parent = JSResolveUtil.findParent(element);
        if (!(parent instanceof JSClass)) {
            return false;
        }
        JSClass jsClass = (JSClass)parent;
        String accessorName = JSRefactoringUtil.transformVarNameToAccessorName(name, element.getProject());
        return jsClass.findFunctionByNameAndKind(accessorName, JSFunction.FunctionKind.GETTER) != null || jsClass.findFunctionByNameAndKind(accessorName, JSFunction.FunctionKind.SETTER) != null;
    }

    @Nullable
    static JSFunction.FunctionKind getFunctionKindToSearch(JSFunction function) {
        JSFunction.FunctionKind toFind = null;
        if (function.isGetProperty()) {
            toFind = JSFunction.FunctionKind.SETTER;
        } else if (function.isSetProperty()) {
            toFind = JSFunction.FunctionKind.GETTER;
        }
        return toFind;
    }

    public static void addGetterSetterRelatedElements(PsiElement element, @NotNull JSClass parent, String newName, Map<PsiElement, String> allRenames) {
        if (parent == null) {
            JSGetterSetterRenameUtil.$$$reportNull$$$0(0);
        }
        if (JSGetterSetterRenameUtil.isGetterSetterFunction(element)) {
            JSFunction function = (JSFunction)element;
            JSFunction.FunctionKind toFind = JSGetterSetterRenameUtil.getFunctionKindToSearch(function);
            if (toFind != null) {
                JSField field;
                Project project;
                String expectedFieldName;
                String funName = function.getName();
                JSFunction oppositePropertyFunction = parent.findFunctionByNameAndKind(funName, toFind);
                if (oppositePropertyFunction != null) {
                    allRenames.put((PsiElement)oppositePropertyFunction, newName);
                }
                if ((expectedFieldName = JSRefactoringUtil.transformAccessorNameToPropertyName(funName, project = element.getProject())) != null && !expectedFieldName.equals(funName) && (field = parent.findFieldByName(expectedFieldName)) != null) {
                    allRenames.put((PsiElement)field, JSRefactoringUtil.transformAccessorNameToPropertyName(newName, project));
                }
            }
        } else if (element instanceof JSVariable) {
            Project project;
            String name = ((JSVariable)element).getName();
            String expectedPropertyName = JSRefactoringUtil.transformVarNameToAccessorName(name, project = element.getProject());
            if (!StringUtil.equals((CharSequence)expectedPropertyName, (CharSequence)name)) {
                JSFunction getter = parent.findFunctionByNameAndKind(expectedPropertyName, JSFunction.FunctionKind.GETTER);
                JSFunction setter = parent.findFunctionByNameAndKind(expectedPropertyName, JSFunction.FunctionKind.SETTER);
                String accessorNewName = JSRefactoringUtil.transformVarNameToAccessorName(newName, project);
                if (!(getter == null && setter == null || ApplicationManager.getApplication().isUnitTestMode() || Messages.showYesNoDialog((String)JSBundle.message((String)"rename.accessors.dialog.text", (Object[])new Object[]{accessorNewName}), (String)JSBundle.message((String)"rename.accessors.dialog.title", (Object[])new Object[0]), (Icon)UIUtil.getQuestionIcon()) == 0)) {
                    getter = null;
                    setter = null;
                }
                if (getter != null) {
                    allRenames.put((PsiElement)getter, accessorNewName);
                }
                if (setter != null) {
                    allRenames.put((PsiElement)setter, accessorNewName);
                }
            }
            JSResolveUtil.processHierarchy(parent, (Processor<JSClass>)((Processor)aClass -> {
                JSFunction setter;
                if (!aClass.isInterface()) {
                    return true;
                }
                JSFunction getter = aClass.findFunctionByNameAndKind(name, JSFunction.FunctionKind.GETTER);
                if (getter != null) {
                    allRenames.put((PsiElement)getter, newName);
                }
                if ((setter = aClass.findFunctionByNameAndKind(name, JSFunction.FunctionKind.SETTER)) != null) {
                    allRenames.put((PsiElement)setter, newName);
                }
                return true;
            }), true);
        }
    }

    public static boolean isGetterSetterFunction(@NotNull PsiElement element) {
        if (element == null) {
            JSGetterSetterRenameUtil.$$$reportNull$$$0(1);
        }
        return element instanceof JSFunction && (((JSFunction)element).isGetProperty() || ((JSFunction)element).isSetProperty());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/refactoring/JSGetterSetterRenameUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addGetterSetterRelatedElements";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isGetterSetterFunction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

