/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSFlexAdapter;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JSNamesValidator
implements NamesValidator {
    protected final Lexer myLexer;
    private final DialectOptionHolder myDialect;

    JSNamesValidator(DialectOptionHolder optionHolder) {
        this.myLexer = this.createLexer(optionHolder);
        this.myDialect = optionHolder;
    }

    protected Lexer createLexer(DialectOptionHolder optionHolder) {
        return new JSFlexAdapter(optionHolder);
    }

    public synchronized boolean isKeyword(@NotNull String name, Project project) {
        if (name == null) {
            JSNamesValidator.$$$reportNull$$$0(0);
        }
        this.myLexer.start((CharSequence)name);
        return JSNamesValidator.getKeywords(this.myDialect).contains(this.myLexer.getTokenType()) && this.myLexer.getTokenEnd() == name.length();
    }

    public synchronized boolean isIdentifier(@NotNull String name, Project project) {
        if (name == null) {
            JSNamesValidator.$$$reportNull$$$0(1);
        }
        this.myLexer.start((CharSequence)name);
        return JSNamesValidator.getIdentifiers(this.myDialect).contains(this.myLexer.getTokenType()) && this.myLexer.getTokenEnd() == name.length();
    }

    @NotNull
    public static TokenSet getKeywords(@Nullable DialectOptionHolder dialect) {
        if (dialect != null) {
            if (dialect.isECMA4) {
                TokenSet tokenSet = JSKeywordSets.AS_KEYWORDS;
                if (tokenSet == null) {
                    JSNamesValidator.$$$reportNull$$$0(2);
                }
                return tokenSet;
            }
            if (dialect.isECMA6) {
                TokenSet tokenSet = JSKeywordSets.ES6_RESERVED_WORDS;
                if (tokenSet == null) {
                    JSNamesValidator.$$$reportNull$$$0(3);
                }
                return tokenSet;
            }
        }
        TokenSet tokenSet = JSKeywordSets.JS_RESERVED_AND_STRICT_KEYWORDS;
        if (tokenSet == null) {
            JSNamesValidator.$$$reportNull$$$0(4);
        }
        return tokenSet;
    }

    @NotNull
    public static TokenSet getIdentifiers(@Nullable DialectOptionHolder dialect) {
        if (dialect != null) {
            if (dialect.isECMA4) {
                TokenSet tokenSet = JSKeywordSets.AS_IDENTIFIER_TOKENS_SET;
                if (tokenSet == null) {
                    JSNamesValidator.$$$reportNull$$$0(5);
                }
                return tokenSet;
            }
            if (dialect.isTypeScript) {
                TokenSet tokenSet = JSKeywordSets.TS_IDENTIFIERS_TOKENS_SET;
                if (tokenSet == null) {
                    JSNamesValidator.$$$reportNull$$$0(6);
                }
                return tokenSet;
            }
            if (dialect.isJavaScript()) {
                TokenSet tokenSet = JSKeywordSets.JS_IDENTIFIER_TOKENS_SET;
                if (tokenSet == null) {
                    JSNamesValidator.$$$reportNull$$$0(7);
                }
                return tokenSet;
            }
        }
        TokenSet tokenSet = JSKeywordSets.IDENTIFIER_TOKENS_SET;
        if (tokenSet == null) {
            JSNamesValidator.$$$reportNull$$$0(8);
        }
        return tokenSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/JSNamesValidator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/JSNamesValidator";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdentifiers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isKeyword";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isIdentifier";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

