/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.changeSignature;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.lang.javascript.psi.JSElementFactory;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureDialog;
import com.intellij.lang.javascript.refactoring.changeSignature.JSParameterInfo;
import com.intellij.lang.javascript.refactoring.changeSignature.JSParameterTableModelItem;
import com.intellij.lang.javascript.refactoring.ui.JSEditorTextField;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.IntentionFilterOwner;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.ProjectScope;
import com.intellij.refactoring.changeSignature.ParameterTableModelBase;
import com.intellij.refactoring.changeSignature.ParameterTableModelItemBase;
import com.intellij.refactoring.ui.CodeFragmentTableCellEditorBase;
import com.intellij.refactoring.ui.CodeFragmentTableCellRenderer;
import com.intellij.refactoring.ui.StringTableCellEditor;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.ColumnInfo;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSParameterTableModel
extends ParameterTableModelBase<JSParameterInfo, JSParameterTableModelItem> {
    private static final IntentionFilterOwner.IntentionActionsFilter intentionsNotAvailable = intentionAction -> false;

    public JSParameterTableModel(@NotNull PsiElement defaultValueContext, @Nullable String defaultValueColumnTitle, boolean showTypeColumn, boolean showInitializerColumn, boolean showOptionalColumn) {
        if (defaultValueContext == null) {
            JSParameterTableModel.$$$reportNull$$$0(0);
        }
        super(defaultValueContext, defaultValueContext, JSParameterTableModel.getColumns(defaultValueContext.getProject(), defaultValueColumnTitle, showTypeColumn, showInitializerColumn, showOptionalColumn, JSChangeSignatureDialog.getFileTypeFromContext(defaultValueContext)));
    }

    private static ColumnInfo[] getColumns(Project project, @Nullable String defaultValueColumnTitle, boolean showTypeColumn, boolean showInitializerColumn, boolean showOptionalColumn, LanguageFileType dialect) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (showTypeColumn) {
            result.add((Object)new JSTypeColumn(project, dialect));
        }
        result.add((Object)new DeclarationColumn(project));
        if (showInitializerColumn) {
            result.add((Object)new InitializerColumn(project, dialect));
        }
        if (defaultValueColumnTitle != null) {
            result.add(new ParameterTableModelBase.DefaultValueColumn(project, (FileType)dialect, defaultValueColumnTitle));
        }
        if (showOptionalColumn) {
            result.add((Object)new OptionalFlagColumn());
        }
        return result.toArray(new ColumnInfo[result.size()]);
    }

    protected JSParameterTableModelItem createRowItem(@Nullable JSParameterInfo parameterInfo) {
        if (parameterInfo == null) {
            parameterInfo = new JSParameterInfo("", "", "", "", -1, false, DialectDetector.dialectOfElement(this.myDefaultValueContext));
        }
        JSExpressionCodeFragment paramTypeCodeFragment = JSParameterTableModel.createParameterTypeCellFragment(parameterInfo.getTypeText(), this.myDefaultValueContext);
        JSExpressionCodeFragment defaultValueCodeFragment = JSParameterTableModel.createDefaultValueCellFragment(parameterInfo.getDefaultValue(), this.myDefaultValueContext);
        JSExpressionCodeFragment initializerCodeFragment = JSParameterTableModel.createInitializerCellFragment(parameterInfo.getInitializer(), this.myDefaultValueContext);
        return new JSParameterTableModelItem(parameterInfo, paramTypeCodeFragment, defaultValueCodeFragment, initializerCodeFragment);
    }

    public static JSExpressionCodeFragment createParameterTypeCellFragment(String text, PsiElement context) {
        JSExpressionCodeFragment fragment = JSElementFactory.createExpressionCodeFragment(context.getProject(), StringUtil.notNullize((String)text), context, JSChangeSignatureDialog.getDialectFromContext(context), ProjectScope.getAllScope((Project)context.getProject()), JSElementFactory.TopLevelCompletion.YES, JavaScriptParserBase.ForceContext.Parameter);
        fragment.setIntentionActionsFilter(intentionsNotAvailable);
        return fragment;
    }

    public static JSExpressionCodeFragment createDefaultValueCellFragment(String text, PsiElement context) {
        return JSParameterTableModel.createInitializerCellFragment(StringUtil.notNullize((String)text), context);
    }

    public static JSExpressionCodeFragment createInitializerCellFragment(String text, PsiElement context) {
        JSExpressionCodeFragment fragment = JSElementFactory.createExpressionCodeFragment(context.getProject(), StringUtil.notNullize((String)text), context, JSChangeSignatureDialog.getDialectFromContext(context), ProjectScope.getProjectScope((Project)context.getProject()), JSElementFactory.TopLevelCompletion.LITERAL_VALUES, null);
        fragment.setIntentionActionsFilter(intentionsNotAvailable);
        return fragment;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValueContext", "com/intellij/lang/javascript/refactoring/changeSignature/JSParameterTableModel", "<init>"));
    }

    private static class OptionalFlagColumn
    extends ColumnInfo<ParameterTableModelItemBase<JSParameterInfo>, Boolean> {
        public OptionalFlagColumn() {
            super(JSBundle.message((String)"change.signature.column.name.optional.flag", (Object[])new Object[0]));
        }

        public boolean isCellEditable(ParameterTableModelItemBase<JSParameterInfo> item) {
            return !item.isEllipsisType() && ((JSParameterInfo)item.parameter).getOldIndex() == -1;
        }

        public Boolean valueOf(ParameterTableModelItemBase<JSParameterInfo> item) {
            return ((JSParameterInfo)((JSParameterTableModelItem)item).parameter).isOptional();
        }

        public void setValue(ParameterTableModelItemBase<JSParameterInfo> item, Boolean value) {
            ((JSParameterInfo)((JSParameterTableModelItem)item).parameter).setOptional(value);
        }

        public TableCellRenderer getRenderer(ParameterTableModelItemBase<JSParameterInfo> jsParameterInfoParameterTableModelItemBase) {
            return new BooleanTableCellRenderer();
        }

        public TableCellEditor getEditor(ParameterTableModelItemBase<JSParameterInfo> o) {
            return new BooleanTableCellEditor(false);
        }

        public int getWidth(JTable table) {
            return 55;
        }
    }

    private static class InitializerColumn
    extends ParameterTableModelBase.ColumnInfoBase<JSParameterInfo, JSParameterTableModelItem, PsiCodeFragment> {
        private final Project myProject;
        private final LanguageFileType myLanguageFileType;

        public InitializerColumn(Project project, LanguageFileType languageFileType) {
            super(JSBundle.message((String)"change.signature.column.name.initializer", (Object[])new Object[0]));
            this.myProject = project;
            this.myLanguageFileType = languageFileType;
        }

        public boolean isCellEditable(JSParameterTableModelItem item) {
            return !((JSParameterInfo)item.parameter).isRest() && !((JSParameterInfo)item.parameter).isDeclaredOptional();
        }

        public PsiCodeFragment valueOf(JSParameterTableModelItem item) {
            return item.initializerCodeFragment;
        }

        public TableCellRenderer doCreateRenderer(JSParameterTableModelItem item) {
            return new CodeFragmentTableCellRenderer(this.myProject, (FileType)this.myLanguageFileType);
        }

        public TableCellEditor doCreateEditor(JSParameterTableModelItem item) {
            return new CodeFragmentTableCellEditorBase(this.myProject, (FileType)this.myLanguageFileType){

                protected EditorTextField createEditorField(Document document) {
                    return new JSEditorTextField(myProject, document, false, null);
                }
            };
        }
    }

    private static class DeclarationColumn
    extends ParameterTableModelBase.ColumnInfoBase<JSParameterInfo, JSParameterTableModelItem, String> {
        private final Project myProject;

        public DeclarationColumn(Project project) {
            super(JSBundle.message((String)"change.signature.column.name", (Object[])new Object[0]));
            this.myProject = project;
        }

        protected TableCellRenderer doCreateRenderer(JSParameterTableModelItem item) {
            return new ColoredTableCellRenderer(){

                public void customizeCellRenderer(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    if (value == null) {
                        return;
                    }
                    this.append((String)value, new SimpleTextAttributes(0, null));
                }
            };
        }

        @Nullable
        public String valueOf(JSParameterTableModelItem item) {
            return ((JSParameterInfo)item.parameter).getDeclarationText();
        }

        public void setValue(JSParameterTableModelItem item, String value) {
            ((JSParameterInfo)item.parameter).setDeclarationText(value);
        }

        public boolean isCellEditable(JSParameterTableModelItem item) {
            return !((JSParameterInfo)item.parameter).isDestructuringParameter();
        }

        public TableCellEditor doCreateEditor(JSParameterTableModelItem o) {
            return new StringTableCellEditor(this.myProject){};
        }
    }

    private static class JSTypeColumn
    extends ParameterTableModelBase.TypeColumn<JSParameterInfo, JSParameterTableModelItem> {
        private final LanguageFileType myLanguageFileType;

        public JSTypeColumn(Project project, LanguageFileType myLanguageFileType) {
            super(project, (FileType)myLanguageFileType, JSBundle.message((String)"change.signature.column.type", (Object[])new Object[0]));
            this.myLanguageFileType = myLanguageFileType;
        }

        public TableCellEditor doCreateEditor(JSParameterTableModelItem o) {
            return new CodeFragmentTableCellEditorBase(this.myProject, (FileType)this.myLanguageFileType){

                protected EditorTextField createEditorField(Document document) {
                    return new JSEditorTextField(myProject, document, false, null);
                }
            };
        }
    }
}

