/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.convertToClass;

import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.refactoring.convertToClass.JSToClassConversionConstructorFunction;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class JSToClassConversionResults {
    private final MultiMap<String, UsageInfo> myDuplicateProperties = new MultiMap();
    private final MultiMap<String, PropertyDefinitionType> myPropertyDefinitionTypes = new MultiMap();
    private final List<UsageInfo> myNotConvertedStaticDeclarations = new ArrayList<UsageInfo>();
    private final List<UsageInfo> myNotConvertedUsages = new ArrayList<UsageInfo>();

    public boolean isDuplicate(@NotNull String name, @NotNull UsageInfo usageInfo, @NotNull PropertyDefinitionType definitionType) {
        if (name == null) {
            JSToClassConversionResults.$$$reportNull$$$0(0);
        }
        if (usageInfo == null) {
            JSToClassConversionResults.$$$reportNull$$$0(1);
        }
        if (definitionType == null) {
            JSToClassConversionResults.$$$reportNull$$$0(2);
        }
        Collection types = this.myPropertyDefinitionTypes.get((Object)name);
        boolean hasDuplicate = types.contains((Object)definitionType);
        this.myDuplicateProperties.putValue((Object)name, (Object)usageInfo);
        this.myPropertyDefinitionTypes.putValue((Object)name, (Object)definitionType);
        return hasDuplicate;
    }

    public void notConvertedStatic(@NotNull UsageInfo usageInfo) {
        if (usageInfo == null) {
            JSToClassConversionResults.$$$reportNull$$$0(3);
        }
        this.myNotConvertedStaticDeclarations.add(usageInfo);
    }

    public void notConverted(@NotNull UsageInfo usageInfo) {
        if (usageInfo == null) {
            JSToClassConversionResults.$$$reportNull$$$0(4);
        }
        this.myNotConvertedUsages.add(usageInfo);
    }

    public Set<String> filterDuplicates(@NotNull JSToClassConversionConstructorFunction constructorFunction) {
        if (constructorFunction == null) {
            JSToClassConversionResults.$$$reportNull$$$0(5);
        }
        return this.filterDuplicateProperties(constructorFunction, this.myDuplicateProperties);
    }

    @NotNull
    private Set<String> filterDuplicateProperties(@NotNull JSToClassConversionConstructorFunction constructorFunction, MultiMap<String, UsageInfo> duplicateProperties) {
        List duplicateKeys;
        if (constructorFunction == null) {
            JSToClassConversionResults.$$$reportNull$$$0(6);
        }
        if ((duplicateKeys = ContainerUtil.filter((Collection)duplicateProperties.keySet(), key -> this.isDuplicated((String)key))).isEmpty()) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                JSToClassConversionResults.$$$reportNull$$$0(7);
            }
            return set;
        }
        Iterator iterator = duplicateProperties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry next = (Map.Entry)iterator.next();
            if (!duplicateKeys.contains(next.getKey())) {
                iterator.remove();
                continue;
            }
            assert (((Collection)next.getValue()).size() != 0);
            if (((Collection)next.getValue()).size() > 1) continue;
            UsageInfo usageInfo = (UsageInfo)((Collection)next.getValue()).iterator().next();
            JSAssignmentExpression innerProperty = constructorFunction.getInnerProperty((String)next.getKey());
            if (usageInfo.getElement() != null && innerProperty != null && !usageInfo.getElement().equals(innerProperty)) continue;
            iterator.remove();
        }
        Set set = duplicateProperties.keySet();
        if (set == null) {
            JSToClassConversionResults.$$$reportNull$$$0(8);
        }
        return set;
    }

    private boolean isDuplicated(@NotNull String key) {
        Collection types;
        if (key == null) {
            JSToClassConversionResults.$$$reportNull$$$0(9);
        }
        if ((types = this.myPropertyDefinitionTypes.get((Object)key)).size() > PropertyDefinitionType.values().length) {
            return true;
        }
        for (PropertyDefinitionType type : PropertyDefinitionType.values()) {
            if (types.stream().filter(t -> type.equals(t)).collect(Collectors.toList()).size() <= 1) continue;
            return true;
        }
        return false;
    }

    public List<Pair<String, UsageInfo>> previewDuplicates(@NotNull JSToClassConversionConstructorFunction constructorFunction) {
        Set<String> set;
        if (constructorFunction == null) {
            JSToClassConversionResults.$$$reportNull$$$0(10);
        }
        if ((set = this.filterDuplicateProperties(constructorFunction, (MultiMap<String, UsageInfo>)new MultiMap(this.myDuplicateProperties))).isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Pair<String, UsageInfo>> result = new ArrayList<Pair<String, UsageInfo>>();
        for (String s : set) {
            result.addAll(ContainerUtil.map((Collection)this.myDuplicateProperties.get((Object)s), info -> Pair.create((Object)s, (Object)info)));
            JSAssignmentExpression innerProperty = constructorFunction.getInnerProperty(s);
            if (innerProperty == null) continue;
            result.add((Pair<String, UsageInfo>)Pair.create((Object)s, (Object)new UsageInfo((PsiElement)innerProperty.getDefinitionExpression().getExpression())));
        }
        return result;
    }

    public List<UsageInfo> getNotConvertedUsages() {
        ArrayList<UsageInfo> list = new ArrayList<UsageInfo>();
        list.addAll(this.myNotConvertedStaticDeclarations);
        list.addAll(this.myDuplicateProperties.values());
        return list;
    }

    @NotNull
    public List<UsageInfo> getNotConvertedWithoutDuplicates() {
        ArrayList<UsageInfo> list = new ArrayList<UsageInfo>();
        list.addAll(this.myNotConvertedUsages);
        ArrayList<UsageInfo> arrayList = list;
        if (arrayList == null) {
            JSToClassConversionResults.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definitionType";
                break;
            }
            case 5: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructorFunction";
                break;
            }
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/convertToClass/JSToClassConversionResults";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/convertToClass/JSToClassConversionResults";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "filterDuplicateProperties";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotConvertedWithoutDuplicates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isDuplicate";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "notConvertedStatic";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "notConverted";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "filterDuplicates";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "filterDuplicateProperties";
                break;
            }
            case 7: 
            case 8: 
            case 11: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isDuplicated";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "previewDuplicates";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum PropertyDefinitionType {
        get,
        set,
        value;

    }
}

