/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.extractMethod;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.extractMethod.DefaultJSExtractFunctionSettings;
import com.intellij.lang.javascript.refactoring.extractMethod.ExtractedFunctionSignatureGenerator;
import com.intellij.lang.javascript.refactoring.extractMethod.JSExtractFunctionHandler;
import com.intellij.lang.javascript.refactoring.extractMethod.JSExtractFunctionSettings;
import com.intellij.lang.javascript.refactoring.introduce.BasicIntroducedEntityInfoProvider;
import com.intellij.lang.javascript.refactoring.introduce.IntroducedEntityInfoProvider;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseClassBasedIntroduceDialog;
import com.intellij.lang.javascript.refactoring.ui.JSVisibilityPanel;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.ui.MethodSignatureComponent;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSExtractFunctionDialog
extends JSBaseClassBasedIntroduceDialog<IntroducedEntityInfoProvider>
implements JSExtractFunctionSettings {
    private static final String DECLARE_AS_EXPRESSION_PROPERTY_KEY = "js.extract.function.declare.as.expression";
    private JPanel myPanel;
    private NameSuggestionsField myFunctionName;
    private JSVisibilityPanel myVisibilityPanel;
    private EditorComboBox myVarType;
    private MethodSignatureComponent myPreviewText;
    private JTable parametersTable;
    private JPanel myVarTypePanel;
    private JCheckBox myDeclareStaticCheckBox;
    private JCheckBox myDeclareAsFunctionExpression;
    private JLabel myNameLabel;
    private JPanel myToolbarDecoratorPanel;
    private JSExtractFunctionSettings.ParametersInfo parametersInfo;
    private ExtractedFunctionSignatureGenerator mySignatureGenerator;
    private JSExtractFunctionHandler.ContextInfo contextInfo;
    private JSExtractFunctionHandler.IntroductionScope myIntroductionScope;

    public JSExtractFunctionDialog(final PsiElement context, ExtractedFunctionSignatureGenerator signatureGenerator, JSExtractFunctionHandler.ContextInfo ci, @NotNull JSExtractFunctionHandler.IntroductionScope introductionScope) {
        if (introductionScope == null) {
            JSExtractFunctionDialog.$$$reportNull$$$0(0);
        }
        super(context.getProject(), new IntroducedEntityInfoProvider(){

            @Override
            public int getOccurrenceCount() {
                return 0;
            }

            @Override
            @Nullable
            public String evaluateType() {
                return null;
            }

            @Override
            public PsiFile getContainingFile() {
                return context.getContainingFile();
            }

            @Override
            public String[] suggestCandidateNames() {
                return new String[]{"extracted"};
            }

            @Override
            public boolean checkConflicts(@NotNull String name, boolean replaceAllOccurrences) {
                if (name == null) {
                    1.$$$reportNull$$$0(0);
                }
                return true;
            }

            @Override
            public PsiElement findNamedElementInScope(@NotNull String name, PsiElement place) {
                if (name == null) {
                    1.$$$reportNull$$$0(1);
                }
                return BasicIntroducedEntityInfoProvider.findExistingInScope(name, place, JSResolveUtil.calculateStaticFromContext(place));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "name";
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractFunctionDialog$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkConflicts";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "findNamedElementInScope";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, "javascript.extract.method.title");
        this.contextInfo = ci;
        this.myIntroductionScope = introductionScope;
        this.mySignatureGenerator = signatureGenerator;
        this.$$$setupUI$$$();
        ChangeListener listener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSExtractFunctionDialog.this.initiateValidation();
            }
        };
        this.myVisibilityPanel.addListener(listener);
        this.myDeclareAsFunctionExpression.addChangeListener(listener);
        this.myDeclareAsFunctionExpression.setFocusable(true);
        this.myDeclareStaticCheckBox.addChangeListener(listener);
        this.myDeclareStaticCheckBox.setFocusable(true);
        this.myDeclareAsFunctionExpression.setSelected(PropertiesComponent.getInstance().getBoolean(DECLARE_AS_EXPRESSION_PROPERTY_KEY));
        boolean isClassContext = this.getIntroductionScope().isClassContext();
        this.myVisibilityPanel.setVisible(isClassContext);
        this.myDeclareAsFunctionExpression.setVisible(!this.contextInfo.ecmaL4);
        this.myDeclareAsFunctionExpression.setEnabled(!this.getIntroductionScope().forceMakeFunExpr);
        this.myVarTypePanel.setVisible(false);
        this.myDeclareStaticCheckBox.setVisible(isClassContext);
        if (isClassContext) {
            this.myDeclareStaticCheckBox.setEnabled(!JSResolveUtil.calculateStaticFromContext(context));
            if (!DialectDetector.isActionScript(context)) {
                this.myDeclareAsFunctionExpression.setSelected(true);
                this.myDeclareAsFunctionExpression.setVisible(false);
            }
        }
        this.myVisibilityPanel.configureOptions(false, false, DialectDetector.dialectOfElement(context));
        this.doInit();
    }

    private void swapVars(int selectedRow, int anotherRow) {
        JSVariable var = this.parametersInfo.variables.get(selectedRow);
        this.parametersInfo.variables.set(selectedRow, this.parametersInfo.variables.get(anotherRow));
        this.parametersInfo.variables.set(anotherRow, var);
    }

    private void changeRowNumber(int selectedRow, int newValue) {
        JSVariable currentVar = this.parametersInfo.variables.get(selectedRow);
        JSExtractFunctionSettings.ParameterInfo currentVarParametersInfo = this.parametersInfo.variableOptions.get(currentVar);
        this.parametersInfo.variableOptions.put(currentVar, new JSExtractFunctionSettings.ParameterInfo(currentVarParametersInfo.name, currentVarParametersInfo.used, currentVarParametersInfo.type, newValue));
    }

    @Override
    protected void checkIsValid() {
        super.checkIsValid();
        this.myPreviewText.setSignature(this.mySignatureGenerator.fun(this, this.contextInfo));
        this.checkUniqueness(this.getIntroductionScope().parent);
        PsiFile containingFile = this.contextInfo.anchor.getContainingFile();
        NamesValidator namesValidator = (NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage(containingFile.getLanguage());
        Action action = this.getOKAction();
        boolean nameValidationStatus = true;
        for (JSVariable var : this.parametersInfo.variables) {
            JSExtractFunctionSettings.ParameterInfo parameterInfo = this.parametersInfo.variableOptions.get(var);
            if (parameterInfo == null || namesValidator.isIdentifier(parameterInfo.name, containingFile.getProject())) continue;
            nameValidationStatus = false;
            break;
        }
        action.setEnabled(action.isEnabled() && nameValidationStatus);
    }

    protected String getDimensionServiceKey() {
        return this.getClass().getName();
    }

    @Override
    public JComboBox getVarTypeField() {
        return this.myVarType;
    }

    @Override
    public String getMethodName() {
        return this.getVariableName();
    }

    public JCheckBox getDeclareAsFunctionExpression() {
        return this.myDeclareAsFunctionExpression;
    }

    @Override
    public JSExtractFunctionSettings.ParametersInfo getParametersInfo() {
        return this.parametersInfo;
    }

    private void setParametersInfo(JSExtractFunctionSettings.ParametersInfo parametersInfo) {
        this.parametersInfo = parametersInfo;
        int i = 0;
        for (JSVariable var : parametersInfo.variables) {
            if (JSExtractFunctionHandler.isArgumentsReference(var)) continue;
            String string = JSExtractFunctionDialog.getTypeTextForVariable(var);
            parametersInfo.variableOptions.put(var, new JSExtractFunctionSettings.ParameterInfo(var.getName(), true, string, i++));
        }
        ((AbstractTableModel)this.parametersTable.getModel()).fireTableDataChanged();
    }

    private static String getTypeTextForVariable(JSVariable var) {
        JSType type = var.getType();
        return type == null ? null : type.getTypeText(JSType.TypeTextFormat.CODE);
    }

    @Override
    protected NameSuggestionsField getNameField() {
        return this.myFunctionName;
    }

    @Override
    protected JLabel getNameLabel() {
        return this.myNameLabel;
    }

    @Override
    protected JPanel getPanel() {
        return this.myPanel;
    }

    @Override
    protected JCheckBox getReplaceAllCheckBox() {
        return null;
    }

    @Override
    public JSVisibilityPanel getVisibilityPanel() {
        return this.myVisibilityPanel;
    }

    @Override
    public boolean makeStatic() {
        return this.myDeclareStaticCheckBox.isSelected();
    }

    @Override
    public boolean makeFunctionExpression() {
        return this.myDeclareAsFunctionExpression.isVisible() && this.myDeclareAsFunctionExpression.isSelected() || this.getIntroductionScope().forceMakeFunExpr;
    }

    @Override
    public JSExtractFunctionHandler.IntroductionScope getIntroductionScope() {
        return this.myIntroductionScope;
    }

    public JSExtractFunctionHandler.ContextInfo getContextInfo() {
        return this.contextInfo;
    }

    private void createUIComponents() {
        this.myFunctionName = this.configureNameField();
        this.myVarType = this.configureTypeField();
        this.myPreviewText = new MethodSignatureComponent(this.mySignatureGenerator.fun(new DefaultJSExtractFunctionSettings("extracted", this.myIntroductionScope), this.contextInfo), this.myProject, this.contextInfo.file.getFileType());
        this.myPreviewText.setMinimumSize((Dimension)JBUI.size((int)300, (int)40));
        this.parametersTable = new JBTable();
        this.setParametersInfo(JSExtractFunctionHandler.createDefaultParametersInfo(this.getIntroductionScope()));
        this.parametersTable.setAutoCreateColumnsFromModel(false);
        this.parametersTable.setModel(new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return ((JSExtractFunctionDialog)JSExtractFunctionDialog.this).parametersInfo.variableOptions.size();
            }

            @Override
            public int getColumnCount() {
                return 2 + (JSExtractFunctionDialog.this.isEcma4Context() || JSExtractFunctionDialog.this.isTypeScriptContext() ? 1 : 0);
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                JSVariable var = ((JSExtractFunctionDialog)JSExtractFunctionDialog.this).parametersInfo.variables.get(rowIndex);
                if (columnIndex == 0) {
                    return ((JSExtractFunctionDialog)JSExtractFunctionDialog.this).parametersInfo.variableOptions.get((Object)var).used;
                }
                if (columnIndex == 1) {
                    return ((JSExtractFunctionDialog)JSExtractFunctionDialog.this).parametersInfo.variableOptions.get((Object)var).name;
                }
                if (columnIndex == 2) {
                    return ((JSExtractFunctionDialog)JSExtractFunctionDialog.this).parametersInfo.variableOptions.get((Object)var).type;
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return true;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                JSVariable var = ((JSExtractFunctionDialog)JSExtractFunctionDialog.this).parametersInfo.variables.get(rowIndex);
                JSExtractFunctionSettings.ParameterInfo parameterInfo = ((JSExtractFunctionDialog)JSExtractFunctionDialog.this).parametersInfo.variableOptions.get(var);
                JSExtractFunctionSettings.ParameterInfo newParameterInfo = null;
                if (columnIndex == 0) {
                    newParameterInfo = new JSExtractFunctionSettings.ParameterInfo(parameterInfo.name, (Boolean)aValue, parameterInfo.type, rowIndex);
                } else if (columnIndex == 1) {
                    newParameterInfo = new JSExtractFunctionSettings.ParameterInfo((String)aValue, parameterInfo.used, parameterInfo.type, rowIndex);
                } else if (columnIndex == 2) {
                    newParameterInfo = new JSExtractFunctionSettings.ParameterInfo(parameterInfo.name, parameterInfo.used, (String)aValue, rowIndex);
                }
                if (newParameterInfo != null) {
                    ((JSExtractFunctionDialog)JSExtractFunctionDialog.this).parametersInfo.variableOptions.put(var, newParameterInfo);
                }
                JSExtractFunctionDialog.this.initiateValidation();
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (columnIndex == 0) {
                    return Boolean.class;
                }
                if (columnIndex == 1) {
                    return String.class;
                }
                if (columnIndex == 2) {
                    return String.class;
                }
                return super.getColumnClass(columnIndex);
            }
        });
        DefaultTableColumnModel tableColumnModel = new DefaultTableColumnModel();
        TableColumn checkboxColumn = new TableColumn(0);
        checkboxColumn.setMaxWidth(60);
        tableColumnModel.addColumn(checkboxColumn);
        tableColumnModel.addColumn(new TableColumn(1));
        if (this.isTypeScriptContext() || this.isEcma4Context()) {
            tableColumnModel.addColumn(new TableColumn(2));
        }
        this.parametersTable.setColumnModel(tableColumnModel);
        this.parametersTable.setRowSelectionAllowed(false);
        this.parametersTable.getSelectionModel().setSelectionInterval(0, 0);
        this.myToolbarDecoratorPanel = ToolbarDecorator.createDecorator((JTable)this.parametersTable).setMoveUpAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                int selectedRow = JSExtractFunctionDialog.this.parametersTable.getSelectedRow();
                if (selectedRow - 1 >= 0) {
                    JSExtractFunctionDialog.this.changeRowNumber(selectedRow, selectedRow - 1);
                    JSExtractFunctionDialog.this.changeRowNumber(selectedRow - 1, selectedRow);
                    JSExtractFunctionDialog.this.swapVars(selectedRow, selectedRow - 1);
                    ((AbstractTableModel)JSExtractFunctionDialog.this.parametersTable.getModel()).fireTableRowsUpdated(selectedRow - 1, selectedRow);
                    JSExtractFunctionDialog.this.parametersTable.getSelectionModel().setSelectionInterval(selectedRow - 1, selectedRow - 1);
                    JSExtractFunctionDialog.this.initiateValidation();
                }
            }
        }).setMoveDownAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                int selectedRow = JSExtractFunctionDialog.this.parametersTable.getSelectedRow();
                if (selectedRow + 1 < JSExtractFunctionDialog.this.parametersTable.getRowCount()) {
                    JSExtractFunctionDialog.this.changeRowNumber(selectedRow, selectedRow + 1);
                    JSExtractFunctionDialog.this.changeRowNumber(selectedRow + 1, selectedRow);
                    JSExtractFunctionDialog.this.swapVars(selectedRow, selectedRow + 1);
                    ((AbstractTableModel)JSExtractFunctionDialog.this.parametersTable.getModel()).fireTableRowsUpdated(selectedRow, selectedRow + 1);
                    JSExtractFunctionDialog.this.parametersTable.getSelectionModel().setSelectionInterval(selectedRow + 1, selectedRow + 1);
                    JSExtractFunctionDialog.this.initiateValidation();
                }
            }
        }).createPanel();
    }

    public boolean isEcma4Context() {
        return this.contextInfo.ecmaL4;
    }

    public boolean isTypeScriptContext() {
        return this.contextInfo.holder != null && this.contextInfo.holder.isTypeScript;
    }

    protected String getHelpId() {
        return this.contextInfo.ecmaL4 ? "refactoring.extractMethod.ActionScript" : "refactoring.extractMethod.JavaScript";
    }

    @Override
    protected void doOKAction() {
        if (this.myDeclareAsFunctionExpression.isEnabled() && this.myDeclareAsFunctionExpression.isVisible()) {
            PropertiesComponent.getInstance().setValue(DECLARE_AS_EXPRESSION_PROPERTY_KEY, this.myDeclareAsFunctionExpression.isSelected());
        }
        super.doOKAction();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "introductionScope", "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractFunctionDialog", "<init>"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JSVisibilityPanel jSVisibilityPanel;
        JCheckBox jCheckBox;
        JPanel jPanel;
        JCheckBox jCheckBox2;
        JLabel jLabel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel3, new GridConstraints(2, 0, 1, 2, 0, 3, 7, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Signature preview", (int)0, (int)0, null, null));
        MethodSignatureComponent methodSignatureComponent = this.myPreviewText;
        jPanel3.add((Component)methodSignatureComponent, new GridConstraints(0, 0, 1, 1, 0, 3, 6, 6, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Parameters", (int)0, (int)0, null, null));
        JPanel jPanel5 = this.myToolbarDecoratorPanel;
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel6, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel6.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Function", (int)0, (int)0, null, null));
        this.myNameLabel = jLabel = new JLabel();
        jLabel.setText("Name:");
        jLabel.setDisplayedMnemonic('N');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel6.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        NameSuggestionsField nameSuggestionsField = this.myFunctionName;
        jPanel6.add((Component)nameSuggestionsField, new GridConstraints(0, 1, 1, 1, 8, 1, 3, 0, null, new Dimension(150, -1), null));
        this.myDeclareStaticCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setFocusable(false);
        jCheckBox2.setText("Declare static");
        jCheckBox2.setMnemonic('S');
        jCheckBox2.setDisplayedMnemonicIndex(8);
        jPanel6.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myVarTypePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        EditorComboBox editorComboBox = this.myVarType;
        jPanel.add((Component)editorComboBox, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Return type:");
        jLabel2.setDisplayedMnemonic('T');
        jLabel2.setDisplayedMnemonicIndex(7);
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDeclareAsFunctionExpression = jCheckBox = new JCheckBox();
        jCheckBox.setFocusable(false);
        jCheckBox.setText("Declare functional expression");
        jCheckBox.setMnemonic('F');
        jCheckBox.setDisplayedMnemonicIndex(8);
        jPanel6.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myVisibilityPanel = jSVisibilityPanel = new JSVisibilityPanel();
        JComponent jComponent = jSVisibilityPanel.$$$getRootComponent$$$();
        jPanel2.add((Component)jComponent, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        jLabel2.setLabelFor((Component)editorComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

