/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduceField;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.introduce.BasicIntroducedEntityInfoProvider;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseClassBasedIntroduceDialog;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler;
import com.intellij.lang.javascript.refactoring.introduceField.JSIntroduceFieldSettings;
import com.intellij.lang.javascript.refactoring.ui.JSVisibilityPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;

class JSIntroduceFieldDialog
extends JSBaseClassBasedIntroduceDialog<BasicIntroducedEntityInfoProvider>
implements JSIntroduceFieldSettings {
    private JCheckBox myReplaceAllCheckBox;
    private NameSuggestionsField myNameField;
    private JPanel myPanel;
    private EditorComboBox myVarType;
    private JRadioButton myFieldDeclaration;
    private JRadioButton myCurrentMethod;
    private JRadioButton myConstructor;
    private JLabel myNameLabel;
    private JSVisibilityPanel myVisibilityPanel;
    private JPanel myInitializePanel;
    private final DialectOptionHolder myHolder;
    private static JSIntroduceFieldSettings.InitializationPlace lastInitializationPlace = JSIntroduceFieldSettings.InitializationPlace.FieldDeclaration;
    private boolean myIntroduceOverVarName;
    private final Collection<JSIntroduceFieldSettings.InitializationPlace> myAvailablePlaces;

    public JSIntroduceFieldDialog(Project project, JSExpression[] occurrences, final JSExpression expression, final PsiElement scope, Collection<JSIntroduceFieldSettings.InitializationPlace> availableInitializationPlaces) {
        super(project, new BasicIntroducedEntityInfoProvider(expression, occurrences, scope){

            @Override
            public String[] suggestCandidateNames() {
                JSCodeStyleSettings jsCodeStyleSettings = JSCodeStyleSettings.getSettings(scope);
                List<String> candidates = BasicIntroducedEntityInfoProvider.generateVariableNamesFromExpression(expression, scope, jsCodeStyleSettings.FIELD_PREFIX, Collections.emptySet(), EnumSet.noneOf(BasicIntroducedEntityInfoProvider.NameSuggestOption.class));
                return ArrayUtil.toStringArray(candidates);
            }

            @Override
            public boolean checkConflicts(@NotNull String name, boolean replaceAllOccurences) {
                if (name == null) {
                    1.$$$reportNull$$$0(0);
                }
                return true;
            }

            @Override
            public PsiElement findNamedElementInScope(@NotNull String name, PsiElement place) {
                if (name == null) {
                    1.$$$reportNull$$$0(1);
                }
                return BasicIntroducedEntityInfoProvider.findExistingInScope(name, place, JSResolveUtil.calculateStaticFromContext(place));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "name";
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/introduceField/JSIntroduceFieldDialog$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkConflicts";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "findNamedElementInScope";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, "javascript.introduce.field.title");
        this.myAvailablePlaces = availableInitializationPlaces;
        this.$$$setupUI$$$();
        this.myIntroduceOverVarName = JSBaseIntroduceHandler.introduceOverVariableNameRef((PsiElement)expression);
        this.myHolder = DialectDetector.dialectOfElement((PsiElement)expression);
        ((GridLayoutManager)this.myInitializePanel.getLayout()).setVGap(0);
        this.doInit();
    }

    @Override
    protected void doInit() {
        super.doInit();
        this.myConstructor.setEnabled(this.myAvailablePlaces.contains((Object)JSIntroduceFieldSettings.InitializationPlace.Constructor));
        this.myFieldDeclaration.setEnabled(this.myAvailablePlaces.contains((Object)JSIntroduceFieldSettings.InitializationPlace.FieldDeclaration));
        this.myCurrentMethod.setEnabled(this.myAvailablePlaces.contains((Object)JSIntroduceFieldSettings.InitializationPlace.CurrentMethod));
        if (this.myAvailablePlaces.contains((Object)lastInitializationPlace)) {
            this.getControlForPlace(lastInitializationPlace).setSelected(true);
        } else {
            JSIntroduceFieldSettings.InitializationPlace first = (JSIntroduceFieldSettings.InitializationPlace)((Object)ContainerUtil.getFirstItem(this.myAvailablePlaces));
            if (first != null) {
                this.getControlForPlace(first).setSelected(true);
            }
        }
        if (this.myIntroduceOverVarName) {
            this.myReplaceAllCheckBox.setSelected(true);
            this.myReplaceAllCheckBox.setEnabled(false);
        }
        if (this.myHolder != null && !this.myHolder.hasFeature(JSLanguageFeature.TYPES)) {
            this.myVarType.setVisible(false);
        }
        this.myVisibilityPanel.configureOptions(false, false, this.myHolder);
    }

    @NotNull
    private JRadioButton getControlForPlace(JSIntroduceFieldSettings.InitializationPlace initializationPlace) {
        switch (initializationPlace) {
            case CurrentMethod: {
                JRadioButton jRadioButton = this.myCurrentMethod;
                if (jRadioButton == null) {
                    JSIntroduceFieldDialog.$$$reportNull$$$0(0);
                }
                return jRadioButton;
            }
            case FieldDeclaration: {
                JRadioButton jRadioButton = this.myFieldDeclaration;
                if (jRadioButton == null) {
                    JSIntroduceFieldDialog.$$$reportNull$$$0(1);
                }
                return jRadioButton;
            }
            case Constructor: {
                JRadioButton jRadioButton = this.myConstructor;
                if (jRadioButton == null) {
                    JSIntroduceFieldDialog.$$$reportNull$$$0(2);
                }
                return jRadioButton;
            }
        }
        throw new RuntimeException("No control for place " + (Object)((Object)initializationPlace));
    }

    @Override
    protected JLabel getNameLabel() {
        return this.myNameLabel;
    }

    @Override
    protected NameSuggestionsField getNameField() {
        return this.myNameField;
    }

    @Override
    protected JPanel getPanel() {
        return this.myPanel;
    }

    @Override
    protected JCheckBox getReplaceAllCheckBox() {
        return this.myReplaceAllCheckBox;
    }

    @Override
    public JComboBox getVarTypeField() {
        return this.myVarType;
    }

    @Override
    protected JSVisibilityPanel getVisibilityPanel() {
        return this.myVisibilityPanel;
    }

    @Override
    public JSIntroduceFieldSettings.InitializationPlace getInitializationPlace() {
        return this.myFieldDeclaration.isSelected() ? JSIntroduceFieldSettings.InitializationPlace.FieldDeclaration : (this.myCurrentMethod.isSelected() ? JSIntroduceFieldSettings.InitializationPlace.CurrentMethod : JSIntroduceFieldSettings.InitializationPlace.Constructor);
    }

    @Override
    protected void doOKAction() {
        super.doOKAction();
        lastInitializationPlace = this.getInitializationPlace();
    }

    @Override
    protected void checkIsValid() {
        super.checkIsValid();
        JSClass classOfContext = JSResolveUtil.getClassOfContext((PsiElement)((BasicIntroducedEntityInfoProvider)this.entityInfoProvider).myMainOccurrence);
        if (classOfContext != null) {
            this.checkUniqueness((PsiElement)classOfContext);
        }
    }

    private void createUIComponents() {
        this.myNameField = this.configureNameField();
        this.myVarType = this.configureTypeField();
    }

    protected String getHelpId() {
        return this.myHolder != null && this.myHolder.isECMA4 ? "refactoring.introduceField.ActionScript" : "refactoring.introduceField.JavaScript";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/introduceField/JSIntroduceFieldDialog", "getControlForPlace"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JSVisibilityPanel jSVisibilityPanel;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel;
        JCheckBox jCheckBox;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myReplaceAllCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setActionCommand("");
        jCheckBox.setContentAreaFilled(false);
        jCheckBox.setFocusable(false);
        jCheckBox.setMargin(new Insets(2, 0, 2, 3));
        jCheckBox.setText("");
        jPanel2.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myInitializePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Initialize in", (int)0, (int)0, null, null));
        this.myFieldDeclaration = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("Field declaration");
        jRadioButton3.setMnemonic('D');
        jRadioButton3.setDisplayedMnemonicIndex(6);
        jPanel.add((Component)jRadioButton3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCurrentMethod = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Current method");
        jRadioButton2.setMnemonic('M');
        jRadioButton2.setDisplayedMnemonicIndex(8);
        jPanel.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myConstructor = jRadioButton = new JRadioButton();
        jRadioButton.setText("Class constructor");
        jRadioButton.setMnemonic('C');
        jRadioButton.setDisplayedMnemonicIndex(6);
        jPanel.add((Component)jRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myVisibilityPanel = jSVisibilityPanel = new JSVisibilityPanel();
        JComponent jComponent = jSVisibilityPanel.$$$getRootComponent$$$();
        jPanel2.add((Component)jComponent, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Type:");
        jLabel2.setDisplayedMnemonic('T');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorComboBox editorComboBox = this.myVarType;
        jPanel3.add((Component)editorComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myNameLabel = jLabel = new JLabel();
        jLabel.setRequestFocusEnabled(false);
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/JavaScriptBundle").getString("javascript.introduce.variable.name.prompt"));
        jPanel3.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        NameSuggestionsField nameSuggestionsField = this.myNameField;
        jPanel3.add((Component)nameSuggestionsField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        jLabel2.setLabelFor((Component)editorComboBox);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

