/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service.highlighting;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.problems.ProblemImpl;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLanguageServiceAnnotationProvider {
    public void apply(@NotNull PsiFile file, @Nullable List<JSAnnotationError> annotationResult, @NotNull AnnotationHolder holder, @NotNull JSLanguageService languageService) {
        if (file == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(1);
        }
        if (languageService == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(2);
        }
        if (annotationResult == null) {
            return;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        Project project = file.getProject();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        if (document == null) {
            WolfTheProblemSolver.getInstance((Project)project).clearProblems(virtualFile);
            return;
        }
        ArrayList errorHighlightInfos = ContainerUtil.newArrayList();
        for (JSAnnotationError result : annotationResult) {
            if (StringUtil.isEmpty((String)result.getAbsoluteFilePath()) || !FileUtil.pathsEqual((String)result.getAbsoluteFilePath(), (String)virtualFile.getCanonicalPath())) continue;
            try {
                Annotation annotation;
                JSLanguageServiceUtil.PsiElementInfo info = JSLanguageServiceUtil.getElementInfo(file, document, result);
                if (info == null) continue;
                PsiElement element = info.getElement();
                TextRange range = info.getRange();
                if (element == null && range == null || (annotation = JSLanguageServiceAnnotationProvider.registerAnnotation(file, result, element, range, holder, languageService)) == null || !JSLanguageServiceAnnotationProvider.isError(result)) continue;
                errorHighlightInfos.add(HighlightInfo.fromAnnotation((Annotation)annotation));
            }
            catch (Exception e) {
                JSLanguageServiceQueue.LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        }
        List problems = errorHighlightInfos.stream().map(el -> new ProblemImpl(virtualFile, el, true)).collect(Collectors.toList());
        WolfTheProblemSolver.getInstance((Project)project).reportProblems(virtualFile, problems);
    }

    @Nullable
    private static Annotation registerAnnotation(@NotNull PsiFile file, @NotNull JSAnnotationError result, @Nullable PsiElement element, @Nullable TextRange range, @NotNull AnnotationHolder holder, @NotNull JSLanguageService languageService) {
        if (file == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(3);
        }
        if (result == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(5);
        }
        if (languageService == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(6);
        }
        assert (element != null || range != null);
        String message = result.getDescription();
        if (JSLanguageServiceAnnotationProvider.isError(result)) {
            Annotation annotation = element != null ? holder.createErrorAnnotation(element, message) : holder.createErrorAnnotation(range, message);
            ProblemHighlightType type = result.getHighlightType();
            if (type != null) {
                annotation.setHighlightType(type);
            }
            Collection<? extends IntentionAction> fixes = languageService.getFixes(file, result);
            fixes.forEach(arg_0 -> ((Annotation)annotation).registerFix(arg_0));
            return annotation;
        }
        if (element != null) {
            return holder.createWarningAnnotation(element, message);
        }
        return holder.createWarningAnnotation(range, message);
    }

    private static boolean isError(@NotNull JSAnnotationError result) {
        if (result == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(7);
        }
        return "error".equalsIgnoreCase(result.getCategory());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageService";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/service/highlighting/JSLanguageServiceAnnotationProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "registerAnnotation";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isError";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

