/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.settings;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.flow.FlowJSSettings;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

class FlowJSConfigurationPanel {
    private JPanel myPanel;
    private TextFieldWithHistoryWithBrowseButton myFlowExecutableCombobox;
    private JCheckBox myTypeChecking;
    private JCheckBox myOtherServices;
    private JCheckBox myFlowResolveCheckBox;
    private JCheckBox myAutosaveCheckBox;

    public FlowJSConfigurationPanel(@NotNull Project project) {
        if (project == null) {
            FlowJSConfigurationPanel.$$$reportNull$$$0(0);
        }
        this.myFlowExecutableCombobox = SwingHelper.createTextFieldWithHistoryWithBrowseButton((Project)project, (String)JSBundle.message((String)"js.flow.settings.executable.dialog.title", (Object[])new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor(), () -> {
            if (project == null) {
                FlowJSConfigurationPanel.$$$reportNull$$$0(3);
            }
            return FlowJSServerService.calcPossibleFlowExecutableFiles(project);
        });
        ((TextFieldWithHistory)this.myFlowExecutableCombobox.getChildComponent()).addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                FlowJSConfigurationPanel.this.updateEnabled();
            }
        });
        this.myTypeChecking = new JBCheckBox(JSBundle.message((String)"js.flow.enable.type.checking", (Object[])new Object[0]), FlowJSSettings.DEFAULT.isTypeCheckingEnabled());
        this.myTypeChecking.addChangeListener(e -> this.updateEnabled());
        this.myOtherServices = new JBCheckBox(JSBundle.message((String)"js.flow.enable.other.services", (Object[])new Object[0]), FlowJSSettings.DEFAULT.isOtherServicesEnabled());
        String html = FlowJSConfigurationPanel.getHtmlForCheckbox("js.flow.enable.resolve", "js.flow.enable.resolve.warning");
        this.myFlowResolveCheckBox = new JBCheckBox(html, FlowJSSettings.DEFAULT.isResolveByServerEnabled());
        this.myFlowResolveCheckBox.setToolTipText(JSBundle.message((String)"js.flow.enable.resolve.description", (Object[])new Object[0]));
        this.myFlowResolveCheckBox.setVerticalAlignment(1);
        this.myFlowResolveCheckBox.setVerticalTextPosition(1);
        String saveCheckboxHtml = FlowJSConfigurationPanel.getHtmlForCheckbox("js.flow.settings.auto.save", "js.flow.settings.auto.save.warning");
        this.myAutosaveCheckBox = new JBCheckBox(saveCheckboxHtml, FlowJSSettings.DEFAULT.isAutoSaveEnabled());
        this.myFlowResolveCheckBox.setVerticalAlignment(1);
        this.myFlowResolveCheckBox.setVerticalTextPosition(1);
        this.myPanel = FormBuilder.createFormBuilder().setVerticalGap(8).addSeparator().addLabeledComponent(JSBundle.message((String)"js.flow.settings.executable.label", (Object[])new Object[0]), (JComponent)this.myFlowExecutableCombobox).addComponent((JComponent)new JBLabel(JSBundle.message((String)"js.flow.services.label", (Object[])new Object[0]))).addComponent((JComponent)this.myTypeChecking).addComponent((JComponent)this.myOtherServices).addComponent((JComponent)this.myFlowResolveCheckBox).addSeparator().addComponent((JComponent)this.myAutosaveCheckBox).getPanel();
        this.myPanel.setVisible(false);
    }

    @NotNull
    private static String getHtmlForCheckbox(@PropertyKey(resourceBundle="messages.JavaScriptBundle") String messageKey, @PropertyKey(resourceBundle="messages.JavaScriptBundle") String descriptionKey) {
        String string = "<html><body>" + JSBundle.message((String)messageKey, (Object[])new Object[0]) + "<div style='font-size: " + Math.round(UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.SMALL)) + "; color: #" + ColorUtil.toHex((Color)UIUtil.getLabelDisabledForeground()) + "'>" + JSBundle.message((String)descriptionKey, (Object[])new Object[0]) + "</div></body></html>";
        if (string == null) {
            FlowJSConfigurationPanel.$$$reportNull$$$0(1);
        }
        return string;
    }

    JPanel getPanel() {
        return this.myPanel;
    }

    public FlowJSSettings getFlowSettings() {
        return new FlowJSSettings.Builder().setFlowExecutablePath(this.myFlowExecutableCombobox.getText()).setTypeCheckingEnabled(this.myTypeChecking.isSelected()).setOtherServicesEnabled(this.myOtherServices.isSelected()).setFlowResolveEnable(this.myFlowResolveCheckBox.isSelected()).setAutoSaveEnabled(this.myAutosaveCheckBox.isSelected()).build();
    }

    public void setFlowSettings(@NotNull FlowJSSettings settings) {
        if (settings == null) {
            FlowJSConfigurationPanel.$$$reportNull$$$0(2);
        }
        String path = settings.getFlowExecutablePath();
        this.myFlowExecutableCombobox.setTextAndAddToHistory(FileUtil.toSystemDependentName((String)path));
        if (!path.isEmpty()) {
            this.myTypeChecking.setSelected(settings.isTypeCheckingEnabled());
            this.myFlowResolveCheckBox.setSelected(settings.isResolveByServerEnabled());
            this.myOtherServices.setSelected(settings.isOtherServicesEnabled());
            this.myAutosaveCheckBox.setSelected(settings.isAutoSaveEnabled());
        }
        this.updateEnabled();
    }

    private void updateEnabled() {
        boolean pathIsEmpty = this.myFlowExecutableCombobox.getText().isEmpty();
        boolean typeCheckSelected = this.myTypeChecking.isSelected();
        this.myTypeChecking.setEnabled(!pathIsEmpty);
        this.myOtherServices.setEnabled(!pathIsEmpty && typeCheckSelected);
        this.myFlowResolveCheckBox.setEnabled(!pathIsEmpty && typeCheckSelected);
        this.myAutosaveCheckBox.setEnabled(!pathIsEmpty && typeCheckSelected);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/settings/FlowJSConfigurationPanel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/settings/FlowJSConfigurationPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getHtmlForCheckbox";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setFlowSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

