/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.structureView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TextEditorBasedStructureViewModel;
import com.intellij.ide.util.ActionShortcutProvider;
import com.intellij.ide.util.FileStructureFilter;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.structureView.JSInheritedFromObjectFilter;
import com.intellij.lang.javascript.structureView.JSStructureViewElement;
import com.intellij.lang.javascript.structureView.JSSuperGroup;
import com.intellij.lang.javascript.structureView.JSSuperGrouper;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PlatformIcons;
import java.util.Comparator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSStructureViewModel
extends TextEditorBasedStructureViewModel
implements StructureViewModel.ElementInfoProvider {
    private Filter[] myFilters = new Filter[]{ourFieldsFilter, ourInheritedFilter, ourInheritedFromObjectFilter};
    @NonNls
    private static final String ID = "KIND";
    private static final Sorter ourKindSorter = new Sorter(){
        private final Comparator myComparator = new Comparator(){

            public int compare(Object o, Object o2) {
                return this.getWeight(o) - this.getWeight(o2);
            }

            private int getWeight(Object s) {
                if (s instanceof JSSuperGroup) {
                    return 5;
                }
                Object o = ((StructureViewTreeElement)s).getValue();
                JSImplicitElement.Type type = null;
                if (o instanceof JSImplicitElement) {
                    type = ((JSImplicitElement)o).getType();
                }
                if (o instanceof JSFunction || type == JSImplicitElement.Type.Function) {
                    return 10;
                }
                if (o instanceof JSVariable || type == JSImplicitElement.Type.Variable || o instanceof JSProperty || type == JSImplicitElement.Type.Property || o instanceof JSDefinitionExpression) {
                    return 20;
                }
                if (o instanceof JSImplicitElement) {
                    return 6;
                }
                if (o instanceof JSClass) {
                    return 7;
                }
                return 30;
            }
        };

        @NotNull
        public Comparator getComparator() {
            Comparator comparator = this.myComparator;
            if (comparator == null) {
                1.$$$reportNull$$$0(0);
            }
            return comparator;
        }

        public boolean isVisible() {
            return false;
        }

        @NotNull
        public ActionPresentation getPresentation() {
            if (null == null) {
                1.$$$reportNull$$$0(1);
            }
            return null;
        }

        @NotNull
        public String getName() {
            if (JSStructureViewModel.ID == null) {
                1.$$$reportNull$$$0(2);
            }
            return JSStructureViewModel.ID;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/lang/javascript/structureView/JSStructureViewModel$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComparator";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    };
    private Sorter[] mySorters = new Sorter[]{ourKindSorter, Sorter.ALPHA_SORTER};
    private static final Filter ourFieldsFilter = new Filter(){
        @NonNls
        public static final String ID = "SHOW_FIELDS";

        public boolean isVisible(TreeElement treeNode) {
            if (!(treeNode instanceof JSStructureViewElement)) {
                return true;
            }
            PsiElement element = ((JSStructureViewElement)treeNode).getValue();
            if (element instanceof JSClass || element instanceof TypeScriptModule) {
                return true;
            }
            return element instanceof JSFunction || element instanceof JSProperty && ((JSProperty)element).tryGetFunctionInitializer() != null || element instanceof JSObjectLiteralExpression;
        }

        public boolean isReverted() {
            return true;
        }

        @NotNull
        public ActionPresentation getPresentation() {
            ActionPresentationData actionPresentationData = new ActionPresentationData(IdeBundle.message((String)"action.structureview.show.fields", (Object[])new Object[0]), null, PlatformIcons.FIELD_ICON);
            if (actionPresentationData == null) {
                2.$$$reportNull$$$0(0);
            }
            return actionPresentationData;
        }

        @NotNull
        public String getName() {
            if (ID == null) {
                2.$$$reportNull$$$0(1);
            }
            return ID;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/lang/javascript/structureView/JSStructureViewModel$2";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    };
    private static final Filter ourInheritedFromObjectFilter = new JSInheritedFromObjectFilter();
    private static final Filter ourInheritedFilter = new MyFileStructureFilter();
    private static final Grouper ourInheritedGrouper = new JSSuperGrouper();
    private Grouper[] myGroupers = new Grouper[]{ourInheritedGrouper};
    private final Class[] myClasses = new Class[]{JSFunction.class, JSVariable.class, JSDefinitionExpression.class, JSAssignmentExpression.class, JSClass.class, JSProperty.class};
    private final StructureViewTreeElement myRootElement;

    public JSStructureViewModel(PsiElement root, Editor editor) {
        super(editor);
        this.myRootElement = this.createRoot(root);
    }

    protected PsiFile getPsiFile() {
        PsiFile file = super.getPsiFile();
        if (file == null) {
            file = ((PsiElement)this.myRootElement.getValue()).getContainingFile();
        }
        return file;
    }

    @NotNull
    public StructureViewTreeElement getRoot() {
        StructureViewTreeElement structureViewTreeElement = this.myRootElement;
        if (structureViewTreeElement == null) {
            JSStructureViewModel.$$$reportNull$$$0(0);
        }
        return structureViewTreeElement;
    }

    protected JSStructureViewElement createRoot(PsiElement root) {
        return new JSStructureViewElement(root, true, root.getContainingFile().getLanguage().isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4));
    }

    @NotNull
    public Grouper[] getGroupers() {
        if (this.myGroupers == null) {
            JSStructureViewModel.$$$reportNull$$$0(1);
        }
        return this.myGroupers;
    }

    @NotNull
    public Sorter[] getSorters() {
        if (this.mySorters == null) {
            JSStructureViewModel.$$$reportNull$$$0(2);
        }
        return this.mySorters;
    }

    @NotNull
    public Filter[] getFilters() {
        if (this.myFilters == null) {
            JSStructureViewModel.$$$reportNull$$$0(3);
        }
        return this.myFilters;
    }

    protected boolean isSuitable(PsiElement element) {
        return super.isSuitable(element) && (!(element instanceof JSVariable) || PsiTreeUtil.getParentOfType((PsiElement)element, JSFunction.class) == null);
    }

    public Object getCurrentEditorElement() {
        PsiElement element;
        int offset;
        PsiElement at;
        PsiLanguageInjectionHost injectionHost;
        Object editorElement = super.getCurrentEditorElement();
        PsiFile file = this.getPsiFile();
        if (editorElement == null && !(file instanceof JSFile) && (injectionHost = (PsiLanguageInjectionHost)PsiTreeUtil.getParentOfType((PsiElement)(at = file.findElementAt(offset = this.getEditor().getCaretModel().getOffset())), PsiLanguageInjectionHost.class)) != null && (element = InjectedLanguageManager.getInstance((Project)file.getProject()).findInjectedElementAt(file, offset)) != null) {
            return this.findAcceptableElement(element);
        }
        if (editorElement instanceof JSFunctionExpression) {
            editorElement = JSPsiImplUtils.getInitializedElement((JSExpression)editorElement);
        }
        if (editorElement instanceof JSAssignmentExpression) {
            editorElement = ((JSAssignmentExpression)editorElement).getDefinitionExpression();
        }
        if (editorElement instanceof JSPsiElementBase) {
            String name = ((JSPsiElementBase)editorElement).getName();
            JSFunction function = JSPsiImplUtils.getPossibleFunction((PsiElement)((JSPsiElementBase)editorElement));
            if (function != null && StringUtil.equals((CharSequence)name, (CharSequence)function.getName())) {
                return function;
            }
        }
        return editorElement;
    }

    public boolean isAlwaysShowsPlus(StructureViewTreeElement element) {
        return true;
    }

    public boolean isAlwaysLeaf(StructureViewTreeElement element) {
        return false;
    }

    @NotNull
    protected Class[] getSuitableClasses() {
        if (this.myClasses == null) {
            JSStructureViewModel.$$$reportNull$$$0(4);
        }
        return this.myClasses;
    }

    public void setFilters(Filter[] filters) {
        this.myFilters = filters;
    }

    public void setGroupers(Grouper[] groupers) {
        this.myGroupers = groupers;
    }

    public void setSorters(Sorter[] sorters) {
        this.mySorters = sorters;
    }

    public boolean shouldEnterElement(Object element) {
        return JSStructureViewModel.shouldEnterElementStatic(element);
    }

    public static boolean shouldEnterElementStatic(Object element) {
        return element instanceof JSClass || element instanceof JSImplicitElement && ((JSImplicitElement)element).getType() == JSImplicitElement.Type.Class;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/structureView/JSStructureViewModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupers";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSorters";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilters";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuitableClasses";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class MyFileStructureFilter
    implements FileStructureFilter,
    ActionShortcutProvider {
        @NonNls
        public static final String ID = "HIDE_INHERITED";

        private MyFileStructureFilter() {
        }

        public boolean isVisible(TreeElement treeNode) {
            if (treeNode instanceof JSStructureViewElement) {
                return !((JSStructureViewElement)treeNode).isInherited();
            }
            return true;
        }

        @NotNull
        public ActionPresentation getPresentation() {
            ActionPresentationData actionPresentationData = new ActionPresentationData(IdeBundle.message((String)"action.structureview.show.inherited", (Object[])new Object[0]), null, AllIcons.Hierarchy.Supertypes);
            if (actionPresentationData == null) {
                MyFileStructureFilter.$$$reportNull$$$0(0);
            }
            return actionPresentationData;
        }

        @NotNull
        public String getName() {
            if (ID == null) {
                MyFileStructureFilter.$$$reportNull$$$0(1);
            }
            return ID;
        }

        public boolean isReverted() {
            return true;
        }

        @NotNull
        public String getCheckBoxText() {
            String string = IdeBundle.message((String)"file.structure.toggle.show.inherited", (Object[])new Object[0]);
            if (string == null) {
                MyFileStructureFilter.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getActionIdForShortcut() {
            if ("FileStructurePopup" == null) {
                MyFileStructureFilter.$$$reportNull$$$0(3);
            }
            return "FileStructurePopup";
        }

        @NotNull
        public Shortcut[] getShortcut() {
            if (null == null) {
                MyFileStructureFilter.$$$reportNull$$$0(4);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/lang/javascript/structureView/JSStructureViewModel$MyFileStructureFilter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCheckBoxText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionIdForShortcut";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getShortcut";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

