/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.template.postfix;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.TextExpression;
import com.intellij.codeInsight.template.postfix.templates.StringBasedPostfixTemplate;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.template.postfix.JSPostfixTemplateUtils;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0014J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0004H\u0016J\u000e\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u0004H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/lang/javascript/template/postfix/TypeScriptCastPostfixTemplate;", "Lcom/intellij/codeInsight/template/postfix/templates/StringBasedPostfixTemplate;", "()V", "getElementToRemove", "Lcom/intellij/psi/PsiElement;", "expr", "getTemplateString", "", "element", "getTypeText", "setVariables", "", "template", "Lcom/intellij/codeInsight/template/Template;", "JavaScriptLanguage"})
public final class TypeScriptCastPostfixTemplate
extends StringBasedPostfixTemplate {
    @Nullable
    public String getTemplateString(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        boolean jsx = DialectDetector.isJSX(element);
        return !jsx ? "(<$AssertionType$>$expr$)" : "($expr$ as $AssertionType$)";
    }

    public void setVariables(@NotNull Template template, @NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)template, (String)"template");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super.setVariables(template, element);
        String typeText = this.getTypeText(element);
        TextExpression expression = new TextExpression(typeText);
        template.addVariable("AssertionType", (Expression)expression, (Expression)expression, true);
    }

    @NotNull
    public final String getTypeText(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (!(element instanceof JSExpression)) {
            String string = JSAnyType.get(element, true).getTypeText(JSType.TypeTextFormat.CODE);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JSAnyType.get(element, true).getTypeText(CODE)");
            return string;
        }
        JSType jSType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)element);
        if (jSType == null) {
            JSAnyType jSAnyType = JSAnyType.get(element, true);
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)jSAnyType), (String)"JSAnyType.get(element, true)");
            jSType = jSAnyType;
        }
        JSType type = jSType;
        String string = type.getTypeText(JSType.TypeTextFormat.CODE);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"type.getTypeText(CODE)");
        return string;
    }

    @NotNull
    protected PsiElement getElementToRemove(@Nullable PsiElement expr) {
        PsiElement psiElement = expr;
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        return psiElement;
    }

    public TypeScriptCastPostfixTemplate() {
        super("cast", "(<any>value)", JSPostfixTemplateUtils.selectorAllExpressionsWithCurrentOffset((Condition<PsiElement>)Conditions.and(JSPostfixTemplateUtils.DEFAULT_AND_NON_LITERAL_CONDITION, JSPostfixTemplateUtils.TYPESCRIPT_CONDITION)));
    }
}

