/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCastExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPartialType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeOperator;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.validation.ES6KeywordHighlighterVisitor;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class TypeScriptKeywordHighlighterVisitor
extends ES6KeywordHighlighterVisitor {
    public static final Collection<IElementType> MODIFIERS_KEYWORDS = ContainerUtil.immutableList((Object[])new IElementType[]{JSTokenTypes.DECLARE_KEYWORD, JSTokenTypes.ABSTRACT_KEYWORD, JSTokenTypes.READONLY_KEYWORD});

    public TypeScriptKeywordHighlighterVisitor(AnnotationHolder holder) {
        super(holder);
    }

    public void visitTypeScriptModule(TypeScriptModule element) {
        this.highlightChildKeywordOfTypes((PsiElement)element, JSKeywordSets.MODULES_AND_GLOBAL_KEYWORDS);
        super.visitTypeScriptModule(element);
    }

    public void visitTypeScriptSingleType(TypeScriptSingleType singleType) {
        JSReferenceExpression referenceExpression = singleType.getReferenceExpression();
        JSReferenceExpression parent = referenceExpression != null ? referenceExpression : singleType;
        this.highlightChildKeywordOfTypes((PsiElement)parent, JSDocumentationUtils.ourPrimitiveTypeFilter);
        super.visitTypeScriptSingleType(singleType);
    }

    public void visitTypeScriptTypeAlias(TypeScriptTypeAlias element) {
        this.highlightChildKeywordOfType((PsiElement)element, JSTokenTypes.TYPE_KEYWORD);
        super.visitTypeScriptTypeAlias(element);
    }

    public void visitTypeScriptPartialType(TypeScriptPartialType element) {
        this.highlightChildKeywordOfType((PsiElement)element, JSTokenTypes.PARTIAL_KEYWORD);
        super.visitTypeScriptPartialType(element);
    }

    public void visitTypeScriptTypeOperator(TypeScriptTypeOperator element) {
        this.highlightChildKeywordOfType((PsiElement)element, JSTokenTypes.KEYOF_KEYWORD);
        super.visitTypeScriptTypeOperator(element);
    }

    @Override
    public void visitJSAttributeList(JSAttributeList element) {
        this.highlightModifierKeywords(element);
        super.visitJSAttributeList(element);
    }

    public void visitTypeScriptImportStatement(TypeScriptImportStatement importStatement) {
        TypeScriptExternalModuleReference externalModuleReference = importStatement.getExternalModuleReference();
        if (externalModuleReference != null) {
            this.highlightChildKeywordOfType((PsiElement)externalModuleReference, JSTokenTypes.REQUIRE_KEYWORD);
        }
        super.visitTypeScriptImportStatement(importStatement);
    }

    public void highlightModifierKeywords(JSAttributeList element) {
        for (IElementType modifier : this.getModifiers()) {
            this.highlightChildKeywordOfType((PsiElement)element, modifier);
        }
    }

    @NotNull
    protected Collection<IElementType> getModifiers() {
        Collection<IElementType> collection = MODIFIERS_KEYWORDS;
        if (collection == null) {
            TypeScriptKeywordHighlighterVisitor.$$$reportNull$$$0(0);
        }
        return collection;
    }

    public void visitTypeScriptCastExpression(TypeScriptCastExpression node) {
        this.highlightChildKeywordOfType((PsiElement)node, JSTokenTypes.AS_KEYWORD);
        super.visitTypeScriptCastExpression(node);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/TypeScriptKeywordHighlighterVisitor", "getModifiers"));
    }
}

