/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMethodsFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.MultiMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptImplementFieldsFix
extends BaseCreateMethodsFix<TypeScriptPropertySignature>
implements IntentionAction {
    public TypeScriptImplementFieldsFix(JSClass jsClass) {
        super(jsClass);
    }

    @NotNull
    public String getText() {
        String string = JSBundle.message((String)"javascript.fix.implement.fields", (Object[])new Object[0]);
        if (string == null) {
            TypeScriptImplementFieldsFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            TypeScriptImplementFieldsFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            TypeScriptImplementFieldsFix.$$$reportNull$$$0(2);
        }
        return this.myJsClass.isValid();
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Override
    public String buildFunctionText(TypeScriptPropertySignature fun, @Nullable MultiMap<String, String> types) {
        JSType type;
        String processedType;
        String name = JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)fun, false);
        if (StringUtil.isEmpty((String)name)) {
            return "";
        }
        StringBuilder builder = new StringBuilder(name);
        JSTypeDeclaration typeDeclaration = fun.getTypeDeclaration();
        if (typeDeclaration != null && !StringUtil.isEmpty((String)(processedType = TypeScriptImplementFieldsFix.getProcessedType(type = fun.getType(), this.myJsClass, (PsiElement)fun)))) {
            builder.append(":");
            builder.append(processedType);
        }
        builder.append(JSCodeStyleSettings.getSemicolon(fun.getContainingFile()));
        return builder.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/TypeScriptImplementFieldsFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/TypeScriptImplementFieldsFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

