/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript;

import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandler;
import com.intellij.lang.javascript.JSTargetElementEvaluator;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceEvents;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptResponseCommon;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveResult;
import java.util.Arrays;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptGoToDeclarationHandler
implements GotoDeclarationHandler {
    @Nullable
    public PsiElement[] getGotoDeclarationTargets(@Nullable PsiElement sourceElement, int offset, Editor editor) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (sourceElement == null) {
            return null;
        }
        Project project = editor.getProject();
        PsiElement parent = sourceElement.getParent();
        if (parent instanceof JSReferenceExpression) {
            if (project == null || !TypeScriptLanguageServiceUtil.isServiceEnabled(editor.getProject())) {
                return null;
            }
            VirtualFile virtualFile = sourceElement.getContainingFile().getVirtualFile();
            TypeScriptCompilerService service = TypeScriptCompilerService.getServiceForFile(project, virtualFile);
            if (service == null || !service.checkCanUseService()) {
                return null;
            }
            ResolveResult[] results = ((JSReferenceExpression)parent).multiResolve(false);
            if (results.length == 0) {
                return TypeScriptGoToDeclarationHandler.getResultsFromTypeScriptService(project, editor, sourceElement);
            }
        } else if (parent instanceof JSVariable && TypeScriptGoToDeclarationHandler.useVariableAsDeclaration((JSVariable)parent, sourceElement) || parent instanceof TypeScriptFunction && TypeScriptGoToDeclarationHandler.useFunctionAsDeclaration((TypeScriptFunction)parent, sourceElement)) {
            return new PsiElement[]{parent};
        }
        return null;
    }

    @Nullable
    private static PsiElement[] getResultsFromTypeScriptService(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement sourceElement) {
        Future<TypeScriptResponseCommon.FileSpan[]> future;
        if (project == null) {
            TypeScriptGoToDeclarationHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            TypeScriptGoToDeclarationHandler.$$$reportNull$$$0(1);
        }
        if (sourceElement == null) {
            TypeScriptGoToDeclarationHandler.$$$reportNull$$$0(2);
        }
        if ((future = TypeScriptLanguageServiceEvents.getService(project).getDeclaration(sourceElement, editor.getDocument())) == null) {
            return null;
        }
        TypeScriptResponseCommon.FileSpan[] spans = JSLanguageServiceUtil.awaitFuture(future, 700L, 10L, null);
        if (spans == null) {
            return null;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        return (PsiElement[])Arrays.stream(spans).map(el -> {
            if (project == null) {
                TypeScriptGoToDeclarationHandler.$$$reportNull$$$0(12);
            }
            String path = el.file;
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
            if (file == null) {
                return null;
            }
            PsiFile psiFile = psiManager.findFile(file);
            if (psiFile == null) {
                return null;
            }
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
            if (document == null) {
                return null;
            }
            return TypeScriptGoToDeclarationHandler.getElement(psiFile, document, el);
        }).filter(el -> el != null).map(el -> JSTargetElementEvaluator.adjustTargetElement(el)).toArray(PsiElement[]::new);
    }

    private static boolean useVariableAsDeclaration(@NotNull JSVariable variable, @NotNull PsiElement sourceElement) {
        if (variable == null) {
            TypeScriptGoToDeclarationHandler.$$$reportNull$$$0(3);
        }
        if (sourceElement == null) {
            TypeScriptGoToDeclarationHandler.$$$reportNull$$$0(4);
        }
        return TypeScriptGoToDeclarationHandler.isIdentifier(sourceElement, variable.getNameIdentifier()) && (variable.hasInitializer() || variable instanceof JSParameter) && variable.getTypeElement() == null && !JSDestructuringUtil.isDestructuring(variable.getParent());
    }

    private static boolean useFunctionAsDeclaration(@NotNull TypeScriptFunction function, @NotNull PsiElement sourceElement) {
        if (function == null) {
            TypeScriptGoToDeclarationHandler.$$$reportNull$$$0(5);
        }
        if (sourceElement == null) {
            TypeScriptGoToDeclarationHandler.$$$reportNull$$$0(6);
        }
        return TypeScriptGoToDeclarationHandler.isIdentifier(sourceElement, function.getNameIdentifier()) && function.getReturnTypeElement() == null && function.getBody().length > 0;
    }

    private static boolean isIdentifier(@NotNull PsiElement sourceElement, @Nullable PsiElement name) {
        if (sourceElement == null) {
            TypeScriptGoToDeclarationHandler.$$$reportNull$$$0(7);
        }
        return sourceElement.isEquivalentTo(name);
    }

    @Nullable
    private static PsiElement getElement(@NotNull PsiFile psiFile, @NotNull Document document, @NotNull TypeScriptResponseCommon.FileSpan span) {
        TypeScriptResponseCommon.Location end;
        TypeScriptResponseCommon.Location start;
        JSLanguageServiceUtil.PsiElementInfo info;
        if (psiFile == null) {
            TypeScriptGoToDeclarationHandler.$$$reportNull$$$0(8);
        }
        if (document == null) {
            TypeScriptGoToDeclarationHandler.$$$reportNull$$$0(9);
        }
        if (span == null) {
            TypeScriptGoToDeclarationHandler.$$$reportNull$$$0(10);
        }
        if ((info = TypeScriptLanguageServiceUtil.getPsiElementInfo(psiFile, document, start = span.start, end = span.end)) == null) {
            return null;
        }
        PsiElement element = info.getElement();
        if (element != null) {
            return element;
        }
        TextRange range = info.getRange();
        if (range == null) {
            return null;
        }
        return TypeScriptGoToDeclarationHandler.getPsiElementByRange(psiFile, range);
    }

    @Nullable
    public static PsiElement getPsiElementByRange(@NotNull PsiFile psiFile, TextRange range) {
        int rangeStartOffset;
        PsiElement startElement;
        if (psiFile == null) {
            TypeScriptGoToDeclarationHandler.$$$reportNull$$$0(11);
        }
        if ((startElement = psiFile.findElementAt(rangeStartOffset = range.getStartOffset())) == null) {
            return null;
        }
        PsiElement lastCandidate = startElement;
        int rangeEndOffset = range.getEndOffset();
        for (PsiElement currentElement = startElement; currentElement != null && !(currentElement instanceof PsiFile) && currentElement.getTextRange().getStartOffset() == rangeStartOffset && currentElement.getTextRange().getEndOffset() <= rangeEndOffset; currentElement = currentElement.getParent()) {
            if (currentElement.getTextRange().getEndOffset() == rangeEndOffset) {
                return currentElement;
            }
            lastCandidate = currentElement;
        }
        return lastCandidate;
    }

    @Nullable
    public String getActionText(DataContext context) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "span";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/TypeScriptGoToDeclarationHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getResultsFromTypeScriptService";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "useVariableAsDeclaration";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "useFunctionAsDeclaration";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isIdentifier";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getElement";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getPsiElementByRange";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getResultsFromTypeScriptService$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

