/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptServiceCommandClean;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class TypeScriptCompileStartupActivity
implements StartupActivity {
    public void runActivity(final @NotNull Project project) {
        if (project == null) {
            TypeScriptCompileStartupActivity.$$$reportNull$$$0(0);
        }
        if (project.isDefault() || project.isDisposed()) {
            return;
        }
        final TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(project);
        if (settings.isCompilerEnabled()) {
            TypeScriptCompilerService.initToolWindow(project);
        }
        final Application application = ApplicationManager.getApplication();
        final boolean testMode = application.isUnitTestMode();
        final ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        project.getMessageBus().connect((Disposable)project).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (project.isDisposed()) {
                    return;
                }
                if (!settings.isCompilerEnabledAndNeedTrackChanges() && !settings.isUseService()) {
                    return;
                }
                Collection filesToCompile = null;
                boolean cleanAllCache = false;
                Collection changedConfigs = null;
                boolean hasCreateEvent = false;
                for (VFileEvent vFileEvent : events) {
                    VirtualFile file;
                    if (!(vFileEvent.getFileSystem() instanceof LocalFileSystem) || (file = vFileEvent.getFile()) == null || !fileIndex.isInContent(file)) continue;
                    boolean isDeleteEvent = vFileEvent instanceof VFileDeleteEvent;
                    if (isDeleteEvent && Boolean.TRUE.equals(file.getUserData(JSLanguageServiceQueue.GENERATED_FILE_MARKER))) {
                        cleanAllCache = true;
                        break;
                    }
                    if (file.isDirectory()) {
                        if (!isDeleteEvent) continue;
                        cleanAllCache = true;
                        break;
                    }
                    FileType type = file.getFileType();
                    if (TypeScriptCompilerSettings.acceptFileType(type)) {
                        hasCreateEvent |= vFileEvent instanceof VFileCreateEvent || vFileEvent instanceof VFileCopyEvent;
                        JSLanguageServiceQueue.LOGGER.debug("event " + vFileEvent.getClass() + " file " + file.toString() + " " + vFileEvent.getRequestor());
                        if (filesToCompile == null) {
                            filesToCompile = ContainerUtil.newArrayList();
                        }
                        TypeScriptCompileStartupActivity.processCreateAndChangeFiles(vFileEvent, (List)filesToCompile);
                        continue;
                    }
                    if (!TypeScriptCompilerConfigUtil.isConfig(file, type)) continue;
                    if (changedConfigs == null) {
                        changedConfigs = ContainerUtil.newHashSet();
                    }
                    changedConfigs.add(file);
                }
                if ((cleanAllCache || hasCreateEvent && TypeScriptCompileStartupActivity.hasConfigParameter(settings)) && settings.isCompilerEnabled()) {
                    TypeScriptCompilerService.sendCleanCommand(project, new TypeScriptServiceCommandClean(true));
                }
                if (changedConfigs != null) {
                    for (VirtualFile virtualFile : changedConfigs) {
                        TypeScriptCompilerService.sendCleanCommand(project, new TypeScriptServiceCommandClean(TypeScriptCompilerConfigUtil.getConfigIdByConfig(virtualFile)));
                    }
                }
                if (!ContainerUtil.isEmpty(filesToCompile) && settings.isCompilerEnabled()) {
                    GlobalSearchScope scope = ProjectScope.getProjectScope((Project)project);
                    List list = filesToCompile.stream().filter(el -> scope.accept(el)).collect(Collectors.toList());
                    if (!list.isEmpty()) {
                        Runnable runnable = () -> {
                            if (project == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            ReadAction.run(() -> {
                                if (project == null) {
                                    1.$$$reportNull$$$0(2);
                                }
                                TypeScriptCompilerService.addFileToCompileQueue(project, files);
                            });
                        };
                        TypeScriptCompileStartupActivity.this.executeExternally(runnable, testMode, application);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "events";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/typescript/compiler/TypeScriptCompileStartupActivity$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "after";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$after$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$null$1";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void executeExternally(Runnable runnable, boolean testMode, Application application) {
        if (testMode) {
            application.invokeLater(runnable);
        } else {
            application.executeOnPooledThread(runnable);
        }
    }

    private static boolean hasConfigParameter(@NotNull TypeScriptCompilerSettings settings) {
        if (settings == null) {
            TypeScriptCompileStartupActivity.$$$reportNull$$$0(1);
        }
        if (settings.isUseConfigForCompiler() || settings.isUseService()) {
            return true;
        }
        String params = settings.getTypeScriptCompilerParams();
        if (StringUtil.isEmpty((String)params)) {
            return false;
        }
        for (String s : ParametersListUtil.parse((String)params)) {
            if (StringUtil.isEmpty((String)s) || !ArrayUtil.contains((String)s, (String[])TypeScriptCompilerSettings.CONFIG_PARAMS)) continue;
            return true;
        }
        return false;
    }

    private static void processCreateAndChangeFiles(VFileEvent event, List<VirtualFile> filesToCompile) {
        if (event instanceof VFileCreateEvent || event instanceof VFileCopyEvent || event instanceof VFileContentChangeEvent) {
            filesToCompile.add(event.getFile());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/compiler/TypeScriptCompileStartupActivity";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "hasConfigParameter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

