/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService.codeFixes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.lang.javascript.service.JSLanguageServiceBase;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceAnnotationResult;
import com.intellij.lang.typescript.compiler.languageService.codeFixes.TypeScriptLanguageServiceFix;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptGetCodeFixes;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptGetCodeFixesRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptCodeActionInfo;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptGetCodeFixesResponse;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;

public class TypeScriptLanguageServiceFixSet {
    private static final int MAX_QUICK_FIXES = 5;
    private final JSLanguageServiceBase myLanguageService;
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final TypeScriptLanguageServiceAnnotationResult myResult;
    @NotNull
    private final List<TypeScriptLanguageServiceFix> myFixes;
    private long myPsiModCount;

    @NotNull
    public List<TypeScriptLanguageServiceFix> getFixes() {
        List<TypeScriptLanguageServiceFix> list = this.myFixes;
        if (list == null) {
            TypeScriptLanguageServiceFixSet.$$$reportNull$$$0(0);
        }
        return list;
    }

    public TypeScriptLanguageServiceFixSet(@NotNull JSLanguageServiceBase service, @NotNull VirtualFile file, @NotNull TypeScriptLanguageServiceAnnotationResult result) {
        if (service == null) {
            TypeScriptLanguageServiceFixSet.$$$reportNull$$$0(1);
        }
        if (file == null) {
            TypeScriptLanguageServiceFixSet.$$$reportNull$$$0(2);
        }
        if (result == null) {
            TypeScriptLanguageServiceFixSet.$$$reportNull$$$0(3);
        }
        this.myLanguageService = service;
        this.myFile = file;
        this.myResult = result;
        ArrayList fixes = ContainerUtil.newArrayListWithCapacity((int)5);
        for (int i = 0; i < 5; ++i) {
            fixes.add(new TypeScriptLanguageServiceFix(this::refresh, i));
        }
        this.myFixes = fixes;
    }

    private void refresh() {
        long modCount = this.myFile.getModificationStamp();
        if (this.myPsiModCount == modCount) {
            return;
        }
        if (ApplicationManager.getApplication().isDispatchThread() && !ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        this.myPsiModCount = modCount;
        if (!this.myLanguageService.checkCanUseService()) {
            return;
        }
        TypeScriptGetCodeFixesRequestArgs args = new TypeScriptGetCodeFixesRequestArgs();
        args.file = TypeScriptCompilerConfigUtil.normalizeNameAndPath(this.myFile);
        args.startOffset = this.myResult.getColumn() + 1;
        args.startLine = this.myResult.getLine() + 1;
        args.endOffset = this.myResult.getEndColumn() + 1;
        args.endLine = this.myResult.getEndLine() + 1;
        args.errorCodes = new int[]{this.myResult.getErrorCode()};
        this.myFixes.forEach(el -> el.update(null));
        TypeScriptGetCodeFixes command = new TypeScriptGetCodeFixes(args);
        Future<TypeScriptGetCodeFixesResponse> future = this.myLanguageService.sendCommand(command, TypeScriptLanguageServiceFixSet.createGetCodeFixesProcessor());
        TypeScriptGetCodeFixesResponse response = JSLanguageServiceUtil.awaitFuture(future, 700L, 10L, null);
        if (response == null || response.body == null) {
            return;
        }
        int index = 0;
        for (TypeScriptCodeActionInfo info : response.body) {
            TypeScriptLanguageServiceFix fix = this.myFixes.get(index++);
            fix.update(new TypeScriptLanguageServiceFix.State(info));
            if (index >= 5) break;
        }
    }

    @NotNull
    private static JSLanguageServiceCommandProcessor<TypeScriptGetCodeFixesResponse> createGetCodeFixesProcessor() {
        JSLanguageServiceCommandProcessor<TypeScriptGetCodeFixesResponse> jSLanguageServiceCommandProcessor = (serviceObject, answer) -> {
            if (answer.isEmpty()) {
                return null;
            }
            JsonObject element = answer.getElement();
            return (TypeScriptGetCodeFixesResponse)JSLanguageServiceQueue.GSON.fromJson((JsonElement)element, TypeScriptGetCodeFixesResponse.class);
        };
        if (jSLanguageServiceCommandProcessor == null) {
            TypeScriptLanguageServiceFixSet.$$$reportNull$$$0(4);
        }
        return jSLanguageServiceCommandProcessor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/languageService/codeFixes/TypeScriptLanguageServiceFixSet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixes";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/languageService/codeFixes/TypeScriptLanguageServiceFixSet";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createGetCodeFixesProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

