/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.completion.JSSmartCompletionContributor;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptSmartCompletionContributor
extends JSSmartCompletionContributor {
    @Override
    @Nullable
    public List<?> getSmartCompletionVariants(@NotNull JSReferenceExpression location) {
        List<Object> variants;
        if (location == null) {
            TypeScriptSmartCompletionContributor.$$$reportNull$$$0(0);
        }
        if (location.getQualifier() == null && !JSResolveUtil.isExprInStrictTypeContext(location) && !(variants = this.addVariantsForUnqualifiedReference(location)).isEmpty()) {
            return variants;
        }
        return super.getSmartCompletionVariants(location);
    }

    @Override
    protected void processSingleLiteralVariant(@NotNull JSExpression location, boolean insideStringLiteral, @NotNull List<LookupElement> literalVariants, JSType type) {
        String enumFieldName;
        Pair<TypeScriptEnum, TypeScriptEnumField> parentAndName;
        if (location == null) {
            TypeScriptSmartCompletionContributor.$$$reportNull$$$0(1);
        }
        if (literalVariants == null) {
            TypeScriptSmartCompletionContributor.$$$reportNull$$$0(2);
        }
        super.processSingleLiteralVariant(location, insideStringLiteral, literalVariants, type);
        if (insideStringLiteral) {
            return;
        }
        if (type instanceof JSTypeImpl && (parentAndName = TypeScriptUtil.getEnumLiteralParentAndField((JSTypeImpl)type)) != null && (enumFieldName = TypeScriptSmartCompletionContributor.getEnumFieldName((TypeScriptEnum)parentAndName.first, ((TypeScriptEnumField)parentAndName.second).getName(), location)) != null) {
            LookupItem<Object> lookupItem = JSLookupUtilImpl.createPrioritizedLookupItem((PsiElement)parentAndName.second, enumFieldName, JSLookupPriority.SMART_PRIORITY, false, false);
            literalVariants.add((LookupElement)lookupItem);
        }
        if (location instanceof JSReferenceExpression && TypeScriptSmartCompletionContributor.isEnumType(type)) {
            Collection<? extends PsiElement> resolvedElements = TypeScriptTypeParser.resolveElementsByType(type);
            for (PsiElement psiElement : resolvedElements) {
                JSField[] fields;
                if (!(psiElement instanceof TypeScriptEnum)) continue;
                for (JSField field : fields = ((TypeScriptEnum)psiElement).getFields()) {
                    String fieldName = field.getName();
                    String enumFieldName2 = TypeScriptSmartCompletionContributor.getEnumFieldName((TypeScriptEnum)psiElement, fieldName, location);
                    if (enumFieldName2 == null) continue;
                    literalVariants.add((LookupElement)JSLookupUtilImpl.createPrioritizedLookupItem((PsiElement)field, enumFieldName2, JSLookupPriority.SMART_PRIORITY, true, false));
                }
            }
        }
    }

    @Nullable
    private static String getEnumFieldName(TypeScriptEnum element, String fieldName, JSExpression location) {
        String qualifiedName = element.getQualifiedName();
        if (qualifiedName == null) {
            return null;
        }
        JSType type = JSNamedType.createType(qualifiedName, JSTypeSourceFactory.createTypeSource((PsiElement)element), JSTypeContext.INSTANCE);
        String name = TypeScriptUtil.getShortestTypeNameInContext(type, (PsiElement)location);
        return name + "." + fieldName;
    }

    @Override
    protected void addVariantsForUnqualifiedExpectedType(@NotNull JSType expectedType, @NotNull JSReferenceExpression location, @NotNull List<Object> variants) {
        List<LookupElement> result;
        JSType typedef;
        if (expectedType == null) {
            TypeScriptSmartCompletionContributor.$$$reportNull$$$0(3);
        }
        if (location == null) {
            TypeScriptSmartCompletionContributor.$$$reportNull$$$0(4);
        }
        if (variants == null) {
            TypeScriptSmartCompletionContributor.$$$reportNull$$$0(5);
        }
        if (expectedType instanceof JSTypeImpl && (typedef = ((JSTypeImpl)expectedType).getTypedef()) != null) {
            expectedType = typedef;
        }
        if ((result = this.getLiteralVariantsForExpectedType((JSExpression)location, false, expectedType)) != null) {
            variants.addAll(result);
        }
        super.addVariantsForUnqualifiedExpectedType(expectedType, location, variants);
    }

    private static boolean isEnumType(JSType expectedType) {
        return expectedType != null && expectedType instanceof JSTypeImpl && ((JSTypeImpl)expectedType).isEnum();
    }

    @Override
    protected boolean needToQualify(int qualifiedStaticVariantsStart, int i) {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalVariants";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variants";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/completion/TypeScriptSmartCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getSmartCompletionVariants";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processSingleLiteralVariant";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addVariantsForUnqualifiedExpectedType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

