/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.imports;

import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.imports.ES6ImportOptimizer;
import com.intellij.lang.javascript.imports.JSModuleImportOptimizerBase;
import com.intellij.lang.javascript.imports.JSOptimizeImportUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.lang.typescript.imports.ES6UnusedImportsHelper;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptImportOptimizer
extends JSModuleImportOptimizerBase {
    public static final TokenSet MODULES = TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.TYPESCRIPT_MODULE, TypeScriptElementTypes.IMPLICIT_MODULE});
    public static final TokenSet TYPESCRIPT_IMPORT = TokenSet.create((IElementType[])new IElementType[]{TypeScriptElementTypes.IMPORT_STATEMENT});

    public boolean supports(PsiFile file) {
        return file instanceof JSFile && DialectDetector.isTypeScript((PsiElement)file);
    }

    @Override
    @NotNull
    public Collection<JSModuleImportOptimizerBase.UnusedModuleInfo> getModulesInfo(@NotNull PsiFile file) {
        if (file == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(0);
        }
        List result = ContainerUtil.newSmartList();
        result.addAll(new ES6ImportOptimizer().getModulesInfo(file));
        Collection<PsiElement> modules = TypeScriptImportOptimizer.getAllModules(file);
        for (PsiElement module : modules) {
            JSModuleImportOptimizerBase.UnusedModuleInfo info = TypeScriptImportOptimizer.getInfo(file, module);
            if (info == null) continue;
            result.add(info);
        }
        List list = result;
        if (list == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static Collection<PsiElement> getAllModules(@NotNull PsiFile file) {
        if (file == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(2);
        }
        ArrayList result = ContainerUtil.newArrayList();
        result.add(file);
        ArrayDeque<Object> toProcess = new ArrayDeque<Object>();
        toProcess.add((JSFile)file);
        while (!toProcess.isEmpty()) {
            PsiElement[] modules;
            JSElement current = (JSElement)toProcess.pop();
            for (PsiElement module : modules = TypeScriptImportOptimizer.getDirectChildModules(current)) {
                if (!(module instanceof TypeScriptModule)) continue;
                result.add(module);
                toProcess.add((JSElement)module);
            }
        }
        return result;
    }

    private static PsiElement[] getDirectChildModules(JSElement context) {
        return JSStubBasedPsiTreeUtil.getChildrenByType(context, MODULES);
    }

    @Nullable
    private static JSModuleImportOptimizerBase.UnusedModuleInfo getInfo(PsiFile file, @NotNull PsiElement module) {
        List<TypeScriptImportStatement> imports;
        if (module == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(3);
        }
        if ((imports = TypeScriptImportOptimizer.getImports((JSElement)module)).isEmpty()) {
            return null;
        }
        Set<TypeScriptImportStatement> unusedImports = TypeScriptImportOptimizer.getUnusedImports(imports);
        final List<String> texts = TypeScriptImportOptimizer.getNewImportTexts(file, imports, unusedImports);
        return new JSModuleImportOptimizerBase.UnusedModuleInfo(){

            @Override
            public List<String> getImportTexts() {
                return texts;
            }

            @Override
            @Nullable
            public PsiElement getAnchor() {
                return (PsiElement)ContainerUtil.getFirstItem((List)imports);
            }

            @Override
            public List<PsiElement> getOldImports() {
                return ContainerUtil.newArrayList((Iterable)imports);
            }
        };
    }

    private static List<String> getNewImportTexts(@NotNull PsiFile file, @NotNull List<TypeScriptImportStatement> imports, @NotNull Set<TypeScriptImportStatement> unusedImports) {
        if (file == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(4);
        }
        if (imports == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(5);
        }
        if (unusedImports == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(6);
        }
        ArrayList importsResult = ContainerUtil.newArrayList();
        ArrayList importsForProcessing = ContainerUtil.newArrayList(imports);
        TypeScriptImportOptimizer.sortImports(file, importsForProcessing);
        String semicolon = JSCodeStyleSettings.getSemicolon(file);
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        for (TypeScriptImportStatement statement : importsForProcessing) {
            if (unusedImports.contains(statement)) continue;
            List<PsiElement> prevComments = JSOptimizeImportUtil.getPrevComments(document, (PsiElement)statement);
            List current = ContainerUtil.newSmartList();
            current.addAll(JSOptimizeImportUtil.getPsiElementsAsStrings(prevComments));
            current.add(TypeScriptImportOptimizer.getImportText(document, statement, semicolon));
            JSOptimizeImportUtil.fillImportsWithNewLines(importsResult, (PsiElement)statement, current);
        }
        return importsResult;
    }

    private static String getImportText(Document document, @NotNull TypeScriptImportStatement statement, @NotNull String semicolon) {
        if (statement == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(7);
        }
        if (semicolon == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(8);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(StringUtil.trimEnd((String)StringUtil.trim((String)statement.getText()), (String)";"));
        builder.append(semicolon);
        JSOptimizeImportUtil.addSameLineComments(document, (PsiElement)statement, builder);
        return builder.toString();
    }

    private static void sortImports(@NotNull PsiFile file, @NotNull List<TypeScriptImportStatement> imports) {
        if (file == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(9);
        }
        if (imports == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(10);
        }
        JSCodeStyleSettings settings = JSCodeStyleSettings.getSettings((PsiElement)file);
        Comparator<String> moduleComparator = ES6ImportPsiUtil.getStringImportFromComparator((PsiElement)file);
        Comparator<String> memberComparator = ES6ImportPsiUtil.getStringImportMemberComparator((PsiElement)file);
        ContainerUtil.sort(imports, (o1, o2) -> {
            TypeScriptEntityName internalModuleReference1 = o1.getInternalModuleReference();
            TypeScriptEntityName internalModuleReference2 = o2.getInternalModuleReference();
            TypeScriptExternalModuleReference externalModuleReference1 = o1.getExternalModuleReference();
            TypeScriptExternalModuleReference externalModuleReference2 = o2.getExternalModuleReference();
            if (externalModuleReference1 != null && externalModuleReference2 != null) {
                if (!settings.IMPORT_SORT_MODULE_NAME) {
                    return 0;
                }
                String name1 = TypeScriptImportOptimizer.getExternalModuleReferenceText(externalModuleReference1);
                String name2 = TypeScriptImportOptimizer.getExternalModuleReferenceText(externalModuleReference2);
                return moduleComparator.compare(name1, name2);
            }
            if (internalModuleReference1 != null && internalModuleReference2 != null) {
                String text2;
                String text1 = StringUtil.trim((String)StringUtil.notNullize((String)internalModuleReference1.getText()));
                if (text1.equals(text2 = StringUtil.trim((String)StringUtil.notNullize((String)internalModuleReference2.getText())))) {
                    return memberComparator.compare(o1.getName(), o2.getName());
                }
                if (!settings.IMPORT_SORT_MODULE_NAME) {
                    return 0;
                }
                return moduleComparator.compare(text1, text2);
            }
            return internalModuleReference1 == null ? -1 : 1;
        });
    }

    @NotNull
    private static String getExternalModuleReferenceText(@Nullable TypeScriptExternalModuleReference externalModuleReference1) {
        String string = externalModuleReference1 == null ? "" : StringUtil.unquoteString((String)StringUtil.notNullize((String)externalModuleReference1.getReferenceText()));
        if (string == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static List<TypeScriptImportStatement> getImports(@NotNull JSElement module) {
        if (module == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(12);
        }
        return Arrays.stream(JSStubBasedPsiTreeUtil.getChildrenByType(module, TYPESCRIPT_IMPORT)).filter(el -> el instanceof TypeScriptImportStatement).map(el -> (TypeScriptImportStatement)el).collect(Collectors.toList());
    }

    private static Set<TypeScriptImportStatement> getUnusedImports(@NotNull Collection<TypeScriptImportStatement> imports) {
        if (imports == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(13);
        }
        HashSet result = ContainerUtil.newHashSet();
        for (PsiElement psiElement : imports) {
            if (!(psiElement instanceof TypeScriptImportStatement) || !ES6UnusedImportsHelper.isUnusedTypeScriptImport((TypeScriptImportStatement)psiElement)) continue;
            result.add((TypeScriptImportStatement)psiElement);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/imports/TypeScriptImportOptimizer";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imports";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unusedImports";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "semicolon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/imports/TypeScriptImportOptimizer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulesInfo";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalModuleReferenceText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getModulesInfo";
                break;
            }
            case 1: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAllModules";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInfo";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNewImportTexts";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getImportText";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "sortImports";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getImports";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getUnusedImports";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

