/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.inspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.inspections.JSVariablesWithInitializerPredicate;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.typescript.inspection.TypescriptExplicitMemberTypeInspection;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypescriptSpecifyTypeExplicitlyQuickFix
implements LocalQuickFix {
    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"typescript.specify.type.explicitly", (Object[])new Object[0]);
        if (string == null) {
            TypescriptSpecifyTypeExplicitlyQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        String qualifiedName;
        Pair<TypeScriptEnum, TypeScriptEnumField> parentAndField;
        PsiElement element;
        if (project == null) {
            TypescriptSpecifyTypeExplicitlyQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            TypescriptSpecifyTypeExplicitlyQuickFix.$$$reportNull$$$0(2);
        }
        if ((element = PsiTreeUtil.getParentOfType((PsiElement)descriptor2.getPsiElement(), (Class[])new Class[]{JSVariable.class, JSFunction.class})) == null || TypescriptExplicitMemberTypeInspection.getTypeDeclarationElement(element) != null) {
            return;
        }
        JSType inferredType = TypescriptExplicitMemberTypeInspection.getInferredType(element);
        if (inferredType == null) {
            return;
        }
        if (inferredType instanceof JSTypeImpl && ((JSTypeImpl)inferredType).isEnumLiteral() && (parentAndField = TypeScriptUtil.getEnumLiteralParentAndField((JSTypeImpl)inferredType)) != null && parentAndField.first != null && (qualifiedName = ((TypeScriptEnum)parentAndField.first).getQualifiedName()) != null) {
            inferredType = JSNamedType.createType(qualifiedName, JSTypeSourceFactory.createTypeSource((PsiElement)parentAndField.first), JSTypeContext.INSTANCE);
        }
        String newTypeStr = JSVariablesWithInitializerPredicate.formatType(inferredType, element);
        JSVarStatement dummyVarStatement = JSChangeUtil.createStatementPsiFromTextWithContext("var x: " + newTypeStr, element, JSVarStatement.class);
        if (dummyVarStatement == null) {
            return;
        }
        PsiElement newTypeDeclaration = ((JSTypeDeclarationOwner)PsiTreeUtil.getRequiredChildOfType((PsiElement)dummyVarStatement, JSTypeDeclarationOwner.class)).getTypeElement();
        PsiElement semicolon = JSChangeUtil.createColonPsiElement(project);
        PsiElement insertionAnchor = TypescriptSpecifyTypeExplicitlyQuickFix.getTypeDeclarationAnchor(element);
        if (newTypeDeclaration == null || insertionAnchor == null) {
            return;
        }
        element.addAfter(newTypeDeclaration, element.addAfter(semicolon, insertionAnchor));
    }

    @Nullable
    private static PsiElement getTypeDeclarationAnchor(@NotNull PsiElement element) {
        JSVariable variable;
        JSFunction function;
        if (element == null) {
            TypescriptSpecifyTypeExplicitlyQuickFix.$$$reportNull$$$0(3);
        }
        JSFunction jSFunction = function = element instanceof JSFunction ? (JSFunction)element : null;
        if (function != null) {
            return ((JSBlockStatement)PsiTreeUtil.getRequiredChildOfType((PsiElement)function, JSBlockStatement.class)).getPrevSibling();
        }
        JSVariable jSVariable = variable = element instanceof JSVariable ? (JSVariable)element : null;
        if (variable != null) {
            return variable.getNameIdentifier();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/inspection/TypescriptSpecifyTypeExplicitlyQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/inspection/TypescriptSpecifyTypeExplicitlyQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTypeDeclarationAnchor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

