/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.intentions;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.lang.typescript.intentions.TypeScriptLibraryUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptReferencesLibraryFix
extends FixAndIntentionAction
implements HighPriorityAction {
    public static final String LIBRARY_NAME = "ts-external-references";

    public TypeScriptReferencesLibraryFix(PsiElement comment) {
        this.registerElementRefForFix(comment, null);
    }

    @Override
    protected void applyFix(Project project, PsiElement psiElement, PsiFile psiFile, Editor editor) {
        if (!(psiFile instanceof JSFile)) {
            return;
        }
        JSFile file = (JSFile)psiFile;
        String libraryName = LIBRARY_NAME;
        Collection<VirtualFile> files = TypeScriptReferencesLibraryFix.getFilesForLibrary(file);
        if (files.isEmpty()) {
            return;
        }
        Collection<Module> modules = TypeScriptLibraryUtil.getModules(project, ContainerUtil.createMaybeSingletonList((Object)file.getVirtualFile()));
        TypeScriptLibraryUtil.updateLibrary(project, modules, libraryName, files, false);
    }

    @NotNull
    private static Collection<VirtualFile> getFilesForLibrary(JSFile file) {
        Collection<VirtualFile> collection = JSFixFactory.getInstance().typeScriptReferencePathValidator().getOutOfProjectReferences(file);
        if (collection == null) {
            TypeScriptReferencesLibraryFix.$$$reportNull$$$0(0);
        }
        return collection;
    }

    @Override
    protected boolean isAvailable(Project project, PsiElement element, Editor editor, PsiFile psiFile) {
        if (!(psiFile instanceof JSFile)) {
            return false;
        }
        JSFile file = (JSFile)psiFile;
        return JSFixFactory.getInstance().typeScriptReferencePathValidator().hasOutOfProjectReferences(file);
    }

    @Nls
    @NotNull
    public String getName() {
        if ("Create library with files outside the project" == null) {
            TypeScriptReferencesLibraryFix.$$$reportNull$$$0(1);
        }
        return "Create library with files outside the project";
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
        if (file == null) {
            TypeScriptReferencesLibraryFix.$$$reportNull$$$0(2);
        }
        return null;
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/intentions/TypeScriptReferencesLibraryFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesForLibrary";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/intentions/TypeScriptReferencesLibraryFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

