/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.library;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.typescript.library.TypeScriptLibraries;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Predicate;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptLibraryProviderImpl
implements TypeScriptLibraryProvider {
    public static final Logger LOG = Logger.getInstance(TypeScriptLibraryProviderImpl.class);
    public static final String BUNDLED_LIB_VERSION = "2.4.1";
    private static final String LIB_PREFIX = "lib";
    private static final String TS_LIB_VERSION_KEY = "ts.lib.d.ts.version";
    @NotNull
    private final Project myProject;
    private static boolean SKIP_DEFAULT_LIBRARY = false;
    @NotNull
    private volatile TypeScriptLibraries myLibrary;
    private volatile boolean myRefreshed;

    public static void setSkipDefaultLibrary(boolean noLib) {
        SKIP_DEFAULT_LIBRARY = noLib;
    }

    private static void asyncRefresh(@NotNull Runnable completeCallback, @NotNull TypeScriptLibraries library, boolean force) {
        if (completeCallback == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(0);
        }
        if (library == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(1);
        }
        String key = PropertiesComponent.getInstance().getValue(TS_LIB_VERSION_KEY);
        if (!force && BUNDLED_LIB_VERSION.equals(key)) {
            return;
        }
        LOG.info("Start refreshing typescript libraries");
        PropertiesComponent.getInstance().setValue(TS_LIB_VERSION_KEY, BUNDLED_LIB_VERSION);
        List list = VfsUtil.markDirty((boolean)true, (boolean)true, (VirtualFile[])VfsUtilCore.toVirtualFileArray(library.getFilesToRefresh()));
        boolean testMode = ApplicationManager.getApplication().isUnitTestMode();
        LocalFileSystem.getInstance().refreshFiles((Iterable)list, !testMode, true, () -> {
            if (completeCallback == null) {
                TypeScriptLibraryProviderImpl.$$$reportNull$$$0(22);
            }
            LOG.info("End refreshing typescript libraries");
            completeCallback.run();
        });
    }

    public TypeScriptLibraryProviderImpl(@NotNull Project project) {
        if (project == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(2);
        }
        this.myRefreshed = false;
        this.myProject = project;
        this.myLibrary = new TypeScriptLibraries();
        TypeScriptLibraryProviderImpl.asyncRefresh(() -> this.reloadLibrary(), this.myLibrary, false);
    }

    private void reloadLibrary() {
        if (!this.myRefreshed) {
            TypeScriptLibraries oldLibrary = this.myLibrary;
            this.myLibrary = new TypeScriptLibraries();
            if (this.myLibrary.getModificationId() != oldLibrary.getModificationId() && !ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.info("Refresh roots after updating typescript libraries");
                ProjectRootManagerEx.getInstanceEx((Project)this.myProject).makeRootsChange(EmptyRunnable.getInstance(), false, true);
            }
            this.myRefreshed = true;
        }
    }

    @Override
    @NotNull
    public Set<VirtualFile> getAllPredefinedLibraries() {
        Set<VirtualFile> libs = this.myLibrary.getAllLibs();
        Set<VirtualFile> set = this.filterAndRefreshIfRequired(libs);
        if (set == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(3);
        }
        return set;
    }

    @Override
    @NotNull
    public GlobalSearchScope getFileTypeRestrictedScope(@NotNull GlobalSearchScope moduleAndLibraryScope, @NotNull VirtualFile file) {
        List withAllowJs;
        if (moduleAndLibraryScope == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(4);
        }
        if (file == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(5);
        }
        Collection<TypeScriptConfig> includes = this.getIncludeConfigs(file);
        Set<VirtualFile> tsLibs = this.getPredefinedLibrariesImpl(file, includes);
        GlobalSearchScope resultScope = moduleAndLibraryScope.uniteWith(GlobalSearchScope.filesScope((Project)this.myProject, tsLibs));
        List list = withAllowJs = includes.isEmpty() ? ContainerUtil.emptyList() : includes.stream().filter(el -> el.allowJs()).collect(Collectors.toList());
        if (withAllowJs.isEmpty()) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)resultScope, (FileType[])TypeScriptUtil.TYPESCRIPT_FILE_TYPES_ARRAY);
            if (globalSearchScope == null) {
                TypeScriptLibraryProviderImpl.$$$reportNull$$$0(6);
            }
            return globalSearchScope;
        }
        TypeScriptConfigService configService = TypeScriptConfigService.Provider.get(this.myProject);
        assert (configService != null);
        final Predicate<VirtualFile> accessScope = configService.getAccessScope(file);
        DelegatingGlobalSearchScope delegatingGlobalSearchScope = new DelegatingGlobalSearchScope(resultScope){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!super.contains(file)) {
                    return false;
                }
                FileType fileType = file.getFileType();
                if (TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(fileType)) {
                    return true;
                }
                if (DialectDetector.JAVASCRIPT_FILE_TYPES.contains(fileType)) {
                    return accessScope.apply((Object)file);
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/library/TypeScriptLibraryProviderImpl$1", "contains"));
            }
        };
        if (delegatingGlobalSearchScope == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(7);
        }
        return delegatingGlobalSearchScope;
    }

    @Override
    @NotNull
    public String getLibraryVersion() {
        if (BUNDLED_LIB_VERSION == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(8);
        }
        return BUNDLED_LIB_VERSION;
    }

    private Set<VirtualFile> filterAndRefreshIfRequired(Set<VirtualFile> libs) {
        boolean hasInvalidFiles = libs.stream().anyMatch(el -> !el.isValid());
        if (hasInvalidFiles) {
            if (!this.myRefreshed) {
                TypeScriptLibraryProviderImpl.asyncRefresh(() -> this.reloadLibrary(), this.myLibrary, true);
            } else {
                LOG.error("Some of the library files are invalidated after refresh");
            }
        }
        return hasInvalidFiles ? libs.stream().filter(VirtualFile::isValid).collect(Collectors.toSet()) : libs;
    }

    @Override
    @NotNull
    public Set<VirtualFile> getPredefinedLibraries(@NotNull VirtualFile file) {
        if (file == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(9);
        }
        Set<VirtualFile> set = this.filterAndRefreshIfRequired(this.getPredefinedLibrariesImpl(file));
        if (set == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(10);
        }
        return set;
    }

    @NotNull
    public Set<VirtualFile> getPredefinedLibrariesImpl(@NotNull VirtualFile file) {
        if (file == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(11);
        }
        Collection<TypeScriptConfig> includes = this.getIncludeConfigs(file);
        Set<VirtualFile> set = this.getPredefinedLibrariesImpl(file, includes);
        if (set == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(12);
        }
        return set;
    }

    @NotNull
    private Collection<TypeScriptConfig> getIncludeConfigs(@NotNull VirtualFile file) {
        Collection<TypeScriptConfig> configs;
        if (file == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(13);
        }
        Collection<TypeScriptConfig> collection = (configs = TypeScriptConfigService.Provider.getConfigFiles(this.myProject)).size() <= 1 || TypeScriptUtil.isUnderNodeModules(file, this.myProject) ? configs : TypeScriptConfigService.Provider.getConfigInclude(this.myProject, file);
        if (collection == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(14);
        }
        return collection;
    }

    @NotNull
    public Set<VirtualFile> getPredefinedLibrariesImpl(@NotNull VirtualFile file, @NotNull Collection<TypeScriptConfig> includes) {
        if (file == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(15);
        }
        if (includes == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(16);
        }
        if (SKIP_DEFAULT_LIBRARY) {
            Set set = ContainerUtil.immutableSet((Object[])new VirtualFile[0]);
            if (set == null) {
                TypeScriptLibraryProviderImpl.$$$reportNull$$$0(17);
            }
            return set;
        }
        if (includes.isEmpty()) {
            JSLanguageDialect configuredJSVersion = DialectDetector.getConfiguredJSVersion(file, this.myProject);
            Set<VirtualFile> set = this.getLibraries(configuredJSVersion.getOptionHolder().isECMA6, null);
            if (set == null) {
                TypeScriptLibraryProviderImpl.$$$reportNull$$$0(18);
            }
            return set;
        }
        List additionalLibs = null;
        boolean targetES6 = false;
        for (TypeScriptConfig config2 : includes) {
            targetES6 |= config2.getLanguageTarget() == TypeScriptConfig.LanguageTarget.ES6 || config2.hasES6Lib();
            Collection<String> names = config2.getLibNames();
            if (names.isEmpty()) continue;
            if (additionalLibs == null) {
                additionalLibs = ContainerUtil.newSmartList();
            }
            additionalLibs.addAll(names);
        }
        Set<VirtualFile> set = this.getLibraries(targetES6, additionalLibs);
        if (set == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(19);
        }
        return set;
    }

    @NotNull
    private Set<VirtualFile> getLibraries(boolean isES6, @Nullable List<String> additionalLibs) {
        Set<VirtualFile> defaultLibrary;
        Set<VirtualFile> set = defaultLibrary = isES6 ? this.myLibrary.getES6Libs() : this.myLibrary.getDefaultLibs();
        if (additionalLibs == null || additionalLibs.isEmpty()) {
            Set<VirtualFile> set2 = defaultLibrary;
            if (set2 == null) {
                TypeScriptLibraryProviderImpl.$$$reportNull$$$0(20);
            }
            return set2;
        }
        HashSet result = ContainerUtil.newHashSet(defaultLibrary);
        for (VirtualFile file : this.myLibrary.getAllLibs()) {
            int endIndex;
            String rawName = file.getName();
            if (TypeScriptLibraryProvider.LIBS_D_TS.contains(rawName)) continue;
            int startIndex = LIB_PREFIX.length() + 1;
            if (startIndex > (endIndex = rawName.length() - ".d.ts".length()) || endIndex > rawName.length()) {
                LOG.error("Name rage error start:" + startIndex + " end: " + endIndex + " name " + rawName);
                continue;
            }
            String name = rawName.substring(startIndex, endIndex);
            if (!additionalLibs.contains(name)) continue;
            result.add(file);
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(21);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completeCallback";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/library/TypeScriptLibraryProviderImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleAndLibraryScope";
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/library/TypeScriptLibraryProviderImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPredefinedLibraries";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeRestrictedScope";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryVersion";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedLibraries";
                break;
            }
            case 12: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedLibrariesImpl";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludeConfigs";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "asyncRefresh";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeRestrictedScope";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedLibraries";
                break;
            }
            case 11: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedLibrariesImpl";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getIncludeConfigs";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$asyncRefresh$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

